/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationListTest;
import com.android.tradefed.testtype.TestTimeoutListener;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest,
TestTimeoutListener.ITimeoutCallback {
    private static final String LOG_TAG = "InstrumentationTest";
    private static final int COLLECT_TESTS_ATTEMPTS = 3;
    private static final int COLLECT_TESTS_POLL_INTERVAL = 5000;
    private static final int COLLECT_TESTS_OP_TIMEOUT = 120000;
    static final String TIMED_OUT_MSG = "timed out: test did not complete in %d ms";
    static final String DELAY_MSEC_ARG = "delay_msec";
    @Option(name="package", shortName=112, description="The manifest package name of the Android test application to run")
    private String mPackageName = null;
    @Option(name="runner", description="The instrumentation test runner class name to use")
    private String mRunnerName = "android.test.InstrumentationTestRunner";
    @Option(name="class", shortName=99, description="The test class name to run")
    private String mTestClassName = null;
    @Option(name="method", shortName=109, description="The test method name to run.")
    private String mTestMethodName = null;
    @Option(name="timeout", description="Aborts the test run if any test takes longer than the specified number of milliseconds ")
    private long mTestTimeout = 600000L;
    @Option(name="size", description="Restrict test to a specific test size")
    private String mTestSize = null;
    @Option(name="rerun", description="Rerun non-executed tests individually if test run fails to complete")
    private boolean mIsRerunMode = true;
    @Option(name="log-delay", description="Delay in msec between each test when collecting test information")
    private int mTestDelay = 10;
    @Option(name="install-file", description="Optional file path to apk file that contains the tests.")
    private File mInstallFile = null;
    private ITestDevice mDevice = null;
    private IRemoteAndroidTestRunner mRunner;
    private Collection<ITestRunListener> mListeners;

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    public void setPackageName(String packageName) {
        this.mPackageName = packageName;
    }

    public void setRunnerName(String runnerName) {
        this.mRunnerName = runnerName;
    }

    public void setClassName(String testClassName) {
        this.mTestClassName = testClassName;
    }

    public void setMethodName(String testMethodName) {
        this.mTestMethodName = testMethodName;
    }

    public void setTestSize(String size) {
        this.mTestSize = size;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    String getClassName() {
        return this.mTestClassName;
    }

    String getMethodName() {
        return this.mTestMethodName;
    }

    String getTestSize() {
        return this.mTestSize;
    }

    public void setTestTimeout(long timeout) {
        this.mTestTimeout = timeout;
    }

    boolean isRerunMode() {
        return this.mIsRerunMode;
    }

    public void setRerunMode(boolean rerun) {
        this.mIsRerunMode = rerun;
    }

    long getTestTimeout() {
        return this.mTestTimeout;
    }

    long getTestDelay() {
        return this.mTestDelay;
    }

    public void setInstallFile(File installFile) {
        this.mInstallFile = installFile;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    IRemoteAndroidTestRunner createRemoteAndroidTestRunner(String packageName, String runnerName, IDevice device) {
        return new RemoteAndroidTestRunner(packageName, runnerName, device);
    }

    @Override
    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.mPackageName == null) {
            throw new IllegalArgumentException("package name has not been set");
        }
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        this.mRunner = this.createRemoteAndroidTestRunner(this.mPackageName, this.mRunnerName, this.mDevice.getIDevice());
        if (this.mTestClassName != null) {
            if (this.mTestMethodName != null) {
                this.mRunner.setMethodName(this.mTestClassName, this.mTestMethodName);
            } else {
                this.mRunner.setClassName(this.mTestClassName);
            }
        }
        if (this.mTestSize != null) {
            this.mRunner.setTestSize(IRemoteAndroidTestRunner.TestSize.getTestSize((String)this.mTestSize));
        }
        if (this.mInstallFile != null) {
            this.mDevice.installPackage(this.mInstallFile, true);
            this.doTestRun(listeners);
            this.mDevice.uninstallPackage(this.mPackageName);
        } else {
            this.doTestRun(listeners);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doTestRun(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        Collection<TestIdentifier> expectedTests = this.collectTestsToRun(this.mRunner);
        this.mListeners = new ArrayList<ITestRunListener>();
        this.mListeners.addAll(listeners);
        if (this.mTestTimeout >= 0L) {
            this.mListeners.add(new TestTimeoutListener(this.mTestTimeout, this));
        }
        if (expectedTests == null) {
            this.mDevice.runInstrumentationTests(this.mRunner, this.mListeners);
            return true;
        }
        if (expectedTests.size() != 0) {
            this.runWithRerun(listeners, expectedTests);
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("No tests expected for %s, skipping", this.mPackageName));
        return false;
    }

    private void runWithRerun(List<ITestInvocationListener> listeners, Collection<TestIdentifier> expectedTests) throws DeviceNotAvailableException {
        CollectingTestListener testTracker = new CollectingTestListener();
        this.mListeners.add(testTracker);
        this.mDevice.runInstrumentationTests(this.mRunner, this.mListeners);
        TestRunResult runResult = testTracker.getCurrentRunResults();
        if (runResult.isRunFailure() || !runResult.isRunComplete()) {
            expectedTests.removeAll(runResult.getTests());
            InstrumentationListTest testRerunner = new InstrumentationListTest(this.mPackageName, this.mRunnerName, expectedTests);
            testRerunner.setDevice(this.getDevice());
            testRerunner.setTestTimeout(this.getTestTimeout());
            testRerunner.run(listeners);
        }
    }

    private Collection<TestIdentifier> collectTestsToRun(IRemoteAndroidTestRunner runner) throws DeviceNotAvailableException {
        if (this.isRerunMode()) {
            Log.d((String)LOG_TAG, (String)String.format("Collecting test info for %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
            runner.setLogOnly(true);
            if (this.mTestDelay > 0) {
                runner.addInstrumentationArg(DELAY_MSEC_ARG, Integer.toString(this.mTestDelay));
            }
            CollectingTestsRunnable collectRunnable = new CollectingTestsRunnable(this.mDevice, this.mRunner);
            boolean result = this.getRunUtil().runTimedRetry(120000L, 5000L, 3, collectRunnable);
            runner.setLogOnly(false);
            this.mRunner.removeInstrumentationArg(DELAY_MSEC_ARG);
            if (result) {
                return collectRunnable.getTests();
            }
            if (collectRunnable.getException() != null) {
                throw collectRunnable.getException();
            }
            Log.w((String)LOG_TAG, (String)String.format("Failed to collect tests to run for %s on device %s", this.mPackageName, this.mDevice.getSerialNumber()));
        }
        return null;
    }

    @Override
    public void testTimeout(TestIdentifier test) {
        this.mRunner.cancel();
        String msg = String.format(TIMED_OUT_MSG, this.mTestTimeout);
        for (ITestRunListener listener : this.mListeners) {
            listener.testFailed(ITestRunListener.TestFailure.ERROR, test, msg);
            listener.testRunFailed(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CollectingTestsRunnable
    implements IRunUtil.IRunnableResult {
        private final IRemoteAndroidTestRunner mRunner;
        private final ITestDevice mDevice;
        private Collection<TestIdentifier> mTests;
        private DeviceNotAvailableException mException;

        public CollectingTestsRunnable(ITestDevice device, IRemoteAndroidTestRunner runner) {
            this.mRunner = runner;
            this.mDevice = device;
            this.mTests = null;
            this.mException = null;
        }

        @Override
        public boolean run() {
            CollectingTestListener listener = new CollectingTestListener();
            ArrayList<ITestRunListener> listeners = new ArrayList<ITestRunListener>(1);
            listeners.add(listener);
            try {
                this.mDevice.runInstrumentationTests(this.mRunner, listeners);
                TestRunResult runResults = listener.getCurrentRunResults();
                this.mTests = runResults.getTests();
                return !runResults.isRunFailure() && runResults.isRunComplete();
            }
            catch (DeviceNotAvailableException e) {
                this.mException = e;
                return false;
            }
        }

        public Collection<TestIdentifier> getTests() {
            return new ArrayList<TestIdentifier>(this.mTests);
        }

        public DeviceNotAvailableException getException() {
            return this.mException;
        }

        @Override
        public void cancel() {
            this.mRunner.cancel();
        }
    }
}

