/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.testtype;

import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.testtype.AbstractRemoteTest;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import com.android.tradefed.testtype.InstrumentationTest;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InstrumentationListTest
extends AbstractRemoteTest
implements IDeviceTest,
IRemoteTest {
    private final String mPackageName;
    private final String mRunnerName;
    private final Collection<TestIdentifier> mTests;
    private long mTestTimeout = 600000L;
    private ITestDevice mDevice = null;

    InstrumentationListTest(String packageName, String runnerName, Collection<TestIdentifier> testsToRun) {
        this.mPackageName = packageName;
        this.mRunnerName = runnerName;
        this.mTests = testsToRun;
    }

    @Override
    public void setDevice(ITestDevice device) {
        this.mDevice = device;
    }

    void setTestTimeout(long timeout) {
        this.mTestTimeout = timeout;
    }

    @Override
    public ITestDevice getDevice() {
        return this.mDevice;
    }

    @Override
    public int countTestCases() {
        return this.mTests.size();
    }

    InstrumentationTest createInstrumentationTest() {
        return new InstrumentationTest();
    }

    @Override
    public void run(List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        if (this.mDevice == null) {
            throw new IllegalArgumentException("Device has not been set");
        }
        for (TestIdentifier testToRun : this.mTests) {
            InstrumentationTest runner = this.createInstrumentationTest();
            runner.setDevice(this.mDevice);
            runner.setPackageName(this.mPackageName);
            runner.setRunnerName(this.mRunnerName);
            runner.setClassName(testToRun.getClassName());
            runner.setMethodName(testToRun.getTestName());
            runner.setTestTimeout(this.mTestTimeout);
            runner.setRerunMode(false);
            runner.run(listeners);
        }
    }
}

