/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetsetup;

import com.android.tradefed.targetsetup.IFlashingResourcesParser;
import com.android.tradefed.targetsetup.TargetSetupError;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashingResourcesParser
implements IFlashingResourcesParser {
    private static final String ANDROID_INFO_FILE_NAME = "android-info.txt";
    private static final Pattern KEY_PATTERN = Pattern.compile("(?:require\\s)?(.*)=(.*)");
    static final String PRODUCT_KEY = "product";
    static final String BOARD_KEY = "board";
    static final String BOOTLOADER_VERSION_KEY = "version-bootloader";
    static final String BASEBAND_VERSION_KEY = "version-baseband";
    private Map<String, List<String>> mReqs;

    public FlashingResourcesParser(File deviceImgZipFile) throws TargetSetupError {
        this.mReqs = FlashingResourcesParser.getBuildRequirements(deviceImgZipFile);
    }

    public FlashingResourcesParser(BufferedReader infoReader) throws TargetSetupError, IOException {
        this.mReqs = FlashingResourcesParser.parseAndroidInfo(infoReader);
    }

    @Override
    public String getRequiredBootloaderVersion() {
        return this.getRequiredImageVersion(BOOTLOADER_VERSION_KEY);
    }

    @Override
    public String getRequiredBasebandVersion() {
        return this.getRequiredImageVersion(BASEBAND_VERSION_KEY);
    }

    @Override
    public String getRequiredImageVersion(String imageVersionKey) {
        return this.getFirst(this.mReqs.get(imageVersionKey));
    }

    @Override
    public Collection<String> getRequiredBoards() {
        ArrayList<String> all = new ArrayList<String>();
        Collection board = this.mReqs.get(BOARD_KEY);
        Collection product = this.mReqs.get(PRODUCT_KEY);
        if (board != null) {
            all.addAll(board);
        } else if (product != null) {
            all.addAll(product);
        } else {
            return null;
        }
        return all;
    }

    private String getFirst(List<String> values) {
        if (values != null && !values.isEmpty()) {
            return values.get(0);
        }
        return null;
    }

    static Map<String, List<String>> getBuildRequirements(File deviceImgZipFile) throws TargetSetupError {
        ZipFile deviceZip = null;
        BufferedReader infoReader = null;
        try {
            deviceZip = new ZipFile(deviceImgZipFile);
            ZipEntry androidInfoEntry = deviceZip.getEntry(ANDROID_INFO_FILE_NAME);
            if (androidInfoEntry == null) {
                throw new TargetSetupError(String.format("Could not find %s in device image zip %s", ANDROID_INFO_FILE_NAME, deviceImgZipFile.getName()));
            }
            infoReader = new BufferedReader(new InputStreamReader(deviceZip.getInputStream(androidInfoEntry)));
            Map<String, List<String>> map = FlashingResourcesParser.parseAndroidInfo(infoReader);
            return map;
        }
        catch (ZipException e) {
            throw new TargetSetupError(String.format("Could not read device image zip %s", deviceImgZipFile.getName()), e);
        }
        catch (IOException e) {
            throw new TargetSetupError(String.format("Could not read device image zip %s", deviceImgZipFile.getName()), e);
        }
        finally {
            if (deviceZip != null) {
                try {
                    deviceZip.close();
                }
                catch (IOException e) {}
            }
            if (infoReader != null) {
                try {
                    infoReader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    static Map<String, List<String>> parseAndroidInfo(BufferedReader infoReader) throws IOException {
        HashMap<String, List<String>> requiredImageMap = new HashMap<String, List<String>>();
        boolean eof = false;
        while (!eof) {
            String line = infoReader.readLine();
            if (line != null) {
                Matcher matcher = KEY_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String values = matcher.group(2);
                requiredImageMap.put(matcher.group(1), Arrays.asList(values.split("\\|")));
                continue;
            }
            eof = true;
        }
        return requiredImageMap;
    }
}

