/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.targetsetup;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.targetsetup.BuildError;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IDeviceBuildInfo;
import com.android.tradefed.targetsetup.IDeviceFlasher;
import com.android.tradefed.targetsetup.ITargetPreparer;
import com.android.tradefed.targetsetup.TargetSetupError;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.File;
import java.io.IOException;

public class DeviceSetup
implements ITargetPreparer {
    private static final String LOG_TAG = "DeviceSetup";
    private static final int BOOT_POLL_TIME_MS = 5000;
    @Option(name="wifi-network", description="the name of wifi network to connect to")
    private String mWifiNetwork = null;
    @Option(name="wifi-psk", description="WPA-PSK passphrase of wifi network to connect to")
    private String mWifiPsk = null;
    @Option(name="min-external-store-space", description="the minimum amount of free space in KBthat must be present on device's external storage")
    private long mMinExternalStoreSpace = 500L;
    @Option(name="local-data-path", description="optional local file path of test data to sync to device's external storage. Use --remote-data-path to set remote location")
    private File mLocalDataFile = null;
    @Option(name="remote-data-path", description="optional file path on device's external storage to sync test data. Must be used with --local-data-path")
    private String mRemoteDataPath = null;
    @Option(name="disable-dialing", description="set disable dialing property on boot")
    private boolean mDisableDialing = true;
    @Option(name="set-monkey", description="set ro.monkey on boot")
    private boolean mSetMonkey = true;
    @Option(name="audio-silent", description="set ro.audio.silent on boot")
    private boolean mSetAudioSilent = true;
    @Option(name="disable-dalvik-verifier", description="disable the dalvik verifier on device. Allows package-private framework tests to run.")
    private boolean mDisableDalvikVerifier = false;
    @Option(name="device-boot-time", description="max time in ms to wait for device to boot. Default 5 minutes.")
    private long mDeviceBootTime = 300000L;
    @Option(name="skip-flash", description="don't flash a new build on device ie setup only")
    private boolean mSkipFlash = false;
    @Option(name="userdata-flash", description="specify handling of userdata partition. One of FLASH (default), TESTS_ZIP, WIPE, SKIP")
    private String mUserDataFlashString = IDeviceFlasher.UserDataFlashOption.FLASH.toString();

    void setLocalDataPath(File localPath) {
        this.mLocalDataFile = localPath;
    }

    void setRemoteDataPath(String remotePath) {
        this.mRemoteDataPath = remotePath;
    }

    void setWifiNetwork(String network) {
        this.mWifiNetwork = network;
    }

    void setDeviceBootTime(long bootTime) {
        this.mDeviceBootTime = bootTime;
    }

    int getDeviceBootPollTimeMs() {
        return 5000;
    }

    void setMinExternalStoreSpace(int minKBytes) {
        this.mMinExternalStoreSpace = minKBytes;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public void setUp(ITestDevice device, IBuildInfo buildInfo) throws TargetSetupError, DeviceNotAvailableException, BuildError {
        Log.i((String)LOG_TAG, (String)String.format("Performing setup on %s", device.getSerialNumber()));
        if (!this.mSkipFlash) {
            if (!(buildInfo instanceof IDeviceBuildInfo)) {
                throw new IllegalArgumentException("Provided buildInfo is not a IDeviceBuildInfo");
            }
            IDeviceBuildInfo deviceBuild = (IDeviceBuildInfo)buildInfo;
            IDeviceFlasher flasher = this.createFlasher(device);
            flasher.setUserDataFlashOption(IDeviceFlasher.UserDataFlashOption.valueOf(this.mUserDataFlashString));
            flasher.flash(device, deviceBuild);
            device.waitForDeviceOnline();
            this.waitForBootComplete(device, buildInfo.getBuildId());
            device.waitForDeviceAvailable();
        }
        this.configureDevice(device);
    }

    protected IDeviceFlasher createFlasher(ITestDevice device) throws DeviceNotAvailableException {
        throw new UnsupportedOperationException();
    }

    private void waitForBootComplete(ITestDevice device, int buildId) throws DeviceNotAvailableException, BuildError {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < this.mDeviceBootTime) {
            String output = device.executeShellCommand("getprop dev.bootcomplete");
            if ((output = output.replace('#', ' ').trim()).equals("1")) {
                return;
            }
            this.getRunUtil().sleep(this.getDeviceBootPollTimeMs());
        }
        throw new BuildError(String.format("Device %s running build %d did not boot after %d ms", device.getSerialNumber(), buildId, this.mDeviceBootTime));
    }

    protected void configureDevice(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        device.enableAdbRoot();
        this.configureSystemProperties(device);
        this.keepScreenOn(device);
        this.connectToWifi(device);
        this.syncTestData(device);
        this.checkExternalStoreSpace(device);
        device.postBootSetup();
        device.clearErrorDialogs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureSystemProperties(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        StringBuilder propertyBuilder = new StringBuilder();
        if (this.mDisableDialing) {
            propertyBuilder.append("ro.telephony.disable-call=true\n");
        }
        if (this.mSetMonkey) {
            propertyBuilder.append("ro.monkey=1\n");
        }
        if (this.mSetAudioSilent) {
            propertyBuilder.append("ro.audio.silent=1\n");
        }
        if (this.mDisableDalvikVerifier) {
            propertyBuilder.append("dalvik.vm.dexopt-flags = v=n");
        }
        if (propertyBuilder.length() > 0) {
            File localFile = this.createTempFile("local.prop", propertyBuilder.toString());
            try {
                boolean result = device.pushFile(localFile, "/data/local.prop");
                if (!result) {
                    throw new TargetSetupError(String.format("Failed to push file to %s", device.getSerialNumber()));
                }
            }
            finally {
                localFile.delete();
            }
            Log.i((String)LOG_TAG, (String)String.format("Setup requires system property change. Reboot of %s required", device.getSerialNumber()));
            device.reboot();
        }
    }

    private void keepScreenOn(ITestDevice device) throws DeviceNotAvailableException {
        device.executeShellCommand("svc power stayon true");
    }

    private void checkExternalStoreSpace(ITestDevice device) throws DeviceNotAvailableException {
        long freeSpace;
        if (this.mMinExternalStoreSpace > 0L && (freeSpace = device.getExternalStoreFreeSpace()) < this.mMinExternalStoreSpace) {
            throw new DeviceNotAvailableException(String.format("External store free space %dK is less than required %dK for device %s", freeSpace, this.mMinExternalStoreSpace, device.getSerialNumber()));
        }
    }

    private void connectToWifi(ITestDevice device) throws DeviceNotAvailableException, TargetSetupError {
        if (this.mWifiNetwork != null) {
            if (device.connectToWifiNetwork(this.mWifiNetwork, this.mWifiPsk)) {
                Log.i((String)LOG_TAG, (String)String.format("Connected to wifi network %s", this.mWifiNetwork));
            } else {
                throw new TargetSetupError(String.format("Failed to connect to wifi network %s on %s", this.mWifiNetwork, device.getSerialNumber()));
            }
        }
    }

    void syncTestData(ITestDevice device) throws TargetSetupError, DeviceNotAvailableException {
        if (this.mLocalDataFile != null) {
            boolean result;
            if (!this.mLocalDataFile.exists() || !this.mLocalDataFile.isDirectory()) {
                throw new TargetSetupError(String.format("local-data-path %s is not a directory", this.mLocalDataFile.getAbsolutePath()));
            }
            String fullRemotePath = device.getIDevice().getMountPoint("EXTERNAL_STORAGE");
            if (this.mRemoteDataPath != null) {
                fullRemotePath = String.format("%s/%s", fullRemotePath, this.mRemoteDataPath);
            }
            if (!(result = device.syncFiles(this.mLocalDataFile, fullRemotePath))) {
                throw new DeviceNotAvailableException(String.format("failed to sync test data from local-data-path %s to %s on device %s", this.mLocalDataFile.getAbsolutePath(), fullRemotePath, device.getSerialNumber()));
            }
        }
    }

    private File createTempFile(String fileName, String fileContents) throws TargetSetupError {
        File tmpFile = null;
        try {
            tmpFile = FileUtil.createTempFile(fileName, ".txt");
            FileUtil.writeToFile(fileContents, tmpFile);
            return tmpFile;
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            if (tmpFile != null) {
                tmpFile.delete();
            }
            throw new TargetSetupError("Failed to create local temp file", e);
        }
    }
}

