/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.result.TestResult;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunResult {
    private final String mTestRunName;
    private Map<TestIdentifier, TestResult> mTestResults = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, String> mRunMetrics = null;
    private boolean mIsRunComplete = false;
    private boolean mIsRunFailed = false;
    private long mElapsedTime = 0L;
    private Integer mNumFailedTests = null;
    private Integer mNumErrorTests = null;
    private Integer mNumPassedTests = null;

    public TestRunResult(String runName) {
        this.mTestRunName = runName;
    }

    public String getName() {
        return this.mTestRunName;
    }

    public Map<TestIdentifier, TestResult> getTestResults() {
        return this.mTestResults;
    }

    public void setMetrics(Map<String, String> runMetrics) {
        this.mRunMetrics = runMetrics;
    }

    public Map<String, String> getRunMetrics() {
        return this.mRunMetrics;
    }

    public Set<TestIdentifier> getTests() {
        return this.mTestResults.keySet();
    }

    public boolean isRunFailure() {
        return this.mIsRunFailed;
    }

    public boolean isRunComplete() {
        return this.mIsRunComplete;
    }

    void setRunComplete(boolean runComplete) {
        this.mIsRunComplete = runComplete;
    }

    void setRunFailed(boolean runFailed) {
        this.mIsRunFailed = runFailed;
    }

    void addElapsedTime(long elapsedTime) {
        this.mElapsedTime += elapsedTime;
    }

    private synchronized boolean areTestCountsCalculated() {
        return this.mNumFailedTests != null;
    }

    private synchronized void calculateTestCounts() {
        this.mNumFailedTests = 0;
        this.mNumErrorTests = 0;
        this.mNumPassedTests = 0;
        for (TestResult result : this.getTestResults().values()) {
            switch (result.getStatus()) {
                case PASSED: {
                    Integer n = this.mNumPassedTests;
                    Integer n2 = this.mNumPassedTests = Integer.valueOf(this.mNumPassedTests + 1);
                    break;
                }
                case FAILURE: {
                    Integer n = this.mNumFailedTests;
                    Integer n2 = this.mNumFailedTests = Integer.valueOf(this.mNumFailedTests + 1);
                    break;
                }
                case ERROR: {
                    Integer n = this.mNumErrorTests;
                    Integer n2 = this.mNumErrorTests = Integer.valueOf(this.mNumErrorTests + 1);
                }
            }
        }
    }

    public int getNumPassedTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumPassedTests;
    }

    public int getNumTests() {
        return this.mTestResults.size();
    }

    public int getNumFailedTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumFailedTests;
    }

    public int getNumErrorTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumErrorTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    public long getElapsedTime() {
        return this.mElapsedTime;
    }
}

