/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.Log;
import com.android.tradefed.config.Option;
import com.android.tradefed.result.CollectingTestListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.util.Email;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailResultReporter
extends CollectingTestListener
implements ITestSummaryListener {
    private static final String LOG_TAG = "EmailResultReporter";
    @Option(name="sender", description="The envelope-sender address to use for the messages")
    private String mSender = null;
    @Option(name="destination", description="One or more destination addresses")
    private Collection<String> mDestinations = new HashSet<String>();
    private List<TestSummary> mSummaries = null;

    @Override
    public void putSummary(List<TestSummary> summaries) {
        this.mSummaries = summaries;
    }

    protected boolean shouldSendMessage() {
        return true;
    }

    protected String generateEmailSubject() {
        return String.format("Tradefed: %d passed, %d failed, %d error", this.getNumPassedTests(), this.getNumFailedTests(), this.getNumErrorTests());
    }

    protected String generateEmailBody() {
        StringBuilder bodyBuilder = new StringBuilder();
        ListIterator<TestSummary> iter = this.mSummaries.listIterator();
        while (iter.hasNext()) {
            TestSummary summary = iter.next();
            bodyBuilder.append("Source ");
            bodyBuilder.append(summary.getSource());
            bodyBuilder.append(" provided summary \"");
            bodyBuilder.append(summary.getSummary().getString());
            bodyBuilder.append("\".\nIts key-value dump was:\n");
            bodyBuilder.append(summary.getKvEntries().toString());
            bodyBuilder.append("\n\n");
        }
        return bodyBuilder.toString();
    }

    @Override
    public void invocationEnded(long elapsedTime) {
        if (this.mDestinations.isEmpty()) {
            Log.e((String)LOG_TAG, (String)"Failed to send email because no destination addresses were set.");
            return;
        }
        Email mailer = new Email();
        mailer.setSender(this.mSender);
        Email.Message msg = new Email.Message();
        msg.setSubject(this.generateEmailSubject());
        msg.setBody(this.generateEmailBody());
        Iterator<String> toAddress = this.mDestinations.iterator();
        while (toAddress.hasNext()) {
            msg.addTo(toAddress.next());
        }
        try {
            mailer.send(msg);
        }
        catch (Throwable e) {
            System.err.println("Caught a throwable: " + e.toString());
        }
    }
}

