/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.result;

import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestResult;
import com.android.tradefed.result.TestRunResult;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.targetsetup.IBuildInfo;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectingTestListener
implements ITestInvocationListener {
    private Map<String, TestRunResult> mRunResultsMap = Collections.synchronizedMap(new LinkedHashMap());
    private TestRunResult mCurrentResults = null;
    private Integer mNumTotalTests = null;
    private Integer mNumPassedTests = null;
    private Integer mNumFailedTests = null;
    private Integer mNumErrorTests = null;

    @Override
    public void invocationStarted(IBuildInfo buildInfo) {
    }

    public void testRunStarted(String name, int numTests) {
        if (this.mRunResultsMap.containsKey(name)) {
            this.mCurrentResults = this.mRunResultsMap.get(name);
        } else {
            this.mCurrentResults = new TestRunResult(name);
            this.mRunResultsMap.put(name, this.mCurrentResults);
        }
        this.mCurrentResults.setRunComplete(false);
        this.mCurrentResults.setRunFailed(false);
    }

    public void testStarted(TestIdentifier test) {
    }

    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("testEnded called before testRunStarted");
        }
        if (!this.mCurrentResults.getTestResults().containsKey(test)) {
            this.mCurrentResults.getTestResults().put(test, new TestResult(TestResult.TestStatus.PASSED));
        }
    }

    public void testFailed(ITestRunListener.TestFailure status, TestIdentifier test, String trace) {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("testFailed called before testRunStarted");
        }
        if (status.equals((Object)ITestRunListener.TestFailure.ERROR)) {
            this.mCurrentResults.getTestResults().put(test, new TestResult(TestResult.TestStatus.ERROR, trace));
        } else {
            this.mCurrentResults.getTestResults().put(test, new TestResult(TestResult.TestStatus.FAILURE, trace));
        }
    }

    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("testRunEnded called before testRunStarted");
        }
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.setMetrics(runMetrics);
        this.mCurrentResults.addElapsedTime(elapsedTime);
    }

    public void testRunFailed(String errorMessage) {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("testRunFailed called before testRunStarted");
        }
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.setRunFailed(true);
    }

    public void testRunStopped(long elapsedTime) {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("testRunStopped called before testRunStarted");
        }
        this.mCurrentResults.setRunComplete(true);
        this.mCurrentResults.addElapsedTime(elapsedTime);
    }

    public TestRunResult getCurrentRunResults() {
        if (this.mCurrentResults == null) {
            throw new IllegalStateException("no current results");
        }
        return this.mCurrentResults;
    }

    public Collection<TestRunResult> getRunResults() {
        return this.mRunResultsMap.values();
    }

    public int getNumTotalTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumTotalTests;
    }

    public int getNumFailedTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumFailedTests;
    }

    public int getNumErrorTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumErrorTests;
    }

    public int getNumPassedTests() {
        if (!this.areTestCountsCalculated()) {
            this.calculateTestCounts();
        }
        return this.mNumPassedTests;
    }

    public boolean hasFailedTests() {
        return this.getNumErrorTests() > 0 || this.getNumFailedTests() > 0;
    }

    private synchronized boolean areTestCountsCalculated() {
        return this.mNumTotalTests != null;
    }

    private synchronized void calculateTestCounts() {
        this.mNumTotalTests = 0;
        this.mNumPassedTests = 0;
        this.mNumFailedTests = 0;
        this.mNumErrorTests = 0;
        for (TestRunResult runResult : this.getRunResults()) {
            this.mNumTotalTests = this.mNumTotalTests + runResult.getNumTests();
            this.mNumPassedTests = this.mNumPassedTests + runResult.getNumPassedTests();
            this.mNumFailedTests = this.mNumFailedTests + runResult.getNumFailedTests();
            this.mNumErrorTests = this.mNumErrorTests + runResult.getNumErrorTests();
        }
    }

    @Override
    public void invocationEnded(long elapsedTime) {
    }

    @Override
    public void invocationFailed(Throwable cause) {
    }

    @Override
    public TestSummary getSummary() {
        return null;
    }

    @Override
    public void testLog(String dataName, LogDataType dataType, InputStream dataStream) {
    }
}

