/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.invoker;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.ITestDevice;
import com.android.tradefed.invoker.ITestInvocation;
import com.android.tradefed.log.ILeveledLogOutput;
import com.android.tradefed.log.LogRegistry;
import com.android.tradefed.result.ITestInvocationListener;
import com.android.tradefed.result.ITestSummaryListener;
import com.android.tradefed.result.JUnitToInvocationResultForwarder;
import com.android.tradefed.result.LogDataType;
import com.android.tradefed.result.TestSummary;
import com.android.tradefed.targetsetup.BuildError;
import com.android.tradefed.targetsetup.IBuildInfo;
import com.android.tradefed.targetsetup.IBuildProvider;
import com.android.tradefed.targetsetup.ITargetPreparer;
import com.android.tradefed.targetsetup.TargetSetupError;
import com.android.tradefed.testtype.IDeviceTest;
import com.android.tradefed.testtype.IRemoteTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestInvocation
implements ITestInvocation {
    private static final String LOG_TAG = "TestInvocation";
    static final String TRADEFED_LOG_NAME = "host_log";
    static final String DEVICE_LOG_NAME = "device_logcat";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(ITestDevice device, IConfiguration config) throws DeviceNotAvailableException {
        List<ITestInvocationListener> listeners = null;
        ILeveledLogOutput logger = null;
        try {
            logger = config.getLogOutput();
            IBuildProvider buildProvider = config.getBuildProvider();
            List<ITargetPreparer> preparers = config.getTargetPreparers();
            IDeviceRecovery recovery = config.getDeviceRecovery();
            device.setRecovery(recovery);
            List<Test> tests = config.getTests();
            IBuildInfo info = buildProvider.getBuild();
            if (info != null) {
                listeners = config.getTestInvocationListeners();
                this.performInvocation(config, buildProvider, device, listeners, preparers, tests, info, logger);
            } else {
                Log.i((String)LOG_TAG, (String)"No build to test");
            }
        }
        catch (TargetSetupError e) {
            Log.e((String)LOG_TAG, (Throwable)e);
        }
        catch (ConfigurationException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
        }
        finally {
            if (logger != null) {
                logger.closeLog();
            }
        }
    }

    private void logStartInvocation(IBuildInfo info, ITestDevice device) {
        StringBuilder msg = new StringBuilder("Starting invocation for target ");
        msg.append(info.getTestTarget());
        msg.append(" on build ");
        msg.append(info.getBuildId());
        for (String buildAttr : info.getBuildAttributes().values()) {
            msg.append(" ");
            msg.append(buildAttr);
        }
        msg.append(" on device ");
        msg.append(device.getSerialNumber());
        Log.logAndDisplay((Log.LogLevel)Log.LogLevel.INFO, (String)LOG_TAG, (String)msg.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInvocation(IConfiguration config, IBuildProvider buildProvider, ITestDevice device, List<ITestInvocationListener> listeners, List<ITargetPreparer> preparers, List<Test> tests, IBuildInfo info, ILeveledLogOutput logger) throws DeviceNotAvailableException {
        long startTime = System.currentTimeMillis();
        long elapsedTime = -1L;
        this.getLogRegistry().registerLogger(logger);
        this.logStartInvocation(info, device);
        for (ITestInvocationListener listener : listeners) {
            listener.invocationStarted(info);
        }
        try {
            if (device != null) {
                info.addBuildAttribute("device_serial", device.getSerialNumber());
            }
            for (ITargetPreparer preparer : preparers) {
                preparer.setUp(device, info);
            }
            this.runTests(config, device, info, tests, listeners);
        }
        catch (BuildError e) {
            Log.w((String)LOG_TAG, (String)String.format("Build %d failed on device %s", info.getBuildId(), device.getSerialNumber()));
            this.reportFailure(e, listeners, buildProvider, info);
        }
        catch (TargetSetupError e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            this.reportFailure(e, listeners, buildProvider, info);
        }
        catch (DeviceNotAvailableException e) {
            Log.e((String)LOG_TAG, (Throwable)e);
            this.reportFailure(e, listeners, buildProvider, info);
            throw e;
        }
        catch (RuntimeException e) {
            Log.e((String)LOG_TAG, (String)"Unexpected runtime exception!");
            Log.e((String)LOG_TAG, (Throwable)e);
            this.reportFailure(e, listeners, buildProvider, info);
            throw e;
        }
        finally {
            elapsedTime = System.currentTimeMillis() - startTime;
            try {
                this.reportInvocationEnded(device, listeners, logger, elapsedTime);
            }
            finally {
                info.cleanUp();
            }
        }
    }

    private void reportFailure(Throwable exception, List<ITestInvocationListener> listeners, IBuildProvider buildProvider, IBuildInfo info) {
        for (ITestInvocationListener listener : listeners) {
            listener.invocationFailed(exception);
        }
        if (!(exception instanceof BuildError)) {
            buildProvider.buildNotTested(info);
        }
    }

    private void reportInvocationEnded(ITestDevice device, List<ITestInvocationListener> listeners, ILeveledLogOutput logger, long elapsedTime) {
        ArrayList<TestSummary> summaries = new ArrayList<TestSummary>(listeners.size());
        for (ITestInvocationListener listener : listeners) {
            if (device != null) {
                listener.testLog(DEVICE_LOG_NAME, LogDataType.TEXT, device.getLogcat());
            }
            listener.testLog(TRADEFED_LOG_NAME, LogDataType.TEXT, logger.getLog());
            this.getLogRegistry().unregisterLogger();
            if (listener instanceof ITestSummaryListener) continue;
            listener.invocationEnded(elapsedTime);
            TestSummary summary = listener.getSummary();
            if (summary == null) continue;
            summary.setSource(listener.getClass().getName());
            summaries.add(summary);
        }
        for (ITestInvocationListener listener : listeners) {
            if (!(listener instanceof ITestSummaryListener)) continue;
            ((ITestSummaryListener)listener).putSummary(summaries);
            listener.invocationEnded(elapsedTime);
        }
    }

    LogRegistry getLogRegistry() {
        return LogRegistry.getLogRegistry();
    }

    private void runTests(IConfiguration config, ITestDevice device, IBuildInfo buildInfo, List<Test> tests, List<ITestInvocationListener> listeners) throws DeviceNotAvailableException {
        for (Test test : tests) {
            if (test instanceof IDeviceTest) {
                ((IDeviceTest)test).setDevice(device);
            }
            if (test instanceof IRemoteTest) {
                ((IRemoteTest)test).run(listeners);
                continue;
            }
            for (ITestInvocationListener listener : listeners) {
                listener.testRunStarted(test.getClass().getName(), test.countTestCases());
            }
            long startTime = System.currentTimeMillis();
            JUnitToInvocationResultForwarder resultForwarder = new JUnitToInvocationResultForwarder(listeners);
            TestResult result = new TestResult();
            result.addListener(resultForwarder);
            test.run(result);
            Map emptyMap = Collections.emptyMap();
            for (ITestInvocationListener listener : listeners) {
                listener.testRunEnded(System.currentTimeMillis() - startTime, emptyMap);
            }
        }
    }
}

