/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.FileListingService;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.testrunner.IRemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.tradefed.config.Option;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.DeviceNotAvailableException;
import com.android.tradefed.device.DeviceUnresponsiveException;
import com.android.tradefed.device.FileEntryWrapper;
import com.android.tradefed.device.IDeviceRecovery;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.IFileEntry;
import com.android.tradefed.device.IManagedTestDevice;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.device.WifiHelper;
import com.android.tradefed.result.StubTestListener;
import com.android.tradefed.util.CommandResult;
import com.android.tradefed.util.CommandStatus;
import com.android.tradefed.util.FileUtil;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestDevice
implements IManagedTestDevice {
    private static final String LOG_TAG = "TestDevice";
    static final int MAX_RETRY_ATTEMPTS = 3;
    private static final int LOGCAT_BUFF_SIZE = 32768;
    private static final String LOGCAT_CMD = "logcat -v threadtime";
    private int mLogStartDelay = 5000;
    private static final int FASTBOOT_TIMEOUT = 60000;
    private static final int NUM_CLEAR_ATTEMPTS = 5;
    static final String DISMISS_DIALOG_CMD = "input keyevent 23";
    private int mCmdTimeout = 120000;
    private long mLongCmdTimeout = 720000L;
    private IDevice mIDevice;
    private IDeviceRecovery mRecovery;
    private final IDeviceStateMonitor mMonitor;
    private TestDeviceState mState = TestDeviceState.ONLINE;
    private Semaphore mFastbootLock = new Semaphore(1);
    private LogCatReceiver mLogcatReceiver;
    private IFileEntry mRootFile = null;
    @Option(name="enable-root", description="enable adb root on boot")
    private boolean mEnableAdbRoot = true;
    @Option(name="disable-keyguard", description="attempt to disable keyguard once complete")
    private boolean mDisableKeyguard = true;
    @Option(name="disable-keyguard-cmd", description="shell command to disable keyguard")
    private String mDisableKeyguardCmd = "input keyevent 82";
    @Option(name="max-tmp-logcat-file", description="The maximum size of a tmp logcat file, in bytes")
    private long mMaxLogcatFileSize = 0xA00000L;

    TestDevice(IDevice device, IDeviceStateMonitor monitor) {
        this.mIDevice = device;
        this.mMonitor = monitor;
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    void setTmpLogcatSize(long size) {
        this.mMaxLogcatFileSize = size;
    }

    void setLogStartDelay(int delay) {
        this.mLogStartDelay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDevice getIDevice() {
        IDevice iDevice = this.mIDevice;
        synchronized (iDevice) {
            return this.mIDevice;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIDevice(IDevice newDevice) {
        IDevice currentDevice = this.mIDevice;
        if (!this.getIDevice().equals(newDevice)) {
            IDevice iDevice = currentDevice;
            synchronized (iDevice) {
                this.mIDevice = newDevice;
            }
            this.mMonitor.setIDevice(this.mIDevice);
        }
    }

    @Override
    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    @Override
    public String getProductType() throws DeviceNotAvailableException {
        return this.internalGetProductType(3);
    }

    private String internalGetProductType(int retryAttempts) throws DeviceNotAvailableException {
        String productType = this.getIDevice().getProperty("ro.product.board");
        if (productType == null || productType.isEmpty()) {
            if (this.getDeviceState() == TestDeviceState.FASTBOOT) {
                Log.w((String)LOG_TAG, (String)String.format("Product type for device %s is null, re-querying in fastboot", this.getSerialNumber()));
                productType = this.getFastbootProduct();
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Product type for device %s is null, re-querying", this.getSerialNumber()));
                productType = this.executeShellCommand("getprop ro.product.board").trim();
                if (productType.isEmpty()) {
                    productType = this.executeShellCommand("getprop ro.product.device").trim();
                    Log.w((String)LOG_TAG, (String)String.format("Fell back to ro.product.device because ro.product.board is unset. product type is %s.", productType));
                }
            }
        }
        if (productType == null || productType.isEmpty()) {
            if (retryAttempts > 0) {
                this.recoverDevice();
                productType = this.internalGetProductType(retryAttempts - 1);
            }
            if (productType == null || productType.isEmpty()) {
                throw new DeviceNotAvailableException(String.format("Could not determine product type for device %s.", this.getSerialNumber()));
            }
        }
        return productType;
    }

    private String getFastbootProduct() throws DeviceNotAvailableException {
        CommandResult result = this.executeFastbootCommand("getvar", "product");
        if (result.getStatus() == CommandStatus.SUCCESS) {
            Matcher matcher;
            Pattern fastbootProductPattern = Pattern.compile("product:[ ]+(\\w+)");
            String resultText = result.getStdout();
            if (resultText == null || resultText.length() < 1) {
                resultText = result.getStderr();
            }
            if ((matcher = fastbootProductPattern.matcher(resultText)).find()) {
                return matcher.group(1);
            }
        }
        return null;
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(command, receiver, TestDevice.this.mCmdTimeout);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, 3);
    }

    @Override
    public void executeShellCommand(final String command, final IShellOutputReceiver receiver, final int maxTimeToOutputShellResponse, int retryAttempts) throws DeviceNotAvailableException {
        DeviceAction action = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, ShellCommandUnresponsiveException {
                TestDevice.this.getIDevice().executeShellCommand(command, receiver, maxTimeToOutputShellResponse);
                return true;
            }
        };
        this.performDeviceAction(String.format("shell %s", command), action, retryAttempts);
    }

    @Override
    public String executeShellCommand(String command) throws DeviceNotAvailableException {
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        this.executeShellCommand(command, receiver);
        String output = receiver.getOutput();
        Log.v((String)LOG_TAG, (String)String.format("%s on %s returned %s", command, this.getSerialNumber(), output));
        return output;
    }

    @Override
    public void runInstrumentationTests(IRemoteAndroidTestRunner runner, Collection<ITestRunListener> listeners) throws DeviceNotAvailableException {
        try {
            RunFailureListener failureListener = new RunFailureListener();
            listeners.add(failureListener);
            runner.setMaxtimeToOutputResponse((int)this.mLongCmdTimeout);
            runner.run(listeners);
            if (failureListener.mIsRunFailure && this.mMonitor.waitForDeviceAvailable(5000L) == null) {
                this.recoverDevice();
            }
        }
        catch (IOException e) {
            this.recoverDevice();
        }
        catch (ShellCommandUnresponsiveException e) {
            this.recoverDevice();
        }
        catch (TimeoutException e) {
            this.recoverDevice();
        }
        catch (AdbCommandRejectedException e) {
            this.recoverDevice();
        }
    }

    @Override
    public void runInstrumentationTests(IRemoteAndroidTestRunner runner, ITestRunListener ... listeners) throws DeviceNotAvailableException {
        ArrayList<ITestRunListener> listenerList = new ArrayList<ITestRunListener>();
        listenerList.addAll(Arrays.asList(listeners));
        this.runInstrumentationTests(runner, listenerList);
    }

    @Override
    public String installPackage(final File packageFile, final boolean reinstall) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        DeviceAction installAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String result;
                response[0] = result = TestDevice.this.getIDevice().installPackage(packageFile.getAbsolutePath(), reinstall);
                return result == null;
            }
        };
        this.performDeviceAction(String.format("install %s", packageFile.getAbsolutePath()), installAction, 3);
        return response[0];
    }

    @Override
    public String uninstallPackage(final String packageName) throws DeviceNotAvailableException {
        final String[] response = new String[1];
        DeviceAction uninstallAction = new DeviceAction(){

            public boolean run() throws InstallException {
                String result;
                response[0] = result = TestDevice.this.getIDevice().uninstallPackage(packageName);
                return result == null;
            }
        };
        this.performDeviceAction(String.format("uninstall %s", packageName), uninstallAction, 3);
        return response[0];
    }

    @Override
    public boolean pullFile(final String remoteFilePath, final File localFile) throws DeviceNotAvailableException {
        DeviceAction pullAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.pullFile(remoteFilePath, localFile.getAbsolutePath(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to pull %s from %s. Message %s", remoteFilePath, TestDevice.this.getSerialNumber(), e.getMessage()));
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("pull %s", remoteFilePath), pullAction, 3);
    }

    @Override
    public boolean pushFile(final File localFile, final String remoteFilePath) throws DeviceNotAvailableException {
        DeviceAction pushAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.pushFile(localFile.getAbsolutePath(), remoteFilePath, SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to push to %s on device %s. Message %s", remoteFilePath, TestDevice.this.getSerialNumber(), e.getMessage()));
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("push %s", remoteFilePath), pushAction, 3);
    }

    @Override
    public boolean doesFileExist(String destPath) throws DeviceNotAvailableException {
        String lsGrep = this.executeShellCommand(String.format("ls \"%s\"", destPath));
        return !lsGrep.contains("No such file or directory");
    }

    @Override
    public long getExternalStoreFreeSpace() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Checking free space for %s", this.getSerialNumber()));
        String externalStorePath = this.getMountPoint("EXTERNAL_STORAGE");
        String output = this.executeShellCommand(String.format("df %s", externalStorePath));
        Long available = this.parseFreeSpaceFromAvailable(output);
        if (available != null) {
            return available;
        }
        available = this.parseFreeSpaceFromFree(externalStorePath, output);
        if (available != null) {
            return available;
        }
        Log.e((String)LOG_TAG, (String)String.format("free space command output \"%s\" did not match expected patterns", output));
        return 0L;
    }

    private Long parseFreeSpaceFromAvailable(String dfOutput) {
        Pattern freeSpacePattern = Pattern.compile("(\\d+)K available");
        Matcher patternMatcher = freeSpacePattern.matcher(dfOutput);
        if (patternMatcher.find()) {
            String freeSpaceString = patternMatcher.group(1);
            try {
                return Long.parseLong(freeSpaceString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    private Long parseFreeSpaceFromFree(String externalStorePath, String dfOutput) {
        Long freeSpace = null;
        Pattern freeSpaceTablePattern = Pattern.compile(String.format("%s\\s+[\\w\\d]+\\s+[\\w\\d]+\\s+(\\d+)(\\w)", externalStorePath));
        Matcher tablePatternMatcher = freeSpaceTablePattern.matcher(dfOutput);
        if (tablePatternMatcher.find()) {
            String numericValueString = tablePatternMatcher.group(1);
            String unitType = tablePatternMatcher.group(2);
            try {
                freeSpace = Long.parseLong(numericValueString);
                if (unitType.equals("M")) {
                    freeSpace = freeSpace * 1024L;
                } else if (unitType.equals("G")) {
                    freeSpace = freeSpace * 1024L * 1024L;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return freeSpace;
    }

    @Override
    public String getMountPoint(String mountName) {
        return this.mMonitor.getMountPoint(mountName);
    }

    @Override
    public IFileEntry getFileEntry(String path) throws DeviceNotAvailableException {
        String[] pathComponents = path.split("/");
        if (this.mRootFile == null) {
            FileListingService service = this.getIDevice().getFileListingService();
            this.mRootFile = new FileEntryWrapper(this, service.getRoot());
        }
        return FileEntryWrapper.getDescendant(this.mRootFile, Arrays.asList(pathComponents));
    }

    @Override
    public boolean syncFiles(File localFileDir, String deviceFilePath) throws DeviceNotAvailableException {
        IFileEntry remoteFileEntry;
        Log.i((String)LOG_TAG, (String)String.format("Syncing %s to %s on device %s", localFileDir.getAbsolutePath(), deviceFilePath, this.getSerialNumber()));
        if (!localFileDir.isDirectory()) {
            Log.e((String)LOG_TAG, (String)String.format("file %s is not a directory", localFileDir.getAbsolutePath()));
            return false;
        }
        if (!this.doesFileExist(deviceFilePath = String.format("%s/%s", deviceFilePath, localFileDir.getName()))) {
            this.executeShellCommand(String.format("mkdir %s", deviceFilePath));
        }
        if ((remoteFileEntry = this.getFileEntry(deviceFilePath)) == null) {
            Log.e((String)LOG_TAG, (String)String.format("Could not find remote file entry %s ", deviceFilePath));
            return false;
        }
        return this.syncFiles(localFileDir, remoteFileEntry);
    }

    private boolean syncFiles(File localFileDir, final IFileEntry remoteFileEntry) throws DeviceNotAvailableException {
        Log.d((String)LOG_TAG, (String)String.format("Syncing %s to %s on %s", localFileDir.getAbsolutePath(), remoteFileEntry.getFullPath(), this.getSerialNumber()));
        File[] localFiles = localFileDir.listFiles(new NoHiddenFilesFilter());
        ArrayList<String> filePathsToSync = new ArrayList<String>();
        for (File localFile : localFiles) {
            IFileEntry entry = remoteFileEntry.findChild(localFile.getName());
            if (entry == null) {
                Log.d((String)LOG_TAG, (String)String.format("Detected missing file path %s", localFile.getAbsolutePath()));
                filePathsToSync.add(localFile.getAbsolutePath());
                continue;
            }
            if (localFile.isDirectory()) {
                if (this.syncFiles(localFile, entry)) continue;
                return false;
            }
            if (!this.isNewer(localFile, entry)) continue;
            Log.d((String)LOG_TAG, (String)String.format("Detected newer file %s", localFile.getAbsolutePath()));
            filePathsToSync.add(localFile.getAbsolutePath());
        }
        if (filePathsToSync.size() == 0) {
            Log.d((String)LOG_TAG, (String)"No files to sync");
            return true;
        }
        final String[] files = filePathsToSync.toArray(new String[filePathsToSync.size()]);
        DeviceAction syncAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException, SyncException {
                SyncService syncService = null;
                boolean status = false;
                try {
                    syncService = TestDevice.this.getIDevice().getSyncService();
                    syncService.push(files, remoteFileEntry.getFileEntry(), SyncService.getNullProgressMonitor());
                    status = true;
                }
                catch (SyncException e) {
                    Log.w((String)TestDevice.LOG_TAG, (String)String.format("Failed to sync files to %s on device %s. Message %s", remoteFileEntry.getFullPath(), TestDevice.this.getSerialNumber(), e.getMessage()));
                    throw e;
                }
                finally {
                    if (syncService != null) {
                        syncService.close();
                    }
                }
                return status;
            }
        };
        return this.performDeviceAction(String.format("sync files %s", remoteFileEntry.getFullPath()), syncAction, 3);
    }

    FileListingService.FileEntry[] getFileChildren(FileListingService.FileEntry remoteFileEntry) throws DeviceNotAvailableException {
        FileQueryAction action = new FileQueryAction(remoteFileEntry, this.getIDevice().getFileListingService());
        this.performDeviceAction("buildFileCache", action, 3);
        return action.mFileContents;
    }

    private boolean isNewer(File localFile, IFileEntry entry) {
        String entryTimeString = String.format("%s %s GMT", entry.getDate(), entry.getTime());
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm zzz");
            Date remoteDate = format.parse(entryTimeString);
            return localFile.lastModified() > remoteDate.getTime() - 60000L;
        }
        catch (ParseException e) {
            Log.e((String)LOG_TAG, (String)String.format("Error converting remote time stamp %s for %s on device %s", entryTimeString, entry.getFullPath(), this.getSerialNumber()));
            return true;
        }
    }

    @Override
    public String executeAdbCommand(String ... cmdArgs) throws DeviceNotAvailableException {
        final String[] fullCmd = this.buildAdbCommand(cmdArgs);
        final String[] output = new String[1];
        DeviceAction adbAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException {
                CommandResult result = TestDevice.this.getRunUtil().runTimedCmd(TestDevice.this.getCommandTimeout(), fullCmd);
                if (result.getStatus() != CommandStatus.SUCCESS) {
                    throw new IOException();
                }
                if (result.getStatus() == CommandStatus.EXCEPTION) {
                    throw new IOException();
                }
                if (result.getStatus() == CommandStatus.TIMED_OUT) {
                    throw new TimeoutException();
                }
                output[0] = result.getStdout();
                return true;
            }
        };
        this.performDeviceAction(String.format("adb %s", cmdArgs[0]), adbAction, 3);
        return output[0];
    }

    @Override
    public CommandResult executeFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException {
        return this.doFastbootCommand(this.getCommandTimeout(), cmdArgs);
    }

    @Override
    public CommandResult executeLongFastbootCommand(String ... cmdArgs) throws DeviceNotAvailableException {
        return this.doFastbootCommand(this.getLongCommandTimeout(), cmdArgs);
    }

    private CommandResult doFastbootCommand(long timeout, String ... cmdArgs) throws DeviceNotAvailableException {
        String[] fullCmd = this.buildFastbootCommand(cmdArgs);
        for (int i = 0; i < 3; ++i) {
            try {
                this.mFastbootLock.acquire();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            CommandResult result = this.getRunUtil().runTimedCmd(timeout, fullCmd);
            this.mFastbootLock.release();
            if (!this.isRecoveryNeeded(result)) {
                return result;
            }
            this.recoverDeviceFromBootloader();
        }
        throw new DeviceUnresponsiveException(String.format("Attempted fastboot %s multiple times on device %s without communication success. Aborting.", cmdArgs[0], this.getSerialNumber()));
    }

    private boolean isRecoveryNeeded(CommandResult fastbootResult) {
        if (fastbootResult.getStatus().equals((Object)CommandStatus.TIMED_OUT)) {
            return true;
        }
        if (fastbootResult.getStderr().contains("data transfer failure (Protocol error)") || fastbootResult.getStderr().contains("status read failed (No such device)")) {
            Log.w((String)LOG_TAG, (String)String.format("Bad fastboot response from device %s. stderr: %s. Entering recovery", this.getSerialNumber(), fastbootResult.getStderr()));
            return true;
        }
        return false;
    }

    int getCommandTimeout() {
        return this.mCmdTimeout;
    }

    void setLongCommandTimeout(long timeout) {
        this.mLongCmdTimeout = timeout;
    }

    long getLongCommandTimeout() {
        return this.mLongCmdTimeout;
    }

    void setCommandTimeout(int timeout) {
        this.mCmdTimeout = timeout;
    }

    private String[] buildAdbCommand(String ... commandArgs) {
        int numAdbArgs = 3;
        String[] newCmdArgs = new String[commandArgs.length + 3];
        newCmdArgs[0] = "adb";
        newCmdArgs[1] = "-s";
        newCmdArgs[2] = this.getSerialNumber();
        System.arraycopy(commandArgs, 0, newCmdArgs, 3, commandArgs.length);
        return newCmdArgs;
    }

    private String[] buildFastbootCommand(String ... commandArgs) {
        int numAdbArgs = 3;
        String[] newCmdArgs = new String[commandArgs.length + 3];
        newCmdArgs[0] = "fastboot";
        newCmdArgs[1] = "-s";
        newCmdArgs[2] = this.getSerialNumber();
        System.arraycopy(commandArgs, 0, newCmdArgs, 3, commandArgs.length);
        return newCmdArgs;
    }

    private boolean performDeviceAction(String actionDescription, DeviceAction action, int attempts) throws DeviceNotAvailableException {
        for (int i = 0; i < attempts; ++i) {
            try {
                return action.run();
            }
            catch (TimeoutException e) {
                Log.w((String)LOG_TAG, (String)String.format("'%s' timed out on device %s", actionDescription, this.getSerialNumber()));
            }
            catch (IOException e) {
                Log.w((String)LOG_TAG, (String)String.format("Exception when attempting %s on device %s", actionDescription, this.getSerialNumber()));
            }
            catch (InstallException e) {
                Log.w((String)LOG_TAG, (String)String.format("InstallException when attempting %s on device %s", actionDescription, this.getSerialNumber()));
            }
            catch (SyncException e) {
                Log.w((String)LOG_TAG, (String)String.format("SyncException when attempting %s on device %s", actionDescription, this.getSerialNumber()));
            }
            catch (AdbCommandRejectedException e) {
                Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException when attempting %s on device %s", actionDescription, this.getSerialNumber()));
            }
            catch (ShellCommandUnresponsiveException e) {
                Log.w((String)LOG_TAG, (String)String.format("Device %s stopped responding when attempting %s", this.getSerialNumber(), actionDescription));
            }
            this.recoverDevice();
        }
        throw new DeviceUnresponsiveException(String.format("Attempted %s multiple times on device %s without communication success. Aborting.", actionDescription, this.getSerialNumber()));
    }

    void recoverDevice() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempting recovery on %s", this.getSerialNumber()));
        this.mRecovery.recoverDevice(this.mMonitor);
        Log.i((String)LOG_TAG, (String)String.format("Recovery successful for %s", this.getSerialNumber()));
        this.postBootSetup();
    }

    private void recoverDeviceFromBootloader() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempting recovery on %s in bootloader", this.getSerialNumber()));
        this.mRecovery.recoverDeviceBootloader(this.mMonitor);
        Log.i((String)LOG_TAG, (String)String.format("Bootloader recovery successful for %s", this.getSerialNumber()));
    }

    @Override
    public void startLogcat() {
        if (this.mLogcatReceiver != null) {
            Log.d((String)LOG_TAG, (String)String.format("Already capturing logcat for %s, ignoring", this.getSerialNumber()));
            return;
        }
        this.mLogcatReceiver = new LogCatReceiver();
        this.mLogcatReceiver.start();
    }

    @Override
    public InputStream getLogcat() {
        if (this.mLogcatReceiver == null) {
            Log.w((String)LOG_TAG, (String)String.format("Not capturing logcat for %s in background, returning a logcat dump", this.getSerialNumber()));
            return this.getLogcatDump();
        }
        return this.mLogcatReceiver.getLogcatData();
    }

    private InputStream getLogcatDump() {
        String output = "";
        try {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            this.getIDevice().executeShellCommand("logcat -v threadtime -d", (IShellOutputReceiver)receiver);
            output = receiver.getOutput();
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage()));
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: timeout", this.getSerialNumber()));
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage()));
        }
        catch (ShellCommandUnresponsiveException e) {
            Log.w((String)LOG_TAG, (String)String.format("Failed to get logcat dump from %s: ", this.getSerialNumber(), e.getMessage()));
        }
        return new ByteArrayInputStream(output.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLogcat() {
        if (this.mLogcatReceiver != null) {
            LogCatReceiver logCatReceiver = this.mLogcatReceiver;
            synchronized (logCatReceiver) {
                this.mLogcatReceiver.cancel();
                this.mLogcatReceiver = null;
            }
        } else {
            Log.w((String)LOG_TAG, (String)String.format("Attempting to stop logcat when not capturing for %s", this.getSerialNumber()));
        }
    }

    LogCatReceiver createLogcatReceiver() {
        return new LogCatReceiver();
    }

    @Override
    public boolean connectToWifiNetwork(String wifiSsid, String wifiPsk) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber()));
        WifiHelper wifi = new WifiHelper(this);
        wifi.enableWifi();
        wifi.waitForWifiState(WifiHelper.WifiState.SCANNING, WifiHelper.WifiState.COMPLETED);
        Integer networkId = null;
        networkId = wifiPsk != null ? wifi.addWpaPskNetwork(wifiSsid, wifiPsk) : wifi.addOpenNetwork(wifiSsid);
        if (networkId == null) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to add wifi network %s on %s", wifiSsid, this.getSerialNumber()));
            return false;
        }
        if (!wifi.associateNetwork(networkId)) {
            Log.e((String)LOG_TAG, (String)String.format("Failed to enable wifi network %s on %s", wifiSsid, this.getSerialNumber()));
            return false;
        }
        if (!wifi.waitForWifiState(WifiHelper.WifiState.COMPLETED)) {
            Log.e((String)LOG_TAG, (String)String.format("wifi network %s failed to associate on %s", wifiSsid, this.getSerialNumber()));
            return false;
        }
        if (!wifi.waitForDhcp(30000L)) {
            Log.e((String)LOG_TAG, (String)String.format("dhcp timeout when connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber()));
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            String pingOutput = this.executeShellCommand("ping -c 1 -w 5 www.google.com");
            if (pingOutput.contains("1 packets transmitted, 1 received")) {
                return true;
            }
            this.getRunUtil().sleep(1000L);
        }
        Log.e((String)LOG_TAG, (String)String.format("ping unsuccessful after connecting to wifi network %s on %s", wifiSsid, this.getSerialNumber()));
        return false;
    }

    @Override
    public boolean disconnectFromWifi() throws DeviceNotAvailableException {
        WifiHelper wifi = new WifiHelper(this);
        wifi.removeAllNetworks();
        wifi.disableWifi();
        return true;
    }

    @Override
    public boolean clearErrorDialogs() throws DeviceNotAvailableException {
        for (int i = 0; i < 5; ++i) {
            int numErrorDialogs = this.getErrorDialogCount();
            if (numErrorDialogs == 0) {
                return true;
            }
            this.doClearDialogs(numErrorDialogs);
        }
        if (this.getErrorDialogCount() > 0) {
            Log.e((String)LOG_TAG, (String)String.format("error dialogs still exist on %s.", this.getSerialNumber()));
            return false;
        }
        return true;
    }

    private int getErrorDialogCount() throws DeviceNotAvailableException {
        int errorDialogCount = 0;
        Pattern crashPattern = Pattern.compile(".*crashing=true.*AppErrorDialog.*");
        Pattern anrPattern = Pattern.compile(".*notResponding=true.*AppNotRespondingDialog.*");
        String systemStatusOutput = this.executeShellCommand("dumpsys activity processes");
        Matcher crashMatcher = crashPattern.matcher(systemStatusOutput);
        while (crashMatcher.find()) {
            ++errorDialogCount;
        }
        Matcher anrMatcher = anrPattern.matcher(systemStatusOutput);
        while (anrMatcher.find()) {
            ++errorDialogCount;
        }
        return errorDialogCount;
    }

    private void doClearDialogs(int numDialogs) throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("Attempted to clear %d dialogs on %s", numDialogs, this.getSerialNumber()));
        for (int i = 0; i < numDialogs; ++i) {
            this.executeShellCommand(DISMISS_DIALOG_CMD);
        }
    }

    IDeviceStateMonitor getDeviceStateMonitor() {
        return this.mMonitor;
    }

    @Override
    public void postBootSetup() throws DeviceNotAvailableException {
        if (this.mEnableAdbRoot) {
            this.enableAdbRoot();
        }
        if (this.mDisableKeyguard) {
            Log.i((String)LOG_TAG, (String)String.format("Attempting to disable keyguard on %s using %s", this.getSerialNumber(), this.mDisableKeyguardCmd));
            this.executeShellCommand(this.mDisableKeyguardCmd);
        }
    }

    String getDisableKeyguardCmd() {
        return this.mDisableKeyguardCmd;
    }

    @Override
    public void rebootIntoBootloader() throws DeviceNotAvailableException {
        if (TestDeviceState.FASTBOOT == this.mMonitor.getDeviceState()) {
            Log.i((String)LOG_TAG, (String)String.format("device %s already in fastboot. Rebooting anyway", this.getSerialNumber()));
            this.executeFastbootCommand("reboot-bootloader");
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Booting device %s into bootloader", this.getSerialNumber()));
            this.doAdbRebootBootloader();
        }
        if (!this.mMonitor.waitForDeviceBootloader(60000L)) {
            this.recoverDeviceFromBootloader();
        }
    }

    private void doAdbRebootBootloader() throws DeviceNotAvailableException {
        try {
            this.getIDevice().reboot("bootloader");
            return;
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (String)String.format("IOException '%s' when rebooting %s into bootloader", e.getMessage(), this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
        catch (TimeoutException e) {
            Log.w((String)LOG_TAG, (String)String.format("TimeoutException when rebooting %s into bootloader", this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
        catch (AdbCommandRejectedException e) {
            Log.w((String)LOG_TAG, (String)String.format("AdbCommandRejectedException '%s' when rebooting %s into bootloader", e.getMessage(), this.getSerialNumber()));
            this.recoverDeviceFromBootloader();
        }
    }

    @Override
    public void reboot() throws DeviceNotAvailableException {
        this.doReboot();
        if (this.mMonitor.waitForDeviceAvailable() != null) {
            this.postBootSetup();
            return;
        }
        this.recoverDevice();
    }

    @Override
    public void rebootUntilOnline() throws DeviceNotAvailableException {
        this.doReboot();
        if (this.mMonitor.waitForDeviceOnline() != null) {
            if (this.mEnableAdbRoot) {
                this.enableAdbRoot();
            }
            return;
        }
        this.recoverDevice();
    }

    private void doReboot() throws DeviceNotAvailableException {
        if (TestDeviceState.FASTBOOT == this.getDeviceState()) {
            Log.i((String)LOG_TAG, (String)String.format("device %s in fastboot. Rebooting to userspace.", this.getSerialNumber()));
            this.executeFastbootCommand("reboot");
        } else {
            Log.i((String)LOG_TAG, (String)String.format("Rebooting device %s", this.getSerialNumber()));
            this.doAdbReboot(null);
            this.waitForDeviceNotAvailable("reboot", this.getCommandTimeout());
        }
    }

    private void doAdbReboot(final String into) throws DeviceNotAvailableException {
        DeviceAction rebootAction = new DeviceAction(){

            public boolean run() throws TimeoutException, IOException, AdbCommandRejectedException {
                TestDevice.this.getIDevice().reboot(into);
                return true;
            }
        };
        this.performDeviceAction("reboot", rebootAction, 3);
    }

    private void waitForDeviceNotAvailable(String operationDesc, long time) {
        if (!this.mMonitor.waitForDeviceNotAvailable(time)) {
            Log.w((String)LOG_TAG, (String)String.format("Did not detect device %s becoming unavailable after %s", this.getSerialNumber(), operationDesc));
        }
    }

    @Override
    public boolean enableAdbRoot() throws DeviceNotAvailableException {
        Log.i((String)LOG_TAG, (String)String.format("adb root on device %s", this.getSerialNumber()));
        String output = this.executeAdbCommand("root");
        if (output.contains("adbd is already running as root")) {
            return true;
        }
        if (output.contains("restarting adbd as root")) {
            this.waitForDeviceNotAvailable("root", 30000L);
            this.waitForDeviceOnline();
            return true;
        }
        Log.e((String)LOG_TAG, (String)String.format("Unrecognized output from adb root: %s", output));
        return false;
    }

    @Override
    public void waitForDeviceOnline(long waitTime) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline(waitTime) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceOnline() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceOnline() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable(long waitTime) throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable(waitTime) == null) {
            this.recoverDevice();
        }
    }

    @Override
    public void waitForDeviceAvailable() throws DeviceNotAvailableException {
        if (this.mMonitor.waitForDeviceAvailable() == null) {
            this.recoverDevice();
        }
    }

    @Override
    public boolean waitForDeviceNotAvailable(long waitTime) {
        return this.mMonitor.waitForDeviceNotAvailable(waitTime);
    }

    void setEnableAdbRoot(boolean enable) {
        this.mEnableAdbRoot = enable;
    }

    IDeviceRecovery getRecovery() {
        return this.mRecovery;
    }

    @Override
    public void setRecovery(IDeviceRecovery recovery) {
        this.mRecovery = recovery;
    }

    @Override
    public void setDeviceState(TestDeviceState deviceState) {
        if (!deviceState.equals((Object)this.getDeviceState())) {
            if (this.getDeviceState().equals((Object)TestDeviceState.FASTBOOT) && !this.mFastbootLock.tryAcquire()) {
                return;
            }
            Log.d((String)LOG_TAG, (String)String.format("Device %s state is now %s", new Object[]{this.getSerialNumber(), deviceState}));
            this.mState = deviceState;
            this.mFastbootLock.release();
            this.mMonitor.setState(deviceState);
        }
    }

    @Override
    public TestDeviceState getDeviceState() {
        return this.mState;
    }

    class LogCatReceiver
    extends Thread
    implements IShellOutputReceiver {
        private boolean mIsCancelled = false;
        private OutputStream mOutStream;
        private File mPreviousTmpFile = null;
        private File mTmpFile = null;
        private long mTmpBytesStored = 0L;

        LogCatReceiver() {
        }

        public synchronized void addOutput(byte[] data, int offset, int length) {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.write(data, offset, length);
                this.mTmpBytesStored += (long)length;
                if (this.mTmpBytesStored > TestDevice.this.mMaxLogcatFileSize) {
                    Log.i((String)TestDevice.LOG_TAG, (String)String.format("Max tmp logcat file size reached for %s, swapping", TestDevice.this.getSerialNumber()));
                    this.createTmpFile();
                    this.mTmpBytesStored = 0L;
                }
            }
            catch (IOException e) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to write logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized InputStream getLogcatData() {
            if (this.mTmpFile != null) {
                this.flush();
                try {
                    FileInputStream fileStream = new FileInputStream(this.mTmpFile);
                    if (this.mPreviousTmpFile != null) {
                        return new SequenceInputStream(new FileInputStream(this.mPreviousTmpFile), fileStream);
                    }
                    return fileStream;
                }
                catch (IOException e) {
                    Log.e((String)TestDevice.LOG_TAG, (String)String.format("failed to get logcat data for %s.", TestDevice.this.getSerialNumber()));
                    Log.e((String)TestDevice.LOG_TAG, (Throwable)e);
                }
            }
            return new ByteArrayInputStream(new byte[0]);
        }

        public synchronized void flush() {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.flush();
            }
            catch (IOException e) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to flush logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized void cancel() {
            this.mIsCancelled = true;
            this.interrupt();
            this.closeLogStream();
            if (this.mTmpFile != null) {
                this.mTmpFile.delete();
                this.mTmpFile = null;
            }
            if (this.mPreviousTmpFile != null) {
                this.mPreviousTmpFile.delete();
                this.mPreviousTmpFile = null;
            }
        }

        private void closeLogStream() {
            try {
                if (this.mOutStream != null) {
                    this.mOutStream.flush();
                    this.mOutStream.close();
                    this.mOutStream = null;
                }
            }
            catch (IOException e) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to close logcat stream for %s.", TestDevice.this.getSerialNumber()));
            }
        }

        public synchronized boolean isCancelled() {
            return this.mIsCancelled;
        }

        public void run() {
            try {
                this.createTmpFile();
            }
            catch (IOException e) {
                Log.e((String)TestDevice.LOG_TAG, (String)String.format("failed to create tmp logcat file for %s.", TestDevice.this.getSerialNumber()));
                Log.e((String)TestDevice.LOG_TAG, (Throwable)e);
                return;
            }
            while (!this.isCancelled()) {
                try {
                    if (TestDevice.this.mLogStartDelay > 0) {
                        Log.d((String)TestDevice.LOG_TAG, (String)String.format("Sleep for %d before starting logcat for %s.", TestDevice.this.mLogStartDelay, TestDevice.this.getSerialNumber()));
                        TestDevice.this.getRunUtil().sleep(TestDevice.this.mLogStartDelay);
                    }
                    Log.d((String)TestDevice.LOG_TAG, (String)String.format("Starting logcat for %s.", TestDevice.this.getSerialNumber()));
                    TestDevice.this.getIDevice().executeShellCommand(TestDevice.LOGCAT_CMD, (IShellOutputReceiver)this, 0);
                }
                catch (Exception e) {
                    String msg = String.format("logcat capture interrupted for %s. Waiting for device to be back online. May see duplicate content in log.", TestDevice.this.getSerialNumber());
                    Log.d((String)TestDevice.LOG_TAG, (String)msg);
                    this.appendDeviceLogMsg(msg);
                    TestDevice.this.getRunUtil().sleep(5000L);
                    TestDevice.this.mMonitor.waitForDeviceOnline(600000L);
                }
            }
        }

        private synchronized void createTmpFile() throws IOException, FileNotFoundException {
            this.closeLogStream();
            if (this.mPreviousTmpFile != null) {
                this.mPreviousTmpFile.delete();
            }
            this.mPreviousTmpFile = this.mTmpFile;
            this.mTmpFile = FileUtil.createTempFile(String.format("logcat_%s_", TestDevice.this.getSerialNumber()), ".txt");
            Log.i((String)TestDevice.LOG_TAG, (String)String.format("Created tmp logcat file %s", this.mTmpFile.getAbsolutePath()));
            this.mOutStream = new BufferedOutputStream(new FileOutputStream(this.mTmpFile), 32768);
        }

        private synchronized void appendDeviceLogMsg(String msg) {
            if (this.mOutStream == null) {
                return;
            }
            try {
                this.mOutStream.write("\n*******************\n".getBytes());
                this.mOutStream.write(msg.getBytes());
                this.mOutStream.write("\n*******************\n".getBytes());
            }
            catch (IOException e) {
                Log.w((String)TestDevice.LOG_TAG, (String)String.format("failed to write logcat data for %s.", TestDevice.this.getSerialNumber()));
            }
        }
    }

    private static class NoHiddenFilesFilter
    implements FilenameFilter {
        private NoHiddenFilesFilter() {
        }

        public boolean accept(File dir, String name) {
            return !name.startsWith(".");
        }
    }

    private class FileQueryAction
    implements DeviceAction {
        FileListingService.FileEntry[] mFileContents = null;
        private FileListingService.FileEntry mRemoteFileEntry;
        private FileListingService mService;

        FileQueryAction(FileListingService.FileEntry remoteFileEntry, FileListingService service) {
            this.mRemoteFileEntry = remoteFileEntry;
            this.mService = service;
        }

        public boolean run() throws TimeoutException, IOException {
            this.mFileContents = this.mService.getChildren(this.mRemoteFileEntry, false, null);
            return true;
        }
    }

    private static class RunFailureListener
    extends StubTestListener {
        private boolean mIsRunFailure = false;

        private RunFailureListener() {
        }

        public void testRunFailed(String message) {
            this.mIsRunFailure = true;
        }
    }

    private static interface DeviceAction {
        public boolean run() throws IOException, TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, InstallException, SyncException;
    }
}

