/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.tradefed.device.CollectingOutputReceiver;
import com.android.tradefed.device.IDeviceManager;
import com.android.tradefed.device.IDeviceStateMonitor;
import com.android.tradefed.device.TestDeviceState;
import com.android.tradefed.util.IRunUtil;
import com.android.tradefed.util.RunUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

class DeviceStateMonitor
implements IDeviceStateMonitor {
    private static final String LOG_TAG = "DeviceStateMonitor";
    private IDevice mDevice;
    private TestDeviceState mDeviceState;
    private static final long CHECK_POLL_TIME = 5000L;
    private static final int MAX_OP_TIME = 30000;
    private static final long DEFAULT_ONLINE_TIMEOUT = 60000L;
    private static final long DEFAULT_AVAILABLE_TIMEOUT = 360000L;
    private List<DeviceStateListener> mStateListeners;
    private IDeviceManager mMgr;

    DeviceStateMonitor(IDeviceManager mgr, IDevice device) {
        this.mMgr = mgr;
        this.mDevice = device;
        this.mStateListeners = new ArrayList<DeviceStateListener>();
        this.mDeviceState = TestDeviceState.getStateByDdms(device.getState());
    }

    IRunUtil getRunUtil() {
        return RunUtil.getInstance();
    }

    public IDevice waitForDeviceOnline(long waitTime) {
        if (this.waitForDeviceState(TestDeviceState.ONLINE, waitTime)) {
            return this.getIDevice();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevice getIDevice() {
        IDevice iDevice = this.mDevice;
        synchronized (iDevice) {
            return this.mDevice;
        }
    }

    public String getSerialNumber() {
        return this.getIDevice().getSerialNumber();
    }

    public IDevice waitForDeviceOnline() {
        return this.waitForDeviceOnline(60000L);
    }

    public boolean waitForDeviceNotAvailable(long waitTime) {
        StubFastbootListener listener = new StubFastbootListener();
        this.mMgr.addFastbootListener(listener);
        boolean result = this.waitForDeviceState(TestDeviceState.NOT_AVAILABLE, waitTime);
        this.mMgr.removeFastbootListener(listener);
        return result;
    }

    public IDevice waitForDeviceAvailable(long waitTime) {
        long startTime = System.currentTimeMillis();
        IDevice device = this.waitForDeviceOnline(waitTime);
        if (device == null) {
            return null;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.waitForPmResponsive(waitTime - elapsedTime)) {
            return null;
        }
        elapsedTime = System.currentTimeMillis() - startTime;
        if (!this.waitForStoreMount(waitTime - elapsedTime)) {
            return null;
        }
        return device;
    }

    public IDevice waitForDeviceAvailable() {
        return this.waitForDeviceAvailable(360000L);
    }

    private boolean waitForPmResponsive(long waitTime) {
        Log.i((String)LOG_TAG, (String)String.format("Waiting %d ms for device %s package manager", waitTime, this.getSerialNumber()));
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < waitTime) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            String cmd = "pm path android";
            try {
                this.getIDevice().executeShellCommand("pm path android", (IShellOutputReceiver)receiver, 30000);
                String output = receiver.getOutput();
                Log.v((String)LOG_TAG, (String)String.format("%s returned %s", "pm path android", output));
                if (output.contains("package:")) {
                    return true;
                }
            }
            catch (IOException e) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", e.getMessage()));
            }
            catch (TimeoutException e) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: timeout", "pm path android"));
            }
            catch (AdbCommandRejectedException e) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", e.getMessage()));
            }
            catch (ShellCommandUnresponsiveException e) {
                Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", "pm path android", e.getMessage()));
            }
            this.getRunUtil().sleep(5000L);
        }
        Log.w((String)LOG_TAG, (String)String.format("Device %s package manager is unresponsive", this.getSerialNumber()));
        return false;
    }

    private boolean waitForStoreMount(long waitTime) {
        Log.i((String)LOG_TAG, (String)String.format("Waiting %d ms for device %s external store", waitTime, this.getSerialNumber()));
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < waitTime) {
            CollectingOutputReceiver receiver = new CollectingOutputReceiver();
            CollectingOutputReceiver bitBucket = new CollectingOutputReceiver();
            long number = System.currentTimeMillis();
            String externalStore = this.getMountPoint("EXTERNAL_STORAGE");
            String testFile = String.format("'%s/%d'", externalStore, number);
            String testString = String.format("number %d one", number);
            String writeCmd = String.format("echo '%s' > %s", testString, testFile);
            String checkCmd = String.format("cat %s", testFile);
            String cleanupCmd = String.format("rm %s", testFile);
            String cmd = null;
            if (externalStore != null) {
                try {
                    cmd = writeCmd;
                    this.getIDevice().executeShellCommand(writeCmd, (IShellOutputReceiver)bitBucket, 30000);
                    cmd = checkCmd;
                    this.getIDevice().executeShellCommand(checkCmd, (IShellOutputReceiver)receiver, 30000);
                    cmd = cleanupCmd;
                    this.getIDevice().executeShellCommand(cleanupCmd, (IShellOutputReceiver)bitBucket, 30000);
                    String output = receiver.getOutput();
                    Log.v((String)LOG_TAG, (String)String.format("%s returned %s", checkCmd, output));
                    if (output.contains(testString)) {
                        return true;
                    }
                }
                catch (IOException e) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", cmd, e.getMessage()));
                }
                catch (TimeoutException e) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: timeout", cmd));
                }
                catch (AdbCommandRejectedException e) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", cmd, e.getMessage()));
                }
                catch (ShellCommandUnresponsiveException e) {
                    Log.i((String)LOG_TAG, (String)String.format("%s failed: %s", cmd, e.getMessage()));
                }
            } else {
                Log.w((String)LOG_TAG, (String)String.format("Failed to get external store mount point for %s", this.getSerialNumber()));
            }
            this.getRunUtil().sleep(5000L);
        }
        Log.w((String)LOG_TAG, (String)String.format("Device %s external storage is not mounted after %d ms", this.getSerialNumber(), waitTime));
        return false;
    }

    public String getMountPoint(String mountName) {
        String mountPoint = this.getIDevice().getMountPoint(mountName);
        if (mountPoint != null) {
            return mountPoint;
        }
        CollectingOutputReceiver receiver = new CollectingOutputReceiver();
        try {
            this.getIDevice().executeShellCommand("echo $" + mountName, (IShellOutputReceiver)receiver);
            return receiver.getOutput().trim();
        }
        catch (IOException e) {
            return null;
        }
        catch (TimeoutException e) {
            return null;
        }
        catch (AdbCommandRejectedException e) {
            return null;
        }
        catch (ShellCommandUnresponsiveException e) {
            return null;
        }
    }

    public TestDeviceState getDeviceState() {
        return this.mDeviceState;
    }

    public boolean waitForDeviceBootloader(long time) {
        long startTime = System.currentTimeMillis();
        this.waitForDeviceBootloaderStateUpdate();
        long elapsedTime = System.currentTimeMillis() - startTime;
        StubFastbootListener listener = new StubFastbootListener();
        this.mMgr.addFastbootListener(listener);
        boolean result = this.waitForDeviceState(TestDeviceState.FASTBOOT, time - elapsedTime);
        this.mMgr.removeFastbootListener(listener);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeviceBootloaderStateUpdate() {
        NotifyFastbootListener listener;
        NotifyFastbootListener notifyFastbootListener = listener = new NotifyFastbootListener();
        synchronized (notifyFastbootListener) {
            this.mMgr.addFastbootListener(listener);
            try {
                listener.wait();
            }
            catch (InterruptedException e) {
                Log.w((String)LOG_TAG, (String)"wait for device bootloader state update interrupted");
            }
        }
        this.mMgr.removeFastbootListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForDeviceState(TestDeviceState state, long time) {
        String deviceSerial = this.getSerialNumber();
        if (this.getDeviceState() == state) {
            Log.i((String)LOG_TAG, (String)String.format("Device %s is already %s", new Object[]{deviceSerial, state}));
            return true;
        }
        Log.i((String)LOG_TAG, (String)String.format("Waiting for device %s to be %s; it is currently %s...", new Object[]{deviceSerial, state, this.getDeviceState()}));
        DeviceStateListener listener = new DeviceStateListener(state);
        this.addDeviceStateListener(listener);
        DeviceStateListener deviceStateListener = listener;
        synchronized (deviceStateListener) {
            try {
                listener.wait(time);
            }
            catch (InterruptedException e) {
                Log.w((String)LOG_TAG, (String)"wait for device state interrupted");
            }
        }
        this.removeDeviceStateListener(listener);
        return this.getDeviceState().equals((Object)state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeviceStateListener(DeviceStateListener listener) {
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            this.mStateListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceStateListener(DeviceStateListener listener) {
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            this.mStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(TestDeviceState deviceState) {
        this.mDeviceState = deviceState;
        ArrayList<DeviceStateListener> listenerCopy = new ArrayList<DeviceStateListener>(this.mStateListeners.size());
        List<DeviceStateListener> list = this.mStateListeners;
        synchronized (list) {
            listenerCopy.addAll(this.mStateListeners);
        }
        for (DeviceStateListener listener : listenerCopy) {
            listener.stateChanged(deviceState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIDevice(IDevice newDevice) {
        IDevice currentDevice = this.mDevice;
        if (!this.getIDevice().equals(newDevice)) {
            IDevice iDevice = currentDevice;
            synchronized (iDevice) {
                this.mDevice = newDevice;
            }
        }
    }

    private static class NotifyFastbootListener
    implements IDeviceManager.IFastbootListener {
        private NotifyFastbootListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateUpdated() {
            NotifyFastbootListener notifyFastbootListener = this;
            synchronized (notifyFastbootListener) {
                this.notify();
            }
        }
    }

    private static class StubFastbootListener
    implements IDeviceManager.IFastbootListener {
        private StubFastbootListener() {
        }

        public void stateUpdated() {
        }
    }

    private static class DeviceStateListener {
        private final TestDeviceState mExpectedState;

        public DeviceStateListener(TestDeviceState expectedState) {
            this.mExpectedState = expectedState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(TestDeviceState newState) {
            if (this.mExpectedState.equals((Object)newState)) {
                DeviceStateListener deviceStateListener = this;
                synchronized (deviceStateListener) {
                    this.notify();
                }
            }
        }
    }
}

