/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.device;

import com.android.ddmlib.IDevice;
import com.android.tradefed.device.DeviceSelectionOptions;
import java.util.Collection;

public class DeviceSelectionMatcher {
    public static boolean matches(IDevice device, DeviceSelectionOptions deviceOptions) {
        Collection<String> serials = deviceOptions.getSerials();
        Collection<String> excludeSerials = deviceOptions.getExcludeSerials();
        Collection<String> productTypes = deviceOptions.getProductTypes();
        if (!serials.isEmpty() && !serials.contains(device.getSerialNumber())) {
            return false;
        }
        if (excludeSerials.contains(device.getSerialNumber())) {
            return false;
        }
        return productTypes.isEmpty() || productTypes.contains(DeviceSelectionMatcher.getDeviceProductType(device));
    }

    private static String getDeviceProductType(IDevice device) {
        String type = device.getProperty("ro.product.board");
        if (type == null || type.isEmpty()) {
            type = device.getProperty("ro.product.device");
        }
        return type;
    }
}

