/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.ddmlib.Log;
import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.ConfigurationDef;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.ConfigurationXmlParser;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.IConfigurationFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationFactory
implements IConfigurationFactory {
    private static final String LOG_TAG = "ConfigurationFactory";
    private static IConfigurationFactory sInstance = null;
    static final String INSTRUMENT_CONFIG = "instrument";
    static final String HOST_TEST_CONFIG = "host";
    static final String TEST_DEF_CONFIG = "testdef";
    static final String[] sDefaultConfigs = new String[]{"instrument", "host", "testdef"};
    private Map<String, ConfigurationDef> mConfigDefMap = new Hashtable<String, ConfigurationDef>();

    private ConfigurationFactory() {
    }

    public static IConfigurationFactory getInstance() {
        if (sInstance == null) {
            sInstance = new ConfigurationFactory();
        }
        return sInstance;
    }

    @Override
    public IConfiguration getConfiguration(String name) throws ConfigurationException {
        ConfigurationDef def = this.getConfigurationDef(name);
        return def.createConfiguration();
    }

    private ConfigurationDef getConfigurationDef(String name) throws ConfigurationException {
        ConfigurationDef def = this.mConfigDefMap.get(name);
        if (def == null) {
            def = this.loadConfiguration(name);
            this.mConfigDefMap.put(name, def);
        }
        return def;
    }

    private ConfigurationDef loadConfiguration(String name) throws ConfigurationException {
        Log.i((String)LOG_TAG, (String)String.format("Loading configuration '%s'", name));
        InputStream configStream = this.getClass().getResourceAsStream(String.format("/config/%s.xml", name));
        if (configStream == null) {
            try {
                configStream = new FileInputStream(name);
            }
            catch (FileNotFoundException e) {
                throw new ConfigurationException(String.format("Could not find configuration '%s'", name));
            }
        }
        BufferedInputStream bufStream = new BufferedInputStream(configStream);
        ConfigurationXmlParser parser = new ConfigurationXmlParser();
        return parser.parse(name, bufStream);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] args) throws ConfigurationException {
        return this.createConfigurationFromArgs(args, new Object[0]);
    }

    @Override
    public IConfiguration createConfigurationFromArgs(String[] args, Object ... additionalOptionSources) throws ConfigurationException {
        if (args.length == 0) {
            throw new ConfigurationException("Configuration to run was not specified");
        }
        String configName = this.getConfigNameFromArgs(args);
        IConfiguration config = this.getConfiguration(configName);
        Collection<Object> optionObjects = config.getAllConfigurationObjects();
        for (Object optionObj : additionalOptionSources) {
            optionObjects.add(optionObj);
        }
        ArgsOptionParser parser = new ArgsOptionParser(optionObjects);
        List<String> unprocessedArgs = parser.parse(args);
        if (unprocessedArgs.size() != 1 || !unprocessedArgs.get(0).equals(configName)) {
            throw new ConfigurationException(String.format("Invalid arguments provided. Unprocessed arguments: %s", unprocessedArgs));
        }
        return config;
    }

    private String getConfigNameFromArgs(String[] args) {
        return args[args.length - 1];
    }

    @Override
    public void printHelp(String[] args, PrintStream out) {
        this.printHelp(args, out, new Class[0]);
    }

    @Override
    public void printHelp(String[] args, PrintStream out, Class<?> ... additionalSources) {
        out.println("Usage: [options] <configuration_name OR configuration xml file path>");
        out.println();
        if (args.length > 1) {
            String configName = this.getConfigNameFromArgs(args);
            try {
                ConfigurationDef def = this.getConfigurationDef(configName);
                if (additionalSources.length > 0) {
                    StringBuilder buf = new StringBuilder();
                    for (Class<?> source : additionalSources) {
                        buf.append(ArgsOptionParser.getOptionHelp(source));
                    }
                    if (buf.length() > 0) {
                        out.println("General options:");
                        out.println();
                        out.print(buf.toString());
                        out.println();
                    }
                }
                def.printCommandUsage(out);
                return;
            }
            catch (ConfigurationException e) {
                out.println(String.format("Could not load help for config with name '%s'", configName));
            }
        }
        out.println("Use --help <configuration_name> to get list of options for a configuration");
        out.println();
        out.println("See the res/config folder for available configurations.");
        out.println("Some available configurations include:");
        this.loadDefaultConfigs();
        for (ConfigurationDef def : this.mConfigDefMap.values()) {
            out.printf("  %s: %s", def.getName(), def.getDescription());
            out.println();
        }
    }

    private void loadDefaultConfigs() {
        for (String config : sDefaultConfigs) {
            try {
                this.getConfigurationDef(config);
            }
            catch (ConfigurationException e) {
                Log.w((String)LOG_TAG, (String)String.format("Could not load default config with name '%s'", config));
            }
        }
    }
}

