/*
 * Decompiled with CFR 0.152.
 */
package com.android.tradefed.config;

import com.android.tradefed.config.ArgsOptionParser;
import com.android.tradefed.config.Configuration;
import com.android.tradefed.config.ConfigurationException;
import com.android.tradefed.config.IConfiguration;
import com.android.tradefed.config.OptionSetter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationDef {
    private final Map<String, List<String>> mObjectClassMap;
    private final List<OptionDef> mOptionList;
    private final String mName;
    private String mDescription = "";

    public ConfigurationDef(String name) {
        this.mName = name;
        this.mObjectClassMap = new HashMap<String, List<String>>();
        this.mOptionList = new ArrayList<OptionDef>();
    }

    public String getDescription() {
        return this.mDescription;
    }

    void setDescription(String description) {
        this.mDescription = description;
    }

    void addConfigObjectDef(String name, String className) {
        List<String> classList = this.mObjectClassMap.get(name);
        if (classList == null) {
            classList = new ArrayList<String>();
            this.mObjectClassMap.put(name, classList);
        }
        classList.add(className);
    }

    void addOptionDef(String optionName, String optionValue) {
        this.mOptionList.add(new OptionDef(optionName, optionValue));
    }

    Map<String, List<String>> getObjectClassMap() {
        return this.mObjectClassMap;
    }

    List<OptionDef> getOptionList() {
        return this.mOptionList;
    }

    IConfiguration createConfiguration() throws ConfigurationException {
        HashMap<String, List<Object>> configObjectMap = new HashMap<String, List<Object>>(this.mObjectClassMap.size());
        for (Map.Entry<String, List<String>> objClassEntry : this.mObjectClassMap.entrySet()) {
            ArrayList<Object> objectList = new ArrayList<Object>(objClassEntry.getValue().size());
            for (String className : objClassEntry.getValue()) {
                Object configObject = this.createObject(objClassEntry.getKey(), className);
                objectList.add(configObject);
            }
            configObjectMap.put(objClassEntry.getKey(), objectList);
        }
        Configuration config = new Configuration(configObjectMap);
        Collection<Object> allConfigObjs = config.getAllConfigurationObjects();
        OptionSetter setter = new OptionSetter(allConfigObjs);
        for (OptionDef optionEntry : this.mOptionList) {
            setter.setOptionValue(optionEntry.name, optionEntry.value);
        }
        return config;
    }

    public String getName() {
        return this.mName;
    }

    public void printCommandUsage(PrintStream out) throws ConfigurationException {
        out.println(String.format("'%s' configuration: %s", this.getName(), this.getDescription()));
        out.println();
        for (Map.Entry<String, List<String>> configObjectsEntry : this.mObjectClassMap.entrySet()) {
            for (String objectClass : configObjectsEntry.getValue()) {
                String optionHelp = this.printOptionsForObject(configObjectsEntry.getKey(), objectClass);
                if (optionHelp.length() <= 0) continue;
                out.printf("  %s options:", configObjectsEntry.getKey());
                out.println();
                out.print(optionHelp);
                out.println();
            }
        }
    }

    private String printOptionsForObject(String objectName, String objectClass) throws ConfigurationException {
        Class<?> optionClass = this.getClassForObject(objectName, objectClass);
        return ArgsOptionParser.getOptionHelp(optionClass);
    }

    private Object createObject(String objectName, String className) throws ConfigurationException {
        try {
            Class<?> objectClass = this.getClassForObject(objectName, className);
            Object configObject = objectClass.newInstance();
            return configObject;
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Could not instantiate class %s for config object name %s", className, objectName), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Could not access class %s for config object name %s", className, objectName), e);
        }
    }

    private Class<?> getClassForObject(String objectName, String className) throws ConfigurationException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(String.format("Could not find class %s for config object name %s", className, objectName), e);
        }
    }

    static class OptionDef {
        final String name;
        final String value;

        OptionDef(String optionName, String optionValue) {
            this.name = optionName;
            this.value = optionValue;
        }
    }
}

