/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.Call;
import com.android.traceview.ProfileData;
import com.android.traceview.ProfileNode;
import com.android.traceview.ProfileSelf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodData {
    private int mId;
    private int mRank = -1;
    private String mClassName;
    private String mMethodName;
    private String mSignature;
    private String mName;
    private String mProfileName;
    private String mPathname;
    private int mLineNumber;
    private long mElapsedExclusive;
    private long mElapsedInclusive;
    private long mTopExclusive;
    private int[] mNumCalls = new int[2];
    private Color mColor;
    private Color mFadedColor;
    private Image mImage;
    private Image mFadedImage;
    private HashMap<Integer, ProfileData> mParents;
    private HashMap<Integer, ProfileData> mChildren;
    private HashMap<Integer, ProfileData> mRecursiveParents;
    private HashMap<Integer, ProfileData> mRecursiveChildren;
    private ProfileNode[] mProfileNodes;
    private int mX;
    private int mY;
    private double mWeight;
    private Comparator<ProfileData> mByElapsedInclusive = new Comparator<ProfileData>(){

        @Override
        public int compare(ProfileData pd1, ProfileData pd2) {
            if (pd2.getElapsedInclusive() > pd1.getElapsedInclusive()) {
                return 1;
            }
            if (pd2.getElapsedInclusive() < pd1.getElapsedInclusive()) {
                return -1;
            }
            return 0;
        }
    };

    public MethodData(int id, String className) {
        this.mId = id;
        this.mClassName = className;
        this.mMethodName = null;
        this.mSignature = null;
        this.mPathname = null;
        this.mLineNumber = -1;
        this.computeName();
        this.computeProfileName();
    }

    public MethodData(int id, String className, String methodName, String signature, String pathname, int lineNumber) {
        this.mId = id;
        this.mClassName = className;
        this.mMethodName = methodName;
        this.mSignature = signature;
        this.mPathname = pathname;
        this.mLineNumber = lineNumber;
        this.computeName();
        this.computeProfileName();
    }

    public double addWeight(int x, int y, double weight) {
        if (this.mX == x && this.mY == y) {
            this.mWeight += weight;
        } else {
            this.mX = x;
            this.mY = y;
            this.mWeight = weight;
        }
        return this.mWeight;
    }

    public void clearWeight() {
        this.mWeight = 0.0;
    }

    public int getRank() {
        return this.mRank;
    }

    public void setRank(int rank) {
        this.mRank = rank;
        this.computeProfileName();
    }

    public void addElapsedExclusive(long time) {
        this.mElapsedExclusive += time;
    }

    public void addElapsedInclusive(long time, boolean isRecursive, Call parent) {
        if (!isRecursive) {
            this.mElapsedInclusive += time;
            this.mNumCalls[0] = this.mNumCalls[0] + 1;
        } else {
            this.mNumCalls[1] = this.mNumCalls[1] + 1;
        }
        if (parent == null) {
            return;
        }
        MethodData parentMethod = parent.mMethodData;
        if (parent.isRecursive()) {
            parentMethod.mRecursiveChildren = this.updateInclusive(time, parentMethod, this, false, parentMethod.mRecursiveChildren);
        } else {
            parentMethod.mChildren = this.updateInclusive(time, parentMethod, this, false, parentMethod.mChildren);
        }
        if (isRecursive) {
            this.mRecursiveParents = this.updateInclusive(time, this, parentMethod, true, this.mRecursiveParents);
        } else {
            this.mParents = this.updateInclusive(time, this, parentMethod, true, this.mParents);
        }
    }

    private HashMap<Integer, ProfileData> updateInclusive(long time, MethodData contextMethod, MethodData elementMethod, boolean elementIsParent, HashMap<Integer, ProfileData> map) {
        if (map == null) {
            map = new HashMap(4);
        } else {
            ProfileData profileData = map.get(elementMethod.mId);
            if (profileData != null) {
                profileData.addElapsedInclusive(time);
                return map;
            }
        }
        ProfileData elementData = new ProfileData(contextMethod, elementMethod, elementIsParent);
        elementData.setElapsedInclusive(time);
        elementData.setNumCalls(1);
        map.put(elementMethod.mId, elementData);
        return map;
    }

    public void analyzeData() {
        ProfileNode profileNode;
        ProfileData[] sortedParents = this.sortProfileData(this.mParents);
        ProfileData[] sortedChildren = this.sortProfileData(this.mChildren);
        ProfileData[] sortedRecursiveParents = this.sortProfileData(this.mRecursiveParents);
        ProfileData[] sortedRecursiveChildren = this.sortProfileData(this.mRecursiveChildren);
        sortedChildren = this.addSelf(sortedChildren);
        ArrayList<ProfileNode> nodes = new ArrayList<ProfileNode>();
        if (this.mParents != null) {
            profileNode = new ProfileNode("Parents", this, sortedParents, true, false);
            nodes.add(profileNode);
        }
        if (this.mChildren != null) {
            profileNode = new ProfileNode("Children", this, sortedChildren, false, false);
            nodes.add(profileNode);
        }
        if (this.mRecursiveParents != null) {
            profileNode = new ProfileNode("Parents while recursive", this, sortedRecursiveParents, true, true);
            nodes.add(profileNode);
        }
        if (this.mRecursiveChildren != null) {
            profileNode = new ProfileNode("Children while recursive", this, sortedRecursiveChildren, false, true);
            nodes.add(profileNode);
        }
        this.mProfileNodes = nodes.toArray(new ProfileNode[nodes.size()]);
    }

    private ProfileData[] sortProfileData(HashMap<Integer, ProfileData> map) {
        if (map == null) {
            return null;
        }
        Collection<ProfileData> values = map.values();
        ProfileData[] sorted = values.toArray(new ProfileData[values.size()]);
        Arrays.sort(sorted, this.mByElapsedInclusive);
        return sorted;
    }

    private ProfileData[] addSelf(ProfileData[] children) {
        ProfileData[] pdata;
        if (children == null) {
            pdata = new ProfileData[1];
        } else {
            pdata = new ProfileData[children.length + 1];
            System.arraycopy(children, 0, pdata, 1, children.length);
        }
        pdata[0] = new ProfileSelf(this);
        return pdata;
    }

    public void addTopExclusive(long time) {
        this.mTopExclusive += time;
    }

    public long getTopExclusive() {
        return this.mTopExclusive;
    }

    public int getId() {
        return this.mId;
    }

    private void computeName() {
        if (this.mMethodName == null) {
            this.mName = this.mClassName;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mClassName);
        sb.append(".");
        sb.append(this.mMethodName);
        sb.append(" ");
        sb.append(this.mSignature);
        this.mName = sb.toString();
    }

    public String getName() {
        return this.mName;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getMethodName() {
        return this.mMethodName;
    }

    public String getProfileName() {
        return this.mProfileName;
    }

    public void computeProfileName() {
        if (this.mRank == -1) {
            this.mProfileName = this.mName;
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.mRank);
        sb.append(" ");
        sb.append(this.getName());
        this.mProfileName = sb.toString();
    }

    public String getCalls() {
        return String.format("%d+%d", this.mNumCalls[0], this.mNumCalls[1]);
    }

    public int getTotalCalls() {
        return this.mNumCalls[0] + this.mNumCalls[1];
    }

    public Color getColor() {
        return this.mColor;
    }

    public void setColor(Color color) {
        this.mColor = color;
    }

    public void setImage(Image image) {
        this.mImage = image;
    }

    public Image getImage() {
        return this.mImage;
    }

    public String toString() {
        return this.getName();
    }

    public long getElapsedExclusive() {
        return this.mElapsedExclusive;
    }

    public long getElapsedInclusive() {
        return this.mElapsedInclusive;
    }

    public void setFadedColor(Color fadedColor) {
        this.mFadedColor = fadedColor;
    }

    public Color getFadedColor() {
        return this.mFadedColor;
    }

    public void setFadedImage(Image fadedImage) {
        this.mFadedImage = fadedImage;
    }

    public Image getFadedImage() {
        return this.mFadedImage;
    }

    public void setPathname(String pathname) {
        this.mPathname = pathname;
    }

    public String getPathname() {
        return this.mPathname;
    }

    public void setLineNumber(int lineNumber) {
        this.mLineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.mLineNumber;
    }

    public ProfileNode[] getProfileNodes() {
        return this.mProfileNodes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Sorter
    implements Comparator<MethodData> {
        private Column mColumn;
        private Direction mDirection;

        @Override
        public int compare(MethodData md1, MethodData md2) {
            if (this.mColumn == Column.BY_NAME) {
                int result = md1.getName().compareTo(md2.getName());
                return this.mDirection == Direction.INCREASING ? result : -result;
            }
            if (this.mColumn == Column.BY_INCLUSIVE) {
                if (md2.getElapsedInclusive() > md1.getElapsedInclusive()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (md2.getElapsedInclusive() < md1.getElapsedInclusive()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return md1.getName().compareTo(md2.getName());
            }
            if (this.mColumn == Column.BY_EXCLUSIVE) {
                if (md2.getElapsedExclusive() > md1.getElapsedExclusive()) {
                    return this.mDirection == Direction.INCREASING ? -1 : 1;
                }
                if (md2.getElapsedExclusive() < md1.getElapsedExclusive()) {
                    return this.mDirection == Direction.INCREASING ? 1 : -1;
                }
                return md1.getName().compareTo(md2.getName());
            }
            if (this.mColumn == Column.BY_CALLS) {
                int result = md1.getTotalCalls() - md2.getTotalCalls();
                if (result == 0) {
                    return md1.getName().compareTo(md2.getName());
                }
                return this.mDirection == Direction.INCREASING ? result : -result;
            }
            if (this.mColumn == Column.BY_TIME_PER_CALL) {
                double time1 = md1.getElapsedInclusive();
                double time2 = md2.getElapsedInclusive();
                double diff = (time1 /= (double)md1.getTotalCalls()) - (time2 /= (double)md2.getTotalCalls());
                int result = 0;
                if (diff < 0.0) {
                    result = -1;
                } else if (diff > 0.0) {
                    result = 1;
                }
                if (result == 0) {
                    return md1.getName().compareTo(md2.getName());
                }
                return this.mDirection == Direction.INCREASING ? result : -result;
            }
            return 0;
        }

        public void setColumn(Column column) {
            this.mDirection = this.mColumn == column ? (this.mDirection == Direction.INCREASING ? Direction.DECREASING : Direction.INCREASING) : (column == Column.BY_NAME ? Direction.INCREASING : Direction.DECREASING);
            this.mColumn = column;
        }

        public Column getColumn() {
            return this.mColumn;
        }

        public void setDirection(Direction direction) {
            this.mDirection = direction;
        }

        public Direction getDirection() {
            return this.mDirection;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Direction {
            INCREASING,
            DECREASING;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Column {
            BY_NAME,
            BY_EXCLUSIVE,
            BY_INCLUSIVE,
            BY_CALLS,
            BY_TIME_PER_CALL;

        }
    }
}

