/*
 * Decompiled with CFR 0.152.
 */
package com.android.traceview;

import com.android.traceview.MethodData;
import com.android.traceview.TimeLineView;
import org.eclipse.swt.graphics.Color;

class Call
implements TimeLineView.Block {
    private static final int METHOD_ACTION_MASK = 3;
    private static final int IS_RECURSIVE = 16;
    private int mThreadId;
    private int mFlags;
    MethodData mMethodData;
    long mThreadStartTime;
    long mGlobalStartTime;
    long mGlobalEndTime;
    private String mName;

    Call(String name, MethodData methodData) {
        this.mName = name;
        this.mMethodData = methodData;
    }

    Call() {
    }

    Call(int threadId, MethodData methodData, long time, int methodAction) {
        this.mThreadId = threadId;
        this.mMethodData = methodData;
        this.mThreadStartTime = time;
        this.mFlags = methodAction & 3;
        this.mName = methodData.getProfileName();
    }

    public void set(int threadId, MethodData methodData, long time, int methodAction) {
        this.mThreadId = threadId;
        this.mMethodData = methodData;
        this.mThreadStartTime = time;
        this.mFlags = methodAction & 3;
        this.mName = methodData.getProfileName();
    }

    public void updateName() {
        this.mName = this.mMethodData.getProfileName();
    }

    public double addWeight(int x, int y, double weight) {
        return this.mMethodData.addWeight(x, y, weight);
    }

    public void clearWeight() {
        this.mMethodData.clearWeight();
    }

    public long getStartTime() {
        return this.mGlobalStartTime;
    }

    public long getEndTime() {
        return this.mGlobalEndTime;
    }

    public Color getColor() {
        return this.mMethodData.getColor();
    }

    public void addExclusiveTime(long elapsed) {
        this.mMethodData.addElapsedExclusive(elapsed);
        if ((this.mFlags & 0x10) == 0) {
            this.mMethodData.addTopExclusive(elapsed);
        }
    }

    public void addInclusiveTime(long elapsed, Call parent) {
        boolean isRecursive = (this.mFlags & 0x10) != 0;
        this.mMethodData.addElapsedInclusive(elapsed, isRecursive, parent);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    int getThreadId() {
        return this.mThreadId;
    }

    public MethodData getMethodData() {
        return this.mMethodData;
    }

    int getMethodAction() {
        return this.mFlags & 3;
    }

    public void dump() {
        System.out.printf("%s [%d, %d]\n", this.mName, this.mGlobalStartTime, this.mGlobalEndTime);
    }

    public void setRecursive(boolean isRecursive) {
        this.mFlags = isRecursive ? (this.mFlags |= 0x10) : (this.mFlags &= 0xFFFFFFEF);
    }

    public boolean isRecursive() {
        return (this.mFlags & 0x10) != 0;
    }
}

