/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xnet.provider.jsse;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedPKIXParameters
extends PKIXParameters {
    public final Map<Bytes, TrustAnchor> encodings = new HashMap<Bytes, TrustAnchor>();
    public final Map<X500Principal, TrustAnchor> bySubject = new HashMap<X500Principal, TrustAnchor>();
    public final Map<X500Principal, List<TrustAnchor>> byCA = new HashMap<X500Principal, List<TrustAnchor>>();

    public IndexedPKIXParameters(Set<TrustAnchor> anchors) throws KeyStoreException, InvalidAlgorithmParameterException, CertificateEncodingException {
        super(anchors);
        for (TrustAnchor anchor : anchors) {
            X509Certificate cert = anchor.getTrustedCert();
            Bytes encoded = new Bytes(cert.getEncoded());
            this.encodings.put(encoded, anchor);
            X500Principal subject = cert.getSubjectX500Principal();
            if (this.bySubject.put(subject, anchor) != null) {
                throw new KeyStoreException("Two certs have the same subject: " + subject);
            }
            X500Principal ca = anchor.getCA();
            List<TrustAnchor> caAnchors = this.byCA.get(ca);
            if (caAnchors == null) {
                caAnchors = new ArrayList<TrustAnchor>();
                this.byCA.put(ca, caAnchors);
            }
            caAnchors.add(anchor);
        }
    }

    public TrustAnchor findTrustAnchor(X509Certificate cert) throws CertPathValidatorException {
        TrustAnchor anchor;
        Exception verificationException = null;
        X500Principal issuer = cert.getIssuerX500Principal();
        List<TrustAnchor> anchors = this.byCA.get(issuer);
        if (anchors != null) {
            for (TrustAnchor caAnchor : anchors) {
                try {
                    cert.verify(caAnchor.getCAPublicKey());
                    return caAnchor;
                }
                catch (Exception e) {
                    verificationException = e;
                }
            }
        }
        if ((anchor = this.bySubject.get(issuer)) != null) {
            try {
                cert.verify(anchor.getTrustedCert().getPublicKey());
                return anchor;
            }
            catch (Exception e) {
                verificationException = e;
            }
        }
        try {
            Bytes encoded = new Bytes(cert.getEncoded());
            anchor = this.encodings.get(encoded);
            if (anchor != null) {
                return anchor;
            }
        }
        catch (Exception e) {
            Logger.getLogger(IndexedPKIXParameters.class.getName()).log(Level.WARNING, "Error encoding cert.", e);
        }
        if (verificationException != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate verification failed.", verificationException);
        }
        return null;
    }

    public boolean isDirectlyTrusted(X509Certificate cert) {
        try {
            Bytes encoded = new Bytes(cert.getEncoded());
            return this.encodings.containsKey(encoded);
        }
        catch (Exception e) {
            Logger.getLogger(IndexedPKIXParameters.class.getName()).log(Level.WARNING, "Error encoding cert.", e);
            return false;
        }
    }

    public static class Bytes {
        public final byte[] bytes;
        public final int hash;

        public Bytes(byte[] bytes) {
            this.bytes = bytes;
            this.hash = Arrays.hashCode(bytes);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            return Arrays.equals(this.bytes, ((Bytes)o).bytes);
        }
    }
}

