/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1BitString;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.x509.ExtensionValue;

public class KeyUsage
extends ExtensionValue {
    public static final String[] USAGES = new String[]{"digitalSignature", "nonRepudiation", "keyEncipherment", "dataEncipherment", "keyAgreement", "keyCertSign", "cRLSign", "encipherOnly", "decipherOnly"};
    public final boolean[] keyUsage;
    public static final ASN1Type ASN1 = new ASN1BitString.ASN1NamedBitList(9);

    public KeyUsage(boolean[] keyUsage) {
        this.keyUsage = keyUsage;
    }

    public KeyUsage(byte[] encoding) throws IOException {
        super(encoding);
        this.keyUsage = (boolean[])ASN1.decode(encoding);
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this.keyUsage);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("KeyUsage [\n");
        for (int i = 0; i < this.keyUsage.length; ++i) {
            if (!this.keyUsage[i]) continue;
            buffer.append(prefix).append("  ").append(USAGES[i]).append('\n');
        }
        buffer.append(prefix).append("]\n");
    }
}

