/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.AccessDescription;
import org.apache.harmony.security.x509.ExtensionValue;

public class InfoAccessSyntax
extends ExtensionValue {
    public final List accessDescriptions;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(AccessDescription.ASN1){

        public Object getDecodedObject(BerInputStream in) throws IOException {
            return new InfoAccessSyntax((List)in.content, in.getEncoded(), null);
        }

        public Collection getValues(Object object) {
            InfoAccessSyntax aias = (InfoAccessSyntax)object;
            return aias.accessDescriptions;
        }
    };

    public InfoAccessSyntax(List accessDescriptions) throws IOException {
        this(accessDescriptions, null);
    }

    public InfoAccessSyntax(List accessDescriptions, byte[] encoding) throws IOException {
        if (accessDescriptions == null || accessDescriptions.isEmpty()) {
            throw new IOException("AccessDescriptions list is null or empty");
        }
        this.accessDescriptions = accessDescriptions;
        this.encoding = encoding;
    }

    public List getAccessDescriptions() {
        return new ArrayList(this.accessDescriptions);
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public static InfoAccessSyntax decode(byte[] encoding) throws IOException {
        return (InfoAccessSyntax)ASN1.decode(encoding);
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append("\n---- InfoAccessSyntax:");
        if (this.accessDescriptions != null) {
            Iterator it = this.accessDescriptions.iterator();
            while (it.hasNext()) {
                res.append('\n');
                res.append(it.next());
            }
        }
        res.append("\n---- InfoAccessSyntax END\n");
        return res.toString();
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("AccessDescriptions:\n");
        if (this.accessDescriptions == null || this.accessDescriptions.isEmpty()) {
            buffer.append("NULL\n");
        } else {
            Iterator itr = this.accessDescriptions.iterator();
            while (itr.hasNext()) {
                buffer.append(itr.next().toString());
            }
        }
    }

    public /* synthetic */ InfoAccessSyntax(List x0, byte[] x1, 1 x2) throws IOException {
        this(x0, x1);
    }
}

