/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import org.apache.harmony.security.asn1.ASN1Explicit;
import org.apache.harmony.security.asn1.ASN1Implicit;
import org.apache.harmony.security.asn1.ASN1Sequence;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.DistributionPointName;
import org.apache.harmony.security.x509.GeneralNames;
import org.apache.harmony.security.x509.ReasonFlags;

public class DistributionPoint {
    public final DistributionPointName distributionPoint;
    public final ReasonFlags reasons;
    public final GeneralNames cRLIssuer;
    public static final ASN1Sequence ASN1 = new ASN1Sequence(new ASN1Type[]{new ASN1Explicit(0, DistributionPointName.ASN1), new ASN1Implicit(1, ReasonFlags.ASN1), new ASN1Implicit(2, GeneralNames.ASN1)}){
        {
            this.setOptional(0);
            this.setOptional(1);
            this.setOptional(2);
        }

        public Object getDecodedObject(BerInputStream in) throws IOException {
            Object[] values = (Object[])in.content;
            return new DistributionPoint((DistributionPointName)values[0], (ReasonFlags)values[1], (GeneralNames)values[2]);
        }

        public void getValues(Object object, Object[] values) {
            DistributionPoint dp = (DistributionPoint)object;
            values[0] = dp.distributionPoint;
            values[1] = dp.reasons;
            values[2] = dp.cRLIssuer;
        }
    };

    public DistributionPoint() {
        this.distributionPoint = null;
        this.reasons = null;
        this.cRLIssuer = null;
    }

    public DistributionPoint(DistributionPointName distributionPoint, ReasonFlags reasons, GeneralNames cRLIssuer) {
        if (reasons != null && distributionPoint == null && cRLIssuer == null) {
            throw new IllegalArgumentException("DistributionPoint MUST NOT consist of only the reasons field");
        }
        this.distributionPoint = distributionPoint;
        this.reasons = reasons;
        this.cRLIssuer = cRLIssuer;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix);
        buffer.append("Distribution Point: [\n");
        if (this.distributionPoint != null) {
            this.distributionPoint.dumpValue(buffer, prefix + "  ");
        }
        if (this.reasons != null) {
            this.reasons.dumpValue(buffer, prefix + "  ");
        }
        if (this.cRLIssuer != null) {
            buffer.append(prefix);
            buffer.append("  CRL Issuer: [\n");
            this.cRLIssuer.dumpValue(buffer, prefix + "    ");
            buffer.append(prefix);
            buffer.append("  ]\n");
        }
        buffer.append(prefix);
        buffer.append("]\n");
    }
}

