/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.x509;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.security.asn1.ASN1SequenceOf;
import org.apache.harmony.security.asn1.ASN1Type;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.x509.ExtensionValue;
import org.apache.harmony.security.x509.PolicyInformation;

public class CertificatePolicies
extends ExtensionValue {
    public List policyInformations;
    public byte[] encoding;
    public static final ASN1Type ASN1 = new ASN1SequenceOf(PolicyInformation.ASN1){

        public Object getDecodedObject(BerInputStream in) {
            return new CertificatePolicies((List)in.content, in.getEncoded(), null);
        }

        public Collection getValues(Object object) {
            CertificatePolicies cps = (CertificatePolicies)object;
            return cps.policyInformations;
        }
    };

    public CertificatePolicies() {
    }

    public CertificatePolicies(List policyInformations) {
        this.policyInformations = policyInformations;
    }

    public static CertificatePolicies decode(byte[] encoding) throws IOException {
        CertificatePolicies cps = (CertificatePolicies)ASN1.decode(encoding);
        cps.encoding = encoding;
        return cps;
    }

    public CertificatePolicies(List policyInformations, byte[] encoding) {
        this.policyInformations = policyInformations;
        this.encoding = encoding;
    }

    public List getPolicyInformations() {
        return new ArrayList(this.policyInformations);
    }

    public CertificatePolicies addPolicyInformation(PolicyInformation policyInformation) {
        this.encoding = null;
        if (this.policyInformations == null) {
            this.policyInformations = new ArrayList();
        }
        this.policyInformations.add(policyInformation);
        return this;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = ASN1.encode(this);
        }
        return this.encoding;
    }

    public void dumpValue(StringBuffer buffer, String prefix) {
        buffer.append(prefix).append("CertificatePolicies [\n");
        Iterator it = this.policyInformations.iterator();
        while (it.hasNext()) {
            buffer.append(prefix);
            buffer.append("  ");
            ((PolicyInformation)it.next()).dumpValue(buffer);
            buffer.append('\n');
        }
        buffer.append(prefix).append("]\n");
    }

    public /* synthetic */ CertificatePolicies(List x0, byte[] x1, 1 x2) {
        this(x0, x1);
    }
}

