/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.app.PendingIntent;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.telephony.SmsMessage;
import android.telephony.gsm.GsmCellLocation;
import android.util.Log;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.IccUtils;
import com.android.internal.telephony.SMSDispatcher;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.gsm.GSMPhone;
import com.android.internal.telephony.gsm.SmsCbHeader;
import com.android.internal.telephony.gsm.SmsMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GsmSMSDispatcher
extends SMSDispatcher {
    public static final String TAG = "GSM";
    public GSMPhone mGsmPhone;
    public final HashMap<SmsCbConcatInfo, byte[][]> mSmsCbPageMap = new HashMap();

    public GsmSMSDispatcher(GSMPhone phone) {
        super(phone);
        this.mGsmPhone = phone;
        ((BaseCommands)this.mCm).setOnNewGsmBroadcastSms(this, 13, null);
    }

    @Override
    public void handleStatusReport(AsyncResult ar) {
        String pduString = (String)ar.result;
        SmsMessage sms = SmsMessage.newFromCDS(pduString);
        if (sms != null) {
            int tpStatus = sms.getStatus();
            int messageRef = sms.messageRef;
            int count = this.deliveryPendingList.size();
            for (int i = 0; i < count; ++i) {
                SMSDispatcher.SmsTracker tracker = (SMSDispatcher.SmsTracker)this.deliveryPendingList.get(i);
                if (tracker.mMessageRef != messageRef) continue;
                if (tpStatus >= 64 || tpStatus < 32) {
                    this.deliveryPendingList.remove(i);
                }
                PendingIntent intent = tracker.mDeliveryIntent;
                Intent fillIn = new Intent();
                fillIn.putExtra("pdu", IccUtils.hexStringToBytes(pduString));
                try {
                    intent.send(this.mContext, -1, fillIn);
                }
                catch (PendingIntent.CanceledException ex) {}
                break;
            }
        }
        this.acknowledgeLastIncomingSms(true, 1, null);
    }

    @Override
    public int dispatchMessage(SmsMessageBase smsb) {
        if (smsb == null) {
            return 2;
        }
        SmsMessage sms = (SmsMessage)smsb;
        boolean handled = false;
        if (sms.isTypeZero()) {
            Log.d(TAG, "Received short message type 0, Don't display or store it. Send Ack");
            return 1;
        }
        if (sms.isMWISetMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(true);
            handled = sms.isMwiDontStore();
            Log.d(TAG, "Received voice mail indicator set SMS shouldStore=" + !handled);
        } else if (sms.isMWIClearMessage()) {
            this.mGsmPhone.updateMessageWaitingIndicator(false);
            handled = sms.isMwiDontStore();
            Log.d(TAG, "Received voice mail indicator clear SMS shouldStore=" + !handled);
        }
        if (handled) {
            return 1;
        }
        if (!this.mStorageAvailable && sms.getMessageClass() != SmsMessage.MessageClass.CLASS_0) {
            return 3;
        }
        SmsHeader smsHeader = sms.getUserDataHeader();
        if (smsHeader == null || smsHeader.concatRef == null) {
            byte[][] pdus = new byte[][]{sms.getPdu()};
            if (smsHeader != null && smsHeader.portAddrs != null) {
                if (smsHeader.portAddrs.destPort == 2948) {
                    return this.mWapPush.dispatchWapPdu(sms.getUserData());
                }
                this.dispatchPortAddressedPdus(pdus, smsHeader.portAddrs.destPort);
            } else {
                this.dispatchPdus(pdus);
            }
            return -1;
        }
        return this.processMessagePart(sms, smsHeader.concatRef, smsHeader.portAddrs);
    }

    @Override
    public void sendData(String destAddr, String scAddr, int destPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, destPort, data, deliveryIntent != null);
        this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
    }

    @Override
    public void sendText(String destAddr, String scAddr, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        SmsMessage.SubmitPdu pdu = SmsMessage.getSubmitPdu(scAddr, destAddr, text, deliveryIntent != null);
        this.sendRawPdu(pdu.encodedScAddress, pdu.encodedMessage, sentIntent, deliveryIntent);
    }

    @Override
    public void sendMultipartText(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int i;
        int refNumber = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        mRemainingMessages = msgCount;
        SmsMessageBase.TextEncodingDetails[] encodingForParts = new SmsMessageBase.TextEncodingDetails[msgCount];
        for (i = 0; i < msgCount; ++i) {
            SmsMessageBase.TextEncodingDetails details = SmsMessage.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        for (i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = true;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            SmsMessage.SubmitPdu pdus = SmsMessage.getSubmitPdu(scAddress, destinationAddress, parts.get(i), deliveryIntent != null, SmsHeader.toByteArray(smsHeader), encoding, smsHeader.languageTable, smsHeader.languageShiftTable);
            this.sendRawPdu(pdus.encodedScAddress, pdus.encodedMessage, sentIntent, deliveryIntent);
        }
    }

    public void sendMultipartTextWithPermit(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        int i;
        int ss = this.mPhone.getServiceState().getState();
        if (ss != 0) {
            int count = parts.size();
            for (int i2 = 0; i2 < count; ++i2) {
                PendingIntent sentIntent = null;
                if (sentIntents != null && sentIntents.size() > i2) {
                    sentIntent = sentIntents.get(i2);
                }
                SMSDispatcher.SmsTracker tracker = this.SmsTrackerFactory(null, sentIntent, null);
                this.handleNotInService(ss, tracker);
            }
            return;
        }
        int refNumber = GsmSMSDispatcher.getNextConcatenatedRef() & 0xFF;
        int msgCount = parts.size();
        int encoding = 0;
        mRemainingMessages = msgCount;
        SmsMessageBase.TextEncodingDetails[] encodingForParts = new SmsMessageBase.TextEncodingDetails[msgCount];
        for (i = 0; i < msgCount; ++i) {
            SmsMessageBase.TextEncodingDetails details = SmsMessage.calculateLength(parts.get(i), false);
            if (encoding != details.codeUnitSize && (encoding == 0 || encoding == 1)) {
                encoding = details.codeUnitSize;
            }
            encodingForParts[i] = details;
        }
        for (i = 0; i < msgCount; ++i) {
            SmsHeader.ConcatRef concatRef = new SmsHeader.ConcatRef();
            concatRef.refNumber = refNumber;
            concatRef.seqNumber = i + 1;
            concatRef.msgCount = msgCount;
            concatRef.isEightBits = false;
            SmsHeader smsHeader = new SmsHeader();
            smsHeader.concatRef = concatRef;
            if (encoding == 1) {
                smsHeader.languageTable = encodingForParts[i].languageTable;
                smsHeader.languageShiftTable = encodingForParts[i].languageShiftTable;
            }
            PendingIntent sentIntent = null;
            if (sentIntents != null && sentIntents.size() > i) {
                sentIntent = sentIntents.get(i);
            }
            PendingIntent deliveryIntent = null;
            if (deliveryIntents != null && deliveryIntents.size() > i) {
                deliveryIntent = deliveryIntents.get(i);
            }
            SmsMessage.SubmitPdu pdus = SmsMessage.getSubmitPdu(scAddress, destinationAddress, parts.get(i), deliveryIntent != null, SmsHeader.toByteArray(smsHeader), encoding, smsHeader.languageTable, smsHeader.languageShiftTable);
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            map.put("smsc", pdus.encodedScAddress);
            map.put("pdu", pdus.encodedMessage);
            SMSDispatcher.SmsTracker tracker = this.SmsTrackerFactory(map, sentIntent, deliveryIntent);
            this.sendSms(tracker);
        }
    }

    @Override
    public void sendSms(SMSDispatcher.SmsTracker tracker) {
        HashMap map = tracker.mData;
        byte[] smsc = (byte[])map.get("smsc");
        byte[] pdu = (byte[])map.get("pdu");
        Message reply = this.obtainMessage(2, tracker);
        this.mCm.sendSMS(IccUtils.bytesToHexString(smsc), IccUtils.bytesToHexString(pdu), reply);
    }

    @Override
    public void sendMultipartSms(SMSDispatcher.SmsTracker tracker) {
        HashMap map = tracker.mData;
        String destinationAddress = (String)map.get("destination");
        String scAddress = (String)map.get("scaddress");
        ArrayList parts = (ArrayList)map.get("parts");
        ArrayList sentIntents = (ArrayList)map.get("sentIntents");
        ArrayList deliveryIntents = (ArrayList)map.get("deliveryIntents");
        this.sendMultipartTextWithPermit(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    @Override
    public void acknowledgeLastIncomingSms(boolean success, int result, Message response) {
        if (this.mCm != null) {
            this.mCm.acknowledgeLastIncomingGsmSms(success, this.resultToCause(result), response);
        }
    }

    public int resultToCause(int rc) {
        switch (rc) {
            case -1: 
            case 1: {
                return 0;
            }
            case 3: {
                return 211;
            }
        }
        return 255;
    }

    @Override
    public void handleBroadcastSms(AsyncResult ar) {
        try {
            Object pdus = null;
            byte[] receivedPdu = (byte[])ar.result;
            for (int i = 0; i < receivedPdu.length; i += 8) {
                StringBuilder sb = new StringBuilder("SMS CB pdu data: ");
                for (int j = i; j < i + 8 && j < receivedPdu.length; ++j) {
                    int b = receivedPdu[j] & 0xFF;
                    if (b < 16) {
                        sb.append('0');
                    }
                    sb.append(Integer.toHexString(b)).append(' ');
                }
                Log.d(TAG, sb.toString());
            }
            SmsCbHeader header = new SmsCbHeader(receivedPdu);
            String plmn = SystemProperties.get("gsm.operator.numeric");
            GsmCellLocation cellLocation = (GsmCellLocation)this.mGsmPhone.getCellLocation();
            int lac = cellLocation.getLac();
            int cid = cellLocation.getCid();
            if (header.nrOfPages > 1) {
                SmsCbConcatInfo concatInfo = new SmsCbConcatInfo(header, plmn, lac, cid);
                pdus = this.mSmsCbPageMap.get(concatInfo);
                if (pdus == null) {
                    pdus = new byte[header.nrOfPages][];
                    this.mSmsCbPageMap.put(concatInfo, (byte[][])pdus);
                }
                pdus[header.pageIndex - 1] = receivedPdu;
                for (int i = 0; i < ((byte[][])pdus).length; ++i) {
                    if (pdus[i] != null) continue;
                    return;
                }
                this.mSmsCbPageMap.remove(concatInfo);
            } else {
                pdus = new byte[1][];
                pdus[0] = receivedPdu;
            }
            boolean isEmergencyMessage = SmsCbHeader.isEmergencyMessage(header.messageIdentifier);
            this.dispatchBroadcastPdus((byte[][])pdus, isEmergencyMessage);
            Iterator<SmsCbConcatInfo> iter = this.mSmsCbPageMap.keySet().iterator();
            while (iter.hasNext()) {
                SmsCbConcatInfo info = iter.next();
                if (info.matchesLocation(plmn, lac, cid)) continue;
                iter.remove();
            }
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in decoding SMS CB pdu", e);
        }
    }

    public static class SmsCbConcatInfo {
        public final SmsCbHeader mHeader;
        public final String mPlmn;
        public final int mLac;
        public final int mCid;

        public SmsCbConcatInfo(SmsCbHeader header, String plmn, int lac, int cid) {
            this.mHeader = header;
            this.mPlmn = plmn;
            this.mLac = lac;
            this.mCid = cid;
        }

        public int hashCode() {
            return this.mHeader.messageIdentifier * 31 + this.mHeader.updateNumber;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SmsCbConcatInfo) {
                SmsCbConcatInfo other = (SmsCbConcatInfo)obj;
                if (this.mHeader.geographicalScope == other.mHeader.geographicalScope && this.mHeader.messageCode == other.mHeader.messageCode && this.mHeader.updateNumber == other.mHeader.updateNumber && this.mHeader.messageIdentifier == other.mHeader.messageIdentifier && this.mHeader.dataCodingScheme == other.mHeader.dataCodingScheme && this.mHeader.nrOfPages == other.mHeader.nrOfPages) {
                    return this.matchesLocation(other.mPlmn, other.mLac, other.mCid);
                }
            }
            return false;
        }

        public boolean matchesLocation(String plmn, int lac, int cid) {
            switch (this.mHeader.geographicalScope) {
                case 0: 
                case 3: {
                    if (this.mCid != cid) {
                        return false;
                    }
                }
                case 2: {
                    if (this.mLac != lac) {
                        return false;
                    }
                }
                case 1: {
                    return this.mPlmn != null && this.mPlmn.equals(plmn);
                }
            }
            return false;
        }
    }
}

