/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Message;
import android.util.Log;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.cdma.CDMAPhone;

public class RuimPhoneBookInterfaceManager
extends IccPhoneBookInterfaceManager {
    public static final String LOG_TAG = "CDMA";

    public RuimPhoneBookInterfaceManager(CDMAPhone phone) {
        super(phone);
        this.adnCache = phone.mRuimRecords.getAdnCache();
    }

    public void dispose() {
        super.dispose();
    }

    public void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            Log.e(LOG_TAG, "Error while finalizing:", throwable);
        }
        Log.d(LOG_TAG, "RuimPhoneBookInterfaceManager finalized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAdnRecordsSize(int efid) {
        this.logd("getAdnRecordsSize: efid=" + efid);
        Object object = this.mLock;
        synchronized (object) {
            this.checkThread();
            this.recordSize = new int[3];
            Message response = this.mBaseHandler.obtainMessage(1);
            this.phone.getIccFileHandler().getEFLinearRecordSize(efid, response);
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                this.logd("interrupted while trying to load from the RUIM");
            }
        }
        return this.recordSize;
    }

    public void logd(String msg) {
        Log.d(LOG_TAG, "[RuimPbInterfaceManager] " + msg);
    }

    public void loge(String msg) {
        Log.e(LOG_TAG, "[RuimPbInterfaceManager] " + msg);
    }
}

