/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Message;
import android.os.SystemProperties;
import android.util.EventLog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.ApnSetting;
import com.android.internal.util.HierarchicalState;
import com.android.internal.util.HierarchicalStateMachine;

public abstract class DataConnection
extends HierarchicalStateMachine {
    public static final boolean DBG = true;
    public static Object mCountLock = new Object();
    public static int mCount;
    public static final int EVENT_RESET = 1;
    public static final int EVENT_CONNECT = 2;
    public static final int EVENT_SETUP_DATA_CONNECTION_DONE = 3;
    public static final int EVENT_GET_LAST_FAIL_DONE = 4;
    public static final int EVENT_DEACTIVATE_DONE = 5;
    public static final int EVENT_DISCONNECT = 6;
    public static final int EVENT_LOG_BAD_DNS_ADDRESS = 50100;
    public int mTag;
    public PhoneBase phone;
    public int cid;
    public String interfaceName;
    public String ipAddress;
    public String gatewayAddress;
    public String[] dnsServers;
    public long createTime;
    public long lastFailTime;
    public FailCause lastFailCause;
    public static final String NULL_IP = "0.0.0.0";
    public Object userData;
    public DcDefaultState mDefaultState = new DcDefaultState(null);
    public DcInactiveState mInactiveState = new DcInactiveState(null);
    public DcActivatingState mActivatingState = new DcActivatingState(null);
    public DcActiveState mActiveState = new DcActiveState(null);
    public DcDisconnectingState mDisconnectingState = new DcDisconnectingState(null);
    public DcDisconnectingBadDnsState mDisconnectingBadDnsState = new DcDisconnectingBadDnsState(null);

    public abstract String toString();

    public abstract void onConnect(ConnectionParams var1);

    public abstract FailCause getFailCauseFromRequest(int var1);

    public abstract boolean isDnsOk(String[] var1);

    public abstract void log(String var1);

    public DataConnection(PhoneBase phone, String name) {
        super(name);
        this.log("DataConnection constructor E");
        this.phone = phone;
        this.cid = -1;
        this.dnsServers = new String[2];
        this.clearSettings();
        this.setDbg(false);
        this.addState(this.mDefaultState);
        this.addState(this.mInactiveState, this.mDefaultState);
        this.addState(this.mActivatingState, this.mDefaultState);
        this.addState(this.mActiveState, this.mDefaultState);
        this.addState(this.mDisconnectingState, this.mDefaultState);
        this.addState(this.mDisconnectingBadDnsState, this.mDefaultState);
        this.setInitialState(this.mInactiveState);
        this.log("DataConnection constructor X");
    }

    public void tearDownData(Object o) {
        if (this.phone.mCM.getRadioState().isOn()) {
            this.log("tearDownData radio is on, call deactivateDataCall");
            this.phone.mCM.deactivateDataCall(this.cid, this.obtainMessage(5, o));
        } else {
            this.log("tearDownData radio is off sendMessage EVENT_DEACTIVATE_DONE immediately");
            AsyncResult ar = new AsyncResult(o, null, null);
            this.sendMessage(this.obtainMessage(5, ar));
        }
    }

    public void notifyConnectCompleted(ConnectionParams cp, FailCause cause) {
        Message connectionCompletedMsg = cp.onCompletedMsg;
        if (connectionCompletedMsg == null) {
            return;
        }
        long timeStamp = System.currentTimeMillis();
        connectionCompletedMsg.arg1 = this.cid;
        if (cause == FailCause.NONE) {
            this.createTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg);
        } else {
            this.lastFailCause = cause;
            this.lastFailTime = timeStamp;
            AsyncResult.forMessage(connectionCompletedMsg, (Object)cause, new Exception());
        }
        this.log("notifyConnection at " + timeStamp + " cause=" + (Object)((Object)cause));
        connectionCompletedMsg.sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDisconnectCompleted(DisconnectParams dp) {
        this.log("NotifyDisconnectCompleted");
        if (dp.onCompletedMsg != null) {
            Message msg = dp.onCompletedMsg;
            this.log(String.format("msg.what=%d msg.obj=%s", msg.what, msg.obj instanceof String ? (String)msg.obj : "<no-reason>"));
            AsyncResult.forMessage(msg);
            msg.sendToTarget();
        }
        if (dp.lockObj != null) {
            ResetSynchronouslyLock resetSynchronouslyLock = dp.lockObj;
            synchronized (resetSynchronouslyLock) {
                dp.lockObj.notify();
            }
        }
        this.clearSettings();
    }

    public void clearSettings() {
        this.log("clearSettings");
        this.createTime = -1L;
        this.lastFailTime = -1L;
        this.lastFailCause = FailCause.NONE;
        this.interfaceName = null;
        this.ipAddress = null;
        this.gatewayAddress = null;
        this.dnsServers[0] = null;
        this.dnsServers[1] = null;
    }

    public SetupResult onSetupConnectionCompleted(AsyncResult ar) {
        SetupResult result;
        String[] response = (String[])ar.result;
        ConnectionParams cp = (ConnectionParams)ar.userObj;
        if (ar.exception != null) {
            this.log("DataConnection Init failed " + ar.exception);
            if (ar.exception instanceof CommandException && ((CommandException)ar.exception).getCommandError() == CommandException.Error.RADIO_NOT_AVAILABLE) {
                result = SetupResult.ERR_BadCommand;
                result.mFailCause = FailCause.RADIO_NOT_AVAILABLE;
            } else {
                result = SetupResult.ERR_Other;
            }
        } else if (cp.tag != this.mTag) {
            this.log("BUG: onSetupConnectionCompleted is stale cp.tag=" + cp.tag + ", mtag=" + this.mTag);
            result = SetupResult.ERR_Stale;
        } else if (response.length >= 2) {
            this.cid = Integer.parseInt(response[0]);
            this.interfaceName = response[1];
            if (response.length > 2) {
                this.ipAddress = response[2];
                String prefix = "net." + this.interfaceName + ".";
                this.gatewayAddress = SystemProperties.get(prefix + "gw");
                this.dnsServers[0] = SystemProperties.get(prefix + "dns1");
                this.dnsServers[1] = SystemProperties.get(prefix + "dns2");
                this.log("interface=" + this.interfaceName + " ipAddress=" + this.ipAddress + " gateway=" + this.gatewayAddress + " DNS1=" + this.dnsServers[0] + " DNS2=" + this.dnsServers[1]);
                result = this.isDnsOk(this.dnsServers) ? SetupResult.SUCCESS : SetupResult.ERR_BadDns;
            } else {
                result = SetupResult.SUCCESS;
            }
        } else {
            result = SetupResult.ERR_Other;
        }
        this.log("DataConnection setup result='" + (Object)((Object)result) + "' on cid=" + this.cid);
        return result;
    }

    public void reset(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(1, new DisconnectParams(onCompletedMsg)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSynchronously() {
        ResetSynchronouslyLock lockObj;
        ResetSynchronouslyLock resetSynchronouslyLock = lockObj = new ResetSynchronouslyLock();
        synchronized (resetSynchronouslyLock) {
            this.sendMessage(this.obtainMessage(1, new DisconnectParams(lockObj)));
            try {
                lockObj.wait();
            }
            catch (InterruptedException e) {
                this.log("blockingReset: unexpected interrupted of wait()");
            }
        }
    }

    public void connect(Message onCompletedMsg, ApnSetting apn) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(apn, onCompletedMsg)));
    }

    public void connect(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(2, new ConnectionParams(null, onCompletedMsg)));
    }

    public void disconnect(Message onCompletedMsg) {
        this.sendMessage(this.obtainMessage(6, new DisconnectParams(onCompletedMsg)));
    }

    public boolean isInactive() {
        boolean retVal = this.getCurrentState() == this.mInactiveState;
        return retVal;
    }

    public boolean isActive() {
        boolean retVal = this.getCurrentState() == this.mActiveState;
        return retVal;
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String[] getDnsServers() {
        return this.dnsServers;
    }

    public String getStateAsString() {
        String retVal = this.getCurrentState().getName();
        return retVal;
    }

    public long getConnectionTime() {
        return this.createTime;
    }

    public long getLastFailTime() {
        return this.lastFailTime;
    }

    public FailCause getLastFailCause() {
        return this.lastFailCause;
    }

    public class DcDisconnectingBadDnsState
    extends HierarchicalState {
        public DcDisconnectingBadDnsState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcDisconnectingBadDnsState msg.what=EVENT_DEACTIVATE_DONE");
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, FailCause.UNKNOWN);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectingBadDnsState EVENT_DEACTIVE_DONE stale dp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectingBadDnsState not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcDisconnectingBadDnsState(1 x1) {
            this();
        }
    }

    public class DcDisconnectingState
    extends HierarchicalState {
        public DcDisconnectingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 5: {
                    DataConnection.this.log("DcDisconnectingState msg.what=EVENT_DEACTIVATE_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    DisconnectParams dp = (DisconnectParams)ar.userObj;
                    if (dp.tag == DataConnection.this.mTag) {
                        DataConnection.this.mInactiveState.setEnterNotificationParams((DisconnectParams)ar.userObj);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcDisconnectState EVENT_DEACTIVATE_DONE stale dp.tag=" + dp.tag + " mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcDisconnectingState not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcDisconnectingState(1 x1) {
            this();
        }
    }

    public class DcActiveState
    extends HierarchicalState {
        public ConnectionParams mConnectionParams = null;
        public FailCause mFailCause = null;

        public DcActiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = cp;
            this.mFailCause = cause;
        }

        public void enter() {
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcActiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 6: {
                    DataConnection.this.log("DcActiveState msg.what=EVENT_DISCONNECT");
                    DisconnectParams dp = (DisconnectParams)msg.obj;
                    dp.tag = DataConnection.this.mTag;
                    DataConnection.this.tearDownData(dp);
                    DataConnection.this.transitionTo(DataConnection.this.mDisconnectingState);
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActiveState nothandled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcActiveState(1 x1) {
            this();
        }
    }

    public class DcActivatingState
    extends HierarchicalState {
        public DcActivatingState() {
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 6: {
                    DataConnection.this.log("DcActivatingState deferring msg.what=EVENT_DISCONNECT");
                    DataConnection.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 3: {
                    DataConnection.this.log("DcActivatingState msg.what=EVENT_SETUP_DATA_CONNECTION_DONE");
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    SetupResult result = DataConnection.this.onSetupConnectionCompleted(ar);
                    switch (result) {
                        case SUCCESS: {
                            DataConnection.this.mActiveState.setEnterNotificationParams(cp, FailCause.NONE);
                            DataConnection.this.transitionTo(DataConnection.this.mActiveState);
                            break;
                        }
                        case ERR_BadCommand: {
                            DataConnection.this.mInactiveState.setEnterNotificationParams(cp, result.mFailCause);
                            DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                            break;
                        }
                        case ERR_BadDns: {
                            EventLog.writeEvent(50100, DataConnection.this.dnsServers[0]);
                            DataConnection.this.tearDownData(cp);
                            DataConnection.this.transitionTo(DataConnection.this.mDisconnectingBadDnsState);
                            break;
                        }
                        case ERR_Other: {
                            DataConnection.this.phone.mCM.getLastDataCallFailCause(DataConnection.this.obtainMessage(4, cp));
                            break;
                        }
                        case ERR_Stale: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unkown SetupResult, should not happen");
                        }
                    }
                    retVal = true;
                    break;
                }
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ConnectionParams cp = (ConnectionParams)ar.userObj;
                    FailCause cause = FailCause.UNKNOWN;
                    if (cp.tag == DataConnection.this.mTag) {
                        DataConnection.this.log("DcActivatingState msg.what=EVENT_GET_LAST_FAIL_DONE");
                        if (ar.exception == null) {
                            int rilFailCause = ((int[])ar.result)[0];
                            cause = DataConnection.this.getFailCauseFromRequest(rilFailCause);
                        }
                        DataConnection.this.mInactiveState.setEnterNotificationParams(cp, cause);
                        DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    } else {
                        DataConnection.this.log("DcActivatingState EVENT_GET_LAST_FAIL_DONE is stale cp.tag=" + cp.tag + ", mTag=" + DataConnection.this.mTag);
                    }
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcActivatingState not handled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcActivatingState(1 x1) {
            this();
        }
    }

    public class DcInactiveState
    extends HierarchicalState {
        public ConnectionParams mConnectionParams = null;
        public FailCause mFailCause = null;
        public DisconnectParams mDisconnectParams = null;

        public DcInactiveState() {
        }

        public void setEnterNotificationParams(ConnectionParams cp, FailCause cause) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams cp,cause");
            this.mConnectionParams = cp;
            this.mFailCause = cause;
        }

        public void setEnterNotificationParams(DisconnectParams dp) {
            DataConnection.this.log("DcInactiveState: setEnterNoticationParams dp");
            this.mDisconnectParams = dp;
        }

        public void enter() {
            ++DataConnection.this.mTag;
            if (this.mConnectionParams != null && this.mFailCause != null) {
                DataConnection.this.log("DcInactiveState: enter notifyConnectCompleted");
                DataConnection.this.notifyConnectCompleted(this.mConnectionParams, this.mFailCause);
            }
            if (this.mDisconnectParams != null) {
                DataConnection.this.log("DcInactiveState: enter notifyDisconnectCompleted");
                DataConnection.this.notifyDisconnectCompleted(this.mDisconnectParams);
            }
        }

        public void exit() {
            this.mConnectionParams = null;
            this.mFailCause = null;
            this.mDisconnectParams = null;
        }

        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 1: {
                    DataConnection.this.log("DcInactiveState: msg.what=EVENT_RESET, ignore we're already reset");
                    if (msg.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    }
                    retVal = true;
                    break;
                }
                case 2: {
                    DataConnection.this.log("DcInactiveState msg.what=EVENT_CONNECT");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    cp.tag = DataConnection.this.mTag;
                    DataConnection.this.onConnect(cp);
                    DataConnection.this.transitionTo(DataConnection.this.mActivatingState);
                    retVal = true;
                    break;
                }
                default: {
                    DataConnection.this.log("DcInactiveState nothandled msg.what=" + msg.what);
                    retVal = false;
                }
            }
            return retVal;
        }

        public /* synthetic */ DcInactiveState(1 x1) {
            this();
        }
    }

    public class DcDefaultState
    extends HierarchicalState {
        public DcDefaultState() {
        }

        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_RESET");
                    DataConnection.this.clearSettings();
                    if (msg.obj != null) {
                        DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    }
                    DataConnection.this.transitionTo(DataConnection.this.mInactiveState);
                    break;
                }
                case 2: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_CONNECT, fail not expected");
                    ConnectionParams cp = (ConnectionParams)msg.obj;
                    DataConnection.this.notifyConnectCompleted(cp, FailCause.UNKNOWN);
                    break;
                }
                case 6: {
                    DataConnection.this.log("DcDefaultState: msg.what=EVENT_DISCONNECT");
                    DataConnection.this.notifyDisconnectCompleted((DisconnectParams)msg.obj);
                    break;
                }
                default: {
                    DataConnection.this.log("DcDefaultState: shouldn't happen but ignore msg.what=" + msg.what);
                }
            }
            return true;
        }

        public /* synthetic */ DcDefaultState(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FailCause {
        NONE,
        OPERATOR_BARRED,
        INSUFFICIENT_RESOURCES,
        MISSING_UNKNOWN_APN,
        UNKNOWN_PDP_ADDRESS,
        USER_AUTHENTICATION,
        ACTIVATION_REJECT_GGSN,
        ACTIVATION_REJECT_UNSPECIFIED,
        SERVICE_OPTION_NOT_SUPPORTED,
        SERVICE_OPTION_NOT_SUBSCRIBED,
        SERVICE_OPTION_OUT_OF_ORDER,
        NSAPI_IN_USE,
        PROTOCOL_ERRORS,
        REGISTRATION_FAIL,
        GPRS_REGISTRATION_FAIL,
        UNKNOWN,
        RADIO_NOT_AVAILABLE;


        public boolean isPermanentFail() {
            return this == OPERATOR_BARRED || this == MISSING_UNKNOWN_APN || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public boolean isEventLoggable() {
            return this == OPERATOR_BARRED || this == INSUFFICIENT_RESOURCES || this == UNKNOWN_PDP_ADDRESS || this == USER_AUTHENTICATION || this == ACTIVATION_REJECT_GGSN || this == ACTIVATION_REJECT_UNSPECIFIED || this == SERVICE_OPTION_NOT_SUBSCRIBED || this == SERVICE_OPTION_NOT_SUPPORTED || this == SERVICE_OPTION_OUT_OF_ORDER || this == NSAPI_IN_USE || this == PROTOCOL_ERRORS;
        }

        public String toString() {
            switch (this) {
                case NONE: {
                    return "No Error";
                }
                case OPERATOR_BARRED: {
                    return "Operator Barred";
                }
                case INSUFFICIENT_RESOURCES: {
                    return "Insufficient Resources";
                }
                case MISSING_UNKNOWN_APN: {
                    return "Missing / Unknown APN";
                }
                case UNKNOWN_PDP_ADDRESS: {
                    return "Unknown PDP Address";
                }
                case USER_AUTHENTICATION: {
                    return "Error User Authentication";
                }
                case ACTIVATION_REJECT_GGSN: {
                    return "Activation Reject GGSN";
                }
                case ACTIVATION_REJECT_UNSPECIFIED: {
                    return "Activation Reject unspecified";
                }
                case SERVICE_OPTION_NOT_SUPPORTED: {
                    return "Data Not Supported";
                }
                case SERVICE_OPTION_NOT_SUBSCRIBED: {
                    return "Data Not subscribed";
                }
                case SERVICE_OPTION_OUT_OF_ORDER: {
                    return "Data Services Out of Order";
                }
                case NSAPI_IN_USE: {
                    return "NSAPI in use";
                }
                case PROTOCOL_ERRORS: {
                    return "Protocol Errors";
                }
                case REGISTRATION_FAIL: {
                    return "Network Registration Failure";
                }
                case GPRS_REGISTRATION_FAIL: {
                    return "Data Network Registration Failure";
                }
                case RADIO_NOT_AVAILABLE: {
                    return "Radio Not Available";
                }
            }
            return "Unknown Data Error";
        }
    }

    public static class DisconnectParams {
        public int tag;
        public Message onCompletedMsg;
        public ResetSynchronouslyLock lockObj;

        public DisconnectParams(Message onCompletedMsg) {
            this.onCompletedMsg = onCompletedMsg;
        }

        public DisconnectParams(ResetSynchronouslyLock lockObj) {
            this.lockObj = lockObj;
        }
    }

    public class ResetSynchronouslyLock {
    }

    public static class ConnectionParams {
        public int tag;
        public ApnSetting apn;
        public Message onCompletedMsg;

        public ConnectionParams(ApnSetting apn, Message onCompletedMsg) {
            this.apn = apn;
            this.onCompletedMsg = onCompletedMsg;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SetupResult {
        ERR_BadCommand,
        ERR_BadDns,
        ERR_Other,
        ERR_Stale,
        SUCCESS;

        public FailCause mFailCause;

        public String toString() {
            switch (this) {
                case ERR_BadCommand: {
                    return "Bad Command";
                }
                case ERR_BadDns: {
                    return "Bad DNS";
                }
                case ERR_Other: {
                    return "Other error";
                }
                case ERR_Stale: {
                    return "Stale command";
                }
                case SUCCESS: {
                    return "SUCCESS";
                }
            }
            return "unknown";
        }
    }
}

