/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerImpl;
import android.widget.TextView;

public class Toast {
    public static final String TAG = "Toast";
    public static final boolean localLOGV = false;
    public static final int LENGTH_SHORT = 0;
    public static final int LENGTH_LONG = 1;
    public final Handler mHandler = new Handler();
    public final Context mContext;
    public final TN mTN;
    public int mDuration;
    public int mGravity = 81;
    public int mX;
    public int mY;
    public float mHorizontalMargin;
    public float mVerticalMargin;
    public View mView;
    public View mNextView;
    public static INotificationManager sService;

    public Toast(Context context) {
        this.mContext = context;
        this.mTN = new TN();
        this.mY = context.getResources().getDimensionPixelSize(17104899);
    }

    public void show() {
        if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        INotificationManager service = Toast.getService();
        String pkg = this.mContext.getPackageName();
        TN tn = this.mTN;
        try {
            service.enqueueToast(pkg, tn, this.mDuration);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    public void cancel() {
        this.mTN.hide();
    }

    public void setView(View view) {
        this.mNextView = view;
    }

    public View getView() {
        return this.mNextView;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setMargin(float horizontalMargin, float verticalMargin) {
        this.mHorizontalMargin = horizontalMargin;
        this.mVerticalMargin = verticalMargin;
    }

    public float getHorizontalMargin() {
        return this.mHorizontalMargin;
    }

    public float getVerticalMargin() {
        return this.mVerticalMargin;
    }

    public void setGravity(int gravity, int xOffset, int yOffset) {
        this.mGravity = gravity;
        this.mX = xOffset;
        this.mY = yOffset;
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getXOffset() {
        return this.mX;
    }

    public int getYOffset() {
        return this.mY;
    }

    public static Toast makeText(Context context, CharSequence text, int duration) {
        Toast result = new Toast(context);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflate.inflate(17367143, null);
        TextView tv = (TextView)v.findViewById(16908299);
        tv.setText(text);
        result.mNextView = v;
        result.mDuration = duration;
        return result;
    }

    public static Toast makeText(Context context, int resId, int duration) throws Resources.NotFoundException {
        return Toast.makeText(context, context.getResources().getText(resId), duration);
    }

    public void setText(int resId) {
        this.setText(this.mContext.getText(resId));
    }

    public void setText(CharSequence s) {
        if (this.mNextView == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        TextView tv = (TextView)this.mNextView.findViewById(16908299);
        if (tv == null) {
            throw new RuntimeException("This Toast was not created with Toast.makeText()");
        }
        tv.setText(s);
    }

    public static INotificationManager getService() {
        if (sService != null) {
            return sService;
        }
        sService = INotificationManager.Stub.asInterface(ServiceManager.getService((String)"notification"));
        return sService;
    }

    public class TN
    extends ITransientNotification.Stub {
        public final Runnable mShow = new Runnable(){

            public void run() {
                TN.this.handleShow();
            }
        };
        public final Runnable mHide = new Runnable(){

            public void run() {
                TN.this.handleHide();
            }
        };
        public final WindowManager.LayoutParams mParams;
        public WindowManagerImpl mWM;

        public TN() {
            WindowManager.LayoutParams params = this.mParams = new WindowManager.LayoutParams();
            params.height = -2;
            params.width = -2;
            params.flags = 152;
            params.format = -3;
            params.windowAnimations = 16973828;
            params.type = 2005;
            params.setTitle(Toast.TAG);
        }

        public void show() {
            Toast.this.mHandler.post(this.mShow);
        }

        public void hide() {
            Toast.this.mHandler.post(this.mHide);
        }

        public void handleShow() {
            if (Toast.this.mView != Toast.this.mNextView) {
                int gravity;
                this.handleHide();
                Toast.this.mView = Toast.this.mNextView;
                this.mWM = WindowManagerImpl.getDefault();
                this.mParams.gravity = gravity = Toast.this.mGravity;
                if ((gravity & 7) == 7) {
                    this.mParams.horizontalWeight = 1.0f;
                }
                if ((gravity & 0x70) == 112) {
                    this.mParams.verticalWeight = 1.0f;
                }
                this.mParams.x = Toast.this.mX;
                this.mParams.y = Toast.this.mY;
                this.mParams.verticalMargin = Toast.this.mVerticalMargin;
                this.mParams.horizontalMargin = Toast.this.mHorizontalMargin;
                if (Toast.this.mView.getParent() != null) {
                    this.mWM.removeView(Toast.this.mView);
                }
                this.mWM.addView(Toast.this.mView, this.mParams);
            }
        }

        public void handleHide() {
            if (Toast.this.mView != null) {
                if (Toast.this.mView.getParent() != null) {
                    this.mWM.removeView(Toast.this.mView);
                }
                Toast.this.mView = null;
            }
        }
    }
}

