/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.inputmethodservice.ExtractEditText;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.text.BoringLayout;
import android.text.ClipboardManager;
import android.text.DynamicLayout;
import android.text.Editable;
import android.text.GetChars;
import android.text.GraphicsOperations;
import android.text.InputFilter;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.Selection;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.SpannedString;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.BaseKeyListener;
import android.text.method.DateKeyListener;
import android.text.method.DateTimeKeyListener;
import android.text.method.DialerKeyListener;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.text.method.LinkMovementMethod;
import android.text.method.MetaKeyKeyListener;
import android.text.method.MovementMethod;
import android.text.method.PasswordTransformationMethod;
import android.text.method.SingleLineTransformationMethod;
import android.text.method.TextKeyListener;
import android.text.method.TimeKeyListener;
import android.text.method.TransformationMethod;
import android.text.style.ParagraphStyle;
import android.text.style.URLSpan;
import android.text.style.UpdateAppearance;
import android.text.util.Linkify;
import android.util.AttributeSet;
import android.util.FloatMath;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.ExtractedText;
import android.view.inputmethod.ExtractedTextRequest;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import android.widget.RemoteViews;
import android.widget.Scroller;
import com.android.internal.R;
import com.android.internal.util.FastMath;
import com.android.internal.widget.EditableInputConnection;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

@RemoteViews.RemoteView
public class TextView
extends View
implements ViewTreeObserver.OnPreDrawListener {
    public static final String LOG_TAG = "TextView";
    public static final boolean DEBUG_EXTRACT = false;
    public static int PRIORITY = 100;
    public final int[] mTempCoords = new int[2];
    public Rect mTempRect;
    public ColorStateList mTextColor;
    public int mCurTextColor;
    public ColorStateList mHintTextColor;
    public ColorStateList mLinkTextColor;
    public int mCurHintTextColor;
    public boolean mFreezesText;
    public boolean mFrozenWithFocus;
    public boolean mTemporaryDetach;
    public boolean mDispatchTemporaryDetach;
    public boolean mEatTouchRelease = false;
    public boolean mScrolled = false;
    public Editable.Factory mEditableFactory = Editable.Factory.getInstance();
    public Spannable.Factory mSpannableFactory = Spannable.Factory.getInstance();
    public float mShadowRadius;
    public float mShadowDx;
    public float mShadowDy;
    public static final int PREDRAW_NOT_REGISTERED = 0;
    public static final int PREDRAW_PENDING = 1;
    public static final int PREDRAW_DONE = 2;
    public int mPreDrawState = 0;
    public TextUtils.TruncateAt mEllipsize = null;
    public static final int SANS = 1;
    public static final int SERIF = 2;
    public static final int MONOSPACE = 3;
    public static final int SIGNED = 2;
    public static final int DECIMAL = 4;
    public Drawables mDrawables;
    public CharSequence mError;
    public boolean mErrorWasChanged;
    public ErrorPopup mPopup;
    public boolean mShowErrorAfterAttach;
    public CharWrapper mCharWrapper = null;
    public boolean mSelectionMoved = false;
    public boolean mTouchFocusSelected = false;
    public Marquee mMarquee;
    public boolean mRestartMarquee;
    public int mMarqueeRepeatLimit = 3;
    public InputContentType mInputContentType;
    public InputMethodState mInputMethodState;
    public int mTextSelectHandleLeftRes;
    public int mTextSelectHandleRightRes;
    public int mTextSelectHandleRes;
    public Drawable mSelectHandleLeft;
    public Drawable mSelectHandleRight;
    public Drawable mSelectHandleCenter;
    public boolean mCreatedWithASelection = false;
    public boolean mNoContextMenuOnUp = false;
    public static final int EXTRACT_NOTHING = -2;
    public static final int EXTRACT_UNKNOWN = -1;
    public static final BoringLayout.Metrics UNKNOWN_BORING;
    public static final int ID_SELECT_ALL = 16908319;
    public static final int ID_START_SELECTING_TEXT = 16908328;
    public static final int ID_CUT = 0x1020020;
    public static final int ID_COPY = 0x1020021;
    public static final int ID_PASTE = 0x1020022;
    public static final int ID_COPY_URL = 16908323;
    public static final int ID_SWITCH_INPUT_METHOD = 16908324;
    public static final int ID_ADD_TO_DICTIONARY = 16908330;
    @ViewDebug.ExportedProperty
    public CharSequence mText = "";
    public CharSequence mTransformed;
    public BufferType mBufferType = BufferType.NORMAL;
    public int mInputType = 0;
    public CharSequence mHint;
    public Layout mHintLayout;
    public KeyListener mInput;
    public MovementMethod mMovement;
    public TransformationMethod mTransformation;
    public ChangeWatcher mChangeWatcher;
    public ArrayList<TextWatcher> mListeners = null;
    public final TextPaint mTextPaint;
    public boolean mUserSetTextScaleX;
    public final Paint mHighlightPaint;
    public int mHighlightColor = -867739355;
    public Layout mLayout;
    public long mShowCursor;
    public Blink mBlink;
    public boolean mCursorVisible = true;
    public CursorController mInsertionPointCursorController;
    public CursorController mSelectionModifierCursorController;
    public boolean mInsertionControllerEnabled;
    public boolean mSelectionControllerEnabled;
    public boolean mInBatchEditControllers;
    public boolean mIsInTextSelectionMode = false;
    public boolean mDPadCenterIsDown = false;
    public boolean mEnterKeyIsDown = false;
    public boolean mContextMenuTriggeredByKey = false;
    public static Rect sCursorControllerTempRect;
    public boolean mSelectAllOnFocus = false;
    public int mGravity = 51;
    public boolean mHorizontallyScrolling;
    public int mAutoLinkMask;
    public boolean mLinksClickable = true;
    public float mSpacingMult = 1.0f;
    public float mSpacingAdd = 0.0f;
    public static final int LINES = 1;
    public static final int EMS = 1;
    public static final int PIXELS = 2;
    public int mMaximum = Integer.MAX_VALUE;
    public int mMaxMode = 1;
    public int mMinimum = 0;
    public int mMinMode = 1;
    public int mMaxWidth = Integer.MAX_VALUE;
    public int mMaxWidthMode = 2;
    public int mMinWidth = 0;
    public int mMinWidthMode = 2;
    public boolean mSingleLine;
    public int mDesiredHeightAtMeasure = -1;
    public boolean mIncludePad = true;
    public Path mHighlightPath;
    public boolean mHighlightPathBogus = true;
    public static final RectF sTempRect;
    public static final int VERY_WIDE = 16384;
    public static final int BLINK = 500;
    public static final int ANIMATED_SCROLL_GAP = 250;
    public long mLastScroll;
    public Scroller mScroller = null;
    public BoringLayout.Metrics mBoring;
    public BoringLayout.Metrics mHintBoring;
    public BoringLayout mSavedLayout;
    public BoringLayout mSavedHintLayout;
    public static final InputFilter[] NO_FILTERS;
    public InputFilter[] mFilters = NO_FILTERS;
    public static final Spanned EMPTY_SPANNED;

    public TextView(Context context) {
        this(context, null);
    }

    public TextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public TextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        boolean focusable;
        this.mTextPaint = new TextPaint(1);
        this.mTextPaint.density = this.getResources().getDisplayMetrics().density;
        this.mTextPaint.setCompatibilityScaling(this.getResources().getCompatibilityInfo().applicationScale);
        this.mHighlightPaint = new Paint(1);
        this.mHighlightPaint.setCompatibilityScaling(this.getResources().getCompatibilityInfo().applicationScale);
        this.mMovement = this.getDefaultMovementMethod();
        this.mTransformation = null;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextView, defStyle, 0);
        int textColorHighlight = 0;
        ColorStateList textColor = null;
        ColorStateList textColorHint = null;
        ColorStateList textColorLink = null;
        int textSize = 15;
        int typefaceIndex = -1;
        int styleIndex = -1;
        TypedArray appearance = null;
        int ap = a.getResourceId(1, -1);
        if (ap != -1) {
            appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
        }
        if (appearance != null) {
            int n = appearance.getIndexCount();
            block106: for (int i = 0; i < n; ++i) {
                int attr2 = appearance.getIndex(i);
                switch (attr2) {
                    case 4: {
                        textColorHighlight = appearance.getColor(attr2, textColorHighlight);
                        continue block106;
                    }
                    case 3: {
                        textColor = appearance.getColorStateList(attr2);
                        continue block106;
                    }
                    case 5: {
                        textColorHint = appearance.getColorStateList(attr2);
                        continue block106;
                    }
                    case 6: {
                        textColorLink = appearance.getColorStateList(attr2);
                        continue block106;
                    }
                    case 0: {
                        textSize = appearance.getDimensionPixelSize(attr2, textSize);
                        continue block106;
                    }
                    case 1: {
                        typefaceIndex = appearance.getInt(attr2, -1);
                        continue block106;
                    }
                    case 2: {
                        styleIndex = appearance.getInt(attr2, -1);
                    }
                }
            }
            appearance.recycle();
        }
        boolean editable = this.getDefaultEditable();
        CharSequence inputMethod = null;
        int numeric = 0;
        CharSequence digits = null;
        boolean phone = false;
        boolean autotext = false;
        int autocap = -1;
        int buffertype = 0;
        boolean selectallonfocus = false;
        Drawable drawableLeft = null;
        Drawable drawableTop = null;
        Drawable drawableRight = null;
        Drawable drawableBottom = null;
        int drawablePadding = 0;
        int ellipsize = -1;
        boolean singleLine = false;
        int maxlength = -1;
        CharSequence text = "";
        CharSequence hint = null;
        int shadowcolor = 0;
        float dx = 0.0f;
        float dy = 0.0f;
        float r = 0.0f;
        boolean password = false;
        int inputType = 0;
        int n = a.getIndexCount();
        block107: for (int i = 0; i < n; ++i) {
            int attr3 = a.getIndex(i);
            switch (attr3) {
                case 46: {
                    editable = a.getBoolean(attr3, editable);
                    continue block107;
                }
                case 43: {
                    inputMethod = a.getText(attr3);
                    continue block107;
                }
                case 40: {
                    numeric = a.getInt(attr3, numeric);
                    continue block107;
                }
                case 41: {
                    digits = a.getText(attr3);
                    continue block107;
                }
                case 42: {
                    phone = a.getBoolean(attr3, phone);
                    continue block107;
                }
                case 45: {
                    autotext = a.getBoolean(attr3, autotext);
                    continue block107;
                }
                case 44: {
                    autocap = a.getInt(attr3, autocap);
                    continue block107;
                }
                case 17: {
                    buffertype = a.getInt(attr3, buffertype);
                    continue block107;
                }
                case 33: {
                    selectallonfocus = a.getBoolean(attr3, selectallonfocus);
                    continue block107;
                }
                case 11: {
                    this.mAutoLinkMask = a.getInt(attr3, 0);
                    continue block107;
                }
                case 12: {
                    this.mLinksClickable = a.getBoolean(attr3, true);
                    continue block107;
                }
                case 50: {
                    drawableLeft = a.getDrawable(attr3);
                    continue block107;
                }
                case 48: {
                    drawableTop = a.getDrawable(attr3);
                    continue block107;
                }
                case 51: {
                    drawableRight = a.getDrawable(attr3);
                    continue block107;
                }
                case 49: {
                    drawableBottom = a.getDrawable(attr3);
                    continue block107;
                }
                case 52: {
                    drawablePadding = a.getDimensionPixelSize(attr3, drawablePadding);
                    continue block107;
                }
                case 22: {
                    this.setMaxLines(a.getInt(attr3, -1));
                    continue block107;
                }
                case 14: {
                    this.setMaxHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 23: {
                    this.setLines(a.getInt(attr3, -1));
                    continue block107;
                }
                case 24: {
                    this.setHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 25: {
                    this.setMinLines(a.getInt(attr3, -1));
                    continue block107;
                }
                case 16: {
                    this.setMinHeight(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 26: {
                    this.setMaxEms(a.getInt(attr3, -1));
                    continue block107;
                }
                case 13: {
                    this.setMaxWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 27: {
                    this.setEms(a.getInt(attr3, -1));
                    continue block107;
                }
                case 28: {
                    this.setWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 29: {
                    this.setMinEms(a.getInt(attr3, -1));
                    continue block107;
                }
                case 15: {
                    this.setMinWidth(a.getDimensionPixelSize(attr3, -1));
                    continue block107;
                }
                case 10: {
                    this.setGravity(a.getInt(attr3, -1));
                    continue block107;
                }
                case 19: {
                    hint = a.getText(attr3);
                    continue block107;
                }
                case 18: {
                    text = a.getText(attr3);
                    continue block107;
                }
                case 30: {
                    if (!a.getBoolean(attr3, false)) continue block107;
                    this.setHorizontallyScrolling(true);
                    continue block107;
                }
                case 32: {
                    singleLine = a.getBoolean(attr3, singleLine);
                    continue block107;
                }
                case 9: {
                    ellipsize = a.getInt(attr3, ellipsize);
                    continue block107;
                }
                case 55: {
                    this.setMarqueeRepeatLimit(a.getInt(attr3, this.mMarqueeRepeatLimit));
                    continue block107;
                }
                case 34: {
                    if (a.getBoolean(attr3, true)) continue block107;
                    this.setIncludeFontPadding(false);
                    continue block107;
                }
                case 21: {
                    if (a.getBoolean(attr3, true)) continue block107;
                    this.setCursorVisible(false);
                    continue block107;
                }
                case 35: {
                    maxlength = a.getInt(attr3, -1);
                    continue block107;
                }
                case 20: {
                    this.setTextScaleX(a.getFloat(attr3, 1.0f));
                    continue block107;
                }
                case 47: {
                    this.mFreezesText = a.getBoolean(attr3, false);
                    continue block107;
                }
                case 36: {
                    shadowcolor = a.getInt(attr3, 0);
                    continue block107;
                }
                case 37: {
                    dx = a.getFloat(attr3, 0.0f);
                    continue block107;
                }
                case 38: {
                    dy = a.getFloat(attr3, 0.0f);
                    continue block107;
                }
                case 39: {
                    r = a.getFloat(attr3, 0.0f);
                    continue block107;
                }
                case 0: {
                    this.setEnabled(a.getBoolean(attr3, this.isEnabled()));
                    continue block107;
                }
                case 6: {
                    textColorHighlight = a.getColor(attr3, textColorHighlight);
                    continue block107;
                }
                case 5: {
                    textColor = a.getColorStateList(attr3);
                    continue block107;
                }
                case 7: {
                    textColorHint = a.getColorStateList(attr3);
                    continue block107;
                }
                case 8: {
                    textColorLink = a.getColorStateList(attr3);
                    continue block107;
                }
                case 2: {
                    textSize = a.getDimensionPixelSize(attr3, textSize);
                    continue block107;
                }
                case 3: {
                    typefaceIndex = a.getInt(attr3, typefaceIndex);
                    continue block107;
                }
                case 4: {
                    styleIndex = a.getInt(attr3, styleIndex);
                    continue block107;
                }
                case 31: {
                    password = a.getBoolean(attr3, password);
                    continue block107;
                }
                case 53: {
                    this.mSpacingAdd = a.getDimensionPixelSize(attr3, (int)this.mSpacingAdd);
                    continue block107;
                }
                case 54: {
                    this.mSpacingMult = a.getFloat(attr3, this.mSpacingMult);
                    continue block107;
                }
                case 56: {
                    inputType = a.getInt(attr3, this.mInputType);
                    continue block107;
                }
                case 59: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeOptions = a.getInt(attr3, this.mInputContentType.imeOptions);
                    continue block107;
                }
                case 60: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeActionLabel = a.getText(attr3);
                    continue block107;
                }
                case 61: {
                    if (this.mInputContentType == null) {
                        this.mInputContentType = new InputContentType();
                    }
                    this.mInputContentType.imeActionId = a.getInt(attr3, this.mInputContentType.imeActionId);
                    continue block107;
                }
                case 57: {
                    this.setPrivateImeOptions(a.getString(attr3));
                    continue block107;
                }
                case 58: {
                    try {
                        this.setInputExtras(a.getResourceId(attr3, 0));
                    }
                    catch (XmlPullParserException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    catch (IOException e) {
                        Log.w(LOG_TAG, "Failure reading input extras", e);
                    }
                    continue block107;
                }
                case 62: {
                    this.mTextSelectHandleLeftRes = a.getResourceId(attr3, 0);
                    continue block107;
                }
                case 63: {
                    this.mTextSelectHandleRightRes = a.getResourceId(attr3, 0);
                    continue block107;
                }
                case 64: {
                    this.mTextSelectHandleRes = a.getResourceId(attr3, 0);
                }
            }
        }
        a.recycle();
        BufferType bufferType = BufferType.EDITABLE;
        if ((inputType & 0xFFF) == 129) {
            password = true;
        }
        if (inputMethod != null) {
            Class<?> c;
            try {
                c = Class.forName(((Object)inputMethod).toString());
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mInput = (KeyListener)c.newInstance();
            }
            catch (InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
            try {
                this.mInputType = inputType != 0 ? inputType : this.mInput.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mInputType = 1;
            }
        } else if (digits != null) {
            this.mInput = DigitsKeyListener.getInstance(((Object)digits).toString());
            this.mInputType = inputType != 0 ? inputType : 1;
        } else if (inputType != 0) {
            this.setInputType(inputType, true);
            singleLine = (inputType & 0x2000F) != 131073;
        } else if (phone) {
            this.mInput = DialerKeyListener.getInstance();
            inputType = 3;
            this.mInputType = 3;
        } else if (numeric != 0) {
            this.mInput = DigitsKeyListener.getInstance((numeric & 2) != 0, (numeric & 4) != 0);
            inputType = 2;
            if ((numeric & 2) != 0) {
                inputType |= 0x1000;
            }
            if ((numeric & 4) != 0) {
                inputType |= 0x2000;
            }
            this.mInputType = inputType;
        } else if (autotext || autocap != -1) {
            TextKeyListener.Capitalize cap;
            inputType = 1;
            if (!singleLine) {
                inputType |= 0x20000;
            }
            switch (autocap) {
                case 1: {
                    cap = TextKeyListener.Capitalize.SENTENCES;
                    inputType |= 0x4000;
                    break;
                }
                case 2: {
                    cap = TextKeyListener.Capitalize.WORDS;
                    inputType |= 0x2000;
                    break;
                }
                case 3: {
                    cap = TextKeyListener.Capitalize.CHARACTERS;
                    inputType |= 0x1000;
                    break;
                }
                default: {
                    cap = TextKeyListener.Capitalize.NONE;
                }
            }
            this.mInput = TextKeyListener.getInstance(autotext, cap);
            this.mInputType = inputType;
        } else if (editable) {
            this.mInput = TextKeyListener.getInstance();
            this.mInputType = 1;
            if (!singleLine) {
                this.mInputType |= 0x20000;
            }
        } else {
            this.mInput = null;
            switch (buffertype) {
                case 0: {
                    bufferType = BufferType.NORMAL;
                    break;
                }
                case 1: {
                    bufferType = BufferType.SPANNABLE;
                    break;
                }
                case 2: {
                    bufferType = BufferType.EDITABLE;
                }
            }
        }
        if (password && (this.mInputType & 0xF) == 1) {
            this.mInputType = this.mInputType & 0xFFFFF00F | 0x80;
        }
        if (selectallonfocus) {
            this.mSelectAllOnFocus = true;
            if (bufferType == BufferType.NORMAL) {
                bufferType = BufferType.SPANNABLE;
            }
        }
        this.setCompoundDrawablesWithIntrinsicBounds(drawableLeft, drawableTop, drawableRight, drawableBottom);
        this.setCompoundDrawablePadding(drawablePadding);
        if (singleLine) {
            this.setSingleLine();
            if (this.mInput == null && ellipsize < 0) {
                ellipsize = 3;
            }
        }
        switch (ellipsize) {
            case 1: {
                this.setEllipsize(TextUtils.TruncateAt.START);
                break;
            }
            case 2: {
                this.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                break;
            }
            case 3: {
                this.setEllipsize(TextUtils.TruncateAt.END);
                break;
            }
            case 4: {
                this.setHorizontalFadingEdgeEnabled(true);
                this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
            }
        }
        this.setTextColor(textColor != null ? textColor : ColorStateList.valueOf(-16777216));
        this.setHintTextColor(textColorHint);
        this.setLinkTextColor(textColorLink);
        if (textColorHighlight != 0) {
            this.setHighlightColor(textColorHighlight);
        }
        this.setRawTextSize(textSize);
        if (password) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            typefaceIndex = 3;
        } else if ((this.mInputType & 0xFFF) == 129) {
            typefaceIndex = 3;
        }
        this.setTypefaceByIndex(typefaceIndex, styleIndex);
        if (shadowcolor != 0) {
            this.setShadowLayer(r, dx, dy, shadowcolor);
        }
        if (maxlength >= 0) {
            this.setFilters(new InputFilter[]{new InputFilter.LengthFilter(maxlength)});
        } else {
            this.setFilters(NO_FILTERS);
        }
        this.setText(text, bufferType);
        if (hint != null) {
            this.setHint(hint);
        }
        a = context.obtainStyledAttributes(attrs, R.styleable.View, defStyle, 0);
        boolean clickable = focusable = this.mMovement != null || this.mInput != null;
        boolean longClickable = focusable;
        n = a.getIndexCount();
        block108: for (int i = 0; i < n; ++i) {
            int attr4 = a.getIndex(i);
            switch (attr4) {
                case 18: {
                    focusable = a.getBoolean(attr4, focusable);
                    continue block108;
                }
                case 29: {
                    clickable = a.getBoolean(attr4, clickable);
                    continue block108;
                }
                case 30: {
                    longClickable = a.getBoolean(attr4, longClickable);
                }
            }
        }
        a.recycle();
        this.setFocusable(focusable);
        this.setClickable(clickable);
        this.setLongClickable(longClickable);
        this.prepareCursorControllers();
    }

    public void setTypefaceByIndex(int typefaceIndex, int styleIndex) {
        Typeface tf = null;
        switch (typefaceIndex) {
            case 1: {
                tf = Typeface.SANS_SERIF;
                break;
            }
            case 2: {
                tf = Typeface.SERIF;
                break;
            }
            case 3: {
                tf = Typeface.MONOSPACE;
            }
        }
        this.setTypeface(tf, styleIndex);
    }

    public void setTypeface(Typeface tf, int style2) {
        if (style2 > 0) {
            tf = tf == null ? Typeface.defaultFromStyle(style2) : Typeface.create(tf, style2);
            this.setTypeface(tf);
            int typefaceStyle = tf != null ? tf.getStyle() : 0;
            int need = style2 & ~typefaceStyle;
            this.mTextPaint.setFakeBoldText((need & 1) != 0);
            this.mTextPaint.setTextSkewX((need & 2) != 0 ? -0.25f : 0.0f);
        } else {
            this.mTextPaint.setFakeBoldText(false);
            this.mTextPaint.setTextSkewX(0.0f);
            this.setTypeface(tf);
        }
    }

    public boolean getDefaultEditable() {
        return false;
    }

    public MovementMethod getDefaultMovementMethod() {
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getText() {
        return this.mText;
    }

    public int length() {
        return this.mText.length();
    }

    public Editable getEditableText() {
        return this.mText instanceof Editable ? (Editable)this.mText : null;
    }

    public int getLineHeight() {
        return FastMath.round((float)this.mTextPaint.getFontMetricsInt(null) * this.mSpacingMult + this.mSpacingAdd);
    }

    public Layout getLayout() {
        return this.mLayout;
    }

    public KeyListener getKeyListener() {
        return this.mInput;
    }

    public void setKeyListener(KeyListener input) {
        InputMethodManager imm;
        this.setKeyListenerOnly(input);
        this.fixFocusableAndClickableSettings();
        if (input != null) {
            try {
                this.mInputType = this.mInput.getInputType();
            }
            catch (IncompatibleClassChangeError e) {
                this.mInputType = 1;
            }
            if ((this.mInputType & 0xF) == 1) {
                this.mInputType = this.mSingleLine ? (this.mInputType &= 0xFFFDFFFF) : (this.mInputType |= 0x20000);
            }
        } else {
            this.mInputType = 0;
        }
        if ((imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
    }

    public void setKeyListenerOnly(KeyListener input) {
        this.mInput = input;
        if (this.mInput != null && !(this.mText instanceof Editable)) {
            this.setText(this.mText);
        }
        this.setFilters((Editable)this.mText, this.mFilters);
    }

    public MovementMethod getMovementMethod() {
        return this.mMovement;
    }

    public void setMovementMethod(MovementMethod movement) {
        this.mMovement = movement;
        if (this.mMovement != null && !(this.mText instanceof Spannable)) {
            this.setText(this.mText);
        }
        this.fixFocusableAndClickableSettings();
        this.prepareCursorControllers();
    }

    public void fixFocusableAndClickableSettings() {
        if (this.mMovement != null || this.mInput != null) {
            this.setFocusable(true);
            this.setClickable(true);
            this.setLongClickable(true);
        } else {
            this.setFocusable(false);
            this.setClickable(false);
            this.setLongClickable(false);
        }
    }

    public TransformationMethod getTransformationMethod() {
        return this.mTransformation;
    }

    public void setTransformationMethod(TransformationMethod method) {
        if (method == this.mTransformation) {
            return;
        }
        if (this.mTransformation != null && this.mText instanceof Spannable) {
            ((Spannable)this.mText).removeSpan(this.mTransformation);
        }
        this.mTransformation = method;
        this.setText(this.mText);
    }

    public int getCompoundPaddingTop() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableTop == null) {
            return this.mPaddingTop;
        }
        return this.mPaddingTop + dr.mDrawablePadding + dr.mDrawableSizeTop;
    }

    public int getCompoundPaddingBottom() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableBottom == null) {
            return this.mPaddingBottom;
        }
        return this.mPaddingBottom + dr.mDrawablePadding + dr.mDrawableSizeBottom;
    }

    public int getCompoundPaddingLeft() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableLeft == null) {
            return this.mPaddingLeft;
        }
        return this.mPaddingLeft + dr.mDrawablePadding + dr.mDrawableSizeLeft;
    }

    public int getCompoundPaddingRight() {
        Drawables dr = this.mDrawables;
        if (dr == null || dr.mDrawableRight == null) {
            return this.mPaddingRight;
        }
        return this.mPaddingRight + dr.mDrawablePadding + dr.mDrawableSizeRight;
    }

    public int getExtendedPaddingTop() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingTop();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingTop();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return top;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return top;
        }
        if (gravity == 80) {
            return top + viewht - layoutht;
        }
        return top + (viewht - layoutht) / 2;
    }

    public int getExtendedPaddingBottom() {
        if (this.mMaxMode != 1) {
            return this.getCompoundPaddingBottom();
        }
        if (this.mLayout.getLineCount() <= this.mMaximum) {
            return this.getCompoundPaddingBottom();
        }
        int top = this.getCompoundPaddingTop();
        int bottom = this.getCompoundPaddingBottom();
        int viewht = this.getHeight() - top - bottom;
        int layoutht = this.mLayout.getLineTop(this.mMaximum);
        if (layoutht >= viewht) {
            return bottom;
        }
        int gravity = this.mGravity & 0x70;
        if (gravity == 48) {
            return bottom + viewht - layoutht;
        }
        if (gravity == 80) {
            return bottom;
        }
        return bottom + (viewht - layoutht) / 2;
    }

    public int getTotalPaddingLeft() {
        return this.getCompoundPaddingLeft();
    }

    public int getTotalPaddingRight() {
        return this.getCompoundPaddingRight();
    }

    public int getTotalPaddingTop() {
        return this.getExtendedPaddingTop() + this.getVerticalOffset(true);
    }

    public int getTotalPaddingBottom() {
        return this.getExtendedPaddingBottom() + this.getBottomVerticalOffset(true);
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        boolean drawables;
        Drawables dr = this.mDrawables;
        boolean bl = drawables = left != null || top != null || right != null || bottom != null;
        if (!drawables) {
            if (dr != null) {
                if (dr.mDrawablePadding == 0) {
                    this.mDrawables = null;
                } else {
                    if (dr.mDrawableLeft != null) {
                        dr.mDrawableLeft.setCallback(null);
                    }
                    dr.mDrawableLeft = null;
                    if (dr.mDrawableTop != null) {
                        dr.mDrawableTop.setCallback(null);
                    }
                    dr.mDrawableTop = null;
                    if (dr.mDrawableRight != null) {
                        dr.mDrawableRight.setCallback(null);
                    }
                    dr.mDrawableRight = null;
                    if (dr.mDrawableBottom != null) {
                        dr.mDrawableBottom.setCallback(null);
                    }
                    dr.mDrawableBottom = null;
                    dr.mDrawableHeightLeft = 0;
                    dr.mDrawableSizeLeft = 0;
                    dr.mDrawableHeightRight = 0;
                    dr.mDrawableSizeRight = 0;
                    dr.mDrawableWidthTop = 0;
                    dr.mDrawableSizeTop = 0;
                    dr.mDrawableWidthBottom = 0;
                    dr.mDrawableSizeBottom = 0;
                }
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            if (dr.mDrawableLeft != left && dr.mDrawableLeft != null) {
                dr.mDrawableLeft.setCallback(null);
            }
            dr.mDrawableLeft = left;
            if (dr.mDrawableTop != top && dr.mDrawableTop != null) {
                dr.mDrawableTop.setCallback(null);
            }
            dr.mDrawableTop = top;
            if (dr.mDrawableRight != right && dr.mDrawableRight != null) {
                dr.mDrawableRight.setCallback(null);
            }
            dr.mDrawableRight = right;
            if (dr.mDrawableBottom != bottom && dr.mDrawableBottom != null) {
                dr.mDrawableBottom.setCallback(null);
            }
            dr.mDrawableBottom = bottom;
            Rect compoundRect = dr.mCompoundRect;
            int[] state = this.getDrawableState();
            if (left != null) {
                left.setState(state);
                left.copyBounds(compoundRect);
                left.setCallback(this);
                dr.mDrawableSizeLeft = compoundRect.width();
                dr.mDrawableHeightLeft = compoundRect.height();
            } else {
                dr.mDrawableHeightLeft = 0;
                dr.mDrawableSizeLeft = 0;
            }
            if (right != null) {
                right.setState(state);
                right.copyBounds(compoundRect);
                right.setCallback(this);
                dr.mDrawableSizeRight = compoundRect.width();
                dr.mDrawableHeightRight = compoundRect.height();
            } else {
                dr.mDrawableHeightRight = 0;
                dr.mDrawableSizeRight = 0;
            }
            if (top != null) {
                top.setState(state);
                top.copyBounds(compoundRect);
                top.setCallback(this);
                dr.mDrawableSizeTop = compoundRect.height();
                dr.mDrawableWidthTop = compoundRect.width();
            } else {
                dr.mDrawableWidthTop = 0;
                dr.mDrawableSizeTop = 0;
            }
            if (bottom != null) {
                bottom.setState(state);
                bottom.copyBounds(compoundRect);
                bottom.setCallback(this);
                dr.mDrawableSizeBottom = compoundRect.height();
                dr.mDrawableWidthBottom = compoundRect.width();
            } else {
                dr.mDrawableWidthBottom = 0;
                dr.mDrawableSizeBottom = 0;
            }
        }
        this.invalidate();
        this.requestLayout();
    }

    public void setCompoundDrawablesWithIntrinsicBounds(int left, int top, int right, int bottom) {
        Resources resources = this.getContext().getResources();
        this.setCompoundDrawablesWithIntrinsicBounds(left != 0 ? resources.getDrawable(left) : null, top != 0 ? resources.getDrawable(top) : null, right != 0 ? resources.getDrawable(right) : null, bottom != 0 ? resources.getDrawable(bottom) : null);
    }

    public void setCompoundDrawablesWithIntrinsicBounds(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left.setBounds(0, 0, left.getIntrinsicWidth(), left.getIntrinsicHeight());
        }
        if (right != null) {
            right.setBounds(0, 0, right.getIntrinsicWidth(), right.getIntrinsicHeight());
        }
        if (top != null) {
            top.setBounds(0, 0, top.getIntrinsicWidth(), top.getIntrinsicHeight());
        }
        if (bottom != null) {
            bottom.setBounds(0, 0, bottom.getIntrinsicWidth(), bottom.getIntrinsicHeight());
        }
        this.setCompoundDrawables(left, top, right, bottom);
    }

    public Drawable[] getCompoundDrawables() {
        Drawables dr = this.mDrawables;
        if (dr != null) {
            return new Drawable[]{dr.mDrawableLeft, dr.mDrawableTop, dr.mDrawableRight, dr.mDrawableBottom};
        }
        return new Drawable[]{null, null, null, null};
    }

    public void setCompoundDrawablePadding(int pad) {
        Drawables dr = this.mDrawables;
        if (pad == 0) {
            if (dr != null) {
                dr.mDrawablePadding = pad;
            }
        } else {
            if (dr == null) {
                this.mDrawables = dr = new Drawables();
            }
            dr.mDrawablePadding = pad;
        }
        this.invalidate();
        this.requestLayout();
    }

    public int getCompoundDrawablePadding() {
        Drawables dr = this.mDrawables;
        return dr != null ? dr.mDrawablePadding : 0;
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (left != this.mPaddingLeft || right != this.mPaddingRight || top != this.mPaddingTop || bottom != this.mPaddingBottom) {
            this.nullLayouts();
        }
        super.setPadding(left, top, right, bottom);
        this.invalidate();
    }

    public int getAutoLinkMask() {
        return this.mAutoLinkMask;
    }

    public void setTextAppearance(Context context, int resid) {
        int ts;
        ColorStateList colors;
        TypedArray appearance = context.obtainStyledAttributes(resid, R.styleable.TextAppearance);
        int color2 = appearance.getColor(4, 0);
        if (color2 != 0) {
            this.setHighlightColor(color2);
        }
        if ((colors = appearance.getColorStateList(3)) != null) {
            this.setTextColor(colors);
        }
        if ((ts = appearance.getDimensionPixelSize(0, 0)) != 0) {
            this.setRawTextSize(ts);
        }
        if ((colors = appearance.getColorStateList(5)) != null) {
            this.setHintTextColor(colors);
        }
        if ((colors = appearance.getColorStateList(6)) != null) {
            this.setLinkTextColor(colors);
        }
        int typefaceIndex = appearance.getInt(1, -1);
        int styleIndex = appearance.getInt(2, -1);
        this.setTypefaceByIndex(typefaceIndex, styleIndex);
        appearance.recycle();
    }

    public float getTextSize() {
        return this.mTextPaint.getTextSize();
    }

    @RemotableViewMethod
    public void setTextSize(float size) {
        this.setTextSize(2, size);
    }

    public void setTextSize(int unit, float size) {
        Context c = this.getContext();
        Resources r = c == null ? Resources.getSystem() : c.getResources();
        this.setRawTextSize(TypedValue.applyDimension(unit, size, r.getDisplayMetrics()));
    }

    public void setRawTextSize(float size) {
        if (size != this.mTextPaint.getTextSize()) {
            this.mTextPaint.setTextSize(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public float getTextScaleX() {
        return this.mTextPaint.getTextScaleX();
    }

    @RemotableViewMethod
    public void setTextScaleX(float size) {
        if (size != this.mTextPaint.getTextScaleX()) {
            this.mUserSetTextScaleX = true;
            this.mTextPaint.setTextScaleX(size);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setTypeface(Typeface tf) {
        if (this.mTextPaint.getTypeface() != tf) {
            this.mTextPaint.setTypeface(tf);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public Typeface getTypeface() {
        return this.mTextPaint.getTypeface();
    }

    @RemotableViewMethod
    public void setTextColor(int color2) {
        this.mTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setTextColor(ColorStateList colors) {
        if (colors == null) {
            throw new NullPointerException();
        }
        this.mTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getTextColors() {
        return this.mTextColor;
    }

    public int getCurrentTextColor() {
        return this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setHighlightColor(int color2) {
        if (this.mHighlightColor != color2) {
            this.mHighlightColor = color2;
            this.invalidate();
        }
    }

    public void setShadowLayer(float radius, float dx, float dy, int color2) {
        this.mTextPaint.setShadowLayer(radius, dx, dy, color2);
        this.mShadowRadius = radius;
        this.mShadowDx = dx;
        this.mShadowDy = dy;
        this.invalidate();
    }

    public TextPaint getPaint() {
        return this.mTextPaint;
    }

    @RemotableViewMethod
    public void setAutoLinkMask(int mask) {
        this.mAutoLinkMask = mask;
    }

    @RemotableViewMethod
    public void setLinksClickable(boolean whether) {
        this.mLinksClickable = whether;
    }

    public boolean getLinksClickable() {
        return this.mLinksClickable;
    }

    public URLSpan[] getUrls() {
        if (this.mText instanceof Spanned) {
            return ((Spanned)this.mText).getSpans(0, this.mText.length(), URLSpan.class);
        }
        return new URLSpan[0];
    }

    @RemotableViewMethod
    public void setHintTextColor(int color2) {
        this.mHintTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setHintTextColor(ColorStateList colors) {
        this.mHintTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getHintTextColors() {
        return this.mHintTextColor;
    }

    public int getCurrentHintTextColor() {
        return this.mHintTextColor != null ? this.mCurHintTextColor : this.mCurTextColor;
    }

    @RemotableViewMethod
    public void setLinkTextColor(int color2) {
        this.mLinkTextColor = ColorStateList.valueOf(color2);
        this.updateTextColors();
    }

    public void setLinkTextColor(ColorStateList colors) {
        this.mLinkTextColor = colors;
        this.updateTextColors();
    }

    public ColorStateList getLinkTextColors() {
        return this.mLinkTextColor;
    }

    public void setGravity(int gravity) {
        if ((gravity & 7) == 0) {
            gravity |= 3;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        boolean newLayout = false;
        if ((gravity & 7) != (this.mGravity & 7)) {
            newLayout = true;
        }
        if (gravity != this.mGravity) {
            this.invalidate();
        }
        this.mGravity = gravity;
        if (this.mLayout != null && newLayout) {
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), true);
        }
    }

    public int getGravity() {
        return this.mGravity;
    }

    public int getPaintFlags() {
        return this.mTextPaint.getFlags();
    }

    @RemotableViewMethod
    public void setPaintFlags(int flags) {
        if (this.mTextPaint.getFlags() != flags) {
            this.mTextPaint.setFlags(flags);
            if (this.mLayout != null) {
                this.nullLayouts();
                this.requestLayout();
                this.invalidate();
            }
        }
    }

    public void setHorizontallyScrolling(boolean whether) {
        this.mHorizontallyScrolling = whether;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setMinLines(int minlines) {
        this.mMinimum = minlines;
        this.mMinMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinHeight(int minHeight) {
        this.mMinimum = minHeight;
        this.mMinMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxLines(int maxlines) {
        this.mMaximum = maxlines;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxHeight(int maxHeight) {
        this.mMaximum = maxHeight;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setLines(int lines) {
        this.mMaximum = this.mMinimum = lines;
        this.mMinMode = 1;
        this.mMaxMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHeight(int pixels) {
        this.mMaximum = this.mMinimum = pixels;
        this.mMinMode = 2;
        this.mMaxMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinEms(int minems) {
        this.mMinWidth = minems;
        this.mMinWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMinWidth(int minpixels) {
        this.mMinWidth = minpixels;
        this.mMinWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxEms(int maxems) {
        this.mMaxWidth = maxems;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setMaxWidth(int maxpixels) {
        this.mMaxWidth = maxpixels;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setEms(int ems) {
        this.mMaxWidth = this.mMinWidth = ems;
        this.mMinWidthMode = 1;
        this.mMaxWidthMode = 1;
        this.requestLayout();
        this.invalidate();
    }

    @RemotableViewMethod
    public void setWidth(int pixels) {
        this.mMaxWidth = this.mMinWidth = pixels;
        this.mMinWidthMode = 2;
        this.mMaxWidthMode = 2;
        this.requestLayout();
        this.invalidate();
    }

    public void setLineSpacing(float add, float mult) {
        this.mSpacingMult = mult;
        this.mSpacingAdd = add;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void append(CharSequence text) {
        this.append(text, 0, text.length());
    }

    public void append(CharSequence text, int start, int end) {
        if (!(this.mText instanceof Editable)) {
            this.setText(this.mText, BufferType.EDITABLE);
        }
        ((Editable)this.mText).append(text, start, end);
    }

    public void updateTextColors() {
        boolean inval = false;
        int color2 = this.mTextColor.getColorForState(this.getDrawableState(), 0);
        if (color2 != this.mCurTextColor) {
            this.mCurTextColor = color2;
            inval = true;
        }
        if (this.mLinkTextColor != null && (color2 = this.mLinkTextColor.getColorForState(this.getDrawableState(), 0)) != this.mTextPaint.linkColor) {
            this.mTextPaint.linkColor = color2;
            inval = true;
        }
        if (this.mHintTextColor != null && (color2 = this.mHintTextColor.getColorForState(this.getDrawableState(), 0)) != this.mCurHintTextColor && this.mText.length() == 0) {
            this.mCurHintTextColor = color2;
            inval = true;
        }
        if (inval) {
            this.invalidate();
        }
    }

    public void drawableStateChanged() {
        Drawables dr;
        super.drawableStateChanged();
        if (this.mTextColor != null && this.mTextColor.isStateful() || this.mHintTextColor != null && this.mHintTextColor.isStateful() || this.mLinkTextColor != null && this.mLinkTextColor.isStateful()) {
            this.updateTextColors();
        }
        if ((dr = this.mDrawables) != null) {
            int[] state = this.getDrawableState();
            if (dr.mDrawableTop != null && dr.mDrawableTop.isStateful()) {
                dr.mDrawableTop.setState(state);
            }
            if (dr.mDrawableBottom != null && dr.mDrawableBottom.isStateful()) {
                dr.mDrawableBottom.setState(state);
            }
            if (dr.mDrawableLeft != null && dr.mDrawableLeft.isStateful()) {
                dr.mDrawableLeft.setState(state);
            }
            if (dr.mDrawableRight != null && dr.mDrawableRight.isStateful()) {
                dr.mDrawableRight.setState(state);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        boolean save = this.mFreezesText;
        int start = 0;
        int end = 0;
        if (this.mText != null) {
            start = this.getSelectionStart();
            end = this.getSelectionEnd();
            if (start >= 0 || end >= 0) {
                save = true;
            }
        }
        if (save) {
            SavedState ss = new SavedState(superState);
            ss.selStart = start;
            ss.selEnd = end;
            if (this.mText instanceof Spanned) {
                SpannableString sp = new SpannableString(this.mText);
                for (ChangeWatcher cw : sp.getSpans(0, sp.length(), ChangeWatcher.class)) {
                    sp.removeSpan(cw);
                }
                ss.text = sp;
            } else {
                ss.text = ((Object)this.mText).toString();
            }
            if (this.isFocused() && start >= 0 && end >= 0) {
                ss.frozenWithFocus = true;
            }
            ss.error = this.mError;
            return ss;
        }
        return superState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.text != null) {
            this.setText(ss.text);
        }
        if (ss.selStart >= 0 && ss.selEnd >= 0 && this.mText instanceof Spannable) {
            int len = this.mText.length();
            if (ss.selStart > len || ss.selEnd > len) {
                String restored = "";
                if (ss.text != null) {
                    restored = "(restored) ";
                }
                Log.e(LOG_TAG, "Saved cursor position " + ss.selStart + "/" + ss.selEnd + " out of range for " + restored + "text " + this.mText);
            } else {
                Selection.setSelection((Spannable)this.mText, ss.selStart, ss.selEnd);
                if (ss.frozenWithFocus) {
                    this.mFrozenWithFocus = true;
                }
            }
        }
        if (ss.error != null) {
            final CharSequence error = ss.error;
            this.post(new Runnable(){

                public void run() {
                    TextView.this.setError(error);
                }
            });
        }
    }

    @RemotableViewMethod
    public void setFreezesText(boolean freezesText) {
        this.mFreezesText = freezesText;
    }

    public boolean getFreezesText() {
        return this.mFreezesText;
    }

    public void setEditableFactory(Editable.Factory factory) {
        this.mEditableFactory = factory;
        this.setText(this.mText);
    }

    public void setSpannableFactory(Spannable.Factory factory) {
        this.mSpannableFactory = factory;
        this.setText(this.mText);
    }

    @RemotableViewMethod
    public void setText(CharSequence text) {
        this.setText(text, this.mBufferType);
    }

    @RemotableViewMethod
    public void setTextKeepState(CharSequence text) {
        this.setTextKeepState(text, this.mBufferType);
    }

    public void setText(CharSequence text, BufferType type) {
        this.setText(text, type, true, 0);
        if (this.mCharWrapper != null) {
            CharWrapper.access$102(this.mCharWrapper, null);
        }
    }

    public void setText(CharSequence text, BufferType type, boolean notifyBefore, int oldlen) {
        Spannable s2;
        if (text == null) {
            text = "";
        }
        if (!this.mUserSetTextScaleX) {
            this.mTextPaint.setTextScaleX(1.0f);
        }
        if (text instanceof Spanned && ((Spanned)text).getSpanStart((Object)TextUtils.TruncateAt.MARQUEE) >= 0) {
            this.setHorizontalFadingEdgeEnabled(true);
            this.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        }
        int n = this.mFilters.length;
        for (int i = 0; i < n; ++i) {
            CharSequence out = this.mFilters[i].filter(text, 0, text.length(), EMPTY_SPANNED, 0, 0);
            if (out == null) continue;
            text = out;
        }
        if (notifyBefore) {
            if (this.mText != null) {
                oldlen = this.mText.length();
                this.sendBeforeTextChanged(this.mText, 0, oldlen, text.length());
            } else {
                this.sendBeforeTextChanged("", 0, 0, text.length());
            }
        }
        boolean needEditableForNotification = false;
        if (this.mListeners != null && this.mListeners.size() != 0) {
            needEditableForNotification = true;
        }
        if (type == BufferType.EDITABLE || this.mInput != null || needEditableForNotification) {
            Editable t = this.mEditableFactory.newEditable(text);
            text = t;
            this.setFilters(t, this.mFilters);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null) {
                imm.restartInput(this);
            }
        } else if (type == BufferType.SPANNABLE || this.mMovement != null) {
            text = this.mSpannableFactory.newSpannable(text);
        } else if (!(text instanceof CharWrapper)) {
            text = TextUtils.stringOrSpannedString(text);
        }
        if (this.mAutoLinkMask != 0 && Linkify.addLinks(s2 = type == BufferType.EDITABLE || text instanceof Spannable ? (Spannable)text : this.mSpannableFactory.newSpannable(text), this.mAutoLinkMask)) {
            text = s2;
            type = type == BufferType.EDITABLE ? BufferType.EDITABLE : BufferType.SPANNABLE;
            this.mText = text;
            if (this.mLinksClickable) {
                this.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        this.mBufferType = type;
        this.mText = text;
        this.mTransformed = this.mTransformation == null ? text : this.mTransformation.getTransformation(text, this);
        int textLength = text.length();
        if (text instanceof Spannable) {
            Spannable sp = (Spannable)text;
            ChangeWatcher[] watchers = sp.getSpans(0, sp.length(), ChangeWatcher.class);
            int count = watchers.length;
            for (int i = 0; i < count; ++i) {
                sp.removeSpan(watchers[i]);
            }
            if (this.mChangeWatcher == null) {
                this.mChangeWatcher = new ChangeWatcher(null);
            }
            sp.setSpan(this.mChangeWatcher, 0, textLength, 0x12 | PRIORITY << 16);
            if (this.mInput != null) {
                sp.setSpan(this.mInput, 0, textLength, 18);
            }
            if (this.mTransformation != null) {
                sp.setSpan(this.mTransformation, 0, textLength, 18);
            }
            if (this.mMovement != null) {
                this.mMovement.initialize(this, (Spannable)text);
                this.mSelectionMoved = false;
            }
        }
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        this.sendOnTextChanged(text, 0, oldlen, textLength);
        this.onTextChanged(text, 0, oldlen, textLength);
        if (needEditableForNotification) {
            this.sendAfterTextChanged((Editable)text);
        }
        this.prepareCursorControllers();
    }

    public void setText(char[] text, int start, int len) {
        int oldlen = 0;
        if (start < 0 || len < 0 || start + len > text.length) {
            throw new IndexOutOfBoundsException(start + ", " + len);
        }
        if (this.mText != null) {
            oldlen = this.mText.length();
            this.sendBeforeTextChanged(this.mText, 0, oldlen, len);
        } else {
            this.sendBeforeTextChanged("", 0, 0, len);
        }
        if (this.mCharWrapper == null) {
            this.mCharWrapper = new CharWrapper(text, start, len);
        } else {
            this.mCharWrapper.set(text, start, len);
        }
        this.setText(this.mCharWrapper, this.mBufferType, false, oldlen);
    }

    public void setTextKeepState(CharSequence text, BufferType type) {
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        int len = text.length();
        this.setText(text, type);
        if ((start >= 0 || end >= 0) && this.mText instanceof Spannable) {
            Selection.setSelection((Spannable)this.mText, Math.max(0, Math.min(start, len)), Math.max(0, Math.min(end, len)));
        }
    }

    @RemotableViewMethod
    public void setText(int resid) {
        this.setText(this.getContext().getResources().getText(resid));
    }

    public void setText(int resid, BufferType type) {
        this.setText(this.getContext().getResources().getText(resid), type);
    }

    @RemotableViewMethod
    public void setHint(CharSequence hint) {
        this.mHint = TextUtils.stringOrSpannedString(hint);
        if (this.mLayout != null) {
            this.checkForRelayout();
        }
        if (this.mText.length() == 0) {
            this.invalidate();
        }
    }

    @RemotableViewMethod
    public void setHint(int resid) {
        this.setHint(this.getContext().getResources().getText(resid));
    }

    @ViewDebug.CapturedViewProperty
    public CharSequence getHint() {
        return this.mHint;
    }

    public void setInputType(int type) {
        InputMethodManager imm;
        boolean multiLine;
        boolean wasPassword = this.isPasswordInputType(this.mInputType);
        boolean wasVisiblePassword = this.isVisiblePasswordInputType(this.mInputType);
        this.setInputType(type, false);
        boolean isPassword = this.isPasswordInputType(type);
        boolean isVisiblePassword = this.isVisiblePasswordInputType(type);
        boolean forceUpdate = false;
        if (isPassword) {
            this.setTransformationMethod(PasswordTransformationMethod.getInstance());
            this.setTypefaceByIndex(3, 0);
        } else if (isVisiblePassword) {
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
            this.setTypefaceByIndex(3, 0);
        } else if (wasPassword || wasVisiblePassword) {
            this.setTypefaceByIndex(-1, -1);
            if (this.mTransformation == PasswordTransformationMethod.getInstance()) {
                forceUpdate = true;
            }
        }
        boolean bl = multiLine = (type & 0x2000F) == 131073;
        if (this.mSingleLine == multiLine || forceUpdate) {
            this.applySingleLine(!multiLine, !isPassword);
        }
        if ((imm = InputMethodManager.peekInstance()) != null) {
            imm.restartInput(this);
        }
    }

    public boolean hasPasswordTransformationMethod() {
        return this.mTransformation instanceof PasswordTransformationMethod;
    }

    public boolean isPasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 129;
    }

    public boolean isVisiblePasswordInputType(int inputType) {
        int variation = inputType & 0xFFF;
        return variation == 145;
    }

    public void setRawInputType(int type) {
        this.mInputType = type;
    }

    public void setInputType(int type, boolean direct) {
        BaseKeyListener input;
        int cls = type & 0xF;
        if (cls == 1) {
            boolean autotext;
            boolean bl = autotext = (type & 0x8000) != 0;
            TextKeyListener.Capitalize cap = (type & 0x1000) != 0 ? TextKeyListener.Capitalize.CHARACTERS : ((type & 0x2000) != 0 ? TextKeyListener.Capitalize.WORDS : ((type & 0x4000) != 0 ? TextKeyListener.Capitalize.SENTENCES : TextKeyListener.Capitalize.NONE));
            input = TextKeyListener.getInstance(autotext, cap);
        } else if (cls == 2) {
            input = DigitsKeyListener.getInstance((type & 0x1000) != 0, (type & 0x2000) != 0);
        } else if (cls == 4) {
            switch (type & 0xFF0) {
                case 16: {
                    input = DateKeyListener.getInstance();
                    break;
                }
                case 32: {
                    input = TimeKeyListener.getInstance();
                    break;
                }
                default: {
                    input = DateTimeKeyListener.getInstance();
                    break;
                }
            }
        } else {
            input = cls == 3 ? DialerKeyListener.getInstance() : TextKeyListener.getInstance();
        }
        this.setRawInputType(type);
        if (direct) {
            this.mInput = input;
        } else {
            this.setKeyListenerOnly(input);
        }
    }

    public int getInputType() {
        return this.mInputType;
    }

    public void setImeOptions(int imeOptions) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.imeOptions = imeOptions;
    }

    public int getImeOptions() {
        return this.mInputContentType != null ? this.mInputContentType.imeOptions : 0;
    }

    public void setImeActionLabel(CharSequence label, int actionId) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.imeActionLabel = label;
        this.mInputContentType.imeActionId = actionId;
    }

    public CharSequence getImeActionLabel() {
        return this.mInputContentType != null ? this.mInputContentType.imeActionLabel : null;
    }

    public int getImeActionId() {
        return this.mInputContentType != null ? this.mInputContentType.imeActionId : 0;
    }

    public void setOnEditorActionListener(OnEditorActionListener l) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.onEditorActionListener = l;
    }

    public void onEditorAction(int actionCode) {
        Handler h;
        InputContentType ict = this.mInputContentType;
        if (ict != null) {
            if (ict.onEditorActionListener != null && ict.onEditorActionListener.onEditorAction(this, actionCode, null)) {
                return;
            }
            if (actionCode == 5) {
                View v = this.focusSearch(130);
                if (v != null && !v.requestFocus(130)) {
                    throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                }
                return;
            }
            if (actionCode == 6) {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm != null) {
                    imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                }
                return;
            }
        }
        if ((h = this.getHandler()) != null) {
            long eventTime = SystemClock.uptimeMillis();
            h.sendMessage(h.obtainMessage(1011, new KeyEvent(eventTime, eventTime, 0, 66, 0, 0, 0, 0, 22)));
            h.sendMessage(h.obtainMessage(1011, new KeyEvent(SystemClock.uptimeMillis(), eventTime, 1, 66, 0, 0, 0, 0, 22)));
        }
    }

    public void setPrivateImeOptions(String type) {
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.privateImeOptions = type;
    }

    public String getPrivateImeOptions() {
        return this.mInputContentType != null ? this.mInputContentType.privateImeOptions : null;
    }

    public void setInputExtras(int xmlResId) throws XmlPullParserException, IOException {
        XmlResourceParser parser = this.getResources().getXml(xmlResId);
        if (this.mInputContentType == null) {
            this.mInputContentType = new InputContentType();
        }
        this.mInputContentType.extras = new Bundle();
        this.getResources().parseBundleExtras(parser, this.mInputContentType.extras);
    }

    public Bundle getInputExtras(boolean create) {
        if (this.mInputContentType == null) {
            if (!create) {
                return null;
            }
            this.mInputContentType = new InputContentType();
        }
        if (this.mInputContentType.extras == null) {
            if (!create) {
                return null;
            }
            this.mInputContentType.extras = new Bundle();
        }
        return this.mInputContentType.extras;
    }

    public CharSequence getError() {
        return this.mError;
    }

    @RemotableViewMethod
    public void setError(CharSequence error) {
        if (error == null) {
            this.setError(null, null);
        } else {
            Drawable dr = this.getContext().getResources().getDrawable(17301981);
            dr.setBounds(0, 0, dr.getIntrinsicWidth(), dr.getIntrinsicHeight());
            this.setError(error, dr);
        }
    }

    public void setError(CharSequence error, Drawable icon) {
        this.mError = error = TextUtils.stringOrSpannedString(error);
        this.mErrorWasChanged = true;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            this.setCompoundDrawables(dr.mDrawableLeft, dr.mDrawableTop, icon, dr.mDrawableBottom);
        } else {
            this.setCompoundDrawables(null, null, icon, null);
        }
        if (error == null) {
            if (this.mPopup != null) {
                if (this.mPopup.isShowing()) {
                    this.mPopup.dismiss();
                }
                this.mPopup = null;
            }
        } else if (this.isFocused()) {
            this.showError();
        }
    }

    public void showError() {
        if (this.getWindowToken() == null) {
            this.mShowErrorAfterAttach = true;
            return;
        }
        if (this.mPopup == null) {
            LayoutInflater inflater = LayoutInflater.from(this.getContext());
            TextView err = (TextView)inflater.inflate(17367140, null);
            float scale = this.getResources().getDisplayMetrics().density;
            this.mPopup = new ErrorPopup(err, (int)(200.0f * scale + 0.5f), (int)(50.0f * scale + 0.5f));
            this.mPopup.setFocusable(false);
            this.mPopup.setInputMethodMode(1);
        }
        TextView tv = (TextView)this.mPopup.getContentView();
        this.chooseSize(this.mPopup, this.mError, tv);
        tv.setText(this.mError);
        this.mPopup.showAsDropDown(this, this.getErrorX(), this.getErrorY());
        this.mPopup.fixDirection(this.mPopup.isAboveAnchor());
    }

    public int getErrorX() {
        float scale = this.getResources().getDisplayMetrics().density;
        Drawables dr = this.mDrawables;
        return this.getWidth() - this.mPopup.getWidth() - this.getPaddingRight() - (dr != null ? dr.mDrawableSizeRight : 0) / 2 + (int)(25.0f * scale + 0.5f);
    }

    public int getErrorY() {
        int vspace = this.mBottom - this.mTop - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
        Drawables dr = this.mDrawables;
        int icontop = this.getCompoundPaddingTop() + (vspace - (dr != null ? dr.mDrawableHeightRight : 0)) / 2;
        return icontop + (dr != null ? dr.mDrawableHeightRight : 0) - this.getHeight() - 2;
    }

    public void hideError() {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        this.mShowErrorAfterAttach = false;
    }

    public void chooseSize(PopupWindow pop, CharSequence text, TextView tv) {
        int wid = tv.getPaddingLeft() + tv.getPaddingRight();
        int ht = tv.getPaddingTop() + tv.getPaddingBottom();
        int cap = this.getWidth() - wid;
        if (cap < 0) {
            cap = 200;
        }
        StaticLayout l = new StaticLayout(text, tv.getPaint(), cap, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
        float max = 0.0f;
        for (int i = 0; i < ((Layout)l).getLineCount(); ++i) {
            max = Math.max(max, l.getLineWidth(i));
        }
        pop.setWidth(wid + (int)Math.ceil(max));
        pop.setHeight(ht + l.getHeight());
    }

    public boolean setFrame(int l, int t, int r, int b) {
        boolean result = super.setFrame(l, t, r, b);
        if (this.mPopup != null) {
            TextView tv = (TextView)this.mPopup.getContentView();
            this.chooseSize(this.mPopup, this.mError, tv);
            this.mPopup.update(this, this.getErrorX(), this.getErrorY(), this.mPopup.getWidth(), this.mPopup.getHeight());
        }
        this.restartMarqueeIfNeeded();
        return result;
    }

    public void restartMarqueeIfNeeded() {
        if (this.mRestartMarquee && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            this.mRestartMarquee = false;
            this.startMarquee();
        }
    }

    public void setFilters(InputFilter[] filters) {
        if (filters == null) {
            throw new IllegalArgumentException();
        }
        this.mFilters = filters;
        if (this.mText instanceof Editable) {
            this.setFilters((Editable)this.mText, filters);
        }
    }

    public void setFilters(Editable e, InputFilter[] filters) {
        if (this.mInput instanceof InputFilter) {
            InputFilter[] nf = new InputFilter[filters.length + 1];
            System.arraycopy(filters, 0, nf, 0, filters.length);
            nf[filters.length] = (InputFilter)((Object)this.mInput);
            e.setFilters(nf);
        } else {
            e.setFilters(filters);
        }
    }

    public InputFilter[] getFilters() {
        return this.mFilters;
    }

    public int getVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 48) {
            int boxht = l == this.mHintLayout ? this.getMeasuredHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom() : this.getMeasuredHeight() - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 80 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    public int getBottomVerticalOffset(boolean forceNormal) {
        int voffset = 0;
        int gravity = this.mGravity & 0x70;
        Layout l = this.mLayout;
        if (!forceNormal && this.mText.length() == 0 && this.mHintLayout != null) {
            l = this.mHintLayout;
        }
        if (gravity != 80) {
            int boxht = l == this.mHintLayout ? this.getMeasuredHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom() : this.getMeasuredHeight() - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
            int textht = l.getHeight();
            if (textht < boxht) {
                voffset = gravity == 48 ? boxht - textht : boxht - textht >> 1;
            }
        }
        return voffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateCursorPath() {
        if (this.mHighlightPathBogus) {
            this.invalidateCursor();
        } else {
            RectF rectF = sTempRect;
            synchronized (rectF) {
                float thick = FloatMath.ceil(this.mTextPaint.getStrokeWidth());
                if (thick < 1.0f) {
                    thick = 1.0f;
                }
                this.mHighlightPath.computeBounds(sTempRect, false);
                int left = this.getCompoundPaddingLeft();
                int top = this.getExtendedPaddingTop() + this.getVerticalOffset(true);
                this.invalidate((int)FloatMath.floor((float)left + TextView.sTempRect.left - (thick /= 2.0f)), (int)FloatMath.floor((float)top + TextView.sTempRect.top - thick), (int)FloatMath.ceil((float)left + TextView.sTempRect.right + thick), (int)FloatMath.ceil((float)top + TextView.sTempRect.bottom + thick));
            }
        }
    }

    public void invalidateCursor() {
        int where = this.getSelectionEnd();
        this.invalidateCursor(where, where, where);
    }

    public void invalidateCursor(int a, int b, int c) {
        if (this.mLayout == null) {
            this.invalidate();
        } else if (a >= 0 || b >= 0 || c >= 0) {
            int first = Math.min(Math.min(a, b), c);
            int last = Math.max(Math.max(a, b), c);
            int line = this.mLayout.getLineForOffset(first);
            int top = this.mLayout.getLineTop(line);
            if (line > 0) {
                top -= this.mLayout.getLineDescent(line - 1);
            }
            int line2 = first == last ? line : this.mLayout.getLineForOffset(last);
            int bottom = this.mLayout.getLineTop(line2 + 1);
            int voffset = this.getVerticalOffset(true);
            int left = this.getCompoundPaddingLeft() + this.mScrollX;
            this.invalidate(left, top + voffset + this.getExtendedPaddingTop(), left + this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), bottom + voffset + this.getExtendedPaddingTop());
        }
    }

    public void registerForPreDraw() {
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer == null) {
            return;
        }
        if (this.mPreDrawState == 0) {
            observer.addOnPreDrawListener(this);
            this.mPreDrawState = 1;
        } else if (this.mPreDrawState == 2) {
            this.mPreDrawState = 1;
        }
    }

    public boolean onPreDraw() {
        if (this.mPreDrawState != 1) {
            return true;
        }
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        boolean changed = false;
        SelectionModifierCursorController selectionController = null;
        if (this.mSelectionModifierCursorController != null) {
            selectionController = (SelectionModifierCursorController)this.mSelectionModifierCursorController;
        }
        if (this.mMovement != null) {
            int curs = this.getSelectionEnd();
            if (selectionController != null && selectionController.isSelectionStartDragged()) {
                curs = this.getSelectionStart();
            }
            if (curs < 0 && (this.mGravity & 0x70) == 80) {
                curs = this.mText.length();
            }
            if (curs >= 0) {
                changed = this.bringPointIntoView(curs);
            }
        } else {
            changed = this.bringTextIntoView();
        }
        if (this.mCreatedWithASelection || this instanceof ExtractEditText && selectionController != null && this.hasSelection()) {
            this.startTextSelectionMode();
            this.mCreatedWithASelection = false;
        }
        this.mPreDrawState = 2;
        return !changed;
    }

    public void onAttachedToWindow() {
        ViewTreeObserver observer;
        super.onAttachedToWindow();
        this.mTemporaryDetach = false;
        if (this.mShowErrorAfterAttach) {
            this.showError();
            this.mShowErrorAfterAttach = false;
        }
        if ((observer = this.getViewTreeObserver()) != null) {
            if (this.mInsertionPointCursorController != null) {
                observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
            }
            if (this.mSelectionModifierCursorController != null) {
                observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
            }
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ViewTreeObserver observer = this.getViewTreeObserver();
        if (observer != null) {
            if (this.mPreDrawState != 0) {
                observer.removeOnPreDrawListener(this);
                this.mPreDrawState = 0;
            }
            if (this.mInsertionPointCursorController != null) {
                observer.removeOnTouchModeChangeListener(this.mInsertionPointCursorController);
            }
            if (this.mSelectionModifierCursorController != null) {
                observer.removeOnTouchModeChangeListener(this.mSelectionModifierCursorController);
            }
        }
        if (this.mError != null) {
            this.hideError();
        }
        if (this.mBlink != null) {
            this.mBlink.cancel();
        }
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.onDetached();
        }
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.onDetached();
        }
        this.hideControllers();
    }

    public boolean isPaddingOffsetRequired() {
        return this.mShadowRadius != 0.0f || this.mDrawables != null;
    }

    public int getLeftPaddingOffset() {
        return this.getCompoundPaddingLeft() - this.mPaddingLeft + (int)Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
    }

    public int getTopPaddingOffset() {
        return (int)Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
    }

    public int getBottomPaddingOffset() {
        return (int)Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
    }

    public int getRightPaddingOffset() {
        return -(this.getCompoundPaddingRight() - this.mPaddingRight) + (int)Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
    }

    public boolean verifyDrawable(Drawable who) {
        boolean verified = super.verifyDrawable(who);
        if (!verified && this.mDrawables != null) {
            return who == this.mDrawables.mDrawableLeft || who == this.mDrawables.mDrawableTop || who == this.mDrawables.mDrawableRight || who == this.mDrawables.mDrawableBottom;
        }
        return verified;
    }

    public void invalidateDrawable(Drawable drawable2) {
        if (this.verifyDrawable(drawable2)) {
            Rect dirty = drawable2.getBounds();
            int scrollX = this.mScrollX;
            int scrollY = this.mScrollY;
            Drawables drawables = this.mDrawables;
            if (drawables != null) {
                if (drawable2 == drawables.mDrawableLeft) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mPaddingLeft;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightLeft) / 2;
                } else if (drawable2 == drawables.mDrawableRight) {
                    int compoundPaddingTop = this.getCompoundPaddingTop();
                    int compoundPaddingBottom = this.getCompoundPaddingBottom();
                    int vspace = this.mBottom - this.mTop - compoundPaddingBottom - compoundPaddingTop;
                    scrollX += this.mRight - this.mLeft - this.mPaddingRight - drawables.mDrawableSizeRight;
                    scrollY += compoundPaddingTop + (vspace - drawables.mDrawableHeightRight) / 2;
                } else if (drawable2 == drawables.mDrawableTop) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthTop) / 2;
                    scrollY += this.mPaddingTop;
                } else if (drawable2 == drawables.mDrawableBottom) {
                    int compoundPaddingLeft = this.getCompoundPaddingLeft();
                    int compoundPaddingRight = this.getCompoundPaddingRight();
                    int hspace = this.mRight - this.mLeft - compoundPaddingRight - compoundPaddingLeft;
                    scrollX += compoundPaddingLeft + (hspace - drawables.mDrawableWidthBottom) / 2;
                    scrollY += this.mBottom - this.mTop - this.mPaddingBottom - drawables.mDrawableSizeBottom;
                }
            }
            this.invalidate(dirty.left + scrollX, dirty.top + scrollY, dirty.right + scrollX, dirty.bottom + scrollY);
        }
    }

    public void onDraw(Canvas canvas) {
        InputMethodManager imm;
        InputMethodState ims;
        ViewTreeObserver observer;
        this.restartMarqueeIfNeeded();
        super.onDraw(canvas);
        int compoundPaddingLeft = this.getCompoundPaddingLeft();
        int compoundPaddingTop = this.getCompoundPaddingTop();
        int compoundPaddingRight = this.getCompoundPaddingRight();
        int compoundPaddingBottom = this.getCompoundPaddingBottom();
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int right = this.mRight;
        int left = this.mLeft;
        int bottom = this.mBottom;
        int top = this.mTop;
        Drawables dr = this.mDrawables;
        if (dr != null) {
            int vspace = bottom - top - compoundPaddingBottom - compoundPaddingTop;
            int hspace = right - left - compoundPaddingRight - compoundPaddingLeft;
            if (dr.mDrawableLeft != null) {
                canvas.save();
                canvas.translate(scrollX + this.mPaddingLeft, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightLeft) / 2);
                dr.mDrawableLeft.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableRight != null) {
                canvas.save();
                canvas.translate(scrollX + right - left - this.mPaddingRight - dr.mDrawableSizeRight, scrollY + compoundPaddingTop + (vspace - dr.mDrawableHeightRight) / 2);
                dr.mDrawableRight.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableTop != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthTop) / 2, scrollY + this.mPaddingTop);
                dr.mDrawableTop.draw(canvas);
                canvas.restore();
            }
            if (dr.mDrawableBottom != null) {
                canvas.save();
                canvas.translate(scrollX + compoundPaddingLeft + (hspace - dr.mDrawableWidthBottom) / 2, scrollY + bottom - top - this.mPaddingBottom - dr.mDrawableSizeBottom);
                dr.mDrawableBottom.draw(canvas);
                canvas.restore();
            }
        }
        if (this.mPreDrawState == 2 && (observer = this.getViewTreeObserver()) != null) {
            observer.removeOnPreDrawListener(this);
            this.mPreDrawState = 0;
        }
        int color2 = this.mCurTextColor;
        if (this.mLayout == null) {
            this.assumeLayout();
        }
        Layout layout2 = this.mLayout;
        int cursorcolor = color2;
        if (this.mHint != null && this.mText.length() == 0) {
            if (this.mHintTextColor != null) {
                color2 = this.mCurHintTextColor;
            }
            layout2 = this.mHintLayout;
        }
        this.mTextPaint.setColor(color2);
        this.mTextPaint.drawableState = this.getDrawableState();
        canvas.save();
        int extendedPaddingTop = this.getExtendedPaddingTop();
        int extendedPaddingBottom = this.getExtendedPaddingBottom();
        float clipLeft = compoundPaddingLeft + scrollX;
        float clipTop = extendedPaddingTop + scrollY;
        float clipRight = right - left - compoundPaddingRight + scrollX;
        float clipBottom = bottom - top - extendedPaddingBottom + scrollY;
        if (this.mShadowRadius != 0.0f) {
            clipLeft += Math.min(0.0f, this.mShadowDx - this.mShadowRadius);
            clipRight += Math.max(0.0f, this.mShadowDx + this.mShadowRadius);
            clipTop += Math.min(0.0f, this.mShadowDy - this.mShadowRadius);
            clipBottom += Math.max(0.0f, this.mShadowDy + this.mShadowRadius);
        }
        canvas.clipRect(clipLeft, clipTop, clipRight, clipBottom);
        int voffsetText = 0;
        int voffsetCursor = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffsetText = this.getVerticalOffset(false);
            voffsetCursor = this.getVerticalOffset(true);
        }
        canvas.translate(compoundPaddingLeft, extendedPaddingTop + voffsetText);
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (!this.mSingleLine && this.getLineCount() == 1 && this.canMarquee() && (this.mGravity & 7) != 3) {
                canvas.translate(this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight()), 0.0f);
            }
            if (this.mMarquee != null && this.mMarquee.isRunning()) {
                canvas.translate(-this.mMarquee.mScroll, 0.0f);
            }
        }
        Path highlight = null;
        int selStart = -1;
        int selEnd = -1;
        if (this.mMovement != null && (this.isFocused() || this.isPressed())) {
            selStart = this.getSelectionStart();
            selEnd = this.getSelectionEnd();
            if (this.mCursorVisible && selStart >= 0 && this.isEnabled()) {
                if (this.mHighlightPath == null) {
                    this.mHighlightPath = new Path();
                }
                if (selStart == selEnd) {
                    if ((SystemClock.uptimeMillis() - this.mShowCursor) % 1000L < 500L) {
                        if (this.mHighlightPathBogus) {
                            this.mHighlightPath.reset();
                            this.mLayout.getCursorPath(selStart, this.mHighlightPath, this.mText);
                            this.mHighlightPathBogus = false;
                        }
                        this.mHighlightPaint.setColor(cursorcolor);
                        this.mHighlightPaint.setStyle(Paint.Style.STROKE);
                        highlight = this.mHighlightPath;
                    }
                } else {
                    if (this.mHighlightPathBogus) {
                        this.mHighlightPath.reset();
                        this.mLayout.getSelectionPath(selStart, selEnd, this.mHighlightPath);
                        this.mHighlightPathBogus = false;
                    }
                    this.mHighlightPaint.setColor(this.mHighlightColor);
                    this.mHighlightPaint.setStyle(Paint.Style.FILL);
                    highlight = this.mHighlightPath;
                }
            }
        }
        if ((ims = this.mInputMethodState) != null && ims.mBatchEditNesting == 0 && (imm = InputMethodManager.peekInstance()) != null) {
            if (imm.isActive(this)) {
                boolean reported = false;
                if (ims.mContentChanged || ims.mSelectionModeChanged) {
                    reported = this.reportExtractedText();
                }
                if (!reported && highlight != null) {
                    int candStart = -1;
                    int candEnd = -1;
                    if (this.mText instanceof Spannable) {
                        Spannable sp = (Spannable)this.mText;
                        candStart = EditableInputConnection.getComposingSpanStart(sp);
                        candEnd = EditableInputConnection.getComposingSpanEnd(sp);
                    }
                    imm.updateSelection(this, selStart, selEnd, candStart, candEnd);
                }
            }
            if (imm.isWatchingCursor(this) && highlight != null) {
                highlight.computeBounds(ims.mTmpRectF, true);
                ims.mTmpOffset[1] = 0.0f;
                ims.mTmpOffset[0] = 0.0f;
                canvas.getMatrix().mapPoints(ims.mTmpOffset);
                ims.mTmpRectF.offset(ims.mTmpOffset[0], ims.mTmpOffset[1]);
                ims.mTmpRectF.offset(0.0f, voffsetCursor - voffsetText);
                ims.mCursorRectInWindow.set((int)((double)ims.mTmpRectF.left + 0.5), (int)((double)ims.mTmpRectF.top + 0.5), (int)((double)ims.mTmpRectF.right + 0.5), (int)((double)ims.mTmpRectF.bottom + 0.5));
                imm.updateCursor(this, ims.mCursorRectInWindow.left, ims.mCursorRectInWindow.top, ims.mCursorRectInWindow.right, ims.mCursorRectInWindow.bottom);
            }
        }
        layout2.draw(canvas, highlight, this.mHighlightPaint, voffsetCursor - voffsetText);
        if (this.mMarquee != null && this.mMarquee.shouldDrawGhost()) {
            canvas.translate((int)this.mMarquee.getGhostOffset(), 0.0f);
            layout2.draw(canvas, highlight, this.mHighlightPaint, voffsetCursor - voffsetText);
        }
        canvas.restore();
        this.updateCursorControllerPositions();
    }

    public void updateCursorControllerPositions() {
        if (this.mInsertionPointCursorController != null && this.mInsertionPointCursorController.isShowing()) {
            this.mInsertionPointCursorController.updatePosition();
        }
        if (this.mSelectionModifierCursorController != null && this.mSelectionModifierCursorController.isShowing()) {
            this.mSelectionModifierCursorController.updatePosition();
        }
    }

    public void getFocusedRect(Rect r) {
        if (this.mLayout == null) {
            super.getFocusedRect(r);
            return;
        }
        int sel = this.getSelectionEnd();
        if (sel < 0) {
            super.getFocusedRect(r);
            return;
        }
        int line = this.mLayout.getLineForOffset(sel);
        r.top = this.mLayout.getLineTop(line);
        r.bottom = this.mLayout.getLineBottom(line);
        r.left = (int)this.mLayout.getPrimaryHorizontal(sel);
        r.right = r.left + 1;
        int paddingLeft = this.getCompoundPaddingLeft();
        int paddingTop = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            paddingTop += this.getVerticalOffset(false);
        }
        r.offset(paddingLeft, paddingTop);
    }

    public int getLineCount() {
        return this.mLayout != null ? this.mLayout.getLineCount() : 0;
    }

    public int getLineBounds(int line, Rect bounds) {
        if (this.mLayout == null) {
            if (bounds != null) {
                bounds.set(0, 0, 0, 0);
            }
            return 0;
        }
        int baseline = this.mLayout.getLineBounds(line, bounds);
        int voffset = this.getExtendedPaddingTop();
        if ((this.mGravity & 0x70) != 48) {
            voffset += this.getVerticalOffset(true);
        }
        if (bounds != null) {
            bounds.offset(this.getCompoundPaddingLeft(), voffset);
        }
        return baseline + voffset;
    }

    public int getBaseline() {
        if (this.mLayout == null) {
            return super.getBaseline();
        }
        int voffset = 0;
        if ((this.mGravity & 0x70) != 48) {
            voffset = this.getVerticalOffset(true);
        }
        return this.getExtendedPaddingTop() + voffset + this.mLayout.getLineBaseline(0);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        int which = this.doKeyDown(keyCode, event, null);
        if (which == 0) {
            return super.onKeyDown(keyCode, event);
        }
        return true;
    }

    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        KeyEvent down = KeyEvent.changeAction(event, 0);
        int which = this.doKeyDown(keyCode, down, event);
        if (which == 0) {
            return super.onKeyMultiple(keyCode, repeatCount, event);
        }
        if (which == -1) {
            return true;
        }
        --repeatCount;
        KeyEvent up = KeyEvent.changeAction(event, 1);
        if (which == 1) {
            this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mInput.onKeyDown(this, (Editable)this.mText, keyCode, down);
                this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, up);
            }
            if (this.mError != null && !this.mErrorWasChanged) {
                this.setError(null, null);
            }
        } else if (which == 2) {
            this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            while (--repeatCount > 0) {
                this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, down);
                this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, up);
            }
        }
        return true;
    }

    public boolean shouldAdvanceFocusOnEnter() {
        int variation;
        if (this.mInput == null) {
            return false;
        }
        if (this.mSingleLine) {
            return true;
        }
        return (this.mInputType & 0xF) == 1 && ((variation = this.mInputType & 0xFF0) == 32 || variation == 48);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int doKeyDown(int keyCode, KeyEvent event, KeyEvent otherEvent) {
        boolean handled;
        boolean doDown;
        if (!this.isEnabled()) {
            return 0;
        }
        switch (keyCode) {
            case 66: {
                this.mEnterKeyIsDown = true;
                if ((event.getMetaState() & 2) != 0) break;
                if (this.mInputContentType != null && this.mInputContentType.onEditorActionListener != null && this.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                    this.mInputContentType.enterDown = true;
                    return -1;
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                return -1;
            }
            case 23: {
                this.mDPadCenterIsDown = true;
                if (!this.shouldAdvanceFocusOnEnter()) break;
                return 0;
            }
            case 4: {
                if (!this.mIsInTextSelectionMode) break;
                this.stopTextSelectionMode();
                return -1;
            }
        }
        if (this.mInput != null) {
            this.mErrorWasChanged = false;
            doDown = true;
            if (otherEvent != null) {
                try {
                    try {
                        this.beginBatchEdit();
                        handled = this.mInput.onKeyOther(this, (Editable)this.mText, otherEvent);
                        if (this.mError != null && !this.mErrorWasChanged) {
                            this.setError(null, null);
                        }
                        doDown = false;
                        if (handled) {
                            int n = -1;
                            Object var8_9 = null;
                            this.endBatchEdit();
                            return n;
                        }
                        Object var8_10 = null;
                        this.endBatchEdit();
                    }
                    catch (AbstractMethodError e) {
                        Object var8_11 = null;
                        this.endBatchEdit();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.endBatchEdit();
                    throw throwable;
                }
            }
            if (doDown) {
                this.beginBatchEdit();
                if (this.mInput.onKeyDown(this, (Editable)this.mText, keyCode, event)) {
                    this.endBatchEdit();
                    if (this.mError != null && !this.mErrorWasChanged) {
                        this.setError(null, null);
                    }
                    return 1;
                }
                this.endBatchEdit();
            }
        }
        if (this.mMovement != null && this.mLayout != null) {
            doDown = true;
            if (otherEvent != null) {
                try {
                    handled = this.mMovement.onKeyOther(this, (Spannable)this.mText, otherEvent);
                    doDown = false;
                    if (handled) {
                        return -1;
                    }
                }
                catch (AbstractMethodError e) {
                    // empty catch block
                }
            }
            if (doDown && this.mMovement.onKeyDown(this, (Spannable)this.mText, keyCode, event)) {
                return 2;
            }
        }
        return 0;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (!this.isEnabled()) {
            return super.onKeyUp(keyCode, event);
        }
        this.hideControllers();
        this.stopTextSelectionMode();
        switch (keyCode) {
            case 23: {
                this.mDPadCenterIsDown = false;
                if (this.mOnClickListener == null && this.mMovement != null && this.mText instanceof Editable && this.mLayout != null && this.onCheckIsTextEditor()) {
                    InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
                    imm.showSoftInput(this, 0);
                }
                return super.onKeyUp(keyCode, event);
            }
            case 66: {
                this.mEnterKeyIsDown = false;
                if (this.mInputContentType != null && this.mInputContentType.onEditorActionListener != null && this.mInputContentType.enterDown) {
                    this.mInputContentType.enterDown = false;
                    if (this.mInputContentType.onEditorActionListener.onEditorAction(this, 0, event)) {
                        return true;
                    }
                }
                if ((event.getFlags() & 0x10) == 0 && !this.shouldAdvanceFocusOnEnter()) break;
                if (this.mOnClickListener == null) {
                    InputMethodManager imm;
                    View v = this.focusSearch(130);
                    if (v != null) {
                        if (!v.requestFocus(130)) {
                            throw new IllegalStateException("focus search returned a view that wasn't able to take focus!");
                        }
                        super.onKeyUp(keyCode, event);
                        return true;
                    }
                    if ((event.getFlags() & 0x10) != 0 && (imm = InputMethodManager.peekInstance()) != null) {
                        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
                    }
                }
                return super.onKeyUp(keyCode, event);
            }
        }
        if (this.mInput != null && this.mInput.onKeyUp(this, (Editable)this.mText, keyCode, event)) {
            return true;
        }
        if (this.mMovement != null && this.mLayout != null && this.mMovement.onKeyUp(this, (Spannable)this.mText, keyCode, event)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public boolean onCheckIsTextEditor() {
        return this.mInputType != 0;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (this.onCheckIsTextEditor()) {
            if (this.mInputMethodState == null) {
                this.mInputMethodState = new InputMethodState();
            }
            outAttrs.inputType = this.mInputType;
            if (this.mInputContentType != null) {
                outAttrs.imeOptions = this.mInputContentType.imeOptions;
                outAttrs.privateImeOptions = this.mInputContentType.privateImeOptions;
                outAttrs.actionLabel = this.mInputContentType.imeActionLabel;
                outAttrs.actionId = this.mInputContentType.imeActionId;
                outAttrs.extras = this.mInputContentType.extras;
            } else {
                outAttrs.imeOptions = 0;
            }
            if ((outAttrs.imeOptions & 0xFF) == 0) {
                outAttrs.imeOptions = this.focusSearch(130) != null ? (outAttrs.imeOptions |= 5) : (outAttrs.imeOptions |= 6);
                if (!this.shouldAdvanceFocusOnEnter()) {
                    outAttrs.imeOptions |= 0x40000000;
                }
            }
            if ((outAttrs.inputType & 0x2000F) == 131073) {
                outAttrs.imeOptions |= 0x40000000;
            }
            outAttrs.hintText = this.mHint;
            if (this.mText instanceof Editable) {
                EditableInputConnection ic = new EditableInputConnection(this);
                outAttrs.initialSelStart = this.getSelectionStart();
                outAttrs.initialSelEnd = this.getSelectionEnd();
                outAttrs.initialCapsMode = ic.getCursorCapsMode(this.mInputType);
                return ic;
            }
        }
        return null;
    }

    public boolean extractText(ExtractedTextRequest request, ExtractedText outText) {
        return this.extractTextInternal(request, -1, -1, -1, outText);
    }

    public boolean extractTextInternal(ExtractedTextRequest request, int partialStartOffset, int partialEndOffset, int delta, ExtractedText outText) {
        CharSequence content = this.mText;
        if (content != null) {
            if (partialStartOffset != -2) {
                int N = content.length();
                if (partialStartOffset < 0) {
                    outText.partialEndOffset = -1;
                    outText.partialStartOffset = -1;
                    partialStartOffset = 0;
                    partialEndOffset = N;
                } else {
                    if (content instanceof Spanned) {
                        Spanned spanned = (Spanned)content;
                        ParcelableSpan[] spans = spanned.getSpans(partialStartOffset, partialEndOffset, ParcelableSpan.class);
                        int i = spans.length;
                        while (i > 0) {
                            int j;
                            if ((j = spanned.getSpanStart(spans[--i])) < partialStartOffset) {
                                partialStartOffset = j;
                            }
                            if ((j = spanned.getSpanEnd(spans[i])) <= partialEndOffset) continue;
                            partialEndOffset = j;
                        }
                    }
                    outText.partialStartOffset = partialStartOffset;
                    outText.partialEndOffset = partialEndOffset;
                    partialEndOffset += delta;
                    if (partialStartOffset > N) {
                        partialStartOffset = N;
                    } else if (partialStartOffset < 0) {
                        partialStartOffset = 0;
                    }
                    if (partialEndOffset > N) {
                        partialEndOffset = N;
                    } else if (partialEndOffset < 0) {
                        partialEndOffset = 0;
                    }
                }
                outText.text = (request.flags & 1) != 0 ? content.subSequence(partialStartOffset, partialEndOffset) : TextUtils.substring(content, partialStartOffset, partialEndOffset);
            } else {
                outText.partialStartOffset = 0;
                outText.partialEndOffset = 0;
                outText.text = "";
            }
            outText.flags = 0;
            if (MetaKeyKeyListener.getMetaState(this.mText, 65536) != 0) {
                outText.flags |= 2;
            }
            if (this.mSingleLine) {
                outText.flags |= 1;
            }
            outText.startOffset = 0;
            outText.selectionStart = this.getSelectionStart();
            outText.selectionEnd = this.getSelectionEnd();
            return true;
        }
        return false;
    }

    public boolean reportExtractedText() {
        boolean contentChanged;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ((contentChanged = ims.mContentChanged) || ims.mSelectionModeChanged)) {
            InputMethodManager imm;
            ims.mContentChanged = false;
            ims.mSelectionModeChanged = false;
            ExtractedTextRequest req = this.mInputMethodState.mExtracting;
            if (req != null && (imm = InputMethodManager.peekInstance()) != null) {
                if (ims.mChangedStart < 0 && !contentChanged) {
                    ims.mChangedStart = -2;
                }
                if (this.extractTextInternal(req, ims.mChangedStart, ims.mChangedEnd, ims.mChangedDelta, ims.mTmpExtracted)) {
                    imm.updateExtractedText(this, req.token, this.mInputMethodState.mTmpExtracted);
                    return true;
                }
            }
        }
        return false;
    }

    public static void removeParcelableSpans(Spannable spannable, int start, int end) {
        ParcelableSpan[] spans = spannable.getSpans(start, end, ParcelableSpan.class);
        int i = spans.length;
        while (i > 0) {
            spannable.removeSpan(spans[--i]);
        }
    }

    public void setExtractedText(ExtractedText text) {
        Editable content = this.getEditableText();
        if (text.text != null) {
            if (content == null) {
                this.setText(text.text, BufferType.EDITABLE);
            } else if (text.partialStartOffset < 0) {
                TextView.removeParcelableSpans(content, 0, content.length());
                content.replace(0, content.length(), text.text);
            } else {
                int end;
                int start = text.partialStartOffset;
                int N = content.length();
                if (start > N) {
                    start = N;
                }
                if ((end = text.partialEndOffset) > N) {
                    end = N;
                }
                TextView.removeParcelableSpans(content, start, end);
                content.replace(start, end, text.text);
            }
        }
        Spannable sp = (Spannable)this.getText();
        int N = sp.length();
        int start = text.selectionStart;
        if (start < 0) {
            start = 0;
        } else if (start > N) {
            start = N;
        }
        int end = text.selectionEnd;
        if (end < 0) {
            end = 0;
        } else if (end > N) {
            end = N;
        }
        Selection.setSelection(sp, start, end);
        if ((text.flags & 2) != 0) {
            MetaKeyKeyListener.startSelecting(this, sp);
        } else {
            MetaKeyKeyListener.stopSelecting(this, sp);
        }
    }

    public void setExtracting(ExtractedTextRequest req) {
        if (this.mInputMethodState != null) {
            this.mInputMethodState.mExtracting = req;
        }
        this.hideControllers();
    }

    public void onCommitCompletion(CompletionInfo text) {
    }

    public void beginBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = true;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = ++ims.mBatchEditNesting) == 1) {
            ims.mCursorChanged = false;
            ims.mChangedDelta = 0;
            if (ims.mContentChanged) {
                ims.mChangedStart = 0;
                ims.mChangedEnd = this.mText.length();
            } else {
                ims.mChangedStart = -1;
                ims.mChangedEnd = -1;
                ims.mContentChanged = false;
            }
            this.onBeginBatchEdit();
        }
    }

    public void endBatchEdit() {
        int nesting;
        this.mInBatchEditControllers = false;
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && (nesting = --ims.mBatchEditNesting) == 0) {
            this.finishBatchEdit(ims);
        }
    }

    public void ensureEndedBatchEdit() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null && ims.mBatchEditNesting != 0) {
            ims.mBatchEditNesting = 0;
            this.finishBatchEdit(ims);
        }
    }

    public void finishBatchEdit(InputMethodState ims) {
        this.onEndBatchEdit();
        if (ims.mContentChanged || ims.mSelectionModeChanged) {
            this.updateAfterEdit();
            this.reportExtractedText();
        } else if (ims.mCursorChanged) {
            this.invalidateCursor();
        }
    }

    public void updateAfterEdit() {
        this.invalidate();
        int curs = this.getSelectionStart();
        if (curs >= 0 || (this.mGravity & 0x70) == 80) {
            this.registerForPreDraw();
        }
        if (curs >= 0) {
            this.mHighlightPathBogus = true;
            if (this.isFocused()) {
                this.mShowCursor = SystemClock.uptimeMillis();
                this.makeBlink();
            }
        }
        this.checkForResize();
    }

    public void onBeginBatchEdit() {
    }

    public void onEndBatchEdit() {
    }

    public boolean onPrivateIMECommand(String action, Bundle data) {
        return false;
    }

    public void nullLayouts() {
        if (this.mLayout instanceof BoringLayout && this.mSavedLayout == null) {
            this.mSavedLayout = (BoringLayout)this.mLayout;
        }
        if (this.mHintLayout instanceof BoringLayout && this.mSavedHintLayout == null) {
            this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
        }
        this.mHintLayout = null;
        this.mLayout = null;
    }

    public void assumeLayout() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (width < 1) {
            width = 0;
        }
        int physicalWidth = width;
        if (this.mHorizontallyScrolling) {
            width = 16384;
        }
        this.makeNewLayout(width, physicalWidth, UNKNOWN_BORING, UNKNOWN_BORING, physicalWidth, false);
    }

    public void makeNewLayout(int w, int hintWidth, BoringLayout.Metrics boring, BoringLayout.Metrics hintBoring, int ellipsisWidth, boolean bringIntoView) {
        boolean shouldEllipsize;
        Layout.Alignment alignment;
        this.stopMarquee();
        this.mHighlightPathBogus = true;
        if (w < 0) {
            w = 0;
        }
        if (hintWidth < 0) {
            hintWidth = 0;
        }
        switch (this.mGravity & 7) {
            case 1: {
                alignment = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 5: {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
                break;
            }
            default: {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
        }
        boolean bl = shouldEllipsize = this.mEllipsize != null && this.mInput == null;
        if (this.mText instanceof Spannable) {
            this.mLayout = new DynamicLayout(this.mText, this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mInput == null ? this.mEllipsize : null, ellipsisWidth);
        } else {
            if (boring == UNKNOWN_BORING && (boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mBoring)) != null) {
                this.mBoring = boring;
            }
            if (boring != null) {
                if (boring.width <= w && (this.mEllipsize == null || boring.width <= ellipsisWidth)) {
                    this.mLayout = this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad) : BoringLayout.make(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad);
                    this.mSavedLayout = (BoringLayout)this.mLayout;
                } else {
                    this.mLayout = shouldEllipsize && boring.width <= w ? (this.mSavedLayout != null ? this.mSavedLayout.replaceOrMake(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, boring, this.mIncludePad, this.mEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth) : new StaticLayout(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                this.mLayout = shouldEllipsize ? new StaticLayout(this.mTransformed, 0, this.mTransformed.length(), this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth) : new StaticLayout(this.mTransformed, this.mTextPaint, w, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        shouldEllipsize = this.mEllipsize != null;
        this.mHintLayout = null;
        if (this.mHint != null) {
            if (shouldEllipsize) {
                hintWidth = w;
            }
            if (hintBoring == UNKNOWN_BORING && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mHintBoring)) != null) {
                this.mHintBoring = hintBoring;
            }
            if (hintBoring != null) {
                if (!(hintBoring.width > hintWidth || shouldEllipsize && hintBoring.width > ellipsisWidth)) {
                    this.mHintLayout = this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad);
                    this.mSavedHintLayout = (BoringLayout)this.mHintLayout;
                } else {
                    this.mHintLayout = shouldEllipsize && hintBoring.width <= hintWidth ? (this.mSavedHintLayout != null ? this.mSavedHintLayout.replaceOrMake(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth) : BoringLayout.make(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, hintBoring, this.mIncludePad, this.mEllipsize, ellipsisWidth)) : (shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad));
                }
            } else {
                this.mHintLayout = shouldEllipsize ? new StaticLayout(this.mHint, 0, this.mHint.length(), this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad, this.mEllipsize, ellipsisWidth) : new StaticLayout(this.mHint, this.mTextPaint, hintWidth, alignment, this.mSpacingMult, this.mSpacingAdd, this.mIncludePad);
            }
        }
        if (bringIntoView) {
            this.registerForPreDraw();
        }
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE && !this.compressText(ellipsisWidth)) {
            int height = this.mLayoutParams.height;
            if (height != -2 && height != -1) {
                this.startMarquee();
            } else {
                this.mRestartMarquee = true;
            }
        }
        this.prepareCursorControllers();
    }

    public boolean compressText(float width) {
        float textWidth;
        float overflow;
        if (width > 0.0f && this.mLayout != null && this.getLineCount() == 1 && !this.mUserSetTextScaleX && this.mTextPaint.getTextScaleX() == 1.0f && (overflow = ((textWidth = this.mLayout.getLineWidth(0)) + 1.0f - width) / width) > 0.0f && overflow <= 0.07f) {
            this.mTextPaint.setTextScaleX(1.0f - overflow - 0.005f);
            this.post(new Runnable(){

                public void run() {
                    TextView.this.requestLayout();
                }
            });
            return true;
        }
        return false;
    }

    public static int desired(Layout layout2) {
        int i;
        int n = layout2.getLineCount();
        CharSequence text = layout2.getText();
        float max = 0.0f;
        for (i = 0; i < n - 1; ++i) {
            if (text.charAt(layout2.getLineEnd(i) - 1) == '\n') continue;
            return -1;
        }
        for (i = 0; i < n; ++i) {
            max = Math.max(max, layout2.getLineWidth(i));
        }
        return (int)FloatMath.ceil(max);
    }

    public void setIncludeFontPadding(boolean includepad) {
        this.mIncludePad = includepad;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int hintWidth;
        int want;
        int width;
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        BoringLayout.Metrics boring = UNKNOWN_BORING;
        BoringLayout.Metrics hintBoring = UNKNOWN_BORING;
        int des = -1;
        boolean fromexisting = false;
        if (widthMode == 0x40000000) {
            width = widthSize;
        } else {
            if (this.mLayout != null && this.mEllipsize == null) {
                des = TextView.desired(this.mLayout);
            }
            if (des < 0) {
                boring = BoringLayout.isBoring(this.mTransformed, this.mTextPaint, this.mBoring);
                if (boring != null) {
                    this.mBoring = boring;
                }
            } else {
                fromexisting = true;
            }
            if (boring == null || boring == UNKNOWN_BORING) {
                if (des < 0) {
                    des = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mTransformed, this.mTextPaint));
                }
                width = des;
            } else {
                width = boring.width;
            }
            Drawables dr = this.mDrawables;
            if (dr != null) {
                width = Math.max(width, dr.mDrawableWidthTop);
                width = Math.max(width, dr.mDrawableWidthBottom);
            }
            if (this.mHint != null) {
                int hintWidth2;
                int hintDes = -1;
                if (this.mHintLayout != null && this.mEllipsize == null) {
                    hintDes = TextView.desired(this.mHintLayout);
                }
                if (hintDes < 0 && (hintBoring = BoringLayout.isBoring(this.mHint, this.mTextPaint, this.mHintBoring)) != null) {
                    this.mHintBoring = hintBoring;
                }
                if (hintBoring == null || hintBoring == UNKNOWN_BORING) {
                    if (hintDes < 0) {
                        hintDes = (int)FloatMath.ceil(Layout.getDesiredWidth(this.mHint, this.mTextPaint));
                    }
                    hintWidth2 = hintDes;
                } else {
                    hintWidth2 = hintBoring.width;
                }
                if (hintWidth2 > width) {
                    width = hintWidth2;
                }
            }
            width += this.getCompoundPaddingLeft() + this.getCompoundPaddingRight();
            width = this.mMaxWidthMode == 1 ? Math.min(width, this.mMaxWidth * this.getLineHeight()) : Math.min(width, this.mMaxWidth);
            width = this.mMinWidthMode == 1 ? Math.max(width, this.mMinWidth * this.getLineHeight()) : Math.max(width, this.mMinWidth);
            width = Math.max(width, this.getSuggestedMinimumWidth());
            if (widthMode == Integer.MIN_VALUE) {
                width = Math.min(widthSize, width);
            }
        }
        int unpaddedWidth = want = width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hintWant = want;
        if (this.mHorizontallyScrolling) {
            want = 16384;
        }
        int n = hintWidth = this.mHintLayout == null ? hintWant : this.mHintLayout.getWidth();
        if (this.mLayout == null) {
            this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
        } else if (this.mLayout.getWidth() != want || hintWidth != hintWant || this.mLayout.getEllipsizedWidth() != width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight()) {
            if (this.mHint == null && this.mEllipsize == null && want > this.mLayout.getWidth() && (this.mLayout instanceof BoringLayout || fromexisting && des >= 0 && des <= want)) {
                this.mLayout.increaseWidthTo(want);
            } else {
                this.makeNewLayout(want, hintWant, boring, hintBoring, width - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            }
        }
        if (heightMode == 0x40000000) {
            height = heightSize;
            this.mDesiredHeightAtMeasure = -1;
        } else {
            int desired;
            height = desired = this.getDesiredHeight();
            this.mDesiredHeightAtMeasure = desired;
            if (heightMode == Integer.MIN_VALUE) {
                height = Math.min(desired, heightSize);
            }
        }
        int unpaddedHeight = height - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
        if (this.mMaxMode == 1 && this.mLayout.getLineCount() > this.mMaximum) {
            unpaddedHeight = Math.min(unpaddedHeight, this.mLayout.getLineTop(this.mMaximum));
        }
        if (this.mMovement != null || this.mLayout.getWidth() > unpaddedWidth || this.mLayout.getHeight() > unpaddedHeight) {
            this.registerForPreDraw();
        } else {
            this.scrollTo(0, 0);
        }
        this.setMeasuredDimension(width, height);
    }

    public int getDesiredHeight() {
        return Math.max(this.getDesiredHeight(this.mLayout, true), this.getDesiredHeight(this.mHintLayout, this.mEllipsize != null));
    }

    public int getDesiredHeight(Layout layout2, boolean cap) {
        if (layout2 == null) {
            return 0;
        }
        int linecount = layout2.getLineCount();
        int pad = this.getCompoundPaddingTop() + this.getCompoundPaddingBottom();
        int desired = layout2.getLineTop(linecount);
        Drawables dr = this.mDrawables;
        if (dr != null) {
            desired = Math.max(desired, dr.mDrawableHeightLeft);
            desired = Math.max(desired, dr.mDrawableHeightRight);
        }
        desired += pad;
        if (this.mMaxMode == 1) {
            if (cap && linecount > this.mMaximum) {
                desired = layout2.getLineTop(this.mMaximum) + layout2.getBottomPadding();
                if (dr != null) {
                    desired = Math.max(desired, dr.mDrawableHeightLeft);
                    desired = Math.max(desired, dr.mDrawableHeightRight);
                }
                desired += pad;
                linecount = this.mMaximum;
            }
        } else {
            desired = Math.min(desired, this.mMaximum);
        }
        if (this.mMinMode == 1) {
            if (linecount < this.mMinimum) {
                desired += this.getLineHeight() * (this.mMinimum - linecount);
            }
        } else {
            desired = Math.max(desired, this.mMinimum);
        }
        desired = Math.max(desired, this.getSuggestedMinimumHeight());
        return desired;
    }

    public void checkForResize() {
        boolean sizeChanged = false;
        if (this.mLayout != null) {
            int desiredHeight;
            if (this.mLayoutParams.width == -2) {
                sizeChanged = true;
                this.invalidate();
            }
            if (this.mLayoutParams.height == -2) {
                int desiredHeight2 = this.getDesiredHeight();
                if (desiredHeight2 != this.getHeight()) {
                    sizeChanged = true;
                }
            } else if (this.mLayoutParams.height == -1 && this.mDesiredHeightAtMeasure >= 0 && (desiredHeight = this.getDesiredHeight()) != this.mDesiredHeightAtMeasure) {
                sizeChanged = true;
            }
        }
        if (sizeChanged) {
            this.requestLayout();
        }
    }

    public void checkForRelayout() {
        if ((this.mLayoutParams.width != -2 || this.mMaxWidthMode == this.mMinWidthMode && this.mMaxWidth == this.mMinWidth) && (this.mHint == null || this.mHintLayout != null) && this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight() > 0) {
            int oldht = this.mLayout.getHeight();
            int want = this.mLayout.getWidth();
            int hintWant = this.mHintLayout == null ? 0 : this.mHintLayout.getWidth();
            this.makeNewLayout(want, hintWant, UNKNOWN_BORING, UNKNOWN_BORING, this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight(), false);
            if (this.mEllipsize != TextUtils.TruncateAt.MARQUEE) {
                if (this.mLayoutParams.height != -2 && this.mLayoutParams.height != -1) {
                    this.invalidate();
                    return;
                }
                if (this.mLayout.getHeight() == oldht && (this.mHintLayout == null || this.mHintLayout.getHeight() == oldht)) {
                    this.invalidate();
                    return;
                }
            }
            this.requestLayout();
            this.invalidate();
        } else {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public boolean bringTextIntoView() {
        int scrollx;
        int line = 0;
        if ((this.mGravity & 0x70) == 80) {
            line = this.mLayout.getLineCount() - 1;
        }
        Layout.Alignment a = this.mLayout.getParagraphAlignment(line);
        int dir = this.mLayout.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int ht = this.mLayout.getHeight();
        if (a == Layout.Alignment.ALIGN_CENTER) {
            int left = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
            int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
            scrollx = right - left < hspace ? (right + left) / 2 - hspace / 2 : (dir < 0 ? right - hspace : left);
        } else if (a == Layout.Alignment.ALIGN_NORMAL) {
            if (dir < 0) {
                int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
                scrollx = right - hspace;
            } else {
                scrollx = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
            }
        } else if (dir < 0) {
            scrollx = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
        } else {
            int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
            scrollx = right - hspace;
        }
        int scrolly = ht < vspace ? 0 : ((this.mGravity & 0x70) == 80 ? ht - vspace : 0);
        if (scrollx != this.mScrollX || scrolly != this.mScrollY) {
            this.scrollTo(scrollx, scrolly);
            return true;
        }
        return false;
    }

    public boolean bringPointIntoView(int offset) {
        int hslack;
        int grav;
        boolean changed = false;
        int line = this.mLayout.getLineForOffset(offset);
        int x = (int)this.mLayout.getPrimaryHorizontal(offset);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int left = (int)FloatMath.floor(this.mLayout.getLineLeft(line));
        int right = (int)FloatMath.ceil(this.mLayout.getLineRight(line));
        int ht = this.mLayout.getHeight();
        switch (this.mLayout.getParagraphAlignment(line)) {
            case ALIGN_NORMAL: {
                grav = 1;
                break;
            }
            case ALIGN_OPPOSITE: {
                grav = -1;
                break;
            }
            default: {
                grav = 0;
            }
        }
        grav *= this.mLayout.getParagraphDirection(line);
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom();
        int vslack = hslack = (bottom - top) / 2;
        if (vslack > vspace / 4) {
            vslack = vspace / 4;
        }
        if (hslack > hspace / 4) {
            hslack = hspace / 4;
        }
        int hs = this.mScrollX;
        int vs = this.mScrollY;
        if (top - vs < vslack) {
            vs = top - vslack;
        }
        if (bottom - vs > vspace - vslack) {
            vs = bottom - (vspace - vslack);
        }
        if (ht - vs < vspace) {
            vs = ht - vspace;
        }
        if (0 - vs > 0) {
            vs = 0;
        }
        if (grav != 0) {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (grav < 0) {
            if (left - hs > 0) {
                hs = left;
            }
            if (right - hs < hspace) {
                hs = right - hspace;
            }
        } else if (grav > 0) {
            if (right - hs < hspace) {
                hs = right - hspace;
            }
            if (left - hs > 0) {
                hs = left;
            }
        } else if (right - left <= hspace) {
            hs = left - (hspace - (right - left)) / 2;
        } else if (x > right - hslack) {
            hs = right - hspace;
        } else if (x < left + hslack) {
            hs = left;
        } else if (left > hs) {
            hs = left;
        } else if (right < hs + hspace) {
            hs = right - hspace;
        } else {
            if (x - hs < hslack) {
                hs = x - hslack;
            }
            if (x - hs > hspace - hslack) {
                hs = x - (hspace - hslack);
            }
        }
        if (hs != this.mScrollX || vs != this.mScrollY) {
            if (this.mScroller == null) {
                this.scrollTo(hs, vs);
            } else {
                long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
                int dx = hs - this.mScrollX;
                int dy = vs - this.mScrollY;
                if (duration > 250L) {
                    this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy);
                    this.awakenScrollBars(this.mScroller.getDuration());
                    this.invalidate();
                } else {
                    if (!this.mScroller.isFinished()) {
                        this.mScroller.abortAnimation();
                    }
                    this.scrollBy(dx, dy);
                }
                this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
            }
            changed = true;
        }
        if (this.isFocused()) {
            Rect r = new Rect(x, top, x + 1, bottom);
            this.getInterestingRect(r, line);
            r.offset(this.mScrollX, this.mScrollY);
            if (this.requestRectangleOnScreen(r)) {
                changed = true;
            }
        }
        return changed;
    }

    public boolean moveCursorToVisibleOffset() {
        int vs;
        int vspace;
        int end;
        if (!(this.mText instanceof Spannable)) {
            return false;
        }
        int start = this.getSelectionStart();
        if (start != (end = this.getSelectionEnd())) {
            return false;
        }
        int line = this.mLayout.getLineForOffset(start);
        int top = this.mLayout.getLineTop(line);
        int bottom = this.mLayout.getLineTop(line + 1);
        int vslack = (bottom - top) / 2;
        if (vslack > (vspace = this.mBottom - this.mTop - this.getExtendedPaddingTop() - this.getExtendedPaddingBottom()) / 4) {
            vslack = vspace / 4;
        }
        if (top < (vs = this.mScrollY) + vslack) {
            line = this.mLayout.getLineForVertical(vs + vslack + (bottom - top));
        } else if (bottom > vspace + vs - vslack) {
            line = this.mLayout.getLineForVertical(vspace + vs - vslack - (bottom - top));
        }
        int hspace = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        int hs = this.mScrollX;
        int leftChar = this.mLayout.getOffsetForHorizontal(line, hs);
        int rightChar = this.mLayout.getOffsetForHorizontal(line, hspace + hs);
        int newStart = start;
        if (newStart < leftChar) {
            newStart = leftChar;
        } else if (newStart > rightChar) {
            newStart = rightChar;
        }
        if (newStart != start) {
            Selection.setSelection((Spannable)this.mText, newStart);
            return true;
        }
        return false;
    }

    public void computeScroll() {
        if (this.mScroller != null && this.mScroller.computeScrollOffset()) {
            this.mScrollX = this.mScroller.getCurrX();
            this.mScrollY = this.mScroller.getCurrY();
            this.postInvalidate();
        }
    }

    public void getInterestingRect(Rect r, int line) {
        this.convertFromViewportToContentCoordinates(r);
        if (line == 0) {
            r.top -= this.getExtendedPaddingTop();
        }
        if (line == this.mLayout.getLineCount() - 1) {
            r.bottom += this.getExtendedPaddingBottom();
        }
    }

    public void convertFromViewportToContentCoordinates(Rect r) {
        int horizontalOffset = this.viewportToContentHorizontalOffset();
        r.left += horizontalOffset;
        r.right += horizontalOffset;
        int verticalOffset = this.viewportToContentVerticalOffset();
        r.top += verticalOffset;
        r.bottom += verticalOffset;
    }

    public int viewportToContentHorizontalOffset() {
        return this.getCompoundPaddingLeft() - this.mScrollX;
    }

    public int viewportToContentVerticalOffset() {
        int offset = this.getExtendedPaddingTop() - this.mScrollY;
        if ((this.mGravity & 0x70) != 48) {
            offset += this.getVerticalOffset(false);
        }
        return offset;
    }

    public void debug(int depth) {
        super.debug(depth);
        String output = TextView.debugIndent(depth);
        output = output + "frame={" + this.mLeft + ", " + this.mTop + ", " + this.mRight + ", " + this.mBottom + "} scroll={" + this.mScrollX + ", " + this.mScrollY + "} ";
        if (this.mText != null) {
            output = output + "mText=\"" + this.mText + "\" ";
            if (this.mLayout != null) {
                output = output + "mLayout width=" + this.mLayout.getWidth() + " height=" + this.mLayout.getHeight();
            }
        } else {
            output = output + "mText=NULL";
        }
        Log.d("View", output);
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionStart() {
        return Selection.getSelectionStart(this.getText());
    }

    @ViewDebug.ExportedProperty(category="text")
    public int getSelectionEnd() {
        return Selection.getSelectionEnd(this.getText());
    }

    public boolean hasSelection() {
        int selectionStart = this.getSelectionStart();
        int selectionEnd = this.getSelectionEnd();
        return selectionStart >= 0 && selectionStart != selectionEnd;
    }

    public void setSingleLine() {
        this.setSingleLine(true);
    }

    @RemotableViewMethod
    public void setSingleLine(boolean singleLine) {
        if ((this.mInputType & 0xF) == 1) {
            this.mInputType = singleLine ? (this.mInputType &= 0xFFFDFFFF) : (this.mInputType |= 0x20000);
        }
        this.applySingleLine(singleLine, true);
    }

    public void applySingleLine(boolean singleLine, boolean applyTransformation) {
        this.mSingleLine = singleLine;
        if (singleLine) {
            this.setLines(1);
            this.setHorizontallyScrolling(true);
            if (applyTransformation) {
                this.setTransformationMethod(SingleLineTransformationMethod.getInstance());
            }
        } else {
            this.setMaxLines(Integer.MAX_VALUE);
            this.setHorizontallyScrolling(false);
            if (applyTransformation) {
                this.setTransformationMethod(null);
            }
        }
    }

    public void setEllipsize(TextUtils.TruncateAt where) {
        this.mEllipsize = where;
        if (this.mLayout != null) {
            this.nullLayouts();
            this.requestLayout();
            this.invalidate();
        }
    }

    public void setMarqueeRepeatLimit(int marqueeLimit) {
        this.mMarqueeRepeatLimit = marqueeLimit;
    }

    @ViewDebug.ExportedProperty
    public TextUtils.TruncateAt getEllipsize() {
        return this.mEllipsize;
    }

    @RemotableViewMethod
    public void setSelectAllOnFocus(boolean selectAllOnFocus) {
        this.mSelectAllOnFocus = selectAllOnFocus;
        if (selectAllOnFocus && !(this.mText instanceof Spannable)) {
            this.setText(this.mText, BufferType.SPANNABLE);
        }
    }

    @RemotableViewMethod
    public void setCursorVisible(boolean visible) {
        this.mCursorVisible = visible;
        this.invalidate();
        if (visible) {
            this.makeBlink();
        } else if (this.mBlink != null) {
            this.mBlink.removeCallbacks(this.mBlink);
        }
        this.prepareCursorControllers();
    }

    public boolean canMarquee() {
        int width = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        return width > 0 && this.mLayout.getLineWidth(0) > (float)width;
    }

    public void startMarquee() {
        if (this.mInput != null) {
            return;
        }
        if (this.compressText(this.getWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) {
            return;
        }
        if ((this.mMarquee == null || this.mMarquee.isStopped()) && (this.isFocused() || this.isSelected()) && this.getLineCount() == 1 && this.canMarquee()) {
            if (this.mMarquee == null) {
                this.mMarquee = new Marquee(this);
            }
            this.mMarquee.start(this.mMarqueeRepeatLimit);
        }
    }

    public void stopMarquee() {
        if (this.mMarquee != null && !this.mMarquee.isStopped()) {
            this.mMarquee.stop();
        }
    }

    public void startStopMarquee(boolean start) {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (start) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    public void onTextChanged(CharSequence text, int start, int before, int after) {
    }

    public void onSelectionChanged(int selStart, int selEnd) {
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        int i;
        if (this.mListeners != null && (i = this.mListeners.indexOf(watcher)) >= 0) {
            this.mListeners.remove(i);
        }
    }

    public void sendBeforeTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).beforeTextChanged(text, start, before, after);
            }
        }
    }

    public void sendOnTextChanged(CharSequence text, int start, int before, int after) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).onTextChanged(text, start, before, after);
            }
        }
    }

    public void sendAfterTextChanged(Editable text) {
        if (this.mListeners != null) {
            ArrayList<TextWatcher> list = this.mListeners;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                list.get(i).afterTextChanged(text);
            }
        }
    }

    public void handleTextChanged(CharSequence buffer, int start, int before, int after) {
        InputMethodState ims = this.mInputMethodState;
        if (ims == null || ims.mBatchEditNesting == 0) {
            this.updateAfterEdit();
        }
        if (ims != null) {
            ims.mContentChanged = true;
            if (ims.mChangedStart < 0) {
                ims.mChangedStart = start;
                ims.mChangedEnd = start + before;
            } else {
                if (ims.mChangedStart > start) {
                    ims.mChangedStart = start;
                }
                if (ims.mChangedEnd < start + before) {
                    ims.mChangedEnd = start + before;
                }
            }
            ims.mChangedDelta += after - before;
        }
        this.sendOnTextChanged(buffer, start, before, after);
        this.onTextChanged(buffer, start, before, after);
        if (before != after) {
            this.hideControllers();
        }
    }

    public void spanChange(Spanned buf, Object what, int oldStart, int newStart, int oldEnd, int newEnd) {
        boolean selChanged = false;
        int newSelStart = -1;
        int newSelEnd = -1;
        InputMethodState ims = this.mInputMethodState;
        if (what == Selection.SELECTION_END) {
            this.mHighlightPathBogus = true;
            selChanged = true;
            newSelEnd = newStart;
            if (!this.isFocused()) {
                this.mSelectionMoved = true;
            }
            if (oldStart >= 0 || newStart >= 0) {
                this.invalidateCursor(Selection.getSelectionStart(buf), oldStart, newStart);
                this.registerForPreDraw();
                if (this.isFocused()) {
                    this.mShowCursor = SystemClock.uptimeMillis();
                    this.makeBlink();
                }
            }
        }
        if (what == Selection.SELECTION_START) {
            this.mHighlightPathBogus = true;
            selChanged = true;
            newSelStart = newStart;
            if (!this.isFocused()) {
                this.mSelectionMoved = true;
            }
            if (oldStart >= 0 || newStart >= 0) {
                int end = Selection.getSelectionEnd(buf);
                this.invalidateCursor(end, oldStart, newStart);
            }
        }
        if (selChanged && (buf.getSpanFlags(what) & 0x200) == 0) {
            if (newSelStart < 0) {
                newSelStart = Selection.getSelectionStart(buf);
            }
            if (newSelEnd < 0) {
                newSelEnd = Selection.getSelectionEnd(buf);
            }
            this.onSelectionChanged(newSelStart, newSelEnd);
        }
        if (what instanceof UpdateAppearance || what instanceof ParagraphStyle) {
            if (ims == null || ims.mBatchEditNesting == 0) {
                this.invalidate();
                this.mHighlightPathBogus = true;
                this.checkForResize();
            } else {
                ims.mContentChanged = true;
            }
        }
        if (MetaKeyKeyListener.isMetaTracker(buf, what)) {
            this.mHighlightPathBogus = true;
            if (ims != null && MetaKeyKeyListener.isSelectingMetaTracker(buf, what)) {
                ims.mSelectionModeChanged = true;
            }
            if (Selection.getSelectionStart(buf) >= 0) {
                if (ims == null || ims.mBatchEditNesting == 0) {
                    this.invalidateCursor();
                } else {
                    ims.mCursorChanged = true;
                }
            }
        }
        if (what instanceof ParcelableSpan && ims != null && ims.mExtracting != null) {
            if (ims.mBatchEditNesting != 0) {
                if (oldStart >= 0) {
                    if (ims.mChangedStart > oldStart) {
                        ims.mChangedStart = oldStart;
                    }
                    if (ims.mChangedStart > oldEnd) {
                        ims.mChangedStart = oldEnd;
                    }
                }
                if (newStart >= 0) {
                    if (ims.mChangedStart > newStart) {
                        ims.mChangedStart = newStart;
                    }
                    if (ims.mChangedStart > newEnd) {
                        ims.mChangedStart = newEnd;
                    }
                }
            } else {
                ims.mContentChanged = true;
            }
        }
    }

    public void makeBlink() {
        if (!this.mCursorVisible || !this.isTextEditable()) {
            if (this.mBlink != null) {
                this.mBlink.removeCallbacks(this.mBlink);
            }
            return;
        }
        if (this.mBlink == null) {
            this.mBlink = new Blink(this);
        }
        this.mBlink.removeCallbacks(this.mBlink);
        this.mBlink.postAtTime(this.mBlink, this.mShowCursor + 500L);
    }

    public void dispatchFinishTemporaryDetach() {
        this.mDispatchTemporaryDetach = true;
        super.dispatchFinishTemporaryDetach();
        this.mDispatchTemporaryDetach = false;
    }

    public void onStartTemporaryDetach() {
        super.onStartTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = true;
        }
    }

    public void onFinishTemporaryDetach() {
        super.onFinishTemporaryDetach();
        if (!this.mDispatchTemporaryDetach) {
            this.mTemporaryDetach = false;
        }
    }

    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (this.mTemporaryDetach) {
            super.onFocusChanged(focused, direction, previouslyFocusedRect);
            return;
        }
        this.mShowCursor = SystemClock.uptimeMillis();
        this.ensureEndedBatchEdit();
        if (focused) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            boolean isFocusHighlighted = this.mSelectAllOnFocus && selStart == 0 && selEnd == this.mText.length();
            boolean bl = this.mCreatedWithASelection = this.mFrozenWithFocus && this.hasSelection() && !isFocusHighlighted;
            if (!this.mFrozenWithFocus || selStart < 0 || selEnd < 0) {
                int lastTapPosition = this.getLastTapPosition();
                if (lastTapPosition >= 0) {
                    Selection.setSelection((Spannable)this.mText, lastTapPosition);
                }
                if (this.mMovement != null) {
                    this.mMovement.onTakeFocus(this, (Spannable)this.mText, direction);
                }
                if ((this instanceof ExtractEditText || this.mSelectionMoved) && selStart >= 0 && selEnd >= 0) {
                    Selection.setSelection((Spannable)this.mText, selStart, selEnd);
                }
                if (this.mSelectAllOnFocus) {
                    Selection.setSelection((Spannable)this.mText, 0, this.mText.length());
                }
                this.mTouchFocusSelected = true;
            }
            this.mFrozenWithFocus = false;
            this.mSelectionMoved = false;
            if (this.mText instanceof Spannable) {
                Spannable sp = (Spannable)this.mText;
                MetaKeyKeyListener.resetMetaState(sp);
            }
            this.makeBlink();
            if (this.mError != null) {
                this.showError();
            }
        } else {
            if (this.mError != null) {
                this.hideError();
            }
            this.onEndBatchEdit();
            this.hideInsertionPointCursorController();
            if (this instanceof ExtractEditText) {
                this.mIsInTextSelectionMode = false;
            } else {
                this.stopTextSelectionMode();
            }
            if (this.mSelectionModifierCursorController != null) {
                ((SelectionModifierCursorController)this.mSelectionModifierCursorController).resetTouchOffsets();
            }
        }
        this.startStopMarquee(focused);
        if (this.mTransformation != null) {
            this.mTransformation.onFocusChanged(this, this.mText, focused, direction, previouslyFocusedRect);
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    public int getLastTapPosition() {
        int lastTapPosition;
        if (this.mSelectionModifierCursorController != null && (lastTapPosition = ((SelectionModifierCursorController)this.mSelectionModifierCursorController).getMinTouchOffset()) >= 0) {
            if (lastTapPosition > this.mText.length()) {
                Log.e(LOG_TAG, "Invalid tap focus position (" + lastTapPosition + " vs " + this.mText.length() + ")");
                lastTapPosition = this.mText.length();
            }
            return lastTapPosition;
        }
        return -1;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            if (this.mBlink != null) {
                this.mBlink.uncancel();
                if (this.isFocused()) {
                    this.mShowCursor = SystemClock.uptimeMillis();
                    this.makeBlink();
                }
            }
        } else {
            if (this.mBlink != null) {
                this.mBlink.cancel();
            }
            this.onEndBatchEdit();
            if (this.mInputContentType != null) {
                this.mInputContentType.enterDown = false;
            }
            this.hideControllers();
        }
        this.startStopMarquee(hasWindowFocus);
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility != 0) {
            this.hideControllers();
        }
    }

    public void clearComposingText() {
        if (this.mText instanceof Spannable) {
            BaseInputConnection.removeComposingSpans((Spannable)this.mText);
        }
    }

    public void setSelected(boolean selected) {
        boolean wasSelected = this.isSelected();
        super.setSelected(selected);
        if (selected != wasSelected && this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (selected) {
                this.startMarquee();
            } else {
                this.stopMarquee();
            }
        }
    }

    public void onTapUpEvent(int prevStart, int prevEnd) {
        int end;
        int start = this.getSelectionStart();
        if (start == (end = this.getSelectionEnd())) {
            boolean tapInsideSelectAllOnFocus;
            boolean bl = tapInsideSelectAllOnFocus = this.mSelectAllOnFocus && prevStart == 0 && prevEnd == this.mText.length();
            if (start >= prevStart && start < prevEnd && !tapInsideSelectAllOnFocus) {
                Selection.setSelection((Spannable)this.mText, prevStart, prevEnd);
                if (!this.mNoContextMenuOnUp) {
                    this.showContextMenu();
                }
            } else {
                boolean selectAllGotFocus;
                this.stopTextSelectionMode();
                boolean bl2 = selectAllGotFocus = this.mSelectAllOnFocus && this.mTouchFocusSelected;
                if (this.hasInsertionController() && !selectAllGotFocus) {
                    this.getInsertionController().show();
                }
            }
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getActionMasked();
        if (this.hasInsertionController()) {
            this.getInsertionController().onTouchEvent(event);
        }
        if (this.hasSelectionController()) {
            this.getSelectionController().onTouchEvent(event);
        }
        if (action == 0) {
            this.mTouchFocusSelected = false;
            this.mScrolled = false;
        }
        boolean result = super.onTouchEvent(event);
        if (this.mEatTouchRelease && action == 1) {
            this.mEatTouchRelease = false;
        } else if ((this.mMovement != null || this.onCheckIsTextEditor()) && this.mText instanceof Spannable && this.mLayout != null) {
            boolean handled = false;
            int oldSelStart = this.getSelectionStart();
            int oldSelEnd = this.getSelectionEnd();
            int oldScrollX = this.mScrollX;
            int oldScrollY = this.mScrollY;
            if (this.mMovement != null) {
                handled |= this.mMovement.onTouchEvent(this, (Spannable)this.mText, event);
            }
            if (this.isTextEditable()) {
                if (this.mScrollX != oldScrollX || this.mScrollY != oldScrollY) {
                    this.hideInsertionPointCursorController();
                    if (this.mSelectionModifierCursorController != null && this.mSelectionModifierCursorController.isShowing()) {
                        this.mSelectionModifierCursorController.updatePosition();
                    }
                }
                if (action == 1 && this.isFocused() && !this.mScrolled) {
                    InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
                    CommitSelectionReceiver csr = null;
                    if (this.getSelectionStart() != oldSelStart || this.getSelectionEnd() != oldSelEnd || this.didTouchFocusSelect()) {
                        csr = new CommitSelectionReceiver(oldSelStart, oldSelEnd);
                    }
                    handled |= imm.showSoftInput(this, 0, csr) && csr != null;
                    this.onTapUpEvent(oldSelStart, oldSelEnd);
                }
            }
            if (handled) {
                result = true;
            }
        }
        if (action == 1 || action == 3) {
            this.mNoContextMenuOnUp = false;
        }
        return result;
    }

    public void prepareCursorControllers() {
        boolean windowSupportsHandles = false;
        ViewGroup.LayoutParams params = this.getRootView().getLayoutParams();
        if (params instanceof WindowManager.LayoutParams) {
            WindowManager.LayoutParams windowParams = (WindowManager.LayoutParams)params;
            windowSupportsHandles = windowParams.type < 1000 || windowParams.type > 1999;
        }
        this.mInsertionControllerEnabled = windowSupportsHandles && this.mCursorVisible && this.mLayout != null;
        boolean bl = this.mSelectionControllerEnabled = windowSupportsHandles && this.textCanBeSelected() && this.mLayout != null;
        if (!this.mInsertionControllerEnabled) {
            this.mInsertionPointCursorController = null;
        }
        if (!this.mSelectionControllerEnabled) {
            this.stopTextSelectionMode();
            this.mSelectionModifierCursorController = null;
        }
    }

    public boolean isTextEditable() {
        return this.mText instanceof Editable && this.onCheckIsTextEditor() && this.isEnabled();
    }

    public boolean didTouchFocusSelect() {
        return this.mTouchFocusSelected;
    }

    public void cancelLongPress() {
        super.cancelLongPress();
        this.mScrolled = true;
    }

    public boolean onTrackballEvent(MotionEvent event) {
        if (this.mMovement != null && this.mText instanceof Spannable && this.mLayout != null && this.mMovement.onTrackballEvent(this, (Spannable)this.mText, event)) {
            return true;
        }
        return super.onTrackballEvent(event);
    }

    public void setScroller(Scroller s) {
        this.mScroller = s;
    }

    public float getLeftFadingEdgeStrength() {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                if (marquee.shouldDrawLeftFade()) {
                    return marquee.mScroll / (float)this.getHorizontalFadingEdgeLength();
                }
                return 0.0f;
            }
            if (this.getLineCount() == 1) {
                switch (this.mGravity & 7) {
                    case 3: {
                        return 0.0f;
                    }
                    case 5: {
                        return (this.mLayout.getLineRight(0) - (float)(this.mRight - this.mLeft) - (float)this.getCompoundPaddingLeft() - (float)this.getCompoundPaddingRight() - this.mLayout.getLineLeft(0)) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 1: {
                        return 0.0f;
                    }
                }
            }
        }
        return super.getLeftFadingEdgeStrength();
    }

    public float getRightFadingEdgeStrength() {
        if (this.mEllipsize == TextUtils.TruncateAt.MARQUEE) {
            if (this.mMarquee != null && !this.mMarquee.isStopped()) {
                Marquee marquee = this.mMarquee;
                return (marquee.mMaxFadeScroll - marquee.mScroll) / (float)this.getHorizontalFadingEdgeLength();
            }
            if (this.getLineCount() == 1) {
                switch (this.mGravity & 7) {
                    case 3: {
                        int textWidth = this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
                        float lineWidth = this.mLayout.getLineWidth(0);
                        return (lineWidth - (float)textWidth) / (float)this.getHorizontalFadingEdgeLength();
                    }
                    case 5: {
                        return 0.0f;
                    }
                    case 1: {
                        return (this.mLayout.getLineWidth(0) - (float)(this.mRight - this.mLeft - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight())) / (float)this.getHorizontalFadingEdgeLength();
                    }
                }
            }
        }
        return super.getRightFadingEdgeStrength();
    }

    public int computeHorizontalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getWidth();
        }
        return super.computeHorizontalScrollRange();
    }

    public int computeVerticalScrollRange() {
        if (this.mLayout != null) {
            return this.mLayout.getHeight();
        }
        return super.computeVerticalScrollRange();
    }

    public int computeVerticalScrollExtent() {
        return this.getHeight() - this.getCompoundPaddingTop() - this.getCompoundPaddingBottom();
    }

    public static ColorStateList getTextColors(Context context, TypedArray attrs) {
        int ap;
        ColorStateList colors = attrs.getColorStateList(5);
        if (colors == null && (ap = attrs.getResourceId(1, -1)) != -1) {
            TypedArray appearance = context.obtainStyledAttributes(ap, R.styleable.TextAppearance);
            colors = appearance.getColorStateList(3);
            appearance.recycle();
        }
        return colors;
    }

    public static int getTextColor(Context context, TypedArray attrs, int def) {
        ColorStateList colors = TextView.getTextColors(context, attrs);
        if (colors == null) {
            return def;
        }
        return colors.getDefaultColor();
    }

    public boolean onKeyShortcut(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 29: {
                if (!this.canSelectText()) break;
                return this.onTextContextMenuItem(16908319);
            }
            case 52: {
                if (!this.canCut()) break;
                return this.onTextContextMenuItem(0x1020020);
            }
            case 31: {
                if (!this.canCopy()) break;
                return this.onTextContextMenuItem(0x1020021);
            }
            case 50: {
                if (!this.canPaste()) break;
                return this.onTextContextMenuItem(0x1020022);
            }
        }
        return super.onKeyShortcut(keyCode, event);
    }

    public boolean canSelectText() {
        return this.hasSelectionController() && this.mText.length() != 0;
    }

    public boolean textCanBeSelected() {
        return this.mText instanceof Spannable && this.mMovement != null && this.mMovement.canSelectArbitrarily();
    }

    public boolean canCut() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection() && this.mText instanceof Editable && this.mInput != null;
    }

    public boolean canCopy() {
        if (this.hasPasswordTransformationMethod()) {
            return false;
        }
        return this.mText.length() > 0 && this.hasSelection();
    }

    public boolean canPaste() {
        return this.mText instanceof Editable && this.mInput != null && this.getSelectionStart() >= 0 && this.getSelectionEnd() >= 0 && ((ClipboardManager)this.getContext().getSystemService("clipboard")).hasText();
    }

    public long getWordLimitsAt(int offset) {
        int type;
        char c;
        int start;
        int klass = this.mInputType & 0xF;
        if (klass == 2 || klass == 3 || klass == 4) {
            return -1L;
        }
        int variation = this.mInputType & 0xFF0;
        if (variation == 16 || variation == 128 || variation == 144 || variation == 32 || variation == 176) {
            return -1L;
        }
        int len = this.mText.length();
        int end = Math.min(offset, len);
        if (end < 0) {
            return -1L;
        }
        for (start = end; start > 0; --start) {
            c = this.mTransformed.charAt(start - 1);
            type = Character.getType(c);
            if (c != '\'' && type != 1 && type != 2 && type != 3 && type != 4 && type != 9) break;
        }
        while (end < len) {
            c = this.mTransformed.charAt(end);
            type = Character.getType(c);
            if (c != '\'' && type != 1 && type != 2 && type != 3 && type != 4 && type != 9) break;
            ++end;
        }
        if (start == end) {
            return -1L;
        }
        if (end - start > 48) {
            return -1L;
        }
        boolean hasLetter = false;
        for (int i = start; i < end; ++i) {
            if (!Character.isLetter(this.mTransformed.charAt(i))) continue;
            hasLetter = true;
            break;
        }
        if (!hasLetter) {
            return -1L;
        }
        return TextView.packRangeInLong(start, end);
    }

    public static long packRangeInLong(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    public static int extractRangeStartFromLong(long range) {
        return (int)(range >>> 32);
    }

    public static int extractRangeEndFromLong(long range) {
        return (int)(range & 0xFFFFFFFFL);
    }

    public void selectCurrentWord() {
        int maxOffset;
        int minOffset;
        if (this.hasSelection()) {
            return;
        }
        if (this.mContextMenuTriggeredByKey) {
            minOffset = this.getSelectionStart();
            maxOffset = this.getSelectionEnd();
        } else {
            SelectionModifierCursorController selectionModifierCursorController = (SelectionModifierCursorController)this.getSelectionController();
            minOffset = selectionModifierCursorController.getMinTouchOffset();
            maxOffset = selectionModifierCursorController.getMaxTouchOffset();
        }
        long wordLimits = this.getWordLimitsAt(minOffset);
        int selectionStart = wordLimits >= 0L ? TextView.extractRangeStartFromLong(wordLimits) : Math.max(minOffset - 5, 0);
        wordLimits = this.getWordLimitsAt(maxOffset);
        int selectionEnd = wordLimits >= 0L ? TextView.extractRangeEndFromLong(wordLimits) : Math.min(maxOffset + 5, this.mText.length());
        Selection.setSelection((Spannable)this.mText, selectionStart, selectionEnd);
    }

    public String getWordForDictionary() {
        int seedPosition = this.mContextMenuTriggeredByKey ? this.getSelectionStart() : this.getLastTapPosition();
        long wordLimits = this.getWordLimitsAt(seedPosition);
        if (wordLimits >= 0L) {
            int start = TextView.extractRangeStartFromLong(wordLimits);
            int end = TextView.extractRangeEndFromLong(wordLimits);
            return ((Object)this.mTransformed.subSequence(start, end)).toString();
        }
        return null;
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        if (!this.isShown()) {
            return false;
        }
        boolean isPassword = this.isPasswordInputType(this.mInputType);
        if (!isPassword) {
            CharSequence text = this.getText();
            if (TextUtils.isEmpty(text)) {
                text = this.getHint();
            }
            if (!TextUtils.isEmpty(text)) {
                if (text.length() > 500) {
                    text = text.subSequence(0, 501);
                }
                event.getText().add(text);
            }
        } else {
            event.setPassword(isPassword);
        }
        return false;
    }

    public void sendAccessibilityEventTypeViewTextChanged(CharSequence beforeText, int fromIndex, int removedCount, int addedCount) {
        AccessibilityEvent event = AccessibilityEvent.obtain(16);
        event.setFromIndex(fromIndex);
        event.setRemovedCount(removedCount);
        event.setAddedCount(addedCount);
        event.setBeforeText(beforeText);
        this.sendAccessibilityEventUnchecked(event);
    }

    public void onCreateContextMenu(ContextMenu menu) {
        super.onCreateContextMenu(menu);
        boolean added = false;
        this.mContextMenuTriggeredByKey = this.mDPadCenterIsDown || this.mEnterKeyIsDown;
        this.mEnterKeyIsDown = false;
        this.mDPadCenterIsDown = false;
        if (this.mIsInTextSelectionMode) {
            MenuHandler handler = new MenuHandler(null);
            if (this.canCut()) {
                menu.add(0, 0x1020020, 0, 17039363).setOnMenuItemClickListener(handler).setAlphabeticShortcut('x');
                added = true;
            }
            if (this.canCopy()) {
                menu.add(0, 0x1020021, 0, 0x1040001).setOnMenuItemClickListener(handler).setAlphabeticShortcut('c');
                added = true;
            }
            if (this.canPaste()) {
                menu.add(0, 0x1020022, 0, 17039371).setOnMenuItemClickListener(handler).setAlphabeticShortcut('v');
                added = true;
            }
        } else {
            String word;
            int max;
            int selEnd;
            int selStart;
            int min;
            URLSpan[] urls;
            MenuHandler handler = new MenuHandler(null);
            if (this.canSelectText()) {
                if (!this.hasPasswordTransformationMethod()) {
                    menu.add(0, 16908328, 0, 17040108).setOnMenuItemClickListener(handler);
                }
                menu.add(0, 16908319, 0, 17039373).setOnMenuItemClickListener(handler).setAlphabeticShortcut('a');
                added = true;
            }
            if (this.mText instanceof Spanned && (urls = ((Spanned)this.mText).getSpans(min = Math.min(selStart = this.getSelectionStart(), selEnd = this.getSelectionEnd()), max = Math.max(selStart, selEnd), URLSpan.class)).length == 1) {
                menu.add(0, 16908323, 0, 17039362).setOnMenuItemClickListener(handler);
                added = true;
            }
            if (this.canPaste()) {
                menu.add(0, 0x1020022, 0, 17039371).setOnMenuItemClickListener(handler).setAlphabeticShortcut('v');
                added = true;
            }
            if (this.isInputMethodTarget()) {
                menu.add(1, 16908324, 0, 17040109).setOnMenuItemClickListener(handler);
                added = true;
            }
            if ((word = this.getWordForDictionary()) != null) {
                menu.add(1, 16908330, 0, this.getContext().getString(17040110, word)).setOnMenuItemClickListener(handler);
                added = true;
            }
        }
        if (added) {
            this.hideControllers();
            menu.setHeaderTitle(17040111);
        }
    }

    public boolean isInputMethodTarget() {
        InputMethodManager imm = InputMethodManager.peekInstance();
        return imm != null && imm.isActive(this);
    }

    public boolean onTextContextMenuItem(int id2) {
        int min = 0;
        int max = this.mText.length();
        if (this.isFocused()) {
            int selStart = this.getSelectionStart();
            int selEnd = this.getSelectionEnd();
            min = Math.max(0, Math.min(selStart, selEnd));
            max = Math.max(0, Math.max(selStart, selEnd));
        }
        ClipboardManager clip = (ClipboardManager)this.getContext().getSystemService("clipboard");
        switch (id2) {
            case 16908319: {
                Selection.setSelection((Spannable)this.mText, 0, this.mText.length());
                this.startTextSelectionMode();
                this.getSelectionController().show();
                return true;
            }
            case 16908328: {
                this.startTextSelectionMode();
                this.getSelectionController().show();
                return true;
            }
            case 0x1020020: {
                clip.setText(this.mTransformed.subSequence(min, max));
                ((Editable)this.mText).delete(min, max);
                this.stopTextSelectionMode();
                return true;
            }
            case 0x1020021: {
                clip.setText(this.mTransformed.subSequence(min, max));
                this.stopTextSelectionMode();
                return true;
            }
            case 0x1020022: {
                CharSequence paste = clip.getText();
                if (paste != null && paste.length() > 0) {
                    long minMax = this.prepareSpacesAroundPaste(min, max, paste);
                    min = TextView.extractRangeStartFromLong(minMax);
                    max = TextView.extractRangeEndFromLong(minMax);
                    Selection.setSelection((Spannable)this.mText, max);
                    ((Editable)this.mText).replace(min, max, paste);
                    this.stopTextSelectionMode();
                }
                return true;
            }
            case 16908323: {
                URLSpan[] urls = ((Spanned)this.mText).getSpans(min, max, URLSpan.class);
                if (urls.length == 1) {
                    clip.setText(urls[0].getURL());
                }
                return true;
            }
            case 16908324: {
                InputMethodManager imm = InputMethodManager.peekInstance();
                if (imm != null) {
                    imm.showInputMethodPicker();
                }
                return true;
            }
            case 16908330: {
                String word = this.getWordForDictionary();
                if (word != null) {
                    Intent i = new Intent("com.android.settings.USER_DICTIONARY_INSERT");
                    i.putExtra("word", word);
                    i.setFlags(i.getFlags() | 0x10000000);
                    this.getContext().startActivity(i);
                }
                return true;
            }
        }
        return false;
    }

    public long prepareSpacesAroundPaste(int min, int max, CharSequence paste) {
        if (Character.isSpaceChar(paste.charAt(0))) {
            if (min > 0 && Character.isSpaceChar(this.mTransformed.charAt(min - 1))) {
                int originalLength = this.mText.length();
                ((Editable)this.mText).replace(min - 1, min, "");
                int delta = this.mText.length() - originalLength;
                min += delta;
                max += delta;
            }
        } else if (min > 0 && !Character.isSpaceChar(this.mTransformed.charAt(min - 1))) {
            int originalLength = this.mText.length();
            ((Editable)this.mText).replace(min, min, " ");
            int delta = this.mText.length() - originalLength;
            min += delta;
            max += delta;
        }
        if (Character.isSpaceChar(paste.charAt(paste.length() - 1))) {
            if (max < this.mText.length() && Character.isSpaceChar(this.mTransformed.charAt(max))) {
                ((Editable)this.mText).replace(max, max + 1, "");
            }
        } else if (max < this.mText.length() && !Character.isSpaceChar(this.mTransformed.charAt(max))) {
            ((Editable)this.mText).replace(max, max, " ");
        }
        return TextView.packRangeInLong(min, max);
    }

    public boolean performLongClick() {
        if (super.performLongClick()) {
            this.mEatTouchRelease = true;
            return true;
        }
        return false;
    }

    public void startTextSelectionMode() {
        if (!this.mIsInTextSelectionMode) {
            if (!this.hasSelectionController()) {
                Log.w(LOG_TAG, "TextView has no selection controller. Action mode cancelled.");
                return;
            }
            if (!this.canSelectText() || !this.requestFocus()) {
                return;
            }
            this.selectCurrentWord();
            this.getSelectionController().show();
            InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
            imm.showSoftInput(this, 0, null);
            this.mIsInTextSelectionMode = true;
        }
    }

    public void stopTextSelectionMode() {
        if (this.mIsInTextSelectionMode) {
            Selection.setSelection((Spannable)this.mText, this.getSelectionEnd());
            this.hideSelectionModifierCursorController();
            this.mIsInTextSelectionMode = false;
        }
    }

    public void hideInsertionPointCursorController() {
        if (this.mInsertionPointCursorController != null) {
            this.mInsertionPointCursorController.hide();
        }
    }

    public void hideSelectionModifierCursorController() {
        if (this.mSelectionModifierCursorController != null) {
            this.mSelectionModifierCursorController.hide();
        }
    }

    public void hideControllers() {
        this.hideInsertionPointCursorController();
        this.hideSelectionModifierCursorController();
    }

    public int getOffsetForHorizontal(int line, int x) {
        x -= this.getTotalPaddingLeft();
        x = Math.max(0, x);
        x = Math.min(this.getWidth() - this.getTotalPaddingRight() - 1, x);
        return this.getLayout().getOffsetForHorizontal(line, x += this.getScrollX());
    }

    public int getOffset(int x, int y) {
        if (this.getLayout() == null) {
            return -1;
        }
        y -= this.getTotalPaddingTop();
        y = Math.max(0, y);
        y = Math.min(this.getHeight() - this.getTotalPaddingBottom() - 1, y);
        int line = this.getLayout().getLineForVertical(y += this.getScrollY());
        int offset = this.getOffsetForHorizontal(line, x);
        return offset;
    }

    public int getHysteresisOffset(int x, int y, int previousOffset) {
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return -1;
        }
        y -= this.getTotalPaddingTop();
        y = Math.max(0, y);
        y = Math.min(this.getHeight() - this.getTotalPaddingBottom() - 1, y);
        int line = this.getLayout().getLineForVertical(y += this.getScrollY());
        int previousLine = layout2.getLineForOffset(previousOffset);
        int previousLineTop = layout2.getLineTop(previousLine);
        int previousLineBottom = layout2.getLineBottom(previousLine);
        int hysteresisThreshold = (previousLineBottom - previousLineTop) / 8;
        if (line == previousLine + 1 && y - previousLineBottom < hysteresisThreshold || line == previousLine - 1 && previousLineTop - y < hysteresisThreshold) {
            line = previousLine;
        }
        return this.getOffsetForHorizontal(line, x);
    }

    public boolean hasInsertionController() {
        return this.mInsertionControllerEnabled;
    }

    public boolean hasSelectionController() {
        return this.mSelectionControllerEnabled;
    }

    public CursorController getInsertionController() {
        if (!this.mInsertionControllerEnabled) {
            return null;
        }
        if (this.mInsertionPointCursorController == null) {
            this.mInsertionPointCursorController = new InsertionPointCursorController();
            ViewTreeObserver observer = this.getViewTreeObserver();
            if (observer != null) {
                observer.addOnTouchModeChangeListener(this.mInsertionPointCursorController);
            }
        }
        return this.mInsertionPointCursorController;
    }

    public CursorController getSelectionController() {
        if (!this.mSelectionControllerEnabled) {
            return null;
        }
        if (this.mSelectionModifierCursorController == null) {
            this.mSelectionModifierCursorController = new SelectionModifierCursorController();
            ViewTreeObserver observer = this.getViewTreeObserver();
            if (observer != null) {
                observer.addOnTouchModeChangeListener(this.mSelectionModifierCursorController);
            }
        }
        return this.mSelectionModifierCursorController;
    }

    public boolean isInBatchEditMode() {
        InputMethodState ims = this.mInputMethodState;
        if (ims != null) {
            return ims.mBatchEditNesting > 0;
        }
        return this.mInBatchEditControllers;
    }

    static {
        Paint p = new Paint();
        p.setAntiAlias(true);
        p.measureText("H");
        UNKNOWN_BORING = new BoringLayout.Metrics();
        sCursorControllerTempRect = new Rect();
        sTempRect = new RectF();
        NO_FILTERS = new InputFilter[0];
        EMPTY_SPANNED = new SpannedString("");
    }

    public class SelectionModifierCursorController
    implements CursorController {
        public HandleView mStartHandle;
        public HandleView mEndHandle;
        public int mMinTouchOffset;
        public int mMaxTouchOffset;
        public boolean mIsShowing;
        public long mPreviousTapUpTime = 0L;
        public int mPreviousTapPositionX;
        public int mPreviousTapPositionY;

        public SelectionModifierCursorController() {
            this.mStartHandle = new HandleView(this, 0);
            this.mEndHandle = new HandleView(this, 2);
            this.resetTouchOffsets();
        }

        public void show() {
            if (TextView.this.isInBatchEditMode()) {
                return;
            }
            this.mIsShowing = true;
            this.updatePosition();
            this.mStartHandle.show();
            this.mEndHandle.show();
            TextView.this.hideInsertionPointCursorController();
        }

        public void hide() {
            this.mStartHandle.hide();
            this.mEndHandle.hide();
            this.mIsShowing = false;
        }

        public boolean isShowing() {
            return this.mIsShowing;
        }

        public void updatePosition(HandleView handle, int x, int y) {
            int selectionStart = TextView.this.getSelectionStart();
            int selectionEnd = TextView.this.getSelectionEnd();
            int previousOffset = handle == this.mStartHandle ? selectionStart : selectionEnd;
            int offset = TextView.this.getHysteresisOffset(x, y, previousOffset);
            if (handle == this.mStartHandle) {
                if (selectionStart == offset || offset > selectionEnd) {
                    return;
                }
                if (offset == selectionEnd) {
                    offset = selectionEnd - 1;
                }
                selectionStart = offset;
            } else {
                if (selectionEnd == offset || offset < selectionStart) {
                    return;
                }
                if (offset == selectionStart) {
                    offset = selectionStart + 1;
                }
                selectionEnd = offset;
            }
            Selection.setSelection((Spannable)TextView.this.mText, selectionStart, selectionEnd);
            this.updatePosition();
        }

        public void updatePosition() {
            if (!this.isShowing()) {
                return;
            }
            int selectionStart = TextView.this.getSelectionStart();
            int selectionEnd = TextView.this.getSelectionEnd();
            if (selectionStart < 0 || selectionEnd < 0) {
                Log.w(TextView.LOG_TAG, "Update selection controller position called with no cursor");
                this.hide();
                return;
            }
            this.mStartHandle.positionAtCursor(selectionStart, true);
            this.mEndHandle.positionAtCursor(selectionEnd, true);
        }

        public boolean onTouchEvent(MotionEvent event) {
            if (TextView.this.isTextEditable()) {
                switch (event.getActionMasked()) {
                    case 0: {
                        int doubleTapSlop;
                        int slopSquared;
                        int deltaY;
                        int deltaX;
                        int distanceSquared;
                        int x = (int)event.getX();
                        int y = (int)event.getY();
                        this.mMinTouchOffset = this.mMaxTouchOffset = TextView.this.getOffset(x, y);
                        long duration = SystemClock.uptimeMillis() - this.mPreviousTapUpTime;
                        if (duration <= (long)ViewConfiguration.getDoubleTapTimeout() && (distanceSquared = (deltaX = x - this.mPreviousTapPositionX) * deltaX + (deltaY = y - this.mPreviousTapPositionY) * deltaY) < (slopSquared = (doubleTapSlop = ViewConfiguration.get(TextView.this.getContext()).getScaledDoubleTapSlop()) * doubleTapSlop)) {
                            TextView.this.startTextSelectionMode();
                            TextView.this.mNoContextMenuOnUp = true;
                        }
                        this.mPreviousTapPositionX = x;
                        this.mPreviousTapPositionY = y;
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (!TextView.this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen.multitouch.distinct")) break;
                        this.updateMinAndMaxOffsets(event);
                        break;
                    }
                    case 1: {
                        this.mPreviousTapUpTime = SystemClock.uptimeMillis();
                    }
                }
            }
            return false;
        }

        public void updateMinAndMaxOffsets(MotionEvent event) {
            int pointerCount = event.getPointerCount();
            for (int index = 0; index < pointerCount; ++index) {
                int y;
                int x = (int)event.getX(index);
                int offset = TextView.this.getOffset(x, y = (int)event.getY(index));
                if (offset < this.mMinTouchOffset) {
                    this.mMinTouchOffset = offset;
                }
                if (offset <= this.mMaxTouchOffset) continue;
                this.mMaxTouchOffset = offset;
            }
        }

        public int getMinTouchOffset() {
            return this.mMinTouchOffset;
        }

        public int getMaxTouchOffset() {
            return this.mMaxTouchOffset;
        }

        public void resetTouchOffsets() {
            this.mMaxTouchOffset = -1;
            this.mMinTouchOffset = -1;
        }

        public boolean isSelectionStartDragged() {
            return this.mStartHandle.isDragging();
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        public void onDetached() {
        }
    }

    public class InsertionPointCursorController
    implements CursorController {
        public static final int DELAY_BEFORE_FADE_OUT = 4100;
        public final HandleView mHandle;
        public final Runnable mHider = new Runnable(){

            public void run() {
                InsertionPointCursorController.this.hide();
            }
        };

        public InsertionPointCursorController() {
            this.mHandle = new HandleView(this, 1);
        }

        public void show() {
            this.updatePosition();
            this.mHandle.show();
            this.hideDelayed(4100);
        }

        public void hide() {
            this.mHandle.hide();
            TextView.this.removeCallbacks(this.mHider);
        }

        public void hideDelayed(int msec) {
            TextView.this.removeCallbacks(this.mHider);
            TextView.this.postDelayed(this.mHider, msec);
        }

        public boolean isShowing() {
            return this.mHandle.isShowing();
        }

        public void updatePosition(HandleView handle, int x, int y) {
            int previousOffset = TextView.this.getSelectionStart();
            int offset = TextView.this.getHysteresisOffset(x, y, previousOffset);
            if (offset != previousOffset) {
                Selection.setSelection((Spannable)TextView.this.mText, offset);
                this.updatePosition();
            }
            this.hideDelayed(4100);
        }

        public void updatePosition() {
            int offset = TextView.this.getSelectionStart();
            if (offset < 0) {
                Log.w(TextView.LOG_TAG, "Update cursor controller position called with no cursor");
                this.hide();
                return;
            }
            this.mHandle.positionAtCursor(offset, true);
        }

        public boolean onTouchEvent(MotionEvent ev) {
            return false;
        }

        public void onTouchModeChanged(boolean isInTouchMode) {
            if (!isInTouchMode) {
                this.hide();
            }
        }

        public void onDetached() {
            TextView.this.removeCallbacks(this.mHider);
        }
    }

    public class HandleView
    extends View {
        public boolean mPositionOnTop;
        public Drawable mDrawable;
        public PopupWindow mContainer;
        public int mPositionX;
        public int mPositionY;
        public CursorController mController;
        public boolean mIsDragging;
        public float mTouchToWindowOffsetX;
        public float mTouchToWindowOffsetY;
        public float mHotspotX;
        public float mHotspotY;
        public int mHeight;
        public float mTouchOffsetY;
        public int mLastParentX;
        public int mLastParentY;
        public static final int LEFT = 0;
        public static final int CENTER = 1;
        public static final int RIGHT = 2;

        public HandleView(CursorController controller, int pos) {
            super(TextView.this.mContext);
            this.mPositionOnTop = false;
            this.mController = controller;
            this.mContainer = new PopupWindow(TextView.this.mContext, null, 16843464);
            this.mContainer.setSplitTouchEnabled(true);
            this.mContainer.setClippingEnabled(false);
            this.mContainer.setWindowLayoutType(1002);
            this.setOrientation(pos);
        }

        public void setOrientation(int pos) {
            switch (pos) {
                case 0: {
                    if (TextView.this.mSelectHandleLeft == null) {
                        TextView.this.mSelectHandleLeft = this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleLeftRes);
                    }
                    this.mDrawable = TextView.this.mSelectHandleLeft;
                    int handleWidth = this.mDrawable.getIntrinsicWidth();
                    this.mHotspotX = handleWidth * 3 / 4;
                    break;
                }
                case 2: {
                    if (TextView.this.mSelectHandleRight == null) {
                        TextView.this.mSelectHandleRight = this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleRightRes);
                    }
                    this.mDrawable = TextView.this.mSelectHandleRight;
                    int handleWidth = this.mDrawable.getIntrinsicWidth();
                    this.mHotspotX = handleWidth / 4;
                    break;
                }
                default: {
                    if (TextView.this.mSelectHandleCenter == null) {
                        TextView.this.mSelectHandleCenter = this.mContext.getResources().getDrawable(TextView.this.mTextSelectHandleRes);
                    }
                    this.mDrawable = TextView.this.mSelectHandleCenter;
                    int handleWidth = this.mDrawable.getIntrinsicWidth();
                    this.mHotspotX = handleWidth / 2;
                }
            }
            int handleHeight = this.mDrawable.getIntrinsicHeight();
            this.mTouchOffsetY = (float)(-handleHeight) * 0.3f;
            this.mHotspotY = 0.0f;
            this.mHeight = handleHeight;
            this.invalidate();
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.mDrawable.getIntrinsicWidth(), this.mDrawable.getIntrinsicHeight());
        }

        public void show() {
            if (!this.isPositionVisible()) {
                this.hide();
                return;
            }
            this.mContainer.setContentView(this);
            int[] coords = TextView.this.mTempCoords;
            TextView.this.getLocationInWindow(coords);
            coords[0] = coords[0] + this.mPositionX;
            coords[1] = coords[1] + this.mPositionY;
            this.mContainer.showAtLocation(TextView.this, 0, coords[0], coords[1]);
        }

        public void hide() {
            this.mIsDragging = false;
            this.mContainer.dismiss();
        }

        public boolean isShowing() {
            return this.mContainer.isShowing();
        }

        public boolean isPositionVisible() {
            if (this.mIsDragging) {
                return true;
            }
            if (TextView.this.isInBatchEditMode()) {
                return false;
            }
            int extendedPaddingTop = TextView.this.getExtendedPaddingTop();
            int extendedPaddingBottom = TextView.this.getExtendedPaddingBottom();
            int compoundPaddingLeft = TextView.this.getCompoundPaddingLeft();
            int compoundPaddingRight = TextView.this.getCompoundPaddingRight();
            TextView hostView = TextView.this;
            boolean left = false;
            int right = hostView.getWidth();
            boolean top = false;
            int bottom = hostView.getHeight();
            if (TextView.this.mTempRect == null) {
                TextView.this.mTempRect = new Rect();
            }
            Rect clip = TextView.this.mTempRect;
            clip.left = 0 + compoundPaddingLeft;
            clip.top = 0 + extendedPaddingTop;
            clip.right = right - compoundPaddingRight;
            clip.bottom = bottom - extendedPaddingBottom;
            ViewParent parent = hostView.getParent();
            if (parent == null || !parent.getChildVisibleRect(hostView, clip, null)) {
                return false;
            }
            int[] coords = TextView.this.mTempCoords;
            hostView.getLocationInWindow(coords);
            int posX = coords[0] + this.mPositionX + (int)this.mHotspotX;
            int posY = coords[1] + this.mPositionY + (int)this.mHotspotY;
            return posX >= clip.left && posX <= clip.right && posY >= clip.top && posY <= clip.bottom;
        }

        public void moveTo(int x, int y) {
            this.mPositionX = x - TextView.this.mScrollX;
            this.mPositionY = y - TextView.this.mScrollY;
            if (this.isPositionVisible()) {
                int[] coords = null;
                if (this.mContainer.isShowing()) {
                    coords = TextView.this.mTempCoords;
                    TextView.this.getLocationInWindow(coords);
                    this.mContainer.update(coords[0] + this.mPositionX, coords[1] + this.mPositionY, this.mRight - this.mLeft, this.mBottom - this.mTop);
                } else {
                    this.show();
                }
                if (this.mIsDragging) {
                    if (coords == null) {
                        coords = TextView.this.mTempCoords;
                        TextView.this.getLocationInWindow(coords);
                    }
                    if (coords[0] != this.mLastParentX || coords[1] != this.mLastParentY) {
                        this.mTouchToWindowOffsetX += (float)(coords[0] - this.mLastParentX);
                        this.mTouchToWindowOffsetY += (float)(coords[1] - this.mLastParentY);
                        this.mLastParentX = coords[0];
                        this.mLastParentY = coords[1];
                    }
                }
            } else {
                this.hide();
            }
        }

        public void onDraw(Canvas c) {
            this.mDrawable.setBounds(0, 0, this.mRight - this.mLeft, this.mBottom - this.mTop);
            if (this.mPositionOnTop) {
                c.save();
                c.rotate(180.0f, (this.mRight - this.mLeft) / 2, (this.mBottom - this.mTop) / 2);
                this.mDrawable.draw(c);
                c.restore();
            } else {
                this.mDrawable.draw(c);
            }
        }

        public boolean onTouchEvent(MotionEvent ev) {
            switch (ev.getActionMasked()) {
                case 0: {
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    this.mTouchToWindowOffsetX = rawX - (float)this.mPositionX;
                    this.mTouchToWindowOffsetY = rawY - (float)this.mPositionY;
                    int[] coords = TextView.this.mTempCoords;
                    TextView.this.getLocationInWindow(coords);
                    this.mLastParentX = coords[0];
                    this.mLastParentY = coords[1];
                    this.mIsDragging = true;
                    break;
                }
                case 2: {
                    float rawX = ev.getRawX();
                    float rawY = ev.getRawY();
                    float newPosX = rawX - this.mTouchToWindowOffsetX + this.mHotspotX;
                    float newPosY = rawY - this.mTouchToWindowOffsetY + this.mHotspotY + this.mTouchOffsetY;
                    this.mController.updatePosition(this, Math.round(newPosX), Math.round(newPosY));
                    break;
                }
                case 1: 
                case 3: {
                    this.mIsDragging = false;
                }
            }
            return true;
        }

        public boolean isDragging() {
            return this.mIsDragging;
        }

        public void positionAtCursor(int offset, boolean bottom) {
            int width = this.mDrawable.getIntrinsicWidth();
            int height = this.mDrawable.getIntrinsicHeight();
            int line = TextView.this.mLayout.getLineForOffset(offset);
            int lineTop = TextView.this.mLayout.getLineTop(line);
            int lineBottom = TextView.this.mLayout.getLineBottom(line);
            Rect bounds = sCursorControllerTempRect;
            bounds.left = (int)(TextView.this.mLayout.getPrimaryHorizontal(offset) - this.mHotspotX) + TextView.this.mScrollX;
            bounds.top = (bottom ? lineBottom : lineTop - this.mHeight) + TextView.this.mScrollY;
            bounds.right = bounds.left + width;
            bounds.bottom = bounds.top + height;
            TextView.this.convertFromViewportToContentCoordinates(bounds);
            this.moveTo(bounds.left, bounds.top);
        }
    }

    public static interface CursorController
    extends ViewTreeObserver.OnTouchModeChangeListener {
        public void show();

        public void hide();

        public boolean isShowing();

        public void updatePosition(HandleView var1, int var2, int var3);

        public void updatePosition();

        public boolean onTouchEvent(MotionEvent var1);

        public void onDetached();
    }

    public class MenuHandler
    implements MenuItem.OnMenuItemClickListener {
        public MenuHandler() {
        }

        public boolean onMenuItemClick(MenuItem item) {
            return TextView.this.onTextContextMenuItem(item.getItemId());
        }

        public /* synthetic */ MenuHandler(1 x1) {
            this();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferType {
        NORMAL,
        SPANNABLE,
        EDITABLE;

    }

    public static class Blink
    extends Handler
    implements Runnable {
        public final WeakReference<TextView> mView;
        public boolean mCancelled;

        public Blink(TextView v) {
            this.mView = new WeakReference<TextView>(v);
        }

        public void run() {
            int en2;
            int st;
            if (this.mCancelled) {
                return;
            }
            this.removeCallbacks(this);
            TextView tv = (TextView)this.mView.get();
            if (tv != null && tv.isFocused() && (st = tv.getSelectionStart()) == (en2 = tv.getSelectionEnd()) && st >= 0 && en2 >= 0) {
                if (tv.mLayout != null) {
                    tv.invalidateCursorPath();
                }
                this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            }
        }

        public void cancel() {
            if (!this.mCancelled) {
                this.removeCallbacks(this);
                this.mCancelled = true;
            }
        }

        public void uncancel() {
            this.mCancelled = false;
        }
    }

    public class CommitSelectionReceiver
    extends ResultReceiver {
        public final int mPrevStart;
        public final int mPrevEnd;

        public CommitSelectionReceiver(int prevStart, int prevEnd) {
            super(TextView.this.getHandler());
            this.mPrevStart = prevStart;
            this.mPrevEnd = prevEnd;
        }

        public void onReceiveResult(int resultCode, Bundle resultData) {
            if (resultCode == 2) {
                boolean selectAllGotFocus;
                int len = TextView.this.mText.length();
                int start = Math.min(len, this.mPrevStart);
                int end = Math.min(len, this.mPrevEnd);
                Selection.setSelection((Spannable)TextView.this.mText, start, end);
                boolean bl = selectAllGotFocus = TextView.this.mSelectAllOnFocus && TextView.this.mTouchFocusSelected;
                if (TextView.this.hasSelection() && !selectAllGotFocus) {
                    TextView.this.startTextSelectionMode();
                }
            }
        }
    }

    public class ChangeWatcher
    implements TextWatcher,
    SpanWatcher {
        public CharSequence mBeforeText;

        public ChangeWatcher() {
        }

        public void beforeTextChanged(CharSequence buffer, int start, int before, int after) {
            if (AccessibilityManager.getInstance((Context)TextView.this.mContext).isEnabled() && !TextView.this.isPasswordInputType(TextView.this.mInputType)) {
                this.mBeforeText = ((Object)buffer).toString();
            }
            TextView.this.sendBeforeTextChanged(buffer, start, before, after);
        }

        public void onTextChanged(CharSequence buffer, int start, int before, int after) {
            TextView.this.handleTextChanged(buffer, start, before, after);
            if (AccessibilityManager.getInstance((Context)TextView.this.mContext).isEnabled() && (TextView.this.isFocused() || TextView.this.isSelected() && TextView.this.isShown())) {
                TextView.this.sendAccessibilityEventTypeViewTextChanged(this.mBeforeText, start, before, after);
                this.mBeforeText = null;
            }
        }

        public void afterTextChanged(Editable buffer) {
            TextView.this.sendAfterTextChanged(buffer);
            if (MetaKeyKeyListener.getMetaState(buffer, 65536) != 0) {
                MetaKeyKeyListener.stopSelecting(TextView.this, buffer);
            }
        }

        public void onSpanChanged(Spannable buf, Object what, int s, int e, int st, int en2) {
            TextView.this.spanChange(buf, what, s, st, e, en2);
        }

        public void onSpanAdded(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, -1, s, -1, e);
        }

        public void onSpanRemoved(Spannable buf, Object what, int s, int e) {
            TextView.this.spanChange(buf, what, s, -1, e, -1);
        }

        public /* synthetic */ ChangeWatcher(1 x1) {
            this();
        }
    }

    public static class Marquee
    extends Handler {
        public static final float MARQUEE_DELTA_MAX = 0.07f;
        public static final int MARQUEE_DELAY = 1200;
        public static final int MARQUEE_RESTART_DELAY = 1200;
        public static final int MARQUEE_RESOLUTION = 33;
        public static final int MARQUEE_PIXELS_PER_SECOND = 30;
        public static final byte MARQUEE_STOPPED = 0;
        public static final byte MARQUEE_STARTING = 1;
        public static final byte MARQUEE_RUNNING = 2;
        public static final int MESSAGE_START = 1;
        public static final int MESSAGE_TICK = 2;
        public static final int MESSAGE_RESTART = 3;
        public final WeakReference<TextView> mView;
        public byte mStatus = 0;
        public final float mScrollUnit;
        public float mMaxScroll;
        public float mMaxFadeScroll;
        public float mGhostStart;
        public float mGhostOffset;
        public float mFadeStop;
        public int mRepeatLimit;
        public float mScroll;

        public Marquee(TextView v) {
            float density = v.getContext().getResources().getDisplayMetrics().density;
            this.mScrollUnit = 30.0f * density / 33.0f;
            this.mView = new WeakReference<TextView>(v);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mStatus = (byte)2;
                    this.tick();
                    break;
                }
                case 2: {
                    this.tick();
                    break;
                }
                case 3: {
                    if (this.mStatus != 2) break;
                    if (this.mRepeatLimit >= 0) {
                        --this.mRepeatLimit;
                    }
                    this.start(this.mRepeatLimit);
                }
            }
        }

        public void tick() {
            if (this.mStatus != 2) {
                return;
            }
            this.removeMessages(2);
            TextView textView = (TextView)this.mView.get();
            if (textView != null && (textView.isFocused() || textView.isSelected())) {
                this.mScroll += this.mScrollUnit;
                if (this.mScroll > this.mMaxScroll) {
                    this.mScroll = this.mMaxScroll;
                    this.sendEmptyMessageDelayed(3, 1200L);
                } else {
                    this.sendEmptyMessageDelayed(2, 33L);
                }
                textView.invalidate();
            }
        }

        public void stop() {
            this.mStatus = 0;
            this.removeMessages(1);
            this.removeMessages(3);
            this.removeMessages(2);
            this.resetScroll();
        }

        public void resetScroll() {
            this.mScroll = 0.0f;
            TextView textView = (TextView)this.mView.get();
            if (textView != null) {
                textView.invalidate();
            }
        }

        public void start(int repeatLimit) {
            if (repeatLimit == 0) {
                this.stop();
                return;
            }
            this.mRepeatLimit = repeatLimit;
            TextView textView = (TextView)this.mView.get();
            if (textView != null && textView.mLayout != null) {
                this.mStatus = 1;
                this.mScroll = 0.0f;
                int textWidth = textView.getWidth() - textView.getCompoundPaddingLeft() - textView.getCompoundPaddingRight();
                float lineWidth = textView.mLayout.getLineWidth(0);
                float gap = (float)textWidth / 3.0f;
                this.mGhostStart = lineWidth - (float)textWidth + gap;
                this.mMaxScroll = this.mGhostStart + (float)textWidth;
                this.mGhostOffset = lineWidth + gap;
                this.mFadeStop = lineWidth + (float)textWidth / 6.0f;
                this.mMaxFadeScroll = this.mGhostStart + lineWidth + lineWidth;
                textView.invalidate();
                this.sendEmptyMessageDelayed(1, 1200L);
            }
        }

        public float getGhostOffset() {
            return this.mGhostOffset;
        }

        public boolean shouldDrawLeftFade() {
            return this.mScroll <= this.mFadeStop;
        }

        public boolean shouldDrawGhost() {
            return this.mStatus == 2 && this.mScroll > this.mGhostStart;
        }

        public boolean isRunning() {
            return this.mStatus == 2;
        }

        public boolean isStopped() {
            return this.mStatus == 0;
        }
    }

    public static class ErrorPopup
    extends PopupWindow {
        public boolean mAbove = false;
        public final TextView mView;

        public ErrorPopup(TextView v, int width, int height) {
            super(v, width, height);
            this.mView = v;
        }

        public void fixDirection(boolean above) {
            this.mAbove = above;
            if (above) {
                this.mView.setBackgroundResource(17302091);
            } else {
                this.mView.setBackgroundResource(17302090);
            }
        }

        public void update(int x, int y, int w, int h, boolean force) {
            super.update(x, y, w, h, force);
            boolean above = this.isAboveAnchor();
            if (above != this.mAbove) {
                this.fixDirection(above);
            }
        }
    }

    public static class CharWrapper
    implements CharSequence,
    GetChars,
    GraphicsOperations {
        public char[] mChars;
        public int mStart;
        public int mLength;

        public CharWrapper(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        public void set(char[] chars, int start, int len) {
            this.mChars = chars;
            this.mStart = start;
            this.mLength = len;
        }

        public int length() {
            return this.mLength;
        }

        public char charAt(int off) {
            return this.mChars[off + this.mStart];
        }

        public String toString() {
            return new String(this.mChars, this.mStart, this.mLength);
        }

        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            return new String(this.mChars, start + this.mStart, end - start);
        }

        public void getChars(int start, int end, char[] buf, int off) {
            if (start < 0 || end < 0 || start > this.mLength || end > this.mLength) {
                throw new IndexOutOfBoundsException(start + ", " + end);
            }
            System.arraycopy(this.mChars, start + this.mStart, buf, off, end - start);
        }

        public void drawText(Canvas c, int start, int end, float x, float y, Paint p) {
            c.drawText(this.mChars, start + this.mStart, end - start, x, y, p);
        }

        public float measureText(int start, int end, Paint p) {
            return p.measureText(this.mChars, start + this.mStart, end - start);
        }

        public int getTextWidths(int start, int end, float[] widths, Paint p) {
            return p.getTextWidths(this.mChars, start + this.mStart, end - start, widths);
        }

        public static /* synthetic */ char[] access$102(CharWrapper x0, char[] x1) {
            x0.mChars = x1;
            return x1;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public int selStart;
        public int selEnd;
        public CharSequence text;
        public boolean frozenWithFocus;
        public CharSequence error;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.selStart);
            out.writeInt(this.selEnd);
            out.writeInt(this.frozenWithFocus ? 1 : 0);
            TextUtils.writeToParcel(this.text, out, flags);
            if (this.error == null) {
                out.writeInt(0);
            } else {
                out.writeInt(1);
                TextUtils.writeToParcel(this.error, out, flags);
            }
        }

        public String toString() {
            String str = "TextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " start=" + this.selStart + " end=" + this.selEnd;
            if (this.text != null) {
                str = str + " text=" + this.text;
            }
            return str + "}";
        }

        public SavedState(Parcel in) {
            super(in);
            this.selStart = in.readInt();
            this.selEnd = in.readInt();
            this.frozenWithFocus = in.readInt() != 0;
            this.text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            if (in.readInt() != 0) {
                this.error = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            }
        }

        public /* synthetic */ SavedState(Parcel x0, 1 x1) {
            this(x0);
        }
    }

    public static interface OnEditorActionListener {
        public boolean onEditorAction(TextView var1, int var2, KeyEvent var3);
    }

    public class InputMethodState {
        public Rect mCursorRectInWindow = new Rect();
        public RectF mTmpRectF = new RectF();
        public float[] mTmpOffset = new float[2];
        public ExtractedTextRequest mExtracting;
        public final ExtractedText mTmpExtracted = new ExtractedText();
        public int mBatchEditNesting;
        public boolean mCursorChanged;
        public boolean mSelectionModeChanged;
        public boolean mContentChanged;
        public int mChangedStart;
        public int mChangedEnd;
        public int mChangedDelta;
    }

    public class InputContentType {
        public int imeOptions = 0;
        public String privateImeOptions;
        public CharSequence imeActionLabel;
        public int imeActionId;
        public Bundle extras;
        public OnEditorActionListener onEditorActionListener;
        public boolean enterDown;
    }

    public class Drawables {
        public final Rect mCompoundRect = new Rect();
        public Drawable mDrawableTop;
        public Drawable mDrawableBottom;
        public Drawable mDrawableLeft;
        public Drawable mDrawableRight;
        public int mDrawableSizeTop;
        public int mDrawableSizeBottom;
        public int mDrawableSizeLeft;
        public int mDrawableSizeRight;
        public int mDrawableWidthTop;
        public int mDrawableWidthBottom;
        public int mDrawableHeightLeft;
        public int mDrawableHeightRight;
        public int mDrawablePadding;
    }
}

