/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Interpolator;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.net.http.SslCertificate;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.text.Editable;
import android.text.IClipboard;
import android.text.Selection;
import android.util.AttributeSet;
import android.util.EventLog;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AlphaAnimation;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.webkit.CallbackProxy;
import android.webkit.DownloadListener;
import android.webkit.JWebCoreJavaBridge;
import android.webkit.Network;
import android.webkit.PluginFullScreenHolder;
import android.webkit.PluginList;
import android.webkit.URLUtil;
import android.webkit.ViewManager;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebSettings;
import android.webkit.WebTextView;
import android.webkit.WebViewClient;
import android.webkit.WebViewCore;
import android.webkit.WebViewDatabase;
import android.webkit._Original_WebView$1;
import android.webkit._Original_WebView$10;
import android.webkit._Original_WebView$2;
import android.webkit._Original_WebView$3;
import android.webkit._Original_WebView$4;
import android.webkit._Original_WebView$5;
import android.webkit._Original_WebView$6;
import android.webkit._Original_WebView$7;
import android.webkit._Original_WebView$8;
import android.webkit._Original_WebView$9;
import android.webkit._Original_WebView$InvokeListBox$1;
import android.webkit._Original_WebView$InvokeListBox$2;
import android.webkit._Original_WebView$InvokeListBox$3;
import android.webkit._Original_WebView$InvokeListBox$4;
import android.widget.AbsoluteLayout;
import android.widget.Adapter;
import android.widget.ArrayAdapter;
import android.widget.CheckedTextView;
import android.widget.EdgeGlow;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.OverScroller;
import android.widget.Toast;
import android.widget.ZoomButtonsController;
import android.widget.ZoomControls;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _Original_WebView
extends AbsoluteLayout
implements ViewTreeObserver.OnGlobalFocusChangeListener,
ViewGroup.OnHierarchyChangeListener {
    public static final boolean DEBUG_DRAG_TRACKER = false;
    public static final boolean AUTO_REDRAW_HACK = false;
    public boolean mAutoRedraw;
    public static final String LOGTAG = "webview";
    public final CallbackProxy mCallbackProxy;
    public final WebViewDatabase mDatabase;
    public SslCertificate mCertificate;
    public int mNativeClass;
    public WebViewCore mWebViewCore;
    public final Handler mPrivateHandler = new PrivateHandler();
    public WebTextView mWebTextView;
    public int mTextGeneration;
    public final ViewManager mViewManager;
    public PluginFullScreenHolder mFullScreenHolder;
    public float mLastTouchX;
    public float mLastTouchY;
    public long mLastTouchTime;
    public long mLastSentTouchTime;
    public static final int TOUCH_SENT_INTERVAL = 50;
    public int mCurrentTouchInterval = 50;
    public VelocityTracker mVelocityTracker;
    public int mMaximumFling;
    public float mLastVelocity;
    public float mLastVelX;
    public float mLastVelY;
    public int mTouchMode = 7;
    public static final int TOUCH_INIT_MODE = 1;
    public static final int TOUCH_DRAG_START_MODE = 2;
    public static final int TOUCH_DRAG_MODE = 3;
    public static final int TOUCH_SHORTPRESS_START_MODE = 4;
    public static final int TOUCH_SHORTPRESS_MODE = 5;
    public static final int TOUCH_DOUBLE_TAP_MODE = 6;
    public static final int TOUCH_DONE_MODE = 7;
    public static final int TOUCH_PINCH_DRAG = 8;
    public boolean mAllowPanAndScale;
    public boolean mForwardTouchEvents = false;
    public static final int PREVENT_DEFAULT_NO = 0;
    public static final int PREVENT_DEFAULT_MAYBE_YES = 1;
    public static final int PREVENT_DEFAULT_NO_FROM_TOUCH_DOWN = 2;
    public static final int PREVENT_DEFAULT_YES = 3;
    public static final int PREVENT_DEFAULT_IGNORE = 4;
    public int mPreventDefault = 4;
    public boolean mConfirmMove;
    public boolean mDeferTouchProcess;
    public int mDeferTouchMode = 7;
    public float mLastDeferTouchX;
    public float mLastDeferTouchY;
    public boolean mDragFromTextInput;
    public boolean mDrawCursorRing = true;
    public boolean mIsPaused;
    public boolean mDelayedDeleteRootLayer;
    public int mTouchSlopSquare;
    public int mDoubleTapSlopSquare;
    public int mNavSlop;
    public static final int TAP_TIMEOUT = 200;
    public static final int LONG_PRESS_TIMEOUT = 1000;
    public static final int MIN_FLING_TIME = 250;
    public static final int MOTIONLESS_TIME = 100;
    public static final long ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
    public static final int PAGE_SCROLL_OVERLAP = 24;
    public boolean mWidthCanMeasure;
    public boolean mHeightCanMeasure;
    public int mLastWidthSent;
    public int mLastHeightSent;
    public int mContentWidth;
    public int mContentHeight;
    public boolean mOverlayHorizontalScrollbar = true;
    public boolean mOverlayVerticalScrollbar = false;
    public static final int STD_SPEED = 480;
    public static final int MAX_DURATION = 750;
    public static final int SLIDE_TITLE_DURATION = 500;
    public OverScroller mScroller;
    public boolean mInOverScrollMode = false;
    public static Paint mOverScrollBackground;
    public static Paint mOverScrollBorder;
    public boolean mWrapContent;
    public static final int MOTIONLESS_FALSE = 0;
    public static final int MOTIONLESS_PENDING = 1;
    public static final int MOTIONLESS_TRUE = 2;
    public static final int MOTIONLESS_IGNORE = 3;
    public int mHeldMotionless;
    public boolean mSupportMultiTouch;
    public ScaleGestureDetector mScaleDetector;
    public int mAnchorX;
    public int mAnchorY;
    public static final int REMEMBER_PASSWORD = 1;
    public static final int NEVER_REMEMBER_PASSWORD = 2;
    public static final int SWITCH_TO_SHORTPRESS = 3;
    public static final int SWITCH_TO_LONGPRESS = 4;
    public static final int RELEASE_SINGLE_TAP = 5;
    public static final int REQUEST_FORM_DATA = 6;
    public static final int RESUME_WEBCORE_PRIORITY = 7;
    public static final int DRAG_HELD_MOTIONLESS = 8;
    public static final int AWAKEN_SCROLL_BARS = 9;
    public static final int PREVENT_DEFAULT_TIMEOUT = 10;
    public static final int FIRST_PRIVATE_MSG_ID = 1;
    public static final int LAST_PRIVATE_MSG_ID = 10;
    public static final int SCROLL_TO_MSG_ID = 101;
    public static final int SCROLL_BY_MSG_ID = 102;
    public static final int SPAWN_SCROLL_TO_MSG_ID = 103;
    public static final int SYNC_SCROLL_TO_MSG_ID = 104;
    public static final int NEW_PICTURE_MSG_ID = 105;
    public static final int UPDATE_TEXT_ENTRY_MSG_ID = 106;
    public static final int WEBCORE_INITIALIZED_MSG_ID = 107;
    public static final int UPDATE_TEXTFIELD_TEXT_MSG_ID = 108;
    public static final int UPDATE_ZOOM_RANGE = 109;
    public static final int MOVE_OUT_OF_PLUGIN = 110;
    public static final int CLEAR_TEXT_ENTRY = 111;
    public static final int UPDATE_TEXT_SELECTION_MSG_ID = 112;
    public static final int SHOW_RECT_MSG_ID = 113;
    public static final int LONG_PRESS_CENTER = 114;
    public static final int PREVENT_TOUCH_ID = 115;
    public static final int WEBCORE_NEED_TOUCH_EVENTS = 116;
    public static final int INVAL_RECT_MSG_ID = 117;
    public static final int REQUEST_KEYBOARD = 118;
    public static final int DO_MOTION_UP = 119;
    public static final int SHOW_FULLSCREEN = 120;
    public static final int HIDE_FULLSCREEN = 121;
    public static final int DOM_FOCUS_CHANGED = 122;
    public static final int IMMEDIATE_REPAINT_MSG_ID = 123;
    public static final int SET_ROOT_LAYER_MSG_ID = 124;
    public static final int RETURN_LABEL = 125;
    public static final int FIND_AGAIN = 126;
    public static final int CENTER_FIT_RECT = 127;
    public static final int REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID = 128;
    public static final int SET_SCROLLBAR_MODES = 129;
    public static final int FIRST_PACKAGE_MSG_ID = 101;
    public static final int LAST_PACKAGE_MSG_ID = 129;
    public static final String[] HandlerPrivateDebugString;
    public static final String[] HandlerPackageDebugString;
    public static final int DEFAULT_VIEWPORT_WIDTH = 800;
    public static int sMaxViewportWidth;
    public static float DEFAULT_MAX_ZOOM_SCALE;
    public static float DEFAULT_MIN_ZOOM_SCALE;
    public float mMaxZoomScale;
    public float mMinZoomScale;
    public boolean mMinZoomScaleFixed = true;
    public int mInitialScaleInPercent = 0;
    public boolean mInZoomOverview = false;
    public int mZoomOverviewWidth = 800;
    public float mTextWrapScale;
    public static int DEFAULT_SCALE_PERCENT;
    public float mDefaultScale;
    public static float MINIMUM_SCALE_INCREMENT;
    public boolean mPreviewZoomOnly = false;
    public float mActualScale;
    public float mInvActualScale;
    public float mZoomScale;
    public float mInvInitialZoomScale;
    public float mInvFinalZoomScale;
    public int mInitialScrollX;
    public int mInitialScrollY;
    public long mZoomStart;
    public static final int ZOOM_ANIMATION_LENGTH = 500;
    public boolean mUserScroll = false;
    public int mSnapScrollMode = 0;
    public static final int SNAP_NONE = 0;
    public static final int SNAP_LOCK = 1;
    public static final int SNAP_X = 2;
    public static final int SNAP_Y = 4;
    public boolean mSnapPositive;
    public static final int DRAW_EXTRAS_NONE = 0;
    public static final int DRAW_EXTRAS_FIND = 1;
    public static final int DRAW_EXTRAS_SELECTION = 2;
    public static final int DRAW_EXTRAS_CURSOR_RING = 3;
    public static final int SCROLLBAR_AUTO = 0;
    public static final int SCROLLBAR_ALWAYSOFF = 1;
    public static final int SCROLLBAR_ALWAYSON = 2;
    public int mHorizontalScrollBarMode = 0;
    public int mVerticalScrollBarMode = 0;
    public int mOverscrollDistance;
    public int mOverflingDistance;
    public EdgeGlow mEdgeGlowTop;
    public EdgeGlow mEdgeGlowBottom;
    public EdgeGlow mEdgeGlowLeft;
    public EdgeGlow mEdgeGlowRight;
    public int mOverscrollDeltaX;
    public int mOverscrollDeltaY;
    public boolean mGotKeyDown;
    public static boolean mLogEvent;
    public long mLastTouchUpTime = 0L;
    public static final String SCHEME_TEL = "tel:";
    public static final String SCHEME_MAILTO = "mailto:";
    public static final String SCHEME_GEO = "geo:0,0?q=";
    public int mBackgroundColor = -1;
    public PictureListener mPictureListener;
    public ExtendedZoomControls mZoomControls;
    public Runnable mZoomControlRunnable;
    public ZoomButtonsController mZoomButtonsController;
    public float mZoomCenterX;
    public float mZoomCenterY;
    public ZoomButtonsController.OnZoomListener mZoomListener = new _Original_WebView$1(this);
    public View mTitleBar;
    public Drawable mTitleShadow;
    public Rect mLastVisibleRectSent;
    public Rect mLastGlobalRect;
    public boolean mFindIsUp;
    public int mFindHeight;
    public String mLastFind;
    public String mPageThatNeedsToSlideTitleBarOffScreen;
    public int mYDistanceToSlideTitleOffScreen;
    public boolean mNeedToAdjustWebTextView;
    public boolean mDrawHistory = false;
    public Picture mHistoryPicture = null;
    public int mHistoryWidth = 0;
    public int mHistoryHeight = 0;
    public boolean mGotCenterDown = false;
    public int mMinLockSnapReverseDistance;
    public static final float MAX_SLOPE_FOR_DIAG = 1.5f;
    public static final int MIN_BREAK_SNAP_CROSS_DISTANCE = 80;
    public static final int MIN_SCROLL_AMOUNT_TO_DISABLE_DRAG_TRACKER = 4;
    public DragTracker mDragTracker;
    public DragTrackerHandler mDragTrackerHandler;
    public long mTrackballFirstTime = 0L;
    public long mTrackballLastTime = 0L;
    public float mTrackballRemainsX = 0.0f;
    public float mTrackballRemainsY = 0.0f;
    public int mTrackballXMove = 0;
    public int mTrackballYMove = 0;
    public boolean mSelectingText = false;
    public boolean mSelectionStarted = false;
    public boolean mExtendSelection = false;
    public boolean mDrawSelectionPointer = false;
    public static final int TRACKBALL_KEY_TIMEOUT = 1000;
    public static final int TRACKBALL_TIMEOUT = 200;
    public static final int TRACKBALL_WAIT = 100;
    public static final int TRACKBALL_SCALE = 400;
    public static final int TRACKBALL_SCROLL_COUNT = 5;
    public static final int TRACKBALL_MOVE_COUNT = 10;
    public static final int TRACKBALL_MULTIPLIER = 3;
    public static final int SELECT_CURSOR_OFFSET = 16;
    public int mSelectX = 0;
    public int mSelectY = 0;
    public boolean mFocusSizeChanged = false;
    public boolean mShiftIsPressed = false;
    public boolean mTrackballDown = false;
    public long mTrackballUpTime = 0L;
    public long mLastCursorTime = 0L;
    public Rect mLastCursorBounds;
    public boolean mMapTrackballToArrowKeys = true;
    public static final int NO_LEFTEDGE = -1;

    public _Original_WebView(Context context) {
        this(context, null);
    }

    public _Original_WebView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842885);
    }

    public _Original_WebView(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, null);
    }

    public _Original_WebView(Context context, AttributeSet attrs, int defStyle, Map<String, Object> javascriptInterfaces) {
        super(context, attrs, defStyle);
        this.init();
        this.mCallbackProxy = new CallbackProxy(context, this);
        this.mViewManager = new ViewManager(this);
        this.mWebViewCore = new WebViewCore(context, this, this.mCallbackProxy, javascriptInterfaces);
        this.mDatabase = WebViewDatabase.getInstance(context);
        this.mScroller = new OverScroller(context);
        this.updateMultiTouchSupport(context);
    }

    public void updateMultiTouchSupport(Context context) {
        WebSettings settings = this.getSettings();
        PackageManager pm = context.getPackageManager();
        this.mSupportMultiTouch = pm.hasSystemFeature("android.hardware.touchscreen.multitouch") && settings.supportZoom() && settings.getBuiltInZoomControls();
        this.mAllowPanAndScale = pm.hasSystemFeature("android.hardware.touchscreen.multitouch.distinct");
        if (this.mSupportMultiTouch && this.mScaleDetector == null) {
            this.mScaleDetector = new ScaleGestureDetector(context, new ScaleDetectorListener(null));
        } else if (!this.mSupportMultiTouch && this.mScaleDetector != null) {
            this.mScaleDetector = null;
        }
    }

    public void updateZoomButtonsEnabled() {
        boolean canZoomOut;
        if (this.mZoomButtonsController == null) {
            return;
        }
        boolean canZoomIn = this.mActualScale < this.mMaxZoomScale;
        boolean bl = canZoomOut = this.mActualScale > this.mMinZoomScale && !this.mInZoomOverview;
        if (!canZoomIn && !canZoomOut) {
            this.mZoomButtonsController.getZoomControls().setVisibility(8);
        } else {
            this.mZoomButtonsController.setZoomInEnabled(canZoomIn);
            this.mZoomButtonsController.setZoomOutEnabled(canZoomOut);
        }
    }

    public void init() {
        this.setWillNotDraw(false);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setClickable(true);
        this.setLongClickable(true);
        ViewConfiguration configuration = ViewConfiguration.get(this.getContext());
        int slop = configuration.getScaledTouchSlop();
        this.mTouchSlopSquare = slop * slop;
        this.mMinLockSnapReverseDistance = slop;
        slop = configuration.getScaledDoubleTapSlop();
        this.mDoubleTapSlopSquare = slop * slop;
        float density = this.getContext().getResources().getDisplayMetrics().density;
        this.mNavSlop = (int)(16.0f * density);
        DEFAULT_SCALE_PERCENT = (int)(100.0f * density);
        this.mDefaultScale = density;
        this.mActualScale = density;
        this.mInvActualScale = 1.0f / density;
        this.mTextWrapScale = density;
        DEFAULT_MAX_ZOOM_SCALE = 4.0f * density;
        DEFAULT_MIN_ZOOM_SCALE = 0.25f * density;
        this.mMaxZoomScale = DEFAULT_MAX_ZOOM_SCALE;
        this.mMinZoomScale = DEFAULT_MIN_ZOOM_SCALE;
        this.mMaximumFling = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
    }

    @Override
    public void setOverScrollMode(int mode) {
        super.setOverScrollMode(mode);
        if (mode != 2) {
            if (this.mEdgeGlowTop == null) {
                Resources res = this.getContext().getResources();
                Drawable edge = res.getDrawable(17302072);
                Drawable glow = res.getDrawable(17302073);
                this.mEdgeGlowTop = new EdgeGlow(edge, glow);
                this.mEdgeGlowBottom = new EdgeGlow(edge, glow);
                this.mEdgeGlowLeft = new EdgeGlow(edge, glow);
                this.mEdgeGlowRight = new EdgeGlow(edge, glow);
            }
        } else {
            this.mEdgeGlowTop = null;
            this.mEdgeGlowBottom = null;
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
    }

    public void updateDefaultZoomDensity(int zoomDensity) {
        float density = this.getContext().getResources().getDisplayMetrics().density * 100.0f / (float)zoomDensity;
        if ((double)Math.abs(density - this.mDefaultScale) > 0.01) {
            float scaleFactor = density / this.mDefaultScale;
            this.mNavSlop = (int)(16.0f * density);
            DEFAULT_SCALE_PERCENT = (int)(100.0f * density);
            DEFAULT_MAX_ZOOM_SCALE = 4.0f * density;
            DEFAULT_MIN_ZOOM_SCALE = 0.25f * density;
            this.mDefaultScale = density;
            this.mMaxZoomScale *= scaleFactor;
            this.mMinZoomScale *= scaleFactor;
            this.setNewZoomScale(this.mActualScale * scaleFactor, true, false);
        }
    }

    public boolean onSavePassword(String schemePlusHost, String username, String password, Message resumeMsg) {
        boolean rVal = false;
        if (resumeMsg == null) {
            this.mDatabase.setUsernamePassword(schemePlusHost, username, password);
        } else {
            Message remember = this.mPrivateHandler.obtainMessage(1);
            remember.getData().putString("host", schemePlusHost);
            remember.getData().putString("username", username);
            remember.getData().putString("password", password);
            remember.obj = resumeMsg;
            Message neverRemember = this.mPrivateHandler.obtainMessage(2);
            neverRemember.getData().putString("host", schemePlusHost);
            neverRemember.getData().putString("username", username);
            neverRemember.getData().putString("password", password);
            neverRemember.obj = resumeMsg;
            new AlertDialog.Builder(this.getContext()).setTitle(17040061).setMessage(17040071).setPositiveButton(17040072, (DialogInterface.OnClickListener)new _Original_WebView$5(this, resumeMsg)).setNeutralButton(17040073, (DialogInterface.OnClickListener)new _Original_WebView$4(this, remember)).setNegativeButton(17040074, (DialogInterface.OnClickListener)new _Original_WebView$3(this, neverRemember)).setOnCancelListener(new _Original_WebView$2(this, resumeMsg)).show();
            rVal = true;
        }
        return rVal;
    }

    @Override
    public void setScrollBarStyle(int style2) {
        if (style2 == 0x1000000 || style2 == 0x3000000) {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        } else {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        }
        super.setScrollBarStyle(style2);
    }

    public void setHorizontalScrollbarOverlay(boolean overlay) {
        this.mOverlayHorizontalScrollbar = overlay;
    }

    public void setVerticalScrollbarOverlay(boolean overlay) {
        this.mOverlayVerticalScrollbar = overlay;
    }

    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    public int getViewWidth() {
        if (!this.isVerticalScrollBarEnabled() || this.mOverlayVerticalScrollbar) {
            return this.getWidth();
        }
        return this.getWidth() - this.getVerticalScrollbarWidth();
    }

    public int getTitleHeight() {
        return this.mTitleBar != null ? this.mTitleBar.getHeight() : 0;
    }

    public int getVisibleTitleHeight() {
        return Math.max(this.getTitleHeight() - Math.max(0, this.mScrollY), 0);
    }

    public int getViewHeight() {
        return this.getViewHeightWithTitle() - this.getVisibleTitleHeight();
    }

    public int getViewHeightWithTitle() {
        int height = this.getHeight();
        if (this.isHorizontalScrollBarEnabled() && !this.mOverlayHorizontalScrollbar) {
            height -= this.getHorizontalScrollbarHeight();
        }
        return height;
    }

    public SslCertificate getCertificate() {
        return this.mCertificate;
    }

    public void setCertificate(SslCertificate certificate) {
        this.mCertificate = certificate;
    }

    public void savePassword(String host, String username, String password) {
        this.mDatabase.setUsernamePassword(host, username, password);
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.mDatabase.setHttpAuthUsernamePassword(host, realm, username, password);
    }

    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        return this.mDatabase.getHttpAuthUsernamePassword(host, realm);
    }

    public void clearHelpers() {
        this.clearTextEntry(false);
        this.selectionDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.clearHelpers();
        if (this.mWebViewCore != null) {
            this.mCallbackProxy.setWebViewClient(null);
            this.mCallbackProxy.setWebChromeClient(null);
            Object object = this;
            synchronized (object) {
                WebViewCore webViewCore = this.mWebViewCore;
                this.mWebViewCore = null;
                webViewCore.destroy();
            }
            this.mPrivateHandler.removeCallbacksAndMessages(null);
            this.mCallbackProxy.removeCallbacksAndMessages(null);
            object = this.mCallbackProxy;
            synchronized (object) {
                this.mCallbackProxy.notify();
            }
        }
        if (this.mNativeClass != 0) {
            this.nativeDestroy();
            this.mNativeClass = 0;
        }
    }

    public static void enablePlatformNotifications() {
        Network.enablePlatformNotifications();
    }

    public static void disablePlatformNotifications() {
        Network.disablePlatformNotifications();
    }

    public void setJsFlags(String flags) {
        this.mWebViewCore.sendMessage(174, flags);
    }

    public void setNetworkAvailable(boolean networkUp) {
        this.mWebViewCore.sendMessage(119, networkUp ? 1 : 0, 0);
    }

    public void setNetworkType(String type, String subtype) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", type);
        map.put("subtype", subtype);
        this.mWebViewCore.sendMessage(183, map);
    }

    public WebBackForwardList saveState(Bundle outState) {
        if (outState == null) {
            return null;
        }
        WebBackForwardList list = this.copyBackForwardList();
        int currentIndex = list.getCurrentIndex();
        int size = list.getSize();
        if (currentIndex < 0 || currentIndex >= size || size == 0) {
            return null;
        }
        outState.putInt("index", currentIndex);
        ArrayList<byte[]> history = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            WebHistoryItem item = list.getItemAtIndex(i);
            if (null == item) {
                Log.w(LOGTAG, "saveState: Unexpected null history item.");
                return null;
            }
            byte[] data = item.getFlattenedData();
            if (data == null) {
                return null;
            }
            history.add(data);
        }
        outState.putSerializable("history", history);
        if (this.mCertificate != null) {
            outState.putBundle("certificate", SslCertificate.saveState(this.mCertificate));
        }
        return list;
    }

    public boolean savePicture(Bundle b, File dest) {
        if (dest == null || b == null) {
            return false;
        }
        Picture p = this.capturePicture();
        File temp = new File(dest.getPath() + ".writing");
        new Thread(new _Original_WebView$6(this, temp, p, dest)).start();
        b.putInt("scrollX", this.mScrollX);
        b.putInt("scrollY", this.mScrollY);
        b.putFloat("scale", this.mActualScale);
        b.putFloat("textwrapScale", this.mTextWrapScale);
        b.putBoolean("overview", this.mInZoomOverview);
        return true;
    }

    public void restoreHistoryPictureFields(Picture p, Bundle b) {
        int sx = b.getInt("scrollX", 0);
        int sy = b.getInt("scrollY", 0);
        float scale = b.getFloat("scale", 1.0f);
        this.mDrawHistory = true;
        this.mHistoryPicture = p;
        this.mScrollX = sx;
        this.mScrollY = sy;
        this.mHistoryWidth = Math.round((float)p.getWidth() * scale);
        this.mHistoryHeight = Math.round((float)p.getHeight() * scale);
        this.mActualScale = scale;
        this.mInvActualScale = 1.0f / scale;
        this.mTextWrapScale = b.getFloat("textwrapScale", scale);
        this.mInZoomOverview = b.getBoolean("overview");
        this.invalidate();
    }

    public boolean restorePicture(Bundle b, File src) {
        if (src == null || b == null) {
            return false;
        }
        if (!src.exists()) {
            return false;
        }
        try {
            FileInputStream in = new FileInputStream(src);
            Bundle copy = new Bundle(b);
            new Thread(new _Original_WebView$7(this, in, copy)).start();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebBackForwardList restoreState(Bundle inState) {
        WebBackForwardList returnList = null;
        if (inState == null) {
            return returnList;
        }
        if (inState.containsKey("index") && inState.containsKey("history")) {
            this.mCertificate = SslCertificate.restoreState(inState.getBundle("certificate"));
            WebBackForwardList list = this.mCallbackProxy.getBackForwardList();
            int index = inState.getInt("index");
            WebBackForwardList webBackForwardList = list;
            synchronized (webBackForwardList) {
                List history = (List)((Object)inState.getSerializable("history"));
                int size = history.size();
                if (index < 0 || index >= size) {
                    return null;
                }
                for (int i = 0; i < size; ++i) {
                    byte[] data = (byte[])history.remove(0);
                    if (data == null) {
                        return null;
                    }
                    WebHistoryItem item = new WebHistoryItem(data);
                    list.addHistoryItem(item);
                }
                returnList = this.copyBackForwardList();
                returnList.setCurrentIndex(index);
            }
            this.mWebViewCore.removeMessages();
            this.mWebViewCore.sendMessage(108, index);
        }
        return returnList;
    }

    public void loadUrl(String url, Map<String, String> extraHeaders) {
        this.switchOutDrawHistory();
        WebViewCore.GetUrlData arg = new WebViewCore.GetUrlData();
        arg.mUrl = url;
        arg.mExtraHeaders = extraHeaders;
        this.mWebViewCore.sendMessage(100, arg);
        this.clearHelpers();
    }

    public void loadUrl(String url) {
        if (url == null) {
            return;
        }
        this.loadUrl(url, null);
    }

    public void postUrl(String url, byte[] postData) {
        if (URLUtil.isNetworkUrl(url)) {
            this.switchOutDrawHistory();
            WebViewCore.PostUrlData arg = new WebViewCore.PostUrlData();
            arg.mUrl = url;
            arg.mPostData = postData;
            this.mWebViewCore.sendMessage(132, arg);
            this.clearHelpers();
        } else {
            this.loadUrl(url);
        }
    }

    public void loadData(String data, String mimeType, String encoding) {
        this.loadUrl("data:" + mimeType + ";" + encoding + "," + data);
    }

    public void loadDataWithBaseURL(String baseUrl, String data, String mimeType, String encoding, String historyUrl) {
        if (baseUrl != null && baseUrl.toLowerCase().startsWith("data:")) {
            this.loadData(data, mimeType, encoding);
            return;
        }
        this.switchOutDrawHistory();
        WebViewCore.BaseUrlData arg = new WebViewCore.BaseUrlData();
        arg.mBaseUrl = baseUrl;
        arg.mData = data;
        arg.mMimeType = mimeType;
        arg.mEncoding = encoding;
        arg.mHistoryUrl = historyUrl;
        this.mWebViewCore.sendMessage(139, arg);
        this.clearHelpers();
    }

    public void stopLoading() {
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(101);
    }

    public void reload() {
        this.clearHelpers();
        this.switchOutDrawHistory();
        this.mWebViewCore.sendMessage(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBack() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() > 0;
        }
    }

    public void goBack() {
        this.goBackOrForward(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoForward() {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            return l.getCurrentIndex() < l.getSize() - 1;
        }
    }

    public void goForward() {
        this.goBackOrForward(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canGoBackOrForward(int steps) {
        WebBackForwardList l;
        WebBackForwardList webBackForwardList = l = this.mCallbackProxy.getBackForwardList();
        synchronized (webBackForwardList) {
            if (l.getClearPending()) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
            int newIndex = l.getCurrentIndex() + steps;
            return newIndex >= 0 && newIndex < l.getSize();
        }
    }

    public void goBackOrForward(int steps) {
        this.goBackOrForward(steps, false);
    }

    public void goBackOrForward(int steps, boolean ignoreSnapshot) {
        if (steps != 0) {
            this.clearHelpers();
            this.mWebViewCore.sendMessage(106, steps, ignoreSnapshot ? 1 : 0);
        }
    }

    public boolean extendScroll(int y) {
        int finalY = this.mScroller.getFinalY();
        int newY = this.pinLocY(finalY + y);
        if (newY == finalY) {
            return false;
        }
        this.mScroller.setFinalY(newY);
        this.mScroller.extendDuration(_Original_WebView.computeDuration(0, y));
        return true;
    }

    public boolean pageUp(boolean top) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (top) {
            return this.pinScrollTo(this.mScrollX, 0, true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? -h + 24 : -h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public boolean pageDown(boolean bottom) {
        if (this.mNativeClass == 0) {
            return false;
        }
        this.nativeClearCursor();
        if (bottom) {
            return this.pinScrollTo(this.mScrollX, this.computeRealVerticalScrollRange(), true, 0);
        }
        int h = this.getHeight();
        int y = h > 48 ? h - 24 : h / 2;
        this.mUserScroll = true;
        return this.mScroller.isFinished() ? this.pinScrollBy(0, y, true, 0) : this.extendScroll(y);
    }

    public void clearView() {
        this.mContentWidth = 0;
        this.mContentHeight = 0;
        this.mWebViewCore.sendMessage(134);
    }

    public Picture capturePicture() {
        if (null == this.mWebViewCore) {
            return null;
        }
        return this.mWebViewCore.copyContentPicture();
    }

    public boolean inEditingMode() {
        return this.mWebTextView != null && this.mWebTextView.getParent() != null;
    }

    public void clearTextEntry(boolean disableFocusController) {
        if (this.inEditingMode()) {
            this.mWebTextView.remove();
            if (disableFocusController) {
                this.setFocusControllerInactive();
            }
        }
    }

    public float getScale() {
        return this.mActualScale;
    }

    public void setInitialScale(int scaleInPercent) {
        this.mInitialScaleInPercent = scaleInPercent;
    }

    public void invokeZoomPicker() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return;
        }
        this.clearTextEntry(false);
        if (this.getSettings().getBuiltInZoomControls()) {
            this.getZoomButtonsController().setVisible(true);
        } else {
            this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
            this.mPrivateHandler.postDelayed(this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
        }
    }

    public HitTestResult getHitTestResult() {
        int contentY;
        int contentX;
        String text;
        int type;
        if (this.mNativeClass == 0) {
            return null;
        }
        HitTestResult result = new HitTestResult();
        if (this.nativeHasCursorNode()) {
            if (this.nativeCursorIsTextInput()) {
                result.setType(9);
            } else {
                String text2 = this.nativeCursorText();
                if (text2 != null) {
                    if (text2.startsWith(SCHEME_TEL)) {
                        result.setType(2);
                        result.setExtra(text2.substring(SCHEME_TEL.length()));
                    } else if (text2.startsWith(SCHEME_MAILTO)) {
                        result.setType(4);
                        result.setExtra(text2.substring(SCHEME_MAILTO.length()));
                    } else if (text2.startsWith(SCHEME_GEO)) {
                        result.setType(3);
                        result.setExtra(URLDecoder.decode(text2.substring(SCHEME_GEO.length())));
                    } else if (this.nativeCursorIsAnchor()) {
                        result.setType(7);
                        result.setExtra(text2);
                    }
                }
            }
        }
        if (((type = result.getType()) == 0 || type == 7) && (text = this.nativeImageURI(contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX), contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY))) != null) {
            result.setType(type == 0 ? 5 : 8);
            result.setExtra(text);
        }
        return result;
    }

    public void domChangedFocus() {
        if (this.inEditingMode()) {
            this.mPrivateHandler.obtainMessage(122).sendToTarget();
        }
    }

    public void requestFocusNodeHref(Message hrefMsg) {
        if (hrefMsg == null || this.mNativeClass == 0) {
            return;
        }
        if (this.nativeCursorIsAnchor()) {
            this.mWebViewCore.sendMessage(137, this.nativeCursorFramePointer(), this.nativeCursorNodePointer(), hrefMsg);
        }
    }

    public void requestImageRef(Message msg) {
        if (0 == this.mNativeClass) {
            return;
        }
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        String ref = this.nativeImageURI(contentX, contentY);
        Bundle data = msg.getData();
        data.putString("url", ref);
        msg.setData(data);
        msg.sendToTarget();
    }

    public static int pinLoc(int x, int viewMax, int docMax) {
        if (docMax < viewMax) {
            x = 0;
        } else if (x < 0) {
            x = 0;
        } else if (x + viewMax > docMax) {
            x = docMax - viewMax;
        }
        return x;
    }

    public int pinLocX(int x) {
        if (this.mInOverScrollMode) {
            return x;
        }
        return _Original_WebView.pinLoc(x, this.getViewWidth(), this.computeRealHorizontalScrollRange());
    }

    public int pinLocY(int y) {
        if (this.mInOverScrollMode) {
            return y;
        }
        return _Original_WebView.pinLoc(y, this.getViewHeightWithTitle(), this.computeRealVerticalScrollRange() + this.getTitleHeight());
    }

    public void setEmbeddedTitleBar(View v) {
        if (this.mTitleBar == v) {
            return;
        }
        if (this.mTitleBar != null) {
            this.removeView(this.mTitleBar);
        }
        if (null != v) {
            this.addView(v, new AbsoluteLayout.LayoutParams(-1, -2, 0, 0));
            if (this.mTitleShadow == null) {
                this.mTitleShadow = this.mContext.getResources().getDrawable(17302329);
            }
        }
        this.mTitleBar = v;
    }

    public int viewToContentDimension(int d) {
        return Math.round((float)d * this.mInvActualScale);
    }

    public int viewToContentX(int x) {
        return this.viewToContentDimension(x);
    }

    public int viewToContentY(int y) {
        return this.viewToContentDimension(y - this.getTitleHeight());
    }

    public float viewToContentXf(int x) {
        return (float)x * this.mInvActualScale;
    }

    public float viewToContentYf(int y) {
        return (float)(y - this.getTitleHeight()) * this.mInvActualScale;
    }

    public int contentToViewDimension(int d) {
        return Math.round((float)d * this.mActualScale);
    }

    public int contentToViewX(int x) {
        return this.contentToViewDimension(x);
    }

    public int contentToViewY(int y) {
        return this.contentToViewDimension(y) + this.getTitleHeight();
    }

    public Rect contentToViewRect(Rect x) {
        return new Rect(this.contentToViewX(x.left), this.contentToViewY(x.top), this.contentToViewX(x.right), this.contentToViewY(x.bottom));
    }

    public void viewInvalidate(int l, int t, int r, int b) {
        float scale = this.mActualScale;
        int dy = this.getTitleHeight();
        this.invalidate((int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    public void viewInvalidateDelayed(long delay, int l, int t, int r, int b) {
        float scale = this.mActualScale;
        int dy = this.getTitleHeight();
        this.postInvalidateDelayed(delay, (int)Math.floor((float)l * scale), (int)Math.floor((float)t * scale) + dy, (int)Math.ceil((float)r * scale), (int)Math.ceil((float)b * scale) + dy);
    }

    public void invalidateContentRect(Rect r) {
        this.viewInvalidate(r.left, r.top, r.right, r.bottom);
    }

    public void abortAnimation() {
        this.mScroller.abortAnimation();
        this.mLastVelocity = 0.0f;
    }

    public void recordNewContentSize(int w, int h, boolean updateLayout) {
        if ((w | h) == 0) {
            return;
        }
        if (this.mContentWidth != w || this.mContentHeight != h) {
            this.mContentWidth = w;
            this.mContentHeight = h;
            if (!this.mDrawHistory) {
                int oldX = this.mScrollX;
                int oldY = this.mScrollY;
                this.mScrollX = this.pinLocX(this.mScrollX);
                this.mScrollY = this.pinLocY(this.mScrollY);
                if (oldX != this.mScrollX || oldY != this.mScrollY) {
                    this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.setFinalX(this.pinLocX(this.mScroller.getFinalX()));
                    this.mScroller.setFinalY(this.pinLocY(this.mScroller.getFinalY()));
                }
            }
        }
        this.contentSizeChanged(updateLayout);
    }

    public void setNewZoomScale(float scale, boolean updateTextWrapScale, boolean force) {
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
            if (scale < this.mDefaultScale) {
                this.mInZoomOverview = true;
            }
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        if (updateTextWrapScale) {
            this.mTextWrapScale = scale;
            this.mLastHeightSent = 0;
        }
        if (scale != this.mActualScale || force) {
            if (this.mDrawHistory) {
                if (scale != this.mActualScale && !this.mPreviewZoomOnly) {
                    this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
                }
                this.mActualScale = scale;
                this.mInvActualScale = 1.0f / scale;
                this.sendViewSizeZoom();
            } else {
                int oldX = this.mScrollX;
                int oldY = this.mScrollY;
                float ratio = scale * this.mInvActualScale;
                float sx = ratio * (float)oldX + (ratio - 1.0f) * this.mZoomCenterX;
                float sy = ratio * (float)oldY + (ratio - 1.0f) * (this.mZoomCenterY - (float)this.getTitleHeight());
                if (scale != this.mActualScale && !this.mPreviewZoomOnly) {
                    this.mCallbackProxy.onScaleChanged(this.mActualScale, scale);
                }
                this.mActualScale = scale;
                this.mInvActualScale = 1.0f / scale;
                this.mViewManager.scaleAll();
                this.mScrollX = this.pinLocX(Math.round(sx));
                this.mScrollY = this.pinLocY(Math.round(sy));
                if (oldX != this.mScrollX || oldY != this.mScrollY) {
                    this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                } else {
                    this.sendOurVisibleRect();
                }
                this.sendViewSizeZoom();
            }
        }
    }

    public Rect sendOurVisibleRect() {
        Rect globalRect;
        if (this.mPreviewZoomOnly) {
            return this.mLastVisibleRectSent;
        }
        Rect rect = new Rect();
        this.calcOurContentVisibleRect(rect);
        if (!rect.equals(this.mLastVisibleRectSent)) {
            Point pos = new Point(rect.left, rect.top);
            this.mWebViewCore.sendMessage(107, this.nativeMoveGeneration(), 0, pos);
            this.mLastVisibleRectSent = rect;
        }
        if (this.getGlobalVisibleRect(globalRect = new Rect()) && !globalRect.equals(this.mLastGlobalRect)) {
            this.mWebViewCore.sendMessage(116, globalRect);
            this.mLastGlobalRect = globalRect;
        }
        return rect;
    }

    public void calcOurVisibleRect(Rect r) {
        Point p = new Point();
        this.getGlobalVisibleRect(r, p);
        r.offset(-p.x, -p.y);
        if (this.mFindIsUp) {
            r.bottom -= this.mFindHeight;
        }
    }

    public void calcOurContentVisibleRect(Rect r) {
        this.calcOurVisibleRect(r);
        r.left = Math.max(this.viewToContentX(r.left), 0);
        r.top = Math.max(this.viewToContentY(r.top + this.getVisibleTitleHeight()), 0);
        r.right = Math.min(this.viewToContentX(r.right), this.mContentWidth);
        r.bottom = Math.min(this.viewToContentY(r.bottom), this.mContentHeight);
    }

    public void calcOurContentVisibleRectF(RectF r) {
        Rect ri = new Rect(0, 0, 0, 0);
        this.calcOurVisibleRect(ri);
        r.left = Math.max(this.viewToContentXf(ri.left), 0.0f);
        r.top = Math.max(this.viewToContentYf(ri.top + this.getVisibleTitleHeight()), 0.0f);
        r.right = Math.min(this.viewToContentXf(ri.right), (float)this.mContentWidth);
        r.bottom = Math.min(this.viewToContentYf(ri.bottom), (float)this.mContentHeight);
    }

    public boolean sendViewSizeZoom() {
        if (this.mPreviewZoomOnly) {
            return false;
        }
        int viewWidth = this.getViewWidth();
        int newWidth = Math.round((float)viewWidth * this.mInvActualScale);
        int newHeight = Math.round((float)this.getViewHeight() * this.mInvActualScale);
        if (newWidth > this.mLastWidthSent && this.mWrapContent) {
            newHeight = 0;
        }
        if (newWidth != this.mLastWidthSent || newHeight != this.mLastHeightSent) {
            ViewSizeData data = new ViewSizeData();
            data.mWidth = newWidth;
            data.mHeight = newHeight;
            data.mTextWrapWidth = Math.round((float)viewWidth / this.mTextWrapScale);
            data.mScale = this.mActualScale;
            data.mIgnoreHeight = this.mZoomScale != 0.0f && !this.mHeightCanMeasure;
            data.mAnchorX = this.mAnchorX;
            data.mAnchorY = this.mAnchorY;
            this.mWebViewCore.sendMessage(105, data);
            this.mLastWidthSent = newWidth;
            this.mLastHeightSent = newHeight;
            this.mAnchorY = 0;
            this.mAnchorX = 0;
            return true;
        }
        return false;
    }

    public int computeRealHorizontalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryWidth;
        }
        if (this.mHorizontalScrollBarMode == 1 && this.mActualScale - this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT) {
            return this.computeHorizontalScrollExtent();
        }
        return (int)Math.floor((float)this.mContentWidth * this.mActualScale);
    }

    @Override
    public int computeHorizontalScrollRange() {
        int range = this.computeRealHorizontalScrollRange();
        int scrollX = this.mScrollX;
        int overscrollRight = this.computeMaxScrollX();
        if (scrollX < 0) {
            range -= scrollX;
        } else if (scrollX > overscrollRight) {
            range += scrollX - overscrollRight;
        }
        return range;
    }

    @Override
    public int computeHorizontalScrollOffset() {
        return Math.max(this.mScrollX, 0);
    }

    public int computeRealVerticalScrollRange() {
        if (this.mDrawHistory) {
            return this.mHistoryHeight;
        }
        if (this.mVerticalScrollBarMode == 1 && this.mActualScale - this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT) {
            return this.computeVerticalScrollExtent();
        }
        return (int)Math.floor((float)this.mContentHeight * this.mActualScale);
    }

    @Override
    public int computeVerticalScrollRange() {
        int range = this.computeRealVerticalScrollRange();
        int scrollY = this.mScrollY;
        int overscrollBottom = this.computeMaxScrollY();
        if (scrollY < 0) {
            range -= scrollY;
        } else if (scrollY > overscrollBottom) {
            range += scrollY - overscrollBottom;
        }
        return range;
    }

    @Override
    public int computeVerticalScrollOffset() {
        return Math.max(this.mScrollY - this.getTitleHeight(), 0);
    }

    @Override
    public int computeVerticalScrollExtent() {
        return this.getViewHeight();
    }

    @Override
    public void onDrawVerticalScrollBar(Canvas canvas, Drawable scrollBar, int l, int t, int r, int b) {
        if (this.mScrollY < 0) {
            t -= this.mScrollY;
        }
        scrollBar.setBounds(l, t + this.getVisibleTitleHeight(), r, b);
        scrollBar.draw(canvas);
    }

    @Override
    public void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        this.mInOverScrollMode = false;
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        if (maxX == 0) {
            scrollX = this.pinLocX(scrollX);
        } else if (scrollX < 0 || scrollX > maxX) {
            this.mInOverScrollMode = true;
        }
        if (scrollY < 0 || scrollY > maxY) {
            this.mInOverScrollMode = true;
        }
        int oldX = this.mScrollX;
        int oldY = this.mScrollY;
        super.scrollTo(scrollX, scrollY);
        if (this.mEdgeGlowTop != null && oldY == this.mScrollY && oldX == this.mScrollX) {
            if (maxX > 0) {
                int pulledToX = oldX + this.mOverscrollDeltaX;
                if (pulledToX < 0) {
                    this.mEdgeGlowLeft.onPull((float)this.mOverscrollDeltaX / (float)this.getWidth());
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (pulledToX > maxX) {
                    this.mEdgeGlowRight.onPull((float)this.mOverscrollDeltaX / (float)this.getWidth());
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                this.mOverscrollDeltaX = 0;
            }
            if (maxY > 0 || this.getOverScrollMode() == 0) {
                int pulledToY = oldY + this.mOverscrollDeltaY;
                if (pulledToY < 0) {
                    this.mEdgeGlowTop.onPull((float)this.mOverscrollDeltaY / (float)this.getHeight());
                    if (!this.mEdgeGlowBottom.isFinished()) {
                        this.mEdgeGlowBottom.onRelease();
                    }
                } else if (pulledToY > maxY) {
                    this.mEdgeGlowBottom.onPull((float)this.mOverscrollDeltaY / (float)this.getHeight());
                    if (!this.mEdgeGlowTop.isFinished()) {
                        this.mEdgeGlowTop.onRelease();
                    }
                }
                this.mOverscrollDeltaY = 0;
            }
        }
    }

    public String getUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getUrl() : null;
    }

    public String getOriginalUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getOriginalUrl() : null;
    }

    public String getTitle() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTitle() : null;
    }

    public Bitmap getFavicon() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getFavicon() : null;
    }

    public String getTouchIconUrl() {
        WebHistoryItem h = this.mCallbackProxy.getBackForwardList().getCurrentItem();
        return h != null ? h.getTouchIconUrl() : null;
    }

    public int getProgress() {
        return this.mCallbackProxy.getProgress();
    }

    public int getContentHeight() {
        return this.mContentHeight;
    }

    public int getContentWidth() {
        return this.mContentWidth;
    }

    public void pauseTimers() {
        this.mWebViewCore.sendMessage(109);
    }

    public void resumeTimers() {
        this.mWebViewCore.sendMessage(110);
    }

    public void onPause() {
        if (!this.mIsPaused) {
            this.mIsPaused = true;
            this.mWebViewCore.sendMessage(143);
        }
    }

    public void onResume() {
        if (this.mIsPaused) {
            this.mIsPaused = false;
            this.mWebViewCore.sendMessage(144);
        }
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public void freeMemory() {
        this.mWebViewCore.sendMessage(145);
    }

    public void clearCache(boolean includeDiskFiles) {
        this.mWebViewCore.sendMessage(111, includeDiskFiles ? 1 : 0, 0);
    }

    public void clearFormData() {
        if (this.inEditingMode()) {
            WebTextView.AutoCompleteAdapter adapter = null;
            this.mWebTextView.setAdapterCustom(adapter);
        }
    }

    public void clearHistory() {
        this.mCallbackProxy.getBackForwardList().setClearPending();
        this.mWebViewCore.sendMessage(112);
    }

    public void clearSslPreferences() {
        this.mWebViewCore.sendMessage(150);
    }

    public WebBackForwardList copyBackForwardList() {
        return this.mCallbackProxy.getBackForwardList().clone();
    }

    public void findNext(boolean forward) {
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeFindNext(forward);
    }

    public int findAll(String find) {
        if (0 == this.mNativeClass) {
            return 0;
        }
        int result = find != null ? this.nativeFindAll(find.toLowerCase(), find.toUpperCase()) : 0;
        this.invalidate();
        this.mLastFind = find;
        return result;
    }

    public void setFindIsUp(boolean isUp) {
        this.mFindIsUp = isUp;
        if (isUp) {
            this.recordNewContentSize(this.mContentWidth, this.mContentHeight + this.mFindHeight, false);
        }
        if (0 == this.mNativeClass) {
            return;
        }
        this.nativeSetFindIsUp(isUp);
    }

    public int findIndex() {
        if (0 == this.mNativeClass) {
            return -1;
        }
        return this.nativeFindIndex();
    }

    public static String findAddress(String addr) {
        return _Original_WebView.findAddress(addr, false);
    }

    public static String findAddress(String addr, boolean caseInsensitive) {
        return WebViewCore.nativeFindAddress(addr, caseInsensitive);
    }

    public void clearMatches() {
        this.mLastFind = "";
        if (this.mNativeClass == 0) {
            return;
        }
        this.nativeSetFindIsEmpty();
        this.invalidate();
    }

    public void notifyFindDialogDismissed() {
        if (this.mWebViewCore == null) {
            return;
        }
        this.clearMatches();
        this.setFindIsUp(false);
        this.recordNewContentSize(this.mContentWidth, this.mContentHeight - this.mFindHeight, false);
        this.pinScrollTo(this.mScrollX, this.mScrollY, false, 0);
        this.invalidate();
    }

    public void setFindDialogHeight(int height) {
        this.mFindHeight = height;
    }

    public void documentHasImages(Message response) {
        if (response == null) {
            return;
        }
        this.mWebViewCore.sendMessage(120, response);
    }

    @Override
    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            this.invalidate();
            if (oldX != x || oldY != y) {
                int rangeX = this.computeMaxScrollX();
                int rangeY = this.computeMaxScrollY();
                this.overScrollBy(x - oldX, y - oldY, oldX, oldY, rangeX, rangeY, this.mOverflingDistance, this.mOverflingDistance, false);
                if (this.mEdgeGlowTop != null) {
                    if (rangeY > 0 || this.getOverScrollMode() == 0) {
                        if (y < 0 && oldY >= 0) {
                            this.mEdgeGlowTop.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowBottom.isFinished()) {
                                this.mEdgeGlowBottom.onRelease();
                            }
                        } else if (y > rangeY && oldY <= rangeY) {
                            this.mEdgeGlowBottom.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowTop.isFinished()) {
                                this.mEdgeGlowTop.onRelease();
                            }
                        }
                    }
                    if (rangeX > 0) {
                        if (x < 0 && oldX >= 0) {
                            this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowRight.isFinished()) {
                                this.mEdgeGlowRight.onRelease();
                            }
                        } else if (x > rangeX && oldX <= rangeX) {
                            this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                            if (!this.mEdgeGlowLeft.isFinished()) {
                                this.mEdgeGlowLeft.onRelease();
                            }
                        }
                    }
                }
            }
            if (this.mScroller.isFinished()) {
                this.mPrivateHandler.sendEmptyMessage(7);
            }
        } else {
            super.computeScroll();
        }
    }

    public static int computeDuration(int dx, int dy) {
        int distance = Math.max(Math.abs(dx), Math.abs(dy));
        int duration = distance * 1000 / 480;
        return Math.min(duration, 750);
    }

    public boolean pinScrollBy(int dx, int dy, boolean animate, int animationDuration) {
        return this.pinScrollTo(this.mScrollX + dx, this.mScrollY + dy, animate, animationDuration);
    }

    public boolean pinScrollTo(int x, int y, boolean animate, int animationDuration) {
        int dy;
        int dx = (x = this.pinLocX(x)) - this.mScrollX;
        if ((dx | (dy = (y = this.pinLocY(y)) - this.mScrollY)) == 0) {
            return false;
        }
        if (animate) {
            this.mScroller.startScroll(this.mScrollX, this.mScrollY, dx, dy, animationDuration > 0 ? animationDuration : _Original_WebView.computeDuration(dx, dy));
            this.awakenScrollBars(this.mScroller.getDuration());
            this.invalidate();
        } else {
            this.abortAnimation();
            this.scrollTo(x, y);
        }
        return true;
    }

    public boolean setContentScrollBy(int cx, int cy, boolean animate) {
        if (this.mDrawHistory) {
            return false;
        }
        cx = this.contentToViewDimension(cx);
        cy = this.contentToViewDimension(cy);
        if (this.mHeightCanMeasure) {
            if (cy != 0) {
                Rect tempRect = new Rect();
                this.calcOurVisibleRect(tempRect);
                tempRect.offset(cx, cy);
                this.requestRectangleOnScreen(tempRect);
            }
            return cy == 0 && cx != 0 && this.pinScrollBy(cx, 0, animate, 0);
        }
        return this.pinScrollBy(cx, cy, animate, 0);
    }

    public void onPageFinished(String url) {
        if (this.mPageThatNeedsToSlideTitleBarOffScreen != null) {
            if (this.mPageThatNeedsToSlideTitleBarOffScreen.equals(url) && this.mScrollX == 0 && this.mScrollY == 0) {
                this.pinScrollTo(0, this.mYDistanceToSlideTitleOffScreen, true, 500);
            }
            this.mPageThatNeedsToSlideTitleBarOffScreen = null;
        }
    }

    public boolean setContentScrollTo(int cx, int cy) {
        int vy;
        int vx;
        if (this.mDrawHistory) {
            return false;
        }
        if ((cx | cy) == 0) {
            vx = 0;
            vy = 0;
        } else {
            vx = this.contentToViewX(cx);
            vy = this.contentToViewY(cy);
        }
        if (cx == 0 && cy == 1 && this.mScrollX == 0 && this.mScrollY == 0 && this.mTitleBar != null) {
            if (this.getProgress() < 100) {
                this.mPageThatNeedsToSlideTitleBarOffScreen = this.getUrl();
                this.mYDistanceToSlideTitleOffScreen = vy;
            } else {
                this.pinScrollTo(vx, vy, true, 500);
            }
            return false;
        }
        this.pinScrollTo(vx, vy, false, 0);
        return this.mScrollX != vx && cx >= 0 || this.mScrollY != vy && cy >= 0;
    }

    public void spawnContentScrollTo(int cx, int cy) {
        if (this.mDrawHistory) {
            return;
        }
        int vx = this.contentToViewX(cx);
        int vy = this.contentToViewY(cy);
        this.pinScrollTo(vx, vy, true, 0);
    }

    public void contentSizeChanged(boolean updateLayout) {
        if ((this.mContentWidth | this.mContentHeight) == 0) {
            return;
        }
        if (this.mHeightCanMeasure) {
            if (this.getMeasuredHeight() != this.contentToViewDimension(this.mContentHeight) || updateLayout) {
                this.requestLayout();
            }
        } else if (this.mWidthCanMeasure) {
            if (this.getMeasuredWidth() != this.contentToViewDimension(this.mContentWidth) || updateLayout) {
                this.requestLayout();
            }
        } else {
            this.sendViewSizeZoom();
        }
    }

    public void setWebViewClient(WebViewClient client) {
        this.mCallbackProxy.setWebViewClient(client);
    }

    public WebViewClient getWebViewClient() {
        return this.mCallbackProxy.getWebViewClient();
    }

    public void setDownloadListener(DownloadListener listener) {
        this.mCallbackProxy.setDownloadListener(listener);
    }

    public void setWebChromeClient(WebChromeClient client) {
        this.mCallbackProxy.setWebChromeClient(client);
    }

    public WebChromeClient getWebChromeClient() {
        return this.mCallbackProxy.getWebChromeClient();
    }

    public void setWebBackForwardListClient(WebBackForwardListClient client) {
        this.mCallbackProxy.setWebBackForwardListClient(client);
    }

    public WebBackForwardListClient getWebBackForwardListClient() {
        return this.mCallbackProxy.getWebBackForwardListClient();
    }

    public void setPictureListener(PictureListener listener) {
        this.mPictureListener = listener;
    }

    public void externalRepresentation(Message callback) {
        this.mWebViewCore.sendMessage(160, callback);
    }

    public void documentAsText(Message callback) {
        this.mWebViewCore.sendMessage(161, callback);
    }

    public void addJavascriptInterface(Object obj, String interfaceName) {
        WebViewCore.JSInterfaceData arg = new WebViewCore.JSInterfaceData();
        arg.mObject = obj;
        arg.mInterfaceName = interfaceName;
        this.mWebViewCore.sendMessage(138, arg);
    }

    public WebSettings getSettings() {
        return this.mWebViewCore.getSettings();
    }

    public void addPackageNames(Set<String> packageNames) {
        this.mWebViewCore.sendMessage(184, packageNames);
    }

    public void addPackageName(String packageName) {
        this.mWebViewCore.sendMessage(185, packageName);
    }

    public void removePackageName(String packageName) {
        this.mWebViewCore.sendMessage(186, packageName);
    }

    @Deprecated
    public static synchronized PluginList getPluginList() {
        return new PluginList();
    }

    @Deprecated
    public void refreshPlugins(boolean reloadOpenPages) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    @Override
    public boolean drawChild(Canvas canvas, View child, long drawingTime) {
        if (child == this.mTitleBar) {
            this.mTitleBar.offsetLeftAndRight(this.mScrollX - this.mTitleBar.getLeft());
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void drawContent(Canvas canvas) {
        this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), this.mTouchMode == 4 || this.mTrackballDown || this.mGotCenterDown, false);
        this.drawCoreAndCursorRing(canvas, this.mBackgroundColor, this.mDrawCursorRing);
    }

    @Override
    public void onDraw(Canvas canvas) {
        if (this.mNativeClass == 0) {
            return;
        }
        if ((this.mContentWidth | this.mContentHeight) == 0 && this.mHistoryPicture == null) {
            canvas.drawColor(this.mBackgroundColor);
            return;
        }
        int saveCount = canvas.save();
        if (this.mInOverScrollMode && !this.getSettings().getUseWebViewBackgroundForOverscrollBackground()) {
            if (mOverScrollBackground == null) {
                mOverScrollBackground = new Paint();
                Bitmap bm = BitmapFactory.decodeResource(this.mContext.getResources(), 17302240);
                mOverScrollBackground.setShader(new BitmapShader(bm, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
                mOverScrollBorder = new Paint();
                mOverScrollBorder.setStyle(Paint.Style.STROKE);
                mOverScrollBorder.setStrokeWidth(0.0f);
                mOverScrollBorder.setColor(-4473925);
            }
            int top = 0;
            int right = this.computeRealHorizontalScrollRange();
            int bottom = top + this.computeRealVerticalScrollRange();
            canvas.save();
            canvas.translate(this.mScrollX, this.mScrollY);
            canvas.clipRect(-this.mScrollX, top - this.mScrollY, right - this.mScrollX, bottom - this.mScrollY, Region.Op.DIFFERENCE);
            canvas.drawPaint(mOverScrollBackground);
            canvas.restore();
            canvas.drawRect(-1.0f, top - 1, right, bottom, mOverScrollBorder);
            canvas.clipRect(0, top, right, bottom);
        }
        if (this.mTitleBar != null) {
            canvas.translate(0.0f, this.mTitleBar.getHeight());
        }
        if (this.mDragTrackerHandler == null) {
            this.drawContent(canvas);
        } else {
            if (!this.mDragTrackerHandler.draw(canvas)) {
                this.drawContent(canvas);
            }
            if (this.mDragTrackerHandler.isFinished()) {
                this.mDragTrackerHandler = null;
            }
        }
        canvas.restoreToCount(saveCount);
        int titleH = this.getVisibleTitleHeight();
        if (this.mTitleBar != null && titleH == 0) {
            int height = (int)(5.0f * this.getContext().getResources().getDisplayMetrics().density);
            this.mTitleShadow.setBounds(this.mScrollX, this.mScrollY, this.mScrollX + this.getWidth(), this.mScrollY + height);
            this.mTitleShadow.draw(canvas);
        }
        if (this.inEditingMode()) {
            this.mWebTextView.onDrawSubstitute();
        }
        this.mWebViewCore.signalRepaintDone();
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowTop != null && this.drawEdgeGlows(canvas)) {
            this.invalidate();
        }
    }

    public boolean drawEdgeGlows(Canvas canvas) {
        int restoreCount;
        int scrollX = this.mScrollX;
        int scrollY = this.mScrollY;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean invalidateForGlow = false;
        if (!this.mEdgeGlowTop.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(-width / 2 + scrollX, Math.min(0, scrollY));
            this.mEdgeGlowTop.setSize(width * 2, height);
            invalidateForGlow |= this.mEdgeGlowTop.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowBottom.isFinished()) {
            restoreCount = canvas.save();
            canvas.translate(-width / 2 + scrollX, Math.max(this.computeMaxScrollY(), scrollY) + height);
            canvas.rotate(180.0f, width, 0.0f);
            this.mEdgeGlowBottom.setSize(width * 2, height);
            invalidateForGlow |= this.mEdgeGlowBottom.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowLeft.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(270.0f);
            canvas.translate((float)(-height) * 1.5f - (float)scrollY, Math.min(0, scrollX));
            this.mEdgeGlowLeft.setSize(height * 2, width);
            invalidateForGlow |= this.mEdgeGlowLeft.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        if (!this.mEdgeGlowRight.isFinished()) {
            restoreCount = canvas.save();
            canvas.rotate(90.0f);
            canvas.translate(-height / 2 + scrollY, -(Math.max(this.computeMaxScrollX(), scrollX) + width));
            this.mEdgeGlowRight.setSize(height * 2, width);
            invalidateForGlow |= this.mEdgeGlowRight.draw(canvas);
            canvas.restoreToCount(restoreCount);
        }
        return invalidateForGlow;
    }

    @Override
    public void setLayoutParams(ViewGroup.LayoutParams params) {
        if (params.height == -2) {
            this.mWrapContent = true;
        }
        super.setLayoutParams(params);
    }

    @Override
    public boolean performLongClick() {
        if (this.getParent() == null) {
            return false;
        }
        if (this.mNativeClass != 0 && this.nativeCursorIsTextInput()) {
            this.centerKeyPressOnTextField();
            this.rebuildWebTextView();
        } else {
            this.clearTextEntry(true);
        }
        if (this.inEditingMode()) {
            return this.mWebTextView.performLongClick();
        }
        if (super.performLongClick()) {
            return true;
        }
        if (this.mSelectingText) {
            return false;
        }
        int x = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int y = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        this.setUpSelect();
        if (this.mNativeClass != 0 && this.nativeWordSelection(x, y)) {
            this.nativeSetExtendSelection();
            WebChromeClient client = this.getWebChromeClient();
            if (client != null) {
                client.onSelectionStart(this);
            }
            return true;
        }
        this.notifySelectDialogDismissed();
        return false;
    }

    public boolean inAnimateZoom() {
        return this.mZoomScale != 0.0f;
    }

    public boolean didUpdateTextViewBounds(boolean allowIntersect) {
        Rect contentBounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(contentBounds);
        Rect visibleRect = new Rect();
        this.calcOurVisibleRect(visibleRect);
        if (allowIntersect ? Rect.intersects(visibleRect, vBox) : visibleRect.contains(vBox)) {
            this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
            this.mWebTextView.setTextSize(0, this.contentToViewDimension(this.nativeFocusCandidateTextSize()));
            return true;
        }
        this.mWebTextView.remove();
        return false;
    }

    public void drawExtras(Canvas canvas, int extras, boolean animationsRunning) {
        if (animationsRunning) {
            canvas.setDrawFilter(this.mWebViewCore.mZoomFilter);
        }
        this.nativeDrawExtras(canvas, extras);
        canvas.setDrawFilter(null);
    }

    public void drawCoreAndCursorRing(Canvas canvas, int color2, boolean drawCursorRing) {
        boolean animateScroll;
        if (this.mDrawHistory) {
            canvas.scale(this.mActualScale, this.mActualScale);
            canvas.drawPicture(this.mHistoryPicture);
            return;
        }
        boolean animateZoom = this.mZoomScale != 0.0f;
        boolean bl = animateScroll = (!this.mScroller.isFinished() || this.mVelocityTracker != null) && (this.mTouchMode != 3 || this.mHeldMotionless != 2) || this.mDeferTouchMode == 3;
        if (this.mTouchMode == 3) {
            if (this.mHeldMotionless == 1) {
                this.mPrivateHandler.removeMessages(8);
                this.mPrivateHandler.removeMessages(9);
                this.mHeldMotionless = 0;
            }
            if (this.mHeldMotionless == 0) {
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(8), 100L);
                this.mHeldMotionless = 1;
            }
        }
        if (animateZoom) {
            float zoomScale;
            int interval = (int)(SystemClock.uptimeMillis() - this.mZoomStart);
            if (interval < 500) {
                float ratio = (float)interval / 500.0f;
                zoomScale = 1.0f / (this.mInvInitialZoomScale + (this.mInvFinalZoomScale - this.mInvInitialZoomScale) * ratio);
                this.invalidate();
            } else {
                zoomScale = this.mZoomScale;
                this.mZoomScale = 0.0f;
                WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                this.invalidate();
                if (this.mNeedToAdjustWebTextView) {
                    this.mNeedToAdjustWebTextView = false;
                    if (this.didUpdateTextViewBounds(false) && this.nativeFocusCandidateIsPassword()) {
                        this.mWebTextView.setInPassword(true);
                    }
                }
            }
            float scale = zoomScale * this.mInvInitialZoomScale;
            int tx = Math.round(scale * ((float)this.mInitialScrollX + this.mZoomCenterX) - this.mZoomCenterX);
            tx = -_Original_WebView.pinLoc(tx, this.getViewWidth(), Math.round((float)this.mContentWidth * zoomScale)) + this.mScrollX;
            int titleHeight = this.getTitleHeight();
            int ty = Math.round(scale * ((float)this.mInitialScrollY + this.mZoomCenterY - (float)titleHeight) - (this.mZoomCenterY - (float)titleHeight));
            ty = -(ty <= titleHeight ? Math.max(ty, 0) : _Original_WebView.pinLoc(ty - titleHeight, this.getViewHeight(), Math.round((float)this.mContentHeight * zoomScale)) + titleHeight) + this.mScrollY;
            canvas.translate(tx, ty);
            canvas.scale(zoomScale, zoomScale);
            if (this.inEditingMode() && !this.mNeedToAdjustWebTextView && this.mZoomScale != 0.0f) {
                this.mNeedToAdjustWebTextView = true;
                if (this.nativeFocusCandidateIsPassword()) {
                    this.mWebTextView.setInPassword(false);
                }
            }
        } else {
            canvas.scale(this.mActualScale, this.mActualScale);
        }
        boolean UIAnimationsRunning = false;
        if (this.mNativeClass != 0 && this.nativeEvaluateLayersAnimations()) {
            UIAnimationsRunning = true;
            this.invalidate();
        }
        this.mWebViewCore.drawContentPicture(canvas, color2, animateZoom || this.mPreviewZoomOnly || UIAnimationsRunning, animateScroll);
        if (this.mNativeClass == 0) {
            return;
        }
        int extras = 0;
        if (this.mFindIsUp) {
            extras = 1;
        } else if (this.mSelectingText) {
            extras = 2;
            this.nativeSetSelectionPointer(this.mDrawSelectionPointer, this.mInvActualScale, this.mSelectX, this.mSelectY - this.getTitleHeight());
        } else if (drawCursorRing) {
            extras = 3;
        }
        this.drawExtras(canvas, extras, UIAnimationsRunning);
        if (extras == 3 && this.mTouchMode == 4) {
            this.mTouchMode = 5;
        }
        if (this.mFocusSizeChanged) {
            this.mFocusSizeChanged = false;
            if (!animateZoom && this.inEditingMode()) {
                this.didUpdateTextViewBounds(true);
            }
        }
    }

    public boolean drawHistory() {
        return this.mDrawHistory;
    }

    public void switchOutDrawHistory() {
        if (null == this.mWebViewCore) {
            return;
        }
        if (this.mDrawHistory && this.mWebViewCore.pictureReady()) {
            this.mDrawHistory = false;
            this.mHistoryPicture = null;
            this.invalidate();
            int oldScrollX = this.mScrollX;
            int oldScrollY = this.mScrollY;
            this.mScrollX = this.pinLocX(this.mScrollX);
            this.mScrollY = this.pinLocY(this.mScrollY);
            if (oldScrollX != this.mScrollX || oldScrollY != this.mScrollY) {
                this.mUserScroll = false;
                this.mWebViewCore.sendMessage(131, oldScrollX, oldScrollY);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldScrollX, oldScrollY);
            } else {
                this.sendOurVisibleRect();
            }
        }
    }

    public WebViewCore.CursorData cursorData() {
        WebViewCore.CursorData result = new WebViewCore.CursorData();
        result.mMoveGeneration = this.nativeMoveGeneration();
        result.mFrame = this.nativeCursorFramePointer();
        Point position = this.nativeCursorPosition();
        result.mX = position.x;
        result.mY = position.y;
        return result;
    }

    public void deleteSelection(int start, int end) {
        ++this.mTextGeneration;
        WebViewCore.TextSelectionData data = new WebViewCore.TextSelectionData(start, end);
        this.mWebViewCore.sendMessage(122, this.mTextGeneration, 0, data);
    }

    public void setSelection(int start, int end) {
        this.mWebViewCore.sendMessage(113, start, end);
    }

    @Override
    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        InputConnection connection = super.onCreateInputConnection(outAttrs);
        outAttrs.imeOptions |= Integer.MIN_VALUE;
        return connection;
    }

    public void displaySoftKeyboard(boolean isTextView) {
        boolean zoom;
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        boolean bl = zoom = this.mActualScale < this.mDefaultScale;
        if (zoom) {
            this.mInZoomOverview = false;
            this.mZoomCenterX = this.mLastTouchX;
            this.mZoomCenterY = this.mLastTouchY;
            this.setNewZoomScale(this.mDefaultScale, false, false);
        }
        if (isTextView) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                imm.showSoftInput(this.mWebTextView, 0);
                if (zoom) {
                    this.didUpdateTextViewBounds(true);
                }
                return;
            }
        }
        imm.showSoftInput(this, 0);
    }

    public void hideSoftKeyboard() {
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    public void rebuildWebTextView() {
        if (!(this.hasFocus() || null != this.mWebTextView && this.mWebTextView.hasFocus())) {
            return;
        }
        boolean alreadyThere = this.inEditingMode();
        if (0 == this.mNativeClass || !this.nativeFocusCandidateIsTextInput()) {
            if (alreadyThere) {
                this.mWebTextView.remove();
            }
            return;
        }
        if (this.mWebTextView == null) {
            this.mWebTextView = new WebTextView(this.mContext, this);
            this.mTextGeneration = 0;
        }
        this.mWebTextView.setTextSize(0, this.contentToViewDimension(this.nativeFocusCandidateTextSize()));
        Rect visibleRect = new Rect();
        this.calcOurContentVisibleRect(visibleRect);
        Rect bounds = this.nativeFocusCandidateNodeBounds();
        Rect vBox = this.contentToViewRect(bounds);
        this.mWebTextView.setRect(vBox.left, vBox.top, vBox.width(), vBox.height());
        if (!Rect.intersects(bounds, visibleRect)) {
            this.mWebTextView.bringIntoView();
        }
        String text = this.nativeFocusCandidateText();
        int nodePointer = this.nativeFocusCandidatePointer();
        if (alreadyThere && this.mWebTextView.isSameTextField(nodePointer)) {
            if (text != null && !text.equals(this.mWebTextView.getText().toString()) && this.nativeTextGeneration() == this.mTextGeneration) {
                this.mWebTextView.setTextAndKeepSelection(text);
            }
        } else {
            this.mWebTextView.setGravity(this.nativeFocusCandidateIsRtlText() ? 5 : 0);
            this.mWebTextView.setNodePointer(nodePointer);
            this.mWebTextView.setType(this.nativeFocusCandidateType());
            Rect paddingRect = this.nativeFocusCandidatePaddingRect();
            if (paddingRect != null) {
                this.mWebTextView.setPadding(this.contentToViewDimension(paddingRect.left), this.contentToViewDimension(paddingRect.top), this.contentToViewDimension(paddingRect.right), this.contentToViewDimension(paddingRect.bottom));
            }
            if (null == text) {
                text = "";
            }
            this.mWebTextView.setTextAndKeepSelection(text);
            InputMethodManager imm = InputMethodManager.peekInstance();
            if (imm != null && imm.isActive(this.mWebTextView)) {
                imm.restartInput(this.mWebTextView);
            }
        }
        this.mWebTextView.requestFocus();
    }

    public void requestFormData(String name, int nodePointer) {
        if (this.mWebViewCore.getSettings().getSaveFormData()) {
            Message update = this.mPrivateHandler.obtainMessage(6);
            update.arg1 = nodePointer;
            RequestFormData updater = new RequestFormData(name, this.getUrl(), update);
            Thread t = new Thread(updater);
            t.start();
        }
    }

    public void requestLabel(int framePointer, int nodePointer) {
        this.mWebViewCore.sendMessage(97, framePointer, nodePointer);
    }

    public void dumpDisplayTree() {
        this.nativeDumpDisplayTree(this.getUrl());
    }

    public void dumpDomTree(boolean toFile) {
        this.mWebViewCore.sendMessage(170, toFile ? 1 : 0, 0);
    }

    public void dumpRenderTree(boolean toFile) {
        this.mWebViewCore.sendMessage(171, toFile ? 1 : 0, 0);
    }

    public void dumpV8Counters() {
        this.mWebViewCore.sendMessage(173);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        if (keyCode == 0 && event.getCharacters() != null) {
            this.mWebViewCore.sendMessage(103, event);
            this.mWebViewCore.sendMessage(104, event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (keyCode == 59 || keyCode == 60) {
            if (this.nativeFocusIsPlugin()) {
                this.mShiftIsPressed = true;
            } else if (!this.nativeCursorWantsKeyEvents() && !this.mSelectingText) {
                this.setUpSelect();
            }
        }
        if (keyCode >= 19 && keyCode <= 22) {
            this.switchOutDrawHistory();
            if (this.nativeFocusIsPlugin()) {
                this.letPluginHandleNavKey(keyCode, event.getEventTime(), true);
                return true;
            }
            if (this.mSelectingText) {
                int xRate;
                int n = keyCode == 21 ? -1 : (xRate = keyCode == 22 ? 1 : 0);
                int yRate = keyCode == 19 ? -1 : (keyCode == 20 ? 1 : 0);
                int multiplier = event.getRepeatCount() + 1;
                this.moveSelection(xRate * multiplier, yRate * multiplier);
                return true;
            }
            if (this.navHandledKey(keyCode, 1, false, event.getEventTime())) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
                return true;
            }
            return false;
        }
        if (keyCode == 23) {
            this.switchOutDrawHistory();
            if (event.getRepeatCount() == 0) {
                if (this.mSelectingText) {
                    return true;
                }
                this.mGotCenterDown = true;
                this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(114), 1000L);
                this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
                return true;
            }
            return false;
        }
        if (keyCode != 59 && keyCode != 60) {
            this.selectionDone();
            this.mShiftIsPressed = false;
        }
        if (this.getSettings().getNavDump()) {
            switch (keyCode) {
                case 11: {
                    this.dumpDisplayTree();
                    break;
                }
                case 12: 
                case 13: {
                    this.dumpDomTree(keyCode == 12);
                    break;
                }
                case 14: 
                case 15: {
                    this.dumpRenderTree(keyCode == 14);
                    break;
                }
                case 16: {
                    this.nativeInstrumentReport();
                    return true;
                }
            }
        }
        if (this.nativeCursorIsTextInput()) {
            this.mWebViewCore.sendMessage(118, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        } else if (this.nativeHasFocusNode()) {
            this.rebuildWebTextView();
            if (this.inEditingMode()) {
                this.mWebTextView.setDefaultSelection();
                return this.mWebTextView.dispatchKeyEvent(event);
            }
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(103, event);
        return true;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mNativeClass == 0) {
            return false;
        }
        if (keyCode == 5 && this.nativeHasCursorNode()) {
            String text = this.nativeCursorText();
            if (!this.nativeCursorIsTextInput() && text != null && text.startsWith(SCHEME_TEL)) {
                Intent intent = new Intent("android.intent.action.DIAL", Uri.parse(text));
                this.getContext().startActivity(intent);
                return true;
            }
        }
        if (event.isSystem() || this.mCallbackProxy.uiOverrideKeyEvent(event)) {
            return false;
        }
        if (keyCode == 59 || keyCode == 60) {
            if (this.nativeFocusIsPlugin()) {
                this.mShiftIsPressed = false;
            } else if (this.copySelection()) {
                this.selectionDone();
                return true;
            }
        }
        if (keyCode >= 19 && keyCode <= 22) {
            if (this.nativeFocusIsPlugin()) {
                this.letPluginHandleNavKey(keyCode, event.getEventTime(), false);
                return true;
            }
            return false;
        }
        if (keyCode == 23) {
            this.mPrivateHandler.removeMessages(114);
            this.mGotCenterDown = false;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            Rect visibleRect = this.sendOurVisibleRect();
            if (!this.nativeCursorIntersects(visibleRect)) {
                return false;
            }
            WebViewCore.CursorData data = this.cursorData();
            this.mWebViewCore.sendMessage(135, data);
            this.playSoundEffect(0);
            if (this.nativeCursorIsTextInput()) {
                this.rebuildWebTextView();
                this.centerKeyPressOnTextField();
                if (this.inEditingMode()) {
                    this.mWebTextView.setDefaultSelection();
                }
                return true;
            }
            this.clearTextEntry(true);
            this.nativeSetFollowedLink(true);
            if (!this.mCallbackProxy.uiOverrideUrlLoading(this.nativeCursorText())) {
                this.mWebViewCore.sendMessage(118, data.mFrame, this.nativeCursorNodePointer());
            }
            return true;
        }
        if (!this.nativeCursorWantsKeyEvents()) {
            // empty if block
        }
        this.mWebViewCore.sendMessage(104, event);
        return true;
    }

    public void setUpSelect() {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (this.mSelectingText) {
            return;
        }
        this.mExtendSelection = false;
        this.mDrawSelectionPointer = true;
        this.mSelectingText = true;
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        this.nativeResetSelection();
        if (this.nativeHasCursorNode()) {
            Rect rect = this.nativeCursorNodeBounds();
            this.mSelectX = this.contentToViewX(rect.left);
            this.mSelectY = this.contentToViewY(rect.top);
        } else if (this.mLastTouchY > (float)this.getVisibleTitleHeight()) {
            this.mSelectX = this.mScrollX + (int)this.mLastTouchX;
            this.mSelectY = this.mScrollY + (int)this.mLastTouchY;
        } else {
            this.mSelectX = this.mScrollX + this.getViewWidth() / 2;
            this.mSelectY = this.mScrollY + this.getViewHeightWithTitle() / 2;
        }
        this.nativeHideCursor();
    }

    public void emulateShiftHeld() {
        this.setUpSelect();
    }

    public void selectAll() {
        if (0 == this.mNativeClass) {
            return;
        }
        if (this.inFullScreenMode()) {
            return;
        }
        if (!this.mSelectingText) {
            this.setUpSelect();
        }
        this.nativeSelectAll();
        this.mDrawSelectionPointer = false;
        this.mExtendSelection = true;
        this.invalidate();
    }

    public boolean selectDialogIsUp() {
        return this.mSelectingText;
    }

    public void notifySelectDialogDismissed() {
        this.mSelectingText = false;
        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
    }

    public void selectionDone() {
        if (this.mSelectingText) {
            WebChromeClient client = this.getWebChromeClient();
            if (client != null) {
                client.onSelectionDone(this);
            }
            this.invalidate();
            this.notifySelectDialogDismissed();
        }
    }

    public boolean copySelection() {
        boolean copiedSomething = false;
        String selection = this.getSelection();
        if (selection != "") {
            Toast.makeText(this.mContext, 17040076, 0).show();
            copiedSomething = true;
            try {
                IClipboard clip = IClipboard.Stub.asInterface(ServiceManager.getService((String)"clipboard"));
                clip.setClipboardText(selection);
            }
            catch (RemoteException e) {
                Log.e(LOGTAG, "Clipboard failed", e);
            }
        }
        this.invalidate();
        return copiedSomething;
    }

    public String getSelection() {
        if (this.mNativeClass == 0) {
            return "";
        }
        return this.nativeGetSelection();
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.hasWindowFocus()) {
            this.setActive(true);
        }
    }

    @Override
    public void onDetachedFromWindow() {
        this.clearHelpers();
        this.dismissZoomControl();
        if (this.hasWindowFocus()) {
            this.setActive(false);
        }
        super.onDetachedFromWindow();
    }

    @Override
    @Deprecated
    public void onChildViewAdded(View parent, View child) {
    }

    @Override
    @Deprecated
    public void onChildViewRemoved(View p, View child) {
    }

    @Override
    @Deprecated
    public void onGlobalFocusChanged(View oldFocus, View newFocus) {
    }

    public void setActive(boolean active) {
        if (active) {
            if (this.hasFocus()) {
                this.mDrawCursorRing = true;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                    if (this.inEditingMode()) {
                        this.mWebViewCore.sendMessage(142, 1, 0);
                    }
                }
            } else {
                this.mDrawCursorRing = false;
            }
        } else {
            if (this.mWebViewCore != null && this.getSettings().getBuiltInZoomControls() && (this.mZoomButtonsController == null || !this.mZoomButtonsController.isVisible())) {
                this.mDrawCursorRing = false;
            }
            this.mGotKeyDown = false;
            this.mShiftIsPressed = false;
            this.mPrivateHandler.removeMessages(4);
            this.mTouchMode = 7;
            if (this.mNativeClass != 0) {
                this.nativeRecordButtons(false, false, true);
            }
            this.setFocusControllerInactive();
        }
        this.invalidate();
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.setActive(hasWindowFocus);
        if (hasWindowFocus) {
            JWebCoreJavaBridge.setActiveWebView((_Original_WebView)this);
        } else {
            JWebCoreJavaBridge.removeActiveWebView((_Original_WebView)this);
        }
        super.onWindowFocusChanged(hasWindowFocus);
    }

    public void setFocusControllerInactive() {
        if (this.mNativeClass == 0) {
            return;
        }
        this.mWebViewCore.sendMessage(142, 0, 0);
    }

    @Override
    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        if (focused) {
            if (this.hasWindowFocus()) {
                this.mDrawCursorRing = true;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(true, false, true);
                }
            }
        } else {
            if (!this.inEditingMode()) {
                this.mDrawCursorRing = false;
                if (this.mNativeClass != 0) {
                    this.nativeRecordButtons(false, false, true);
                }
                this.setFocusControllerInactive();
            }
            this.mGotKeyDown = false;
        }
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
    }

    @Override
    public boolean setFrame(int left, int top, int right, int bottom) {
        boolean changed = super.setFrame(left, top, right, bottom);
        if (!changed && this.mHeightCanMeasure) {
            this.sendViewSizeZoom();
        }
        return changed;
    }

    @Override
    public void onSizeChanged(int w, int h, int ow, int oh) {
        int newMaxViewportWidth;
        super.onSizeChanged(w, h, ow, oh);
        if (this.mZoomScale == 0.0f) {
            this.mZoomCenterX = 0.0f;
            this.mZoomCenterY = this.getVisibleTitleHeight();
            this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
            this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        }
        if ((newMaxViewportWidth = (int)((float)Math.max(w, h) / DEFAULT_MIN_ZOOM_SCALE)) > sMaxViewportWidth) {
            sMaxViewportWidth = newMaxViewportWidth;
        }
        if (!this.mMinZoomScaleFixed) {
            float initialScale;
            this.mMinZoomScale = Math.min(1.0f, (float)this.getViewWidth() / (float)(this.mDrawHistory ? this.mHistoryPicture.getWidth() : this.mZoomOverviewWidth));
            if (this.mInitialScaleInPercent > 0 && this.mMinZoomScale > (initialScale = (float)this.mInitialScaleInPercent / 100.0f)) {
                this.mMinZoomScale = initialScale;
            }
        }
        this.dismissZoomControl();
        this.post(new PostScale(this, w != ow));
    }

    @Override
    public void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (!this.mInOverScrollMode) {
            this.sendOurVisibleRect();
            int titleHeight = this.getTitleHeight();
            if (Math.max(titleHeight - t, 0) != Math.max(titleHeight - oldt, 0)) {
                this.sendViewSizeZoom();
            }
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean dispatch = true;
        if (!(this.inEditingMode() || this.mNativeClass != 0 && this.nativeFocusIsPlugin())) {
            if (event.getAction() == 0) {
                this.mGotKeyDown = true;
            } else {
                if (!this.mGotKeyDown) {
                    dispatch = false;
                }
                this.mGotKeyDown = false;
            }
        }
        if (dispatch) {
            return super.dispatchKeyEvent(event);
        }
        return false;
    }

    public static int sign(float x) {
        return x > 0.0f ? 1 : (x < 0.0f ? -1 : 0);
    }

    public DragTracker getDragTracker() {
        return this.mDragTracker;
    }

    public void setDragTracker(DragTracker tracker) {
        this.mDragTracker = tracker;
    }

    public boolean hitFocusedPlugin(int contentX, int contentY) {
        return this.nativeFocusIsPlugin() && this.nativeFocusNodeBounds().contains(contentX, contentY);
    }

    public boolean shouldForwardTouchEvent() {
        return this.mFullScreenHolder != null || this.mForwardTouchEvents && !this.mSelectingText && this.mPreventDefault != 4;
    }

    public boolean inFullScreenMode() {
        return this.mFullScreenHolder != null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mNativeClass == 0 || !this.isClickable() && !this.isLongClickable()) {
            return false;
        }
        eventTime = ev.getEventTime();
        if (!this.mSupportMultiTouch || ev.getPointerCount() <= 1) ** GOTO lbl29
        if (this.mAllowPanAndScale || this.mMinZoomScale < this.mMaxZoomScale) {
            this.mScaleDetector.onTouchEvent(ev);
            if (this.mScaleDetector.isInProgress()) {
                this.mLastTouchTime = eventTime;
                if (!this.mAllowPanAndScale) {
                    return true;
                }
                this.mPrivateHandler.removeMessages(3);
                this.mPrivateHandler.removeMessages(4);
            }
            x = this.mScaleDetector.getFocusX();
            y = this.mScaleDetector.getFocusY();
            action = ev.getAction() & 255;
            if (action == 5) {
                this.cancelTouch();
                action = 0;
            } else if (action == 6) {
                this.mLastTouchX = x;
                this.mLastTouchY = y;
            } else if (action == 2 && (x < 0.0f || y < 0.0f)) {
                return true;
            }
        } else {
            return true;
lbl29:
            // 1 sources

            action = ev.getAction();
            x = ev.getX();
            y = ev.getY();
        }
        if (x > (float)(this.getViewWidth() - 1)) {
            x = this.getViewWidth() - 1;
        }
        if (y > (float)(this.getViewHeightWithTitle() - 1)) {
            y = this.getViewHeightWithTitle() - 1;
        }
        fDeltaX = this.mLastTouchX - x;
        fDeltaY = this.mLastTouchY - y;
        deltaX = (int)fDeltaX;
        deltaY = (int)fDeltaY;
        contentX = this.viewToContentX((int)x + this.mScrollX);
        contentY = this.viewToContentY((int)y + this.mScrollY);
        switch (action) {
            case 0: {
                this.mPreventDefault = 0;
                this.mConfirmMove = false;
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mTouchMode = 2;
                    this.mConfirmMove = true;
                    this.mPrivateHandler.removeMessages(7);
                } else if (this.mPrivateHandler.hasMessages(5)) {
                    this.mPrivateHandler.removeMessages(5);
                    if (deltaX * deltaX + deltaY * deltaY < this.mDoubleTapSlopSquare) {
                        this.mTouchMode = 6;
                    } else {
                        this.doShortPress();
                        this.mTouchMode = 1;
                        this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    }
                } else {
                    this.mPreviewZoomOnly = false;
                    this.mTouchMode = 1;
                    this.mDeferTouchProcess = this.inFullScreenMode() == false && this.mForwardTouchEvents != false ? this.hitFocusedPlugin(contentX, contentY) : false;
                    this.mWebViewCore.sendMessage(98);
                    if (_Original_WebView.mLogEvent && eventTime - this.mLastTouchUpTime < 1000L) {
                        EventLog.writeEvent(70102, new Object[]{eventTime - this.mLastTouchUpTime, eventTime});
                    }
                    if (this.mSelectingText) {
                        this.mDrawSelectionPointer = false;
                        this.mSelectionStarted = this.nativeStartSelection(contentX, contentY);
                        this.invalidate();
                    }
                }
                if (this.mTouchMode == 1 || this.mTouchMode == 6) {
                    this.mPrivateHandler.sendEmptyMessageDelayed(3, 200L);
                    this.mPrivateHandler.sendEmptyMessageDelayed(4, 1000L);
                    this.mPreventDefault = this.inFullScreenMode() != false || this.mDeferTouchProcess != false ? 3 : (this.mForwardTouchEvents != false ? 1 : 0);
                    if (this.shouldForwardTouchEvent()) {
                        ted = new WebViewCore.TouchEventData();
                        ted.mAction = action;
                        ted.mX = contentX;
                        ted.mY = contentY;
                        ted.mMetaState = ev.getMetaState();
                        ted.mReprocess = this.mDeferTouchProcess;
                        if (this.mDeferTouchProcess) {
                            this.mLastTouchX = x;
                            this.mLastTouchY = y;
                            ted.mViewX = x;
                            ted.mViewY = y;
                            this.mWebViewCore.sendMessage(141, ted);
                            break;
                        }
                        this.mWebViewCore.sendMessage(141, ted);
                        if (!this.inFullScreenMode()) {
                            this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                        }
                    }
                }
                this.startTouch(x, y, eventTime);
                break;
            }
            case 2: {
                firstMove = false;
                if (!this.mConfirmMove && deltaX * deltaX + deltaY * deltaY >= this.mTouchSlopSquare) {
                    this.mPrivateHandler.removeMessages(3);
                    this.mPrivateHandler.removeMessages(4);
                    this.mConfirmMove = true;
                    firstMove = true;
                    if (this.mTouchMode == 6) {
                        this.mTouchMode = 1;
                    }
                }
                if (this.shouldForwardTouchEvent() && this.mConfirmMove && (firstMove || eventTime - this.mLastSentTouchTime > (long)this.mCurrentTouchInterval)) {
                    this.mLastSentTouchTime = eventTime;
                    ted = new WebViewCore.TouchEventData();
                    ted.mAction = action;
                    ted.mX = contentX;
                    ted.mY = contentY;
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    if (this.mDeferTouchProcess) {
                        ted.mViewX = x;
                        ted.mViewY = y;
                        this.mWebViewCore.sendMessage(141, ted);
                        break;
                    }
                    this.mWebViewCore.sendMessage(141, ted);
                    if (firstMove && !this.inFullScreenMode()) {
                        this.mPrivateHandler.sendMessageDelayed(this.mPrivateHandler.obtainMessage(10, action, 0), 200L);
                    }
                }
                if (this.mTouchMode == 7 || this.mPreventDefault == 3) break;
                if (this.mVelocityTracker == null) {
                    Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess + " mTouchMode = " + this.mTouchMode);
                }
                this.mVelocityTracker.addMovement(ev);
                if (this.mSelectingText && this.mSelectionStarted) {
                    this.nativeExtendSelection(contentX, contentY);
                    this.invalidate();
                    break;
                }
                if (this.mTouchMode != 3) {
                    if (!this.mConfirmMove) break;
                    if (this.mPreventDefault == 1 || this.mPreventDefault == 2) {
                        this.mLastTouchTime = eventTime;
                        break;
                    }
                    if (this.mScaleDetector != null && !this.mScaleDetector.isInProgress()) {
                        ax = Math.abs(deltaX);
                        if ((float)ax > 1.5f * (float)(ay = Math.abs(deltaY))) {
                            this.mSnapScrollMode = 2;
                            this.mSnapPositive = deltaX > 0;
                        } else if ((float)ay > 1.5f * (float)ax) {
                            this.mSnapScrollMode = 4;
                            this.mSnapPositive = deltaY > 0;
                        }
                    }
                    this.mTouchMode = 3;
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    fDeltaX = 0.0f;
                    fDeltaY = 0.0f;
                    deltaX = 0;
                    deltaY = 0;
                    this.startDrag();
                }
                if (this.mDragTrackerHandler != null) {
                    this.mDragTrackerHandler.dragTo(x, y);
                }
                done = false;
                keepScrollBarsVisible = false;
                if (Math.abs(fDeltaX) < 1.0f && Math.abs(fDeltaY) < 1.0f) {
                    this.mLastTouchX = x;
                    this.mLastTouchY = y;
                    done = true;
                    keepScrollBarsVisible = true;
                } else {
                    if (this.mSnapScrollMode == 2 || this.mSnapScrollMode == 4) {
                        ax = Math.abs(deltaX);
                        ay = Math.abs(deltaY);
                        if (this.mSnapScrollMode == 2) {
                            if ((float)ay > 1.5f * (float)ax && ay > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ax > 1.5f * (float)ay && (this.mSnapPositive != false ? deltaX < -this.mMinLockSnapReverseDistance : deltaX > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        } else {
                            if ((float)ax > 1.5f * (float)ay && ax > 80) {
                                this.mSnapScrollMode = 0;
                            }
                            if ((float)ay > 1.5f * (float)ax && (this.mSnapPositive != false ? deltaY < -this.mMinLockSnapReverseDistance : deltaY > this.mMinLockSnapReverseDistance)) {
                                this.mSnapScrollMode |= 1;
                            }
                        }
                    }
                    if (this.mSnapScrollMode != 0) {
                        if ((this.mSnapScrollMode & 2) == 2) {
                            deltaY = 0;
                        } else {
                            deltaX = 0;
                        }
                    }
                    if ((deltaX | deltaY) != 0) {
                        if (deltaX != 0) {
                            this.mLastTouchX = x;
                        }
                        if (deltaY != 0) {
                            this.mLastTouchY = y;
                        }
                        this.mHeldMotionless = 0;
                    } else {
                        this.mLastTouchX = x;
                        this.mLastTouchY = y;
                        keepScrollBarsVisible = true;
                    }
                    this.mLastTouchTime = eventTime;
                    this.mUserScroll = true;
                }
                this.doDrag(deltaX, deltaY);
                if (!keepScrollBarsVisible) break;
                if (this.mHeldMotionless != 2) {
                    this.mHeldMotionless = 2;
                    this.invalidate();
                }
                this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                return done == false;
            }
            case 1: {
                if (this.shouldForwardTouchEvent()) {
                    ted = new WebViewCore.TouchEventData();
                    ted.mAction = action;
                    ted.mX = contentX;
                    ted.mY = contentY;
                    ted.mMetaState = ev.getMetaState();
                    ted.mReprocess = this.mDeferTouchProcess;
                    if (this.mDeferTouchProcess) {
                        ted.mViewX = x;
                        ted.mViewY = y;
                    }
                    this.mWebViewCore.sendMessage(141, ted);
                }
                this.mLastTouchUpTime = eventTime;
                switch (this.mTouchMode) {
                    case 6: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (this.inFullScreenMode() || this.mDeferTouchProcess) {
                            ted = new WebViewCore.TouchEventData();
                            ted.mAction = 512;
                            ted.mX = contentX;
                            ted.mY = contentY;
                            ted.mMetaState = ev.getMetaState();
                            ted.mReprocess = this.mDeferTouchProcess;
                            if (this.mDeferTouchProcess) {
                                ted.mViewX = x;
                                ted.mViewY = y;
                            }
                            this.mWebViewCore.sendMessage(141, ted);
                            break;
                        }
                        if (this.mPreventDefault == 3) break;
                        this.doDoubleTap();
                        this.mTouchMode = 7;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        this.mPrivateHandler.removeMessages(3);
                        this.mPrivateHandler.removeMessages(4);
                        if (!this.mConfirmMove) ** GOTO lbl249
                        Log.w("webview", "Miss a drag as we are waiting for WebCore's response for touch down.");
                        if (this.mPreventDefault != 3 && (this.computeMaxScrollX() > 0 || this.computeMaxScrollY() > 0)) {
                            this.cancelWebCoreTouchEvent(contentX, contentY, true);
                            WebViewCore.reducePriority();
                            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
                        } else {
                            this.invalidate();
                            break;
lbl249:
                            // 1 sources

                            if (this.mSelectingText) {
                                if (this.nativeHitSelection(contentX, contentY)) {
                                    this.copySelection();
                                }
                                this.selectionDone();
                                break;
                            }
                            if (this.mTouchMode == 1) {
                                this.mPrivateHandler.sendEmptyMessageDelayed(5, ViewConfiguration.getDoubleTapTimeout());
                                break;
                            }
                            this.doShortPress();
                            break;
                        }
                    }
                    case 3: {
                        this.mPrivateHandler.removeMessages(8);
                        this.mPrivateHandler.removeMessages(9);
                        if (eventTime - this.mLastTouchTime <= 250L) {
                            if (this.mVelocityTracker == null) {
                                Log.e("webview", "Got null mVelocityTracker when mPreventDefault = " + this.mPreventDefault + " mDeferTouchProcess = " + this.mDeferTouchProcess);
                            }
                            this.mVelocityTracker.addMovement(ev);
                            this.mHeldMotionless = 3;
                            this.doFling();
                            break;
                        }
                        if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                            this.invalidate();
                        }
                        this.mHeldMotionless = 2;
                        this.invalidate();
                    }
                    case 2: {
                        this.mLastVelocity = 0.0f;
                        WebViewCore.resumePriority();
                        WebViewCore.resumeUpdatePicture(this.mWebViewCore);
                    }
                }
                this.stopTouch();
                break;
            }
            case 3: {
                if (this.mTouchMode == 3) {
                    this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY());
                    this.invalidate();
                }
                this.cancelWebCoreTouchEvent(contentX, contentY, false);
                this.cancelTouch();
            }
        }
        return true;
    }

    public void cancelWebCoreTouchEvent(int x, int y, boolean removeEvents) {
        if (this.shouldForwardTouchEvent()) {
            if (removeEvents) {
                this.mWebViewCore.removeMessages(141);
            }
            WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
            ted.mX = x;
            ted.mY = y;
            ted.mAction = 3;
            this.mWebViewCore.sendMessage(141, ted);
            this.mPreventDefault = 4;
        }
    }

    public void startTouch(float x, float y, long eventTime) {
        this.mLastTouchX = x;
        this.mLastTouchY = y;
        this.mLastTouchTime = eventTime;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mSnapScrollMode = 0;
        if (this.mDragTracker != null) {
            this.mDragTrackerHandler = new DragTrackerHandler(x, y, this.mDragTracker);
        }
    }

    public void startDrag() {
        WebSettings settings;
        WebViewCore.reducePriority();
        WebViewCore.pauseUpdatePicture(this.mWebViewCore);
        if (!this.mDragFromTextInput) {
            this.nativeHideCursor();
        }
        if ((settings = this.getSettings()).supportZoom() && settings.getBuiltInZoomControls() && !this.getZoomButtonsController().isVisible() && this.mMinZoomScale < this.mMaxZoomScale && (this.mHorizontalScrollBarMode != 1 || this.mVerticalScrollBarMode != 1)) {
            this.mZoomButtonsController.setVisible(true);
            int count = settings.getDoubleTapToastCount();
            if (this.mInZoomOverview && count > 0) {
                settings.setDoubleTapToastCount(--count);
                Toast.makeText(this.mContext, 17040062, 1).show();
            }
        }
    }

    public void doDrag(int deltaX, int deltaY) {
        if ((deltaX | deltaY) != 0) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int rangeX = this.computeMaxScrollX();
            int rangeY = this.computeMaxScrollY();
            if (this.mEdgeGlowTop != null) {
                this.mOverscrollDeltaX = deltaX;
                this.mOverscrollDeltaY = deltaY;
            }
            this.overScrollBy(deltaX, deltaY, oldX, oldY, rangeX, rangeY, this.mOverscrollDistance, this.mOverscrollDistance, true);
            if (!(this.mEdgeGlowTop == null || this.mEdgeGlowTop.isFinished() && this.mEdgeGlowBottom.isFinished() && this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished())) {
                this.invalidate();
            }
        }
        if (!this.getSettings().getBuiltInZoomControls()) {
            boolean showPlusMinus;
            boolean bl = showPlusMinus = this.mMinZoomScale < this.mMaxZoomScale;
            if (this.mZoomControls != null && showPlusMinus) {
                if (this.mZoomControls.getVisibility() == 0) {
                    this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
                } else {
                    this.mZoomControls.show(showPlusMinus, false);
                }
                this.mPrivateHandler.postDelayed(this.mZoomControlRunnable, ZOOM_CONTROLS_TIMEOUT);
            }
        }
    }

    public void stopTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
            this.mEdgeGlowLeft.onRelease();
            this.mEdgeGlowRight.onRelease();
        }
    }

    public void cancelTouch() {
        if (this.mDragTrackerHandler != null) {
            this.mDragTrackerHandler.stopDrag();
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        if (this.mEdgeGlowTop != null) {
            this.mEdgeGlowTop.onRelease();
            this.mEdgeGlowBottom.onRelease();
            this.mEdgeGlowLeft.onRelease();
            this.mEdgeGlowRight.onRelease();
        }
        if (this.mTouchMode == 3) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
        }
        this.mPrivateHandler.removeMessages(3);
        this.mPrivateHandler.removeMessages(4);
        this.mPrivateHandler.removeMessages(8);
        this.mPrivateHandler.removeMessages(9);
        this.mHeldMotionless = 2;
        this.mTouchMode = 7;
        this.nativeHideCursor();
    }

    public void setMapTrackballToArrowKeys(boolean setMap) {
        this.mMapTrackballToArrowKeys = setMap;
    }

    public void resetTrackballTime() {
        this.mTrackballLastTime = 0L;
    }

    @Override
    public boolean onTrackballEvent(MotionEvent ev) {
        long time = ev.getEventTime();
        if ((ev.getMetaState() & 2) != 0) {
            if (ev.getY() > 0.0f) {
                this.pageDown(true);
            }
            if (ev.getY() < 0.0f) {
                this.pageUp(true);
            }
            return true;
        }
        if (ev.getAction() == 0) {
            if (this.mSelectingText) {
                return true;
            }
            this.mTrackballDown = true;
            if (this.mNativeClass == 0) {
                return false;
            }
            this.nativeRecordButtons(this.hasFocus() && this.hasWindowFocus(), true, true);
            if (time - this.mLastCursorTime <= 200L && !this.mLastCursorBounds.equals(this.nativeGetCursorRingBounds())) {
                this.nativeSelectBestAt(this.mLastCursorBounds);
            }
            if (this.isInTouchMode()) {
                this.requestFocusFromTouch();
            }
            return false;
        }
        if (ev.getAction() == 1) {
            this.mPrivateHandler.removeMessages(114);
            this.mTrackballDown = false;
            this.mTrackballUpTime = time;
            if (this.mSelectingText) {
                if (this.mExtendSelection) {
                    this.copySelection();
                    this.selectionDone();
                } else {
                    this.mExtendSelection = true;
                    this.nativeSetExtendSelection();
                    this.invalidate();
                }
                return true;
            }
            return false;
        }
        if (this.mMapTrackballToArrowKeys && !this.mShiftIsPressed) {
            return false;
        }
        if (this.mTrackballDown) {
            return true;
        }
        if (time - this.mTrackballUpTime < 200L) {
            return true;
        }
        this.switchOutDrawHistory();
        if (time - this.mTrackballLastTime > 200L) {
            this.mTrackballFirstTime = time;
            this.mTrackballYMove = 0;
            this.mTrackballXMove = 0;
        }
        this.mTrackballLastTime = time;
        this.mTrackballRemainsX += ev.getX();
        this.mTrackballRemainsY += ev.getY();
        this.doTrackball(time);
        return true;
    }

    public void moveSelection(float xRate, float yRate) {
        int scrollX;
        if (this.mNativeClass == 0) {
            return;
        }
        int width = this.getViewWidth();
        int height = this.getViewHeight();
        this.mSelectX = (int)((float)this.mSelectX + xRate);
        this.mSelectY = (int)((float)this.mSelectY + yRate);
        int maxX = width + this.mScrollX;
        int maxY = height + this.mScrollY;
        this.mSelectX = Math.min(maxX, Math.max(this.mScrollX - 16, this.mSelectX));
        this.mSelectY = Math.min(maxY, Math.max(this.mScrollY - 16, this.mSelectY));
        this.nativeMoveSelection(this.viewToContentX(this.mSelectX), this.viewToContentY(this.mSelectY));
        int n = this.mSelectX < this.mScrollX ? -16 : (scrollX = this.mSelectX > maxX - 16 ? 16 : 0);
        int scrollY = this.mSelectY < this.mScrollY ? -16 : (this.mSelectY > maxY - 16 ? 16 : 0);
        this.pinScrollBy(scrollX, scrollY, true, 0);
        Rect select = new Rect(this.mSelectX, this.mSelectY, this.mSelectX + 1, this.mSelectY + 1);
        this.requestRectangleOnScreen(select);
        this.invalidate();
    }

    public int scaleTrackballX(float xRate, int width) {
        int xMove;
        int nextXMove = xMove = (int)(xRate / 400.0f * (float)width);
        if (xMove > 0) {
            if (xMove > this.mTrackballXMove) {
                xMove -= this.mTrackballXMove;
            }
        } else if (xMove < this.mTrackballXMove) {
            xMove -= this.mTrackballXMove;
        }
        this.mTrackballXMove = nextXMove;
        return xMove;
    }

    public int scaleTrackballY(float yRate, int height) {
        int yMove;
        int nextYMove = yMove = (int)(yRate / 400.0f * (float)height);
        if (yMove > 0) {
            if (yMove > this.mTrackballYMove) {
                yMove -= this.mTrackballYMove;
            }
        } else if (yMove < this.mTrackballYMove) {
            yMove -= this.mTrackballYMove;
        }
        this.mTrackballYMove = nextYMove;
        return yMove;
    }

    public int keyCodeToSoundsEffect(int keyCode) {
        switch (keyCode) {
            case 19: {
                return 2;
            }
            case 22: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 21: {
                return 1;
            }
        }
        throw new IllegalArgumentException("keyCode must be one of {KEYCODE_DPAD_UP, KEYCODE_DPAD_RIGHT, KEYCODE_DPAD_DOWN, KEYCODE_DPAD_LEFT}.");
    }

    public void doTrackball(long time) {
        int elapsed = (int)(this.mTrackballLastTime - this.mTrackballFirstTime);
        if (elapsed == 0) {
            elapsed = 200;
        }
        float xRate = this.mTrackballRemainsX * 1000.0f / (float)elapsed;
        float yRate = this.mTrackballRemainsY * 1000.0f / (float)elapsed;
        int viewWidth = this.getViewWidth();
        int viewHeight = this.getViewHeight();
        if (this.mSelectingText) {
            if (!this.mDrawSelectionPointer) {
                this.mSelectX = this.contentToViewX(this.nativeSelectionX());
                this.mSelectY = this.contentToViewY(this.nativeSelectionY());
                this.mExtendSelection = true;
                this.mDrawSelectionPointer = true;
                this.nativeSetExtendSelection();
            }
            this.moveSelection(this.scaleTrackballX(xRate, viewWidth), this.scaleTrackballY(yRate, viewHeight));
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
            return;
        }
        float ax = Math.abs(xRate);
        float ay = Math.abs(yRate);
        float maxA = Math.max(ax, ay);
        int width = this.mContentWidth - viewWidth;
        int height = this.mContentHeight - viewHeight;
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        ax = Math.abs(this.mTrackballRemainsX * 3.0f);
        ay = Math.abs(this.mTrackballRemainsY * 3.0f);
        maxA = Math.max(ax, ay);
        int count = Math.max(0, (int)maxA);
        int oldScrollX = this.mScrollX;
        int oldScrollY = this.mScrollY;
        if (count > 0) {
            int selectKeyCode = ax < ay ? (this.mTrackballRemainsY < 0.0f ? 19 : 20) : (this.mTrackballRemainsX < 0.0f ? 21 : 22);
            count = Math.min(count, 10);
            if (this.mNativeClass != 0 && this.nativeFocusIsPlugin()) {
                for (int i = 0; i < count; ++i) {
                    this.letPluginHandleNavKey(selectKeyCode, time, true);
                }
                this.letPluginHandleNavKey(selectKeyCode, time, false);
            } else if (this.navHandledKey(selectKeyCode, count, false, time)) {
                this.playSoundEffect(this.keyCodeToSoundsEffect(selectKeyCode));
            }
            this.mTrackballRemainsY = 0.0f;
            this.mTrackballRemainsX = 0.0f;
        }
        if (count >= 5) {
            int xMove = this.scaleTrackballX(xRate, width);
            int yMove = this.scaleTrackballY(yRate, height);
            if (Math.abs(this.mScrollX - oldScrollX) > Math.abs(xMove)) {
                xMove = 0;
            }
            if (Math.abs(this.mScrollY - oldScrollY) > Math.abs(yMove)) {
                yMove = 0;
            }
            if (xMove != 0 || yMove != 0) {
                this.pinScrollBy(xMove, yMove, true, 0);
            }
            this.mUserScroll = true;
        }
    }

    public int computeMaxScrollX() {
        return Math.max(this.computeRealHorizontalScrollRange() - this.getViewWidth(), 0);
    }

    public int computeMaxScrollY() {
        return Math.max(this.computeRealVerticalScrollRange() + this.getTitleHeight() - this.getViewHeightWithTitle(), 0);
    }

    public void flingScroll(int vx, int vy) {
        this.mScroller.fling(this.mScrollX, this.mScrollY, vx, vy, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY(), this.mOverflingDistance, this.mOverflingDistance);
        this.invalidate();
    }

    public void doFling() {
        if (this.mVelocityTracker == null) {
            return;
        }
        int maxX = this.computeMaxScrollX();
        int maxY = this.computeMaxScrollY();
        this.mVelocityTracker.computeCurrentVelocity(1000, this.mMaximumFling);
        int vx = (int)this.mVelocityTracker.getXVelocity();
        int vy = (int)this.mVelocityTracker.getYVelocity();
        if (this.mSnapScrollMode != 0) {
            if ((this.mSnapScrollMode & 2) == 2) {
                vy = 0;
            } else {
                vx = 0;
            }
        }
        vx = vx * 3 / 4;
        vy = vy * 3 / 4;
        if (maxX == 0 && vy == 0 || maxY == 0 && vx == 0) {
            WebViewCore.resumePriority();
            WebViewCore.resumeUpdatePicture(this.mWebViewCore);
            if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.computeMaxScrollX(), 0, this.computeMaxScrollY())) {
                this.invalidate();
            }
            return;
        }
        float currentVelocity = this.mScroller.getCurrVelocity();
        if (this.mLastVelocity > 0.0f && currentVelocity > 0.0f) {
            float deltaR = (float)Math.abs(Math.atan2(this.mLastVelY, this.mLastVelX) - Math.atan2(vy, vx));
            float circle = (float)Math.PI * 2;
            if (deltaR > 5.6548667f || deltaR < 0.62831855f) {
                vx = (int)((float)vx + currentVelocity * this.mLastVelX / this.mLastVelocity);
                vy = (int)((float)vy + currentVelocity * this.mLastVelY / this.mLastVelocity);
            }
        }
        if ((this.mScrollX == 0 || this.mScrollX == maxX) && Math.abs(vx) < Math.abs(vy)) {
            vx = 0;
        }
        if ((this.mScrollY == 0 || this.mScrollY == maxY) && Math.abs(vy) < Math.abs(vx)) {
            vy = 0;
        }
        if (this.mOverscrollDistance < this.mOverflingDistance) {
            if (this.mScrollX == -this.mOverscrollDistance || this.mScrollX == maxX + this.mOverscrollDistance) {
                vx = 0;
            }
            if (this.mScrollY == -this.mOverscrollDistance || this.mScrollY == maxY + this.mOverscrollDistance) {
                vy = 0;
            }
        }
        this.mLastVelX = vx;
        this.mLastVelY = vy;
        this.mLastVelocity = (float)Math.hypot(vx, vy);
        this.mScroller.fling(this.mScrollX, this.mScrollY, -vx, -vy, 0, maxX, 0, maxY, maxX == 0 ? 0 : this.mOverflingDistance, this.mOverflingDistance);
        int time = this.mScroller.getDuration();
        this.awakenScrollBars(time);
        this.invalidate();
    }

    public boolean zoomWithPreview(float scale, boolean updateTextWrapScale) {
        float oldScale = this.mActualScale;
        this.mInitialScrollX = this.mScrollX;
        this.mInitialScrollY = this.mScrollY;
        if (Math.abs(scale - this.mDefaultScale) < MINIMUM_SCALE_INCREMENT) {
            scale = this.mDefaultScale;
        }
        this.setNewZoomScale(scale, updateTextWrapScale, false);
        if (oldScale != this.mActualScale) {
            this.mZoomStart = SystemClock.uptimeMillis();
            this.mInvInitialZoomScale = 1.0f / oldScale;
            this.mInvFinalZoomScale = 1.0f / this.mActualScale;
            this.mZoomScale = this.mActualScale;
            WebViewCore.pauseUpdatePicture(this.mWebViewCore);
            this.invalidate();
            return true;
        }
        return false;
    }

    @Deprecated
    public View getZoomControls() {
        if (!this.getSettings().supportZoom()) {
            Log.w(LOGTAG, "This WebView doesn't support zoom.");
            return null;
        }
        if (this.mZoomControls == null) {
            this.mZoomControls = this.createZoomControls();
            this.mZoomControls.setVisibility(0);
            this.mZoomControlRunnable = new _Original_WebView$8(this);
        }
        return this.mZoomControls;
    }

    public ExtendedZoomControls createZoomControls() {
        ExtendedZoomControls zoomControls = new ExtendedZoomControls(this.mContext, null);
        zoomControls.setOnZoomInClickListener(new _Original_WebView$9(this));
        zoomControls.setOnZoomOutClickListener(new _Original_WebView$10(this));
        return zoomControls;
    }

    public ZoomButtonsController getZoomButtonsController() {
        if (this.mZoomButtonsController == null) {
            this.mZoomButtonsController = new ZoomButtonsController(this);
            this.mZoomButtonsController.setOnZoomListener(this.mZoomListener);
            View controls = this.mZoomButtonsController.getZoomControls();
            ViewGroup.LayoutParams params = controls.getLayoutParams();
            if (params instanceof FrameLayout.LayoutParams) {
                FrameLayout.LayoutParams frameParams = (FrameLayout.LayoutParams)params;
                frameParams.gravity = 5;
            }
        }
        return this.mZoomButtonsController;
    }

    public boolean zoomIn() {
        this.switchOutDrawHistory();
        this.mInZoomOverview = false;
        this.mZoomCenterX = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.getViewHeight() * 0.5f;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        return this.zoomWithPreview(this.mActualScale * 1.25f, true);
    }

    public boolean zoomOut() {
        this.switchOutDrawHistory();
        this.mZoomCenterX = (float)this.getViewWidth() * 0.5f;
        this.mZoomCenterY = (float)this.getViewHeight() * 0.5f;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        return this.zoomWithPreview(this.mActualScale * 0.8f, true);
    }

    public void updateSelection() {
        if (this.mNativeClass == 0) {
            return;
        }
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        Rect rect = new Rect(contentX - this.mNavSlop, contentY - this.mNavSlop, contentX + this.mNavSlop, contentY + this.mNavSlop);
        this.nativeSelectBestAt(rect);
    }

    public void scrollFocusedTextInput(float xPercent, int y) {
        if (!this.inEditingMode() || this.mWebViewCore == null) {
            return;
        }
        this.mWebViewCore.sendMessage(99, this.viewToContentDimension(y), new Float(xPercent));
    }

    public void initiateTextFieldDrag(float x, float y, long eventTime) {
        if (!this.inEditingMode()) {
            return;
        }
        this.mLastTouchX = x + (float)(this.mWebTextView.getLeft() - this.mScrollX);
        this.mLastTouchY = y + (float)(this.mWebTextView.getTop() - this.mScrollY);
        this.mLastTouchTime = eventTime;
        if (!this.mScroller.isFinished()) {
            this.abortAnimation();
            this.mPrivateHandler.removeMessages(7);
        }
        this.mSnapScrollMode = 0;
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mTouchMode = 2;
    }

    public boolean textFieldDrag(MotionEvent event) {
        if (!this.inEditingMode()) {
            return false;
        }
        this.mDragFromTextInput = true;
        event.offsetLocation(this.mWebTextView.getLeft() - this.mScrollX, this.mWebTextView.getTop() - this.mScrollY);
        boolean result = this.onTouchEvent(event);
        this.mDragFromTextInput = false;
        return result;
    }

    public void touchUpOnTextField(MotionEvent event) {
        if (!this.inEditingMode()) {
            return;
        }
        int x = this.viewToContentX((int)event.getX() + this.mWebTextView.getLeft());
        int y = this.viewToContentY((int)event.getY() + this.mWebTextView.getTop());
        this.nativeMotionUp(x, y, this.mNavSlop);
    }

    public void centerKeyPressOnTextField() {
        this.mWebViewCore.sendMessage(118, this.nativeCursorFramePointer(), this.nativeCursorNodePointer());
    }

    public void doShortPress() {
        if (this.mNativeClass == 0) {
            return;
        }
        if (this.mPreventDefault == 3) {
            return;
        }
        this.mTouchMode = 7;
        this.switchOutDrawHistory();
        int contentX = this.viewToContentX((int)this.mLastTouchX + this.mScrollX);
        int contentY = this.viewToContentY((int)this.mLastTouchY + this.mScrollY);
        if (this.nativePointInNavCache(contentX, contentY, this.mNavSlop)) {
            WebViewCore.MotionUpData motionUpData = new WebViewCore.MotionUpData();
            motionUpData.mFrame = this.nativeCacheHitFramePointer();
            motionUpData.mNode = this.nativeCacheHitNodePointer();
            motionUpData.mBounds = this.nativeCacheHitNodeBounds();
            motionUpData.mX = contentX;
            motionUpData.mY = contentY;
            this.mWebViewCore.sendMessageAtFrontOfQueue(146, motionUpData);
        } else {
            this.doMotionUp(contentX, contentY);
        }
    }

    public void doMotionUp(int contentX, int contentY) {
        if (mLogEvent && this.nativeMotionUp(contentX, contentY, this.mNavSlop)) {
            EventLog.writeEvent(70150, new Object[0]);
        }
        if (this.nativeHasCursorNode() && !this.nativeCursorIsTextInput()) {
            this.playSoundEffect(0);
        }
    }

    public boolean isPluginFitOnScreen(ViewManager.ChildView view) {
        int viewHeight;
        int viewWidth = this.getViewWidth();
        float scale = Math.min((float)viewWidth / (float)view.width, (float)(viewHeight = this.getViewHeightWithTitle()) / (float)view.height);
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        return Math.abs(scale - this.mActualScale) < MINIMUM_SCALE_INCREMENT && this.contentToViewX(view.x) >= this.mScrollX && this.contentToViewX(view.x + view.width) <= this.mScrollX + viewWidth && this.contentToViewY(view.y) >= this.mScrollY && this.contentToViewY(view.y + view.height) <= this.mScrollY + viewHeight;
    }

    public void centerFitRect(int docX, int docY, int docWidth, int docHeight) {
        int viewHeight;
        int viewWidth = this.getViewWidth();
        float scale = Math.min((float)viewWidth / (float)docWidth, (float)(viewHeight = this.getViewHeightWithTitle()) / (float)docHeight);
        if (scale < this.mMinZoomScale) {
            scale = this.mMinZoomScale;
        } else if (scale > this.mMaxZoomScale) {
            scale = this.mMaxZoomScale;
        }
        if (Math.abs(scale - this.mActualScale) < MINIMUM_SCALE_INCREMENT) {
            this.pinScrollTo(this.contentToViewX(docX + docWidth / 2) - viewWidth / 2, this.contentToViewY(docY + docHeight / 2) - viewHeight / 2, true, 0);
        } else {
            float oldScreenX = (float)docX * this.mActualScale - (float)this.mScrollX;
            float rectViewX = (float)docX * scale;
            float rectViewWidth = (float)docWidth * scale;
            float newMaxWidth = (float)this.mContentWidth * scale;
            float newScreenX = ((float)viewWidth - rectViewWidth) / 2.0f;
            if (newScreenX > rectViewX) {
                newScreenX = rectViewX;
            } else if (newScreenX > newMaxWidth - rectViewX - rectViewWidth) {
                newScreenX = (float)viewWidth - (newMaxWidth - rectViewX);
            }
            this.mZoomCenterX = (oldScreenX * scale - newScreenX * this.mActualScale) / (scale - this.mActualScale);
            float oldScreenY = (float)docY * this.mActualScale + (float)this.getTitleHeight() - (float)this.mScrollY;
            float rectViewY = (float)docY * scale + (float)this.getTitleHeight();
            float rectViewHeight = (float)docHeight * scale;
            float newMaxHeight = (float)this.mContentHeight * scale + (float)this.getTitleHeight();
            float newScreenY = ((float)viewHeight - rectViewHeight) / 2.0f;
            if (newScreenY > rectViewY) {
                newScreenY = rectViewY;
            } else if (newScreenY > newMaxHeight - rectViewY - rectViewHeight) {
                newScreenY = (float)viewHeight - (newMaxHeight - rectViewY);
            }
            this.mZoomCenterY = (oldScreenY * scale - newScreenY * this.mActualScale) / (scale - this.mActualScale);
            this.zoomWithPreview(scale, false);
        }
    }

    public void dismissZoomControl() {
        if (this.mWebViewCore == null) {
            if (this.mZoomButtonsController != null) {
                this.mZoomButtonsController.setVisible(false);
            }
            if (this.mZoomControls != null) {
                this.mZoomControls.hide();
            }
            return;
        }
        WebSettings settings = this.getSettings();
        if (settings.getBuiltInZoomControls()) {
            if (this.mZoomButtonsController != null) {
                this.mZoomButtonsController.setVisible(false);
            }
        } else {
            if (this.mZoomControlRunnable != null) {
                this.mPrivateHandler.removeCallbacks(this.mZoomControlRunnable);
            }
            if (this.mZoomControls != null) {
                this.mZoomControls.hide();
            }
        }
    }

    public void doDoubleTap() {
        if (!this.mWebViewCore.getSettings().getUseWideViewPort()) {
            return;
        }
        this.mZoomCenterX = this.mLastTouchX;
        this.mZoomCenterY = this.mLastTouchY;
        this.mAnchorX = this.viewToContentX((int)this.mZoomCenterX + this.mScrollX);
        this.mAnchorY = this.viewToContentY((int)this.mZoomCenterY + this.mScrollY);
        WebSettings settings = this.getSettings();
        settings.setDoubleTapToastCount(0);
        this.dismissZoomControl();
        ViewManager.ChildView plugin = this.mViewManager.hitTest(this.mAnchorX, this.mAnchorY);
        if (plugin != null) {
            if (this.isPluginFitOnScreen(plugin)) {
                this.mInZoomOverview = true;
                if (this.mScrollY < this.getTitleHeight()) {
                    this.mScrollY = 0;
                }
                this.zoomWithPreview((float)this.getViewWidth() / (float)this.mZoomOverviewWidth, true);
            } else {
                this.mInZoomOverview = false;
                this.centerFitRect(plugin.x, plugin.y, plugin.width, plugin.height);
            }
            return;
        }
        boolean zoomToDefault = false;
        if (settings.getLayoutAlgorithm() == WebSettings.LayoutAlgorithm.NARROW_COLUMNS && Math.abs(this.mActualScale - this.mTextWrapScale) >= MINIMUM_SCALE_INCREMENT) {
            this.setNewZoomScale(this.mActualScale, true, true);
            float overviewScale = (float)this.getViewWidth() / (float)this.mZoomOverviewWidth;
            if (Math.abs(this.mActualScale - overviewScale) < MINIMUM_SCALE_INCREMENT) {
                this.mInZoomOverview = true;
            }
        } else if (!this.mInZoomOverview) {
            float newScale = (float)this.getViewWidth() / (float)this.mZoomOverviewWidth;
            if (Math.abs(this.mActualScale - newScale) >= MINIMUM_SCALE_INCREMENT) {
                this.mInZoomOverview = true;
                if (this.mScrollY < this.getTitleHeight()) {
                    this.mScrollY = 0;
                }
                this.zoomWithPreview(newScale, true);
            } else if (Math.abs(this.mActualScale - this.mDefaultScale) >= MINIMUM_SCALE_INCREMENT) {
                zoomToDefault = true;
            }
        } else {
            zoomToDefault = true;
        }
        if (zoomToDefault) {
            this.mInZoomOverview = false;
            int left = this.nativeGetBlockLeftEdge(this.mAnchorX, this.mAnchorY, this.mActualScale);
            if (left != -1) {
                int viewLeft = this.contentToViewX(left < 5 ? 0 : left - 5) - this.mScrollX;
                if (viewLeft > 0) {
                    this.mZoomCenterX = (float)viewLeft * this.mDefaultScale / (this.mDefaultScale - this.mActualScale);
                } else {
                    this.scrollBy(viewLeft, 0);
                    this.mZoomCenterX = 0.0f;
                }
            }
            this.zoomWithPreview(this.mDefaultScale, true);
        }
    }

    public void overrideLoading(String url) {
        this.mCallbackProxy.uiOverrideUrlLoading(url);
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        boolean result = false;
        if (this.inEditingMode()) {
            result = this.mWebTextView.requestFocus(direction, previouslyFocusedRect);
        } else {
            result = super.requestFocus(direction, previouslyFocusedRect);
            if (this.mWebViewCore.getSettings().getNeedInitialFocus()) {
                int fakeKeyDirection = 0;
                switch (direction) {
                    case 33: {
                        fakeKeyDirection = 19;
                        break;
                    }
                    case 130: {
                        fakeKeyDirection = 20;
                        break;
                    }
                    case 17: {
                        fakeKeyDirection = 21;
                        break;
                    }
                    case 66: {
                        fakeKeyDirection = 22;
                        break;
                    }
                    default: {
                        return result;
                    }
                }
                if (this.mNativeClass != 0 && !this.nativeHasCursorNode()) {
                    this.navHandledKey(fakeKeyDirection, 1, true, 0L);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int measuredHeight = heightSize;
        int measuredWidth = widthSize;
        int contentHeight = this.contentToViewDimension(this.mContentHeight);
        int contentWidth = this.contentToViewDimension(this.mContentWidth);
        if (heightMode != 0x40000000) {
            this.mHeightCanMeasure = true;
            measuredHeight = contentHeight;
            if (heightMode == Integer.MIN_VALUE && measuredHeight > heightSize) {
                measuredHeight = heightSize;
                this.mHeightCanMeasure = false;
            }
        } else {
            this.mHeightCanMeasure = false;
        }
        if (this.mNativeClass != 0) {
            this.nativeSetHeightCanMeasure(this.mHeightCanMeasure);
        }
        if (widthMode == 0) {
            this.mWidthCanMeasure = true;
            measuredWidth = contentWidth;
        } else {
            this.mWidthCanMeasure = false;
        }
        _Original_WebView _Original_WebView2 = this;
        synchronized (_Original_WebView2) {
            this.setMeasuredDimension(measuredWidth, measuredHeight);
        }
    }

    @Override
    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        rect.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        Rect content = new Rect(this.viewToContentX(this.mScrollX), this.viewToContentY(this.mScrollY), this.viewToContentX(this.mScrollX + this.getWidth() - this.getVerticalScrollbarWidth()), this.viewToContentY(this.mScrollY + this.getViewHeightWithTitle()));
        content = this.nativeSubtractLayers(content);
        int screenTop = this.contentToViewY(content.top);
        int screenBottom = this.contentToViewY(content.bottom);
        int height = screenBottom - screenTop;
        int scrollYDelta = 0;
        if (rect.bottom > screenBottom) {
            int oneThirdOfScreenHeight = height / 3;
            scrollYDelta = rect.height() > 2 * oneThirdOfScreenHeight ? rect.top - screenTop : rect.top - (screenTop + oneThirdOfScreenHeight);
        } else if (rect.top < screenTop) {
            scrollYDelta = rect.top - screenTop;
        }
        int screenLeft = this.contentToViewX(content.left);
        int screenRight = this.contentToViewX(content.right);
        int width = screenRight - screenLeft;
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
        } else if (rect.left < screenLeft) {
            scrollXDelta -= screenLeft - rect.left;
        }
        if ((scrollYDelta | scrollXDelta) != 0) {
            return this.pinScrollBy(scrollXDelta, scrollYDelta, !immediate, 0);
        }
        return false;
    }

    public void replaceTextfieldText(int oldStart, int oldEnd, String replace, int newStart, int newEnd) {
        WebViewCore.ReplaceTextData arg = new WebViewCore.ReplaceTextData();
        arg.mReplace = replace;
        arg.mNewStart = newStart;
        arg.mNewEnd = newEnd;
        ++this.mTextGeneration;
        arg.mTextGeneration = this.mTextGeneration;
        this.mWebViewCore.sendMessage(114, oldStart, oldEnd, arg);
    }

    public void passToJavaScript(String currentText, KeyEvent event) {
        WebViewCore.JSKeyData arg = new WebViewCore.JSKeyData();
        arg.mEvent = event;
        arg.mCurrentText = currentText;
        ++this.mTextGeneration;
        this.mWebViewCore.sendMessage(115, this.mTextGeneration, 0, arg);
        this.mWebViewCore.removeMessages(128);
        this.mWebViewCore.sendMessageDelayed(128, this.cursorData(), 1000L);
    }

    public synchronized WebViewCore getWebViewCore() {
        return this.mWebViewCore;
    }

    public void updateTextSelectionFromMessage(int nodePointer, int textGeneration, WebViewCore.TextSelectionData data) {
        if (this.inEditingMode() && this.mWebTextView.isSameTextField(nodePointer) && textGeneration == this.mTextGeneration) {
            this.mWebTextView.setSelectionFromWebKit(data.mStart, data.mEnd);
        }
    }

    public void requestListBox(String[] array2, int[] enabledArray, int[] selectedArray) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selectedArray, null));
    }

    public void updateZoomRange(WebViewCore.RestoreState restoreState, int viewWidth, int minPrefWidth, boolean updateZoomOverview) {
        if (restoreState.mMinScale == 0.0f) {
            if (restoreState.mMobileSite) {
                if (minPrefWidth > Math.max(0, viewWidth)) {
                    this.mMinZoomScale = (float)viewWidth / (float)minPrefWidth;
                    this.mMinZoomScaleFixed = false;
                    if (updateZoomOverview) {
                        WebSettings settings = this.getSettings();
                        this.mInZoomOverview = settings.getUseWideViewPort() && settings.getLoadWithOverviewMode();
                    }
                } else {
                    this.mMinZoomScale = restoreState.mDefaultScale;
                    this.mMinZoomScaleFixed = true;
                }
            } else {
                this.mMinZoomScale = DEFAULT_MIN_ZOOM_SCALE;
                this.mMinZoomScaleFixed = false;
            }
        } else {
            this.mMinZoomScale = restoreState.mMinScale;
            this.mMinZoomScaleFixed = true;
        }
        this.mMaxZoomScale = restoreState.mMaxScale == 0.0f ? DEFAULT_MAX_ZOOM_SCALE : restoreState.mMaxScale;
    }

    public void requestListBox(String[] array2, int[] enabledArray, int selection) {
        this.mPrivateHandler.post(new InvokeListBox(array2, enabledArray, selection, null));
    }

    public void sendMoveFocus(int frame, int node) {
        this.mWebViewCore.sendMessage(127, new WebViewCore.CursorData(frame, node, 0, 0));
    }

    public void sendMoveMouse(int frame, int node, int x, int y) {
        this.mWebViewCore.sendMessage(135, new WebViewCore.CursorData(frame, node, x, y));
    }

    public void sendMoveMouseIfLatest(boolean removeFocus) {
        if (removeFocus) {
            this.clearTextEntry(true);
        }
        this.mWebViewCore.sendMessage(136, this.cursorData());
    }

    public void sendMotionUp(int touchGeneration, int frame, int node, int x, int y) {
        WebViewCore.TouchUpData touchUpData = new WebViewCore.TouchUpData();
        touchUpData.mMoveGeneration = touchGeneration;
        touchUpData.mFrame = frame;
        touchUpData.mNode = node;
        touchUpData.mX = x;
        touchUpData.mY = y;
        this.mWebViewCore.sendMessage(140, touchUpData);
    }

    public int getScaledMaxXScroll() {
        int width;
        if (!this.mHeightCanMeasure) {
            width = this.getViewWidth() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            width = visRect.width() / 2;
        }
        return this.viewToContentX(width);
    }

    public int getScaledMaxYScroll() {
        int height;
        if (!this.mHeightCanMeasure) {
            height = this.getViewHeight() / 4;
        } else {
            Rect visRect = new Rect();
            this.calcOurVisibleRect(visRect);
            height = visRect.height() / 2;
        }
        return Math.round((float)height * this.mInvActualScale);
    }

    public void viewInvalidate() {
        this.invalidate();
    }

    public void letPluginHandleNavKey(int keyCode, long time, boolean down) {
        int eventHubAction;
        int keyEventAction;
        if (down) {
            keyEventAction = 0;
            eventHubAction = 103;
            this.playSoundEffect(this.keyCodeToSoundsEffect(keyCode));
        } else {
            keyEventAction = 1;
            eventHubAction = 104;
        }
        KeyEvent event = new KeyEvent(time, time, keyEventAction, keyCode, 1, this.mShiftIsPressed | false | 0, 0, 0, 0);
        this.mWebViewCore.sendMessage(eventHubAction, event);
    }

    public boolean navHandledKey(int keyCode, int count, boolean noScroll, long time) {
        boolean keyHandled;
        if (this.mNativeClass == 0) {
            return false;
        }
        this.mLastCursorTime = time;
        this.mLastCursorBounds = this.nativeGetCursorRingBounds();
        boolean bl = keyHandled = !this.nativeMoveCursor(keyCode, count, noScroll);
        if (!keyHandled || !this.mHeightCanMeasure) {
            return keyHandled;
        }
        Rect contentCursorRingBounds = this.nativeGetCursorRingBounds();
        if (contentCursorRingBounds.isEmpty()) {
            return keyHandled;
        }
        Rect viewCursorRingBounds = this.contentToViewRect(contentCursorRingBounds);
        Rect visRect = new Rect();
        this.calcOurVisibleRect(visRect);
        Rect outset = new Rect(visRect);
        int maxXScroll = visRect.width() / 2;
        int maxYScroll = visRect.height() / 2;
        outset.inset(-maxXScroll, -maxYScroll);
        if (!Rect.intersects(outset, viewCursorRingBounds)) {
            return keyHandled;
        }
        int maxH = Math.min(viewCursorRingBounds.right - visRect.right, maxXScroll);
        if (maxH > 0) {
            this.pinScrollBy(maxH, 0, true, 0);
        } else {
            maxH = Math.max(viewCursorRingBounds.left - visRect.left, -maxXScroll);
            if (maxH < 0) {
                this.pinScrollBy(maxH, 0, true, 0);
            }
        }
        if (this.mLastCursorBounds.isEmpty()) {
            return keyHandled;
        }
        if (this.mLastCursorBounds.equals(contentCursorRingBounds)) {
            return keyHandled;
        }
        this.requestRectangleOnScreen(viewCursorRingBounds);
        this.mUserScroll = true;
        return keyHandled;
    }

    @Override
    public void setBackgroundColor(int color2) {
        this.mBackgroundColor = color2;
        this.mWebViewCore.sendMessage(126, color2);
    }

    public void debugDump() {
        this.nativeDebugDump();
        this.mWebViewCore.sendMessage(172);
    }

    public void drawPage(Canvas canvas) {
        this.mWebViewCore.drawContentPicture(canvas, 0, false, false);
    }

    public void setTouchInterval(int interval) {
        this.mCurrentTouchInterval = interval;
    }

    public void updateCachedTextfield(String updatedText) {
        this.nativeUpdateCachedTextfield(updatedText, this.mTextGeneration);
    }

    public ViewManager getViewManager() {
        return this.mViewManager;
    }

    public int nativeCacheHitFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCacheHitFramePointer()I", true, this);
    }

    public Rect nativeCacheHitNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCacheHitNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeCacheHitNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCacheHitNodePointer()I", true, this);
    }

    public void nativeClearCursor() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeClearCursor()V", true, this);
    }

    public void nativeCreate(int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeCreate(I)V", true, this);
    }

    public int nativeCursorFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorFramePointer()I", true, this);
    }

    public Rect nativeCursorNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeCursorNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorNodePointer()I", true, this);
    }

    public boolean nativeCursorMatchesFocus() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorMatchesFocus()Z", true, this) != 0;
    }

    public boolean nativeCursorIntersects(Rect rect) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIntersects(Landroid/graphics/Rect;)Z", true, this) != 0;
    }

    public boolean nativeCursorIsAnchor() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIsAnchor()Z", true, this) != 0;
    }

    public boolean nativeCursorIsTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorIsTextInput()Z", true, this) != 0;
    }

    public Point nativeCursorPosition() {
        return (Point)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorPosition()Landroid/graphics/Point;", true, this);
    }

    public String nativeCursorText() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeCursorText()Ljava/lang/String;", true, this);
    }

    public boolean nativeCursorWantsKeyEvents() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeCursorWantsKeyEvents()Z", true, this) != 0;
    }

    public void nativeDebugDump() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDebugDump()V", true, this);
    }

    public void nativeDestroy() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDestroy()V", true, this);
    }

    public boolean nativeEvaluateLayersAnimations() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeEvaluateLayersAnimations()Z", true, this) != 0;
    }

    public void nativeExtendSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeExtendSelection(II)V", true, this);
    }

    public void nativeDrawExtras(Canvas canvas, int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDrawExtras(Landroid/graphics/Canvas;I)V", true, this);
    }

    public void nativeDumpDisplayTree(String string2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeDumpDisplayTree(Ljava/lang/String;)V", true, this);
    }

    public int nativeFindAll(String string2, String string3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFindAll(Ljava/lang/String;Ljava/lang/String;)I", true, this);
    }

    public void nativeFindNext(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeFindNext(Z)V", true, this);
    }

    public int nativeFocusCandidateFramePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateFramePointer()I", true, this);
    }

    public boolean nativeFocusCandidateHasNextTextfield() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateHasNextTextfield()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsPassword() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsPassword()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsRtlText() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsRtlText()Z", true, this) != 0;
    }

    public boolean nativeFocusCandidateIsTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateIsTextInput()Z", true, this) != 0;
    }

    public int nativeFocusCandidateMaxLength() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateMaxLength()I", true, this);
    }

    public String nativeFocusCandidateName() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateName()Ljava/lang/String;", true, this);
    }

    public Rect nativeFocusCandidateNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public Rect nativeFocusCandidatePaddingRect() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidatePaddingRect()Landroid/graphics/Rect;", true, this);
    }

    public int nativeFocusCandidatePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidatePointer()I", true, this);
    }

    public String nativeFocusCandidateText() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusCandidateText()Ljava/lang/String;", true, this);
    }

    public int nativeFocusCandidateTextSize() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateTextSize()I", true, this);
    }

    public int nativeFocusCandidateType() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusCandidateType()I", true, this);
    }

    public boolean nativeFocusIsPlugin() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusIsPlugin()Z", true, this) != 0;
    }

    public Rect nativeFocusNodeBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeFocusNodeBounds()Landroid/graphics/Rect;", true, this);
    }

    public int nativeFocusNodePointer() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFocusNodePointer()I", true, this);
    }

    public Rect nativeGetCursorRingBounds() {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeGetCursorRingBounds()Landroid/graphics/Rect;", true, this);
    }

    public String nativeGetSelection() {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeGetSelection()Ljava/lang/String;", true, this);
    }

    public boolean nativeHasCursorNode() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHasCursorNode()Z", true, this) != 0;
    }

    public boolean nativeHasFocusNode() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHasFocusNode()Z", true, this) != 0;
    }

    public void nativeHideCursor() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeHideCursor()V", true, this);
    }

    public boolean nativeHitSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeHitSelection(II)Z", true, this) != 0;
    }

    public String nativeImageURI(int n, int n2) {
        return (String)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeImageURI(II)Ljava/lang/String;", true, this);
    }

    public void nativeInstrumentReport() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeInstrumentReport()V", true, this);
    }

    public boolean nativeMoveCursorToNextTextInput() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveCursorToNextTextInput()Z", true, this) != 0;
    }

    public boolean nativeMotionUp(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMotionUp(III)Z", true, this) != 0;
    }

    public boolean nativeMoveCursor(int n, int n2, boolean bl) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveCursor(IIZ)Z", true, this) != 0;
    }

    public int nativeMoveGeneration() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeMoveGeneration()I", true, this);
    }

    public void nativeMoveSelection(int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeMoveSelection(II)V", true, this);
    }

    public boolean nativePointInNavCache(int n, int n2, int n3) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativePointInNavCache(III)Z", true, this) != 0;
    }

    public void nativeRecordButtons(boolean bl, boolean bl2, boolean bl3) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeRecordButtons(ZZZ)V", true, this);
    }

    public void nativeResetSelection() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeResetSelection()V", true, this);
    }

    public void nativeSelectAll() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSelectAll()V", true, this);
    }

    public void nativeSelectBestAt(Rect rect) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSelectBestAt(Landroid/graphics/Rect;)V", true, this);
    }

    public int nativeSelectionX() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeSelectionX()I", true, this);
    }

    public int nativeSelectionY() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeSelectionY()I", true, this);
    }

    public int nativeFindIndex() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeFindIndex()I", true, this);
    }

    public void nativeSetExtendSelection() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetExtendSelection()V", true, this);
    }

    public void nativeSetFindIsEmpty() {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetFindIsEmpty()V", true, this);
    }

    public void nativeSetFindIsUp(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetFindIsUp(Z)V", true, this);
    }

    public void nativeSetFollowedLink(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetFollowedLink(Z)V", true, this);
    }

    public void nativeSetHeightCanMeasure(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetHeightCanMeasure(Z)V", true, this);
    }

    public void nativeSetRootLayer(int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetRootLayer(I)V", true, this);
    }

    public void nativeSetSelectionPointer(boolean bl, float f, int n, int n2) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetSelectionPointer(ZFII)V", true, this);
    }

    public boolean nativeStartSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeStartSelection(II)Z", true, this) != 0;
    }

    public void nativeSetSelectionRegion(boolean bl) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeSetSelectionRegion(Z)V", true, this);
    }

    public Rect nativeSubtractLayers(Rect rect) {
        return (Rect)OverrideMethod.invokeA("android.webkit._Original_WebView#nativeSubtractLayers(Landroid/graphics/Rect;)Landroid/graphics/Rect;", true, this);
    }

    public int nativeTextGeneration() {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeTextGeneration()I", true, this);
    }

    public void nativeUpdateCachedTextfield(String string2, int n) {
        OverrideMethod.invokeV("android.webkit._Original_WebView#nativeUpdateCachedTextfield(Ljava/lang/String;I)V", true, this);
    }

    public boolean nativeWordSelection(int n, int n2) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeWordSelection(II)Z", true, this) != 0;
    }

    public int nativeGetBlockLeftEdge(int n, int n2, float f) {
        return OverrideMethod.invokeI("android.webkit._Original_WebView#nativeGetBlockLeftEdge(IIF)I", true, this);
    }

    public static /* synthetic */ ZoomButtonsController access$000(_Original_WebView x0) {
        return x0.mZoomButtonsController;
    }

    public static /* synthetic */ void access$300(_Original_WebView x0, Picture x1, Bundle x2) {
        x0.restoreHistoryPictureFields(x1, x2);
    }

    public static /* synthetic */ ExtendedZoomControls access$3400(_Original_WebView x0) {
        return x0.mZoomControls;
    }

    public static /* synthetic */ Runnable access$3500(_Original_WebView x0) {
        return x0.mZoomControlRunnable;
    }

    public static /* synthetic */ long access$3600() {
        return ZOOM_CONTROLS_TIMEOUT;
    }

    static {
        HandlerPrivateDebugString = new String[]{"REMEMBER_PASSWORD", "NEVER_REMEMBER_PASSWORD", "SWITCH_TO_SHORTPRESS", "SWITCH_TO_LONGPRESS", "RELEASE_SINGLE_TAP", "REQUEST_FORM_DATA", "RESUME_WEBCORE_PRIORITY", "DRAG_HELD_MOTIONLESS", "AWAKEN_SCROLL_BARS", "PREVENT_DEFAULT_TIMEOUT"};
        HandlerPackageDebugString = new String[]{"SCROLL_TO_MSG_ID", "SCROLL_BY_MSG_ID", "SPAWN_SCROLL_TO_MSG_ID", "SYNC_SCROLL_TO_MSG_ID", "NEW_PICTURE_MSG_ID", "UPDATE_TEXT_ENTRY_MSG_ID", "WEBCORE_INITIALIZED_MSG_ID", "UPDATE_TEXTFIELD_TEXT_MSG_ID", "UPDATE_ZOOM_RANGE", "MOVE_OUT_OF_PLUGIN", "CLEAR_TEXT_ENTRY", "UPDATE_TEXT_SELECTION_MSG_ID", "SHOW_RECT_MSG_ID", "LONG_PRESS_CENTER", "PREVENT_TOUCH_ID", "WEBCORE_NEED_TOUCH_EVENTS", "INVAL_RECT_MSG_ID", "REQUEST_KEYBOARD", "DO_MOTION_UP", "SHOW_FULLSCREEN", "HIDE_FULLSCREEN", "DOM_FOCUS_CHANGED", "IMMEDIATE_REPAINT_MSG_ID", "SET_ROOT_LAYER_MSG_ID", "RETURN_LABEL", "FIND_AGAIN", "CENTER_FIT_RECT", "REQUEST_KEYBOARD_WITH_SELECTION_MSG_ID", "SET_SCROLLBAR_MODES"};
        sMaxViewportWidth = 800;
        MINIMUM_SCALE_INCREMENT = 0.01f;
        mLogEvent = true;
    }

    public class InvokeListBox
    implements Runnable {
        public boolean mMultiple;
        public int[] mSelectedArray;
        public int mSelection;
        public Container[] mContainers;

        public InvokeListBox(String[] array2, int[] enabled, int[] selected) {
            this.mMultiple = true;
            this.mSelectedArray = selected;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container(null);
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public InvokeListBox(String[] array2, int[] enabled, int selection) {
            this.mSelection = selection;
            this.mMultiple = false;
            int length = array2.length;
            this.mContainers = new Container[length];
            for (int i = 0; i < length; ++i) {
                this.mContainers[i] = new Container(null);
                this.mContainers[i].mString = array2[i];
                this.mContainers[i].mEnabled = enabled[i];
                this.mContainers[i].mId = i;
            }
        }

        public void run() {
            ListView listView = (ListView)LayoutInflater.from(_Original_WebView.this.mContext).inflate(17367134, null);
            MyArrayListAdapter adapter = new MyArrayListAdapter(_Original_WebView.this.mContext, this.mContainers, this.mMultiple);
            AlertDialog.Builder b = new AlertDialog.Builder(_Original_WebView.this.mContext).setView(listView).setCancelable(true).setInverseBackgroundForced(true);
            if (this.mMultiple) {
                b.setPositiveButton(17039370, (DialogInterface.OnClickListener)new _Original_WebView$InvokeListBox$1(this, adapter, listView));
                b.setNegativeButton(0x1040000, (DialogInterface.OnClickListener)new _Original_WebView$InvokeListBox$2(this));
            }
            AlertDialog dialog = b.create();
            listView.setAdapter(adapter);
            listView.setFocusableInTouchMode(true);
            listView.setTextFilterEnabled(!this.mMultiple);
            if (this.mMultiple) {
                listView.setChoiceMode(2);
                int length = this.mSelectedArray.length;
                for (int i = 0; i < length; ++i) {
                    listView.setItemChecked(this.mSelectedArray[i], true);
                }
            } else {
                listView.setOnItemClickListener(new _Original_WebView$InvokeListBox$3(this, dialog));
                if (this.mSelection != -1) {
                    listView.setSelection(this.mSelection);
                    listView.setChoiceMode(1);
                    listView.setItemChecked(this.mSelection, true);
                    SingleDataSetObserver observer = new SingleDataSetObserver(adapter.getItemId(this.mSelection), listView, adapter);
                    adapter.registerDataSetObserver(observer);
                }
            }
            dialog.setOnCancelListener(new _Original_WebView$InvokeListBox$4(this));
            dialog.show();
        }

        public /* synthetic */ InvokeListBox(String[] x1, int[] x2, int[] x3, _Original_WebView$1 x4) {
            this(x1, x2, x3);
        }

        public /* synthetic */ InvokeListBox(String[] x1, int[] x2, int x3, _Original_WebView$1 x4) {
            this(x1, x2, x3);
        }

        public class SingleDataSetObserver
        extends DataSetObserver {
            public long mCheckedId;
            public ListView mListView;
            public Adapter mAdapter;

            public SingleDataSetObserver(long id2, ListView l, Adapter a) {
                this.mCheckedId = id2;
                this.mListView = l;
                this.mAdapter = a;
            }

            public void onChanged() {
                int position = this.mListView.getCheckedItemPosition();
                long id2 = this.mAdapter.getItemId(position);
                if (this.mCheckedId != id2) {
                    this.mListView.clearChoices();
                    int count = this.mAdapter.getCount();
                    for (int i = 0; i < count; ++i) {
                        if (this.mAdapter.getItemId(i) != this.mCheckedId) continue;
                        this.mListView.setItemChecked(i, true);
                        break;
                    }
                }
            }

            public void onInvalidate() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MyArrayListAdapter
        extends ArrayAdapter<Container> {
            public MyArrayListAdapter(Context context, Container[] objects, boolean multiple) {
                super(context, multiple ? 17367059 : 17367058, objects);
            }

            @Override
            public View getView(int position, View convertView, ViewGroup parent) {
                convertView = super.getView(position, null, parent);
                Container c = this.item(position);
                if (c != null && 1 != c.mEnabled) {
                    LinearLayout layout2 = new LinearLayout(_Original_WebView.this.mContext);
                    layout2.setOrientation(1);
                    if (position > 0) {
                        View dividerTop = new View(_Original_WebView.this.mContext);
                        dividerTop.setBackgroundResource(17301522);
                        layout2.addView(dividerTop);
                    }
                    if (-1 == c.mEnabled) {
                        Assert.assertTrue((boolean)(convertView instanceof CheckedTextView));
                        ((CheckedTextView)convertView).setCheckMarkDrawable(null);
                    } else {
                        convertView.setEnabled(false);
                    }
                    layout2.addView(convertView);
                    if (position < this.getCount() - 1) {
                        View dividerBottom = new View(_Original_WebView.this.mContext);
                        dividerBottom.setBackgroundResource(17301522);
                        layout2.addView(dividerBottom);
                    }
                    return layout2;
                }
                return convertView;
            }

            @Override
            public boolean hasStableIds() {
                return false;
            }

            public Container item(int position) {
                if (position < 0 || position >= this.getCount()) {
                    return null;
                }
                return (Container)this.getItem(position);
            }

            @Override
            public long getItemId(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return -1L;
                }
                return item.mId;
            }

            @Override
            public boolean areAllItemsEnabled() {
                return false;
            }

            @Override
            public boolean isEnabled(int position) {
                Container item = this.item(position);
                if (item == null) {
                    return false;
                }
                return 1 == item.mEnabled;
            }
        }

        public class Container {
            public static final int OPTGROUP = -1;
            public static final int OPTION_DISABLED = 0;
            public static final int OPTION_ENABLED = 1;
            public String mString;
            public int mEnabled;
            public int mId;

            public Container() {
            }

            public String toString() {
                return this.mString;
            }

            public /* synthetic */ Container(_Original_WebView$1 x1) {
                this();
            }
        }
    }

    public class PrivateHandler
    extends Handler {
        public void handleMessage(Message msg) {
            if (_Original_WebView.this.mWebViewCore == null) {
                return;
            }
            switch (msg.what) {
                case 1: {
                    _Original_WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), msg.getData().getString("username"), msg.getData().getString("password"));
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 2: {
                    _Original_WebView.this.mDatabase.setUsernamePassword(msg.getData().getString("host"), null, null);
                    ((Message)msg.obj).sendToTarget();
                    break;
                }
                case 10: {
                    if ((msg.arg1 != 0 || _Original_WebView.this.mPreventDefault != 1) && (msg.arg1 != 2 || _Original_WebView.this.mPreventDefault != 2)) break;
                    _Original_WebView.this.cancelWebCoreTouchEvent(_Original_WebView.this.viewToContentX((int)_Original_WebView.this.mLastTouchX + _Original_WebView.this.mScrollX), _Original_WebView.this.viewToContentY((int)_Original_WebView.this.mLastTouchY + _Original_WebView.this.mScrollY), true);
                    break;
                }
                case 3: {
                    if (_Original_WebView.this.mTouchMode == 1) {
                        if (_Original_WebView.this.mPreventDefault != 3) {
                            _Original_WebView.this.mTouchMode = 4;
                            _Original_WebView.this.updateSelection();
                            break;
                        }
                        _Original_WebView.this.mTouchMode = 5;
                        break;
                    }
                    if (_Original_WebView.this.mTouchMode != 6) break;
                    _Original_WebView.this.mTouchMode = 7;
                    break;
                }
                case 4: {
                    if (_Original_WebView.this.inFullScreenMode() || _Original_WebView.this.mDeferTouchProcess) {
                        WebViewCore.TouchEventData ted = new WebViewCore.TouchEventData();
                        ted.mAction = 256;
                        ted.mX = _Original_WebView.this.viewToContentX((int)_Original_WebView.this.mLastTouchX + _Original_WebView.this.mScrollX);
                        ted.mY = _Original_WebView.this.viewToContentY((int)_Original_WebView.this.mLastTouchY + _Original_WebView.this.mScrollY);
                        ted.mMetaState = 0;
                        ted.mReprocess = _Original_WebView.this.mDeferTouchProcess;
                        if (_Original_WebView.this.mDeferTouchProcess) {
                            ted.mViewX = _Original_WebView.this.mLastTouchX;
                            ted.mViewY = _Original_WebView.this.mLastTouchY;
                        }
                        _Original_WebView.this.mWebViewCore.sendMessage(141, ted);
                        break;
                    }
                    if (_Original_WebView.this.mPreventDefault == 3) break;
                    _Original_WebView.this.mTouchMode = 7;
                    _Original_WebView.this.performLongClick();
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 5: {
                    _Original_WebView.this.doShortPress();
                    break;
                }
                case 102: {
                    _Original_WebView.this.setContentScrollBy(msg.arg1, msg.arg2, (Boolean)msg.obj);
                    break;
                }
                case 104: {
                    if (_Original_WebView.this.mUserScroll) {
                        _Original_WebView.this.mUserScroll = false;
                        break;
                    }
                }
                case 101: {
                    if (!_Original_WebView.this.setContentScrollTo(msg.arg1, msg.arg2)) break;
                    _Original_WebView.this.mUserScroll = false;
                    _Original_WebView.this.mWebViewCore.sendMessage(131, msg.arg1, msg.arg2);
                    break;
                }
                case 103: {
                    _Original_WebView.this.spawnContentScrollTo(msg.arg1, msg.arg2);
                    break;
                }
                case 109: {
                    WebViewCore.RestoreState restoreState = (WebViewCore.RestoreState)msg.obj;
                    _Original_WebView.this.updateZoomRange(restoreState, _Original_WebView.this.getViewWidth(), restoreState.mScrollX, false);
                    break;
                }
                case 105: {
                    boolean hasRestoreState;
                    if (_Original_WebView.this.mDelayedDeleteRootLayer) {
                        _Original_WebView.this.mDelayedDeleteRootLayer = false;
                        _Original_WebView.this.nativeSetRootLayer(0);
                    }
                    WebSettings settings = _Original_WebView.this.mWebViewCore.getSettings();
                    int viewWidth = _Original_WebView.this.getViewWidth();
                    WebViewCore.DrawData draw = (WebViewCore.DrawData)msg.obj;
                    Point viewSize = draw.mViewPoint;
                    boolean useWideViewport = settings.getUseWideViewPort();
                    WebViewCore.RestoreState restoreState = draw.mRestoreState;
                    boolean bl = hasRestoreState = restoreState != null;
                    if (hasRestoreState) {
                        _Original_WebView.this.updateZoomRange(restoreState, viewSize.x, draw.mMinPrefWidth, true);
                        if (!_Original_WebView.this.mDrawHistory) {
                            _Original_WebView.this.mInZoomOverview = false;
                            if (_Original_WebView.this.mInitialScaleInPercent > 0) {
                                _Original_WebView.this.setNewZoomScale((float)_Original_WebView.this.mInitialScaleInPercent / 100.0f, (float)_Original_WebView.this.mInitialScaleInPercent != _Original_WebView.this.mTextWrapScale * 100.0f, false);
                            } else if (restoreState.mViewScale > 0.0f) {
                                _Original_WebView.this.mTextWrapScale = restoreState.mTextWrapScale;
                                _Original_WebView.this.setNewZoomScale(restoreState.mViewScale, false, false);
                            } else {
                                _Original_WebView.this.mInZoomOverview = useWideViewport && settings.getLoadWithOverviewMode();
                                float scale = _Original_WebView.this.mInZoomOverview ? (float)viewWidth / 800.0f : restoreState.mTextWrapScale;
                                _Original_WebView.this.setNewZoomScale(scale, Math.abs(scale - _Original_WebView.this.mTextWrapScale) >= MINIMUM_SCALE_INCREMENT, false);
                            }
                            _Original_WebView.this.setContentScrollTo(restoreState.mScrollX, restoreState.mScrollY);
                            _Original_WebView.this.clearTextEntry(false);
                            if (_Original_WebView.this.getSettings().getBuiltInZoomControls()) {
                                _Original_WebView.this.updateZoomButtonsEnabled();
                            }
                        }
                    }
                    boolean updateLayout = viewSize.x == _Original_WebView.this.mLastWidthSent && viewSize.y == _Original_WebView.this.mLastHeightSent;
                    _Original_WebView.this.recordNewContentSize(draw.mWidthHeight.x, draw.mWidthHeight.y + (_Original_WebView.this.mFindIsUp ? _Original_WebView.this.mFindHeight : 0), updateLayout);
                    _Original_WebView.this.invalidateContentRect(draw.mInvalRegion.getBounds());
                    if (_Original_WebView.this.mPictureListener != null) {
                        _Original_WebView.this.mPictureListener.onNewPicture(_Original_WebView.this, _Original_WebView.this.capturePicture());
                    }
                    if (useWideViewport) {
                        _Original_WebView.this.mZoomOverviewWidth = Math.min(sMaxViewportWidth, Math.max((int)((float)viewWidth / _Original_WebView.this.mDefaultScale), Math.max(draw.mMinPrefWidth, draw.mViewPoint.x)));
                    }
                    if (!_Original_WebView.this.mMinZoomScaleFixed) {
                        _Original_WebView.this.mMinZoomScale = (float)viewWidth / (float)_Original_WebView.this.mZoomOverviewWidth;
                    }
                    if (!_Original_WebView.this.mDrawHistory && _Original_WebView.this.mInZoomOverview && Math.abs((float)viewWidth * _Original_WebView.this.mInvActualScale - (float)_Original_WebView.this.mZoomOverviewWidth) > 1.0f) {
                        _Original_WebView.this.setNewZoomScale((float)viewWidth / (float)_Original_WebView.this.mZoomOverviewWidth, Math.abs(_Original_WebView.this.mActualScale - _Original_WebView.this.mTextWrapScale) < MINIMUM_SCALE_INCREMENT, false);
                    }
                    if (draw.mFocusSizeChanged && _Original_WebView.this.inEditingMode()) {
                        _Original_WebView.this.mFocusSizeChanged = true;
                    }
                    if (!hasRestoreState) break;
                    _Original_WebView.this.mViewManager.postReadyToDrawAll();
                    break;
                }
                case 107: {
                    _Original_WebView.this.nativeCreate(msg.arg1);
                    break;
                }
                case 108: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    if (msg.getData().getBoolean("password")) {
                        Editable text = _Original_WebView.this.mWebTextView.getText();
                        int start = Selection.getSelectionStart(text);
                        int end = Selection.getSelectionEnd(text);
                        _Original_WebView.this.mWebTextView.setInPassword(true);
                        Editable pword = _Original_WebView.this.mWebTextView.getText();
                        Selection.setSelection(pword, start, end);
                        break;
                    }
                    if (msg.arg2 != _Original_WebView.this.mTextGeneration) break;
                    _Original_WebView.this.mWebTextView.setTextAndKeepSelection((String)msg.obj);
                    break;
                }
                case 128: {
                    _Original_WebView.this.displaySoftKeyboard(true);
                    _Original_WebView.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 112: {
                    _Original_WebView.this.rebuildWebTextView();
                    _Original_WebView.this.updateTextSelectionFromMessage(msg.arg1, msg.arg2, (WebViewCore.TextSelectionData)msg.obj);
                    break;
                }
                case 125: {
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    _Original_WebView.this.mWebTextView.setHint((String)msg.obj);
                    InputMethodManager imm = InputMethodManager.peekInstance();
                    if (imm == null || !imm.isActive(_Original_WebView.this.mWebTextView)) break;
                    imm.restartInput(_Original_WebView.this.mWebTextView);
                    break;
                }
                case 110: {
                    _Original_WebView.this.navHandledKey(msg.arg1, 1, false, 0L);
                    break;
                }
                case 106: {
                    _Original_WebView.this.selectionDone();
                    if (!_Original_WebView.this.inEditingMode() || !_Original_WebView.this.nativeCursorIsTextInput()) break;
                    _Original_WebView.this.mWebTextView.bringIntoView();
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 111: {
                    _Original_WebView.this.clearTextEntry(false);
                    break;
                }
                case 117: {
                    Rect r = (Rect)msg.obj;
                    if (r == null) {
                        _Original_WebView.this.invalidate();
                        break;
                    }
                    _Original_WebView.this.viewInvalidate(r.left, r.top, r.right, r.bottom);
                    break;
                }
                case 123: {
                    _Original_WebView.this.invalidate();
                    break;
                }
                case 124: {
                    if (0 == msg.arg1) {
                        _Original_WebView.this.mDelayedDeleteRootLayer = true;
                        break;
                    }
                    _Original_WebView.this.mDelayedDeleteRootLayer = false;
                    _Original_WebView.this.nativeSetRootLayer(msg.arg1);
                    _Original_WebView.this.invalidate();
                    break;
                }
                case 6: {
                    WebTextView.AutoCompleteAdapter adapter = (WebTextView.AutoCompleteAdapter)msg.obj;
                    if (!_Original_WebView.this.mWebTextView.isSameTextField(msg.arg1)) break;
                    _Original_WebView.this.mWebTextView.setAdapterCustom(adapter);
                    break;
                }
                case 7: {
                    WebViewCore.resumePriority();
                    WebViewCore.resumeUpdatePicture(_Original_WebView.this.mWebViewCore);
                    break;
                }
                case 114: {
                    _Original_WebView.this.mGotCenterDown = false;
                    _Original_WebView.this.mTrackballDown = false;
                    _Original_WebView.this.performLongClick();
                    break;
                }
                case 116: {
                    _Original_WebView.this.mForwardTouchEvents = msg.arg1 != 0;
                    break;
                }
                case 115: {
                    if (_Original_WebView.this.inFullScreenMode()) break;
                    if (msg.obj == null) {
                        if (msg.arg1 == 0 && _Original_WebView.this.mPreventDefault == 1) {
                            _Original_WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 2;
                            break;
                        }
                        if (msg.arg1 != 2 || _Original_WebView.this.mPreventDefault != 2) break;
                        _Original_WebView.this.mPreventDefault = msg.arg2 == 1 ? 3 : 0;
                        break;
                    }
                    if (msg.arg2 != 0) break;
                    WebViewCore.TouchEventData ted = (WebViewCore.TouchEventData)msg.obj;
                    switch (ted.mAction) {
                        case 0: {
                            _Original_WebView.this.mLastDeferTouchX = ted.mViewX;
                            _Original_WebView.this.mLastDeferTouchY = ted.mViewY;
                            _Original_WebView.this.mDeferTouchMode = 1;
                            break;
                        }
                        case 2: {
                            if (_Original_WebView.this.mDeferTouchMode != 3) {
                                _Original_WebView.this.mDeferTouchMode = 3;
                                _Original_WebView.this.mLastDeferTouchX = ted.mViewX;
                                _Original_WebView.this.mLastDeferTouchY = ted.mViewY;
                                _Original_WebView.this.startDrag();
                            }
                            int deltaX = _Original_WebView.this.pinLocX((int)((float)_Original_WebView.this.mScrollX + _Original_WebView.this.mLastDeferTouchX - ted.mViewX)) - _Original_WebView.this.mScrollX;
                            int deltaY = _Original_WebView.this.pinLocY((int)((float)_Original_WebView.this.mScrollY + _Original_WebView.this.mLastDeferTouchY - ted.mViewY)) - _Original_WebView.this.mScrollY;
                            _Original_WebView.this.doDrag(deltaX, deltaY);
                            if (deltaX != 0) {
                                _Original_WebView.this.mLastDeferTouchX = ted.mViewX;
                            }
                            if (deltaY == 0) break;
                            _Original_WebView.this.mLastDeferTouchY = ted.mViewY;
                            break;
                        }
                        case 1: 
                        case 3: {
                            if (_Original_WebView.this.mDeferTouchMode == 3) {
                                _Original_WebView.this.mScroller.springBack(_Original_WebView.this.mScrollX, _Original_WebView.this.mScrollY, 0, _Original_WebView.this.computeMaxScrollX(), 0, _Original_WebView.this.computeMaxScrollY());
                                _Original_WebView.this.invalidate();
                                WebViewCore.resumePriority();
                                WebViewCore.resumeUpdatePicture(_Original_WebView.this.mWebViewCore);
                            }
                            _Original_WebView.this.mDeferTouchMode = 7;
                            break;
                        }
                        case 512: {
                            _Original_WebView.this.mLastTouchX = ted.mViewX;
                            _Original_WebView.this.mLastTouchY = ted.mViewY;
                            _Original_WebView.this.doDoubleTap();
                            _Original_WebView.this.mDeferTouchMode = 7;
                            break;
                        }
                        case 256: {
                            HitTestResult hitTest = _Original_WebView.this.getHitTestResult();
                            if (hitTest != null && hitTest.mType != 0) {
                                _Original_WebView.this.performLongClick();
                                _Original_WebView.this.rebuildWebTextView();
                            }
                            _Original_WebView.this.mDeferTouchMode = 7;
                        }
                    }
                    break;
                }
                case 118: {
                    if (msg.arg1 == 0) {
                        _Original_WebView.this.hideSoftKeyboard();
                        break;
                    }
                    _Original_WebView.this.displaySoftKeyboard(false);
                    break;
                }
                case 126: {
                    if (!_Original_WebView.this.mFindIsUp) break;
                    _Original_WebView.this.findAll(_Original_WebView.this.mLastFind);
                    break;
                }
                case 8: {
                    _Original_WebView.this.mHeldMotionless = 2;
                    _Original_WebView.this.invalidate();
                }
                case 9: {
                    if (_Original_WebView.this.mTouchMode != 3 || _Original_WebView.this.mHeldMotionless != 2) break;
                    _Original_WebView.this.awakenScrollBars(ViewConfiguration.getScrollDefaultDelay(), false);
                    _Original_WebView.this.mPrivateHandler.sendMessageDelayed(_Original_WebView.this.mPrivateHandler.obtainMessage(9), ViewConfiguration.getScrollDefaultDelay());
                    break;
                }
                case 119: {
                    _Original_WebView.this.doMotionUp(msg.arg1, msg.arg2);
                    break;
                }
                case 120: {
                    View view = (View)msg.obj;
                    int npp = msg.arg1;
                    if (_Original_WebView.this.mFullScreenHolder != null) {
                        Log.w(_Original_WebView.LOGTAG, "Should not have another full screen.");
                        _Original_WebView.this.mFullScreenHolder.dismiss();
                    }
                    _Original_WebView.this.mFullScreenHolder = new PluginFullScreenHolder(_Original_WebView.this, npp);
                    _Original_WebView.this.mFullScreenHolder.setContentView(view);
                    _Original_WebView.this.mFullScreenHolder.setCancelable(false);
                    _Original_WebView.this.mFullScreenHolder.setCanceledOnTouchOutside(false);
                    _Original_WebView.this.mFullScreenHolder.show();
                    break;
                }
                case 121: {
                    if (!_Original_WebView.this.inFullScreenMode()) break;
                    _Original_WebView.this.mFullScreenHolder.dismiss();
                    _Original_WebView.this.mFullScreenHolder = null;
                    break;
                }
                case 122: {
                    if (!_Original_WebView.this.inEditingMode()) break;
                    _Original_WebView.this.nativeClearCursor();
                    _Original_WebView.this.rebuildWebTextView();
                    break;
                }
                case 113: {
                    WebViewCore.ShowRectData data = (WebViewCore.ShowRectData)msg.obj;
                    int x = _Original_WebView.this.mScrollX;
                    int left = _Original_WebView.this.contentToViewX(data.mLeft);
                    int width = _Original_WebView.this.contentToViewDimension(data.mWidth);
                    int maxWidth = _Original_WebView.this.contentToViewDimension(data.mContentWidth);
                    int viewWidth = _Original_WebView.this.getViewWidth();
                    x = width < viewWidth ? (x += left + width / 2 - _Original_WebView.this.mScrollX - viewWidth / 2) : (x += (int)((float)left + data.mXPercentInDoc * (float)width - (float)_Original_WebView.this.mScrollX - data.mXPercentInView * (float)viewWidth));
                    x = Math.max(0, Math.min(maxWidth, x + viewWidth) - viewWidth);
                    int top = _Original_WebView.this.contentToViewY(data.mTop);
                    int height = _Original_WebView.this.contentToViewDimension(data.mHeight);
                    int maxHeight = _Original_WebView.this.contentToViewDimension(data.mContentHeight);
                    int viewHeight = _Original_WebView.this.getViewHeight();
                    int y = (int)((float)top + data.mYPercentInDoc * (float)height - data.mYPercentInView * (float)viewHeight);
                    y = Math.max(0, Math.min(maxHeight, y + viewHeight) - viewHeight);
                    y = Math.max(0, y - _Original_WebView.this.getVisibleTitleHeight());
                    _Original_WebView.this.scrollTo(x, y);
                    break;
                }
                case 127: {
                    Rect r = (Rect)msg.obj;
                    _Original_WebView.this.mInZoomOverview = false;
                    _Original_WebView.this.centerFitRect(r.left, r.top, r.width(), r.height());
                    break;
                }
                case 129: {
                    _Original_WebView.this.mHorizontalScrollBarMode = msg.arg1;
                    _Original_WebView.this.mVerticalScrollBarMode = msg.arg2;
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    public class ScaleDetectorListener
    implements ScaleGestureDetector.OnScaleGestureListener {
        public ScaleDetectorListener() {
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            _Original_WebView.this.cancelTouch();
            _Original_WebView.this.dismissZoomControl();
            _Original_WebView.this.mInZoomOverview = false;
            if (_Original_WebView.this.inEditingMode() && _Original_WebView.this.nativeFocusCandidateIsPassword()) {
                _Original_WebView.this.mWebTextView.setInPassword(false);
            }
            _Original_WebView.this.mViewManager.startZoom();
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            if (_Original_WebView.this.mPreviewZoomOnly) {
                _Original_WebView.this.mPreviewZoomOnly = false;
                _Original_WebView.this.mAnchorX = _Original_WebView.this.viewToContentX((int)_Original_WebView.this.mZoomCenterX + _Original_WebView.this.mScrollX);
                _Original_WebView.this.mAnchorY = _Original_WebView.this.viewToContentY((int)_Original_WebView.this.mZoomCenterY + _Original_WebView.this.mScrollY);
                boolean reflowNow = _Original_WebView.this.mActualScale - _Original_WebView.this.mMinZoomScale <= MINIMUM_SCALE_INCREMENT || (double)_Original_WebView.this.mActualScale <= 0.8 * (double)_Original_WebView.this.mTextWrapScale;
                _Original_WebView.this.setNewZoomScale(_Original_WebView.this.mActualScale, reflowNow, true);
                _Original_WebView.this.invalidate();
            }
            if (_Original_WebView.this.inEditingMode() && _Original_WebView.this.didUpdateTextViewBounds(false) && _Original_WebView.this.nativeFocusCandidateIsPassword()) {
                _Original_WebView.this.mWebTextView.setInPassword(true);
            }
            _Original_WebView.this.mTouchMode = 8;
            _Original_WebView.this.mConfirmMove = true;
            _Original_WebView.this.startTouch(detector.getFocusX(), detector.getFocusY(), _Original_WebView.this.mLastTouchTime);
            _Original_WebView.this.mViewManager.endZoom();
        }

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = (float)((double)Math.round(detector.getScaleFactor() * _Original_WebView.this.mActualScale * 100.0f) / 100.0);
            if (Math.abs(scale - _Original_WebView.this.mActualScale) >= MINIMUM_SCALE_INCREMENT) {
                _Original_WebView.this.mPreviewZoomOnly = true;
                scale = scale > _Original_WebView.this.mActualScale ? Math.min(scale, _Original_WebView.this.mActualScale * 1.25f) : Math.max(scale, _Original_WebView.this.mActualScale * 0.8f);
                _Original_WebView.this.mZoomCenterX = detector.getFocusX();
                _Original_WebView.this.mZoomCenterY = detector.getFocusY();
                _Original_WebView.this.setNewZoomScale(scale, false, false);
                _Original_WebView.this.invalidate();
                return true;
            }
            return false;
        }

        public /* synthetic */ ScaleDetectorListener(_Original_WebView$1 x1) {
            this();
        }
    }

    public static class DragTracker {
        public void onStartDrag(float x, float y) {
        }

        public boolean onStretchChange(float sx, float sy) {
            return false;
        }

        public void onStopDrag() {
        }

        public void onBitmapChange(Bitmap bm) {
        }

        public void onDraw(Canvas canvas) {
        }
    }

    public class DragTrackerHandler {
        public final DragTracker mProxy;
        public final float mStartY;
        public final float mStartX;
        public final float mMinDY;
        public final float mMinDX;
        public final float mMaxDY;
        public final float mMaxDX;
        public float mCurrStretchY;
        public float mCurrStretchX;
        public int mSX;
        public int mSY;
        public Interpolator mInterp;
        public float[] mXY = new float[2];
        public static final int DRAGGING_STATE = 0;
        public static final int ANIMATING_STATE = 1;
        public static final int FINISHED_STATE = 2;
        public int mState;

        public DragTrackerHandler(float x, float y, DragTracker proxy) {
            this.mProxy = proxy;
            int docBottom = _Original_WebView.this.computeRealVerticalScrollRange() + _Original_WebView.this.getTitleHeight();
            int viewTop = _Original_WebView.this.getScrollY();
            int viewBottom = viewTop + _Original_WebView.this.getHeight();
            this.mStartY = y;
            this.mMinDY = -viewTop;
            this.mMaxDY = docBottom - viewBottom;
            int docRight = _Original_WebView.this.computeRealHorizontalScrollRange();
            int viewLeft = _Original_WebView.this.getScrollX();
            int viewRight = viewLeft + _Original_WebView.this.getWidth();
            this.mStartX = x;
            this.mMinDX = -viewLeft;
            this.mMaxDX = docRight - viewRight;
            this.mState = 0;
            this.mProxy.onStartDrag(x, y);
            this.mSX = -99999;
        }

        public float computeStretch(float delta, float min, float max) {
            float stretch = 0.0f;
            if (max - min > 4.0f) {
                if (delta < min) {
                    stretch = delta - min;
                } else if (delta > max) {
                    stretch = delta - max;
                }
            }
            return stretch;
        }

        public void dragTo(float x, float y) {
            float sy = this.computeStretch(this.mStartY - y, this.mMinDY, this.mMaxDY);
            float sx = this.computeStretch(this.mStartX - x, this.mMinDX, this.mMaxDX);
            if ((_Original_WebView.this.mSnapScrollMode & 2) != 0) {
                sy = 0.0f;
            } else if ((_Original_WebView.this.mSnapScrollMode & 4) != 0) {
                sx = 0.0f;
            }
            if (this.mCurrStretchX != sx || this.mCurrStretchY != sy) {
                this.mCurrStretchX = sx;
                this.mCurrStretchY = sy;
                if (this.mProxy.onStretchChange(sx, sy)) {
                    _Original_WebView.this.invalidate();
                }
            }
        }

        public void stopDrag() {
            int DURATION = 200;
            int now = (int)SystemClock.uptimeMillis();
            this.mInterp = new Interpolator(2);
            this.mXY[0] = this.mCurrStretchX;
            this.mXY[1] = this.mCurrStretchY;
            float[] blend = new float[]{0.0f, 0.5f, 0.75f, 1.0f};
            this.mInterp.setKeyFrame(0, now, this.mXY, blend);
            float[] zerozero = new float[]{0.0f, 0.0f};
            this.mInterp.setKeyFrame(1, now + 200, zerozero, null);
            this.mState = 1;
        }

        public boolean isFinished() {
            return this.mState == 2;
        }

        public int hiddenHeightOfTitleBar() {
            return _Original_WebView.this.getTitleHeight() - _Original_WebView.this.getVisibleTitleHeight();
        }

        public Bitmap.Config offscreenBitmapConfig() {
            return Bitmap.Config.RGB_565;
        }

        public boolean draw(Canvas canvas) {
            if (this.mCurrStretchX != 0.0f || this.mCurrStretchY != 0.0f) {
                int sx = _Original_WebView.this.getScrollX();
                int sy = _Original_WebView.this.getScrollY() - this.hiddenHeightOfTitleBar();
                if (this.mSX != sx || this.mSY != sy) {
                    this.buildBitmap(sx, sy);
                    this.mSX = sx;
                    this.mSY = sy;
                }
                if (this.mState == 1) {
                    Interpolator.Result result = this.mInterp.timeToValues(this.mXY);
                    if (result == Interpolator.Result.FREEZE_END) {
                        this.mState = 2;
                        return false;
                    }
                    this.mProxy.onStretchChange(this.mXY[0], this.mXY[1]);
                    _Original_WebView.this.invalidate();
                }
                int count = canvas.save(1);
                canvas.translate(sx, sy);
                this.mProxy.onDraw(canvas);
                canvas.restoreToCount(count);
                return true;
            }
            return false;
        }

        public void buildBitmap(int sx, int sy) {
            int w = _Original_WebView.this.getWidth();
            int h = _Original_WebView.this.getViewHeight();
            Bitmap bm = Bitmap.createBitmap(w, h, this.offscreenBitmapConfig());
            Canvas canvas = new Canvas(bm);
            canvas.translate(-sx, -sy);
            _Original_WebView.this.drawContent(canvas);
            this.mProxy.onBitmapChange(bm);
        }
    }

    public static class PostScale
    implements Runnable {
        public final _Original_WebView mWebView;
        public final boolean mUpdateTextWrap;

        public PostScale(_Original_WebView webView, boolean updateTextWrap) {
            this.mWebView = webView;
            this.mUpdateTextWrap = updateTextWrap;
        }

        public void run() {
            if (this.mWebView.mWebViewCore != null) {
                this.mWebView.setNewZoomScale(this.mWebView.mActualScale, this.mUpdateTextWrap, true);
                if (this.mWebView.getSettings().getBuiltInZoomControls()) {
                    this.mWebView.updateZoomButtonsEnabled();
                }
            }
        }
    }

    public class RequestFormData
    implements Runnable {
        public String mName;
        public String mUrl;
        public Message mUpdateMessage;

        public RequestFormData(String name, String url, Message msg) {
            this.mName = name;
            this.mUrl = url;
            this.mUpdateMessage = msg;
        }

        public void run() {
            ArrayList<String> pastEntries = _Original_WebView.this.mDatabase.getFormData(this.mUrl, this.mName);
            if (pastEntries.size() > 0) {
                WebTextView.AutoCompleteAdapter adapter = new WebTextView.AutoCompleteAdapter(_Original_WebView.this.mContext, pastEntries);
                this.mUpdateMessage.obj = adapter;
                this.mUpdateMessage.sendToTarget();
            }
        }
    }

    public static class ViewSizeData {
        public int mWidth;
        public int mHeight;
        public int mTextWrapWidth;
        public int mAnchorX;
        public int mAnchorY;
        public float mScale;
        public boolean mIgnoreHeight;
    }

    public class HitTestResult {
        public static final int UNKNOWN_TYPE = 0;
        public static final int ANCHOR_TYPE = 1;
        public static final int PHONE_TYPE = 2;
        public static final int GEO_TYPE = 3;
        public static final int EMAIL_TYPE = 4;
        public static final int IMAGE_TYPE = 5;
        public static final int IMAGE_ANCHOR_TYPE = 6;
        public static final int SRC_ANCHOR_TYPE = 7;
        public static final int SRC_IMAGE_ANCHOR_TYPE = 8;
        public static final int EDIT_TEXT_TYPE = 9;
        public int mType = 0;
        public String mExtra;

        public void setType(int type) {
            this.mType = type;
        }

        public void setExtra(String extra) {
            this.mExtra = extra;
        }

        public int getType() {
            return this.mType;
        }

        public String getExtra() {
            return this.mExtra;
        }
    }

    public static interface PictureListener {
        public void onNewPicture(_Original_WebView var1, Picture var2);
    }

    public class WebViewTransport {
        public _Original_WebView mWebview;

        public synchronized void setWebView(_Original_WebView webview) {
            this.mWebview = webview;
        }

        public synchronized _Original_WebView getWebView() {
            return this.mWebview;
        }
    }

    public static class ExtendedZoomControls
    extends FrameLayout {
        public ZoomControls mPlusMinusZoomControls;

        public ExtendedZoomControls(Context context, AttributeSet attrs) {
            super(context, attrs);
            LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
            inflater.inflate(17367151, (ViewGroup)this, true);
            this.mPlusMinusZoomControls = (ZoomControls)this.findViewById(16908847);
            this.findViewById(16908850).setVisibility(8);
        }

        public void show(boolean showZoom, boolean canZoomOut) {
            this.mPlusMinusZoomControls.setVisibility(showZoom ? 0 : 8);
            this.fade(0, 0.0f, 1.0f);
        }

        public void hide() {
            this.fade(8, 1.0f, 0.0f);
        }

        public void fade(int visibility, float startAlpha, float endAlpha) {
            AlphaAnimation anim2 = new AlphaAnimation(startAlpha, endAlpha);
            anim2.setDuration(500L);
            this.startAnimation(anim2);
            this.setVisibility(visibility);
        }

        public boolean hasFocus() {
            return this.mPlusMinusZoomControls.hasFocus();
        }

        public void setOnZoomInClickListener(View.OnClickListener listener) {
            this.mPlusMinusZoomControls.setOnZoomInClickListener(listener);
        }

        public void setOnZoomOutClickListener(View.OnClickListener listener) {
            this.mPlusMinusZoomControls.setOnZoomOutClickListener(listener);
        }
    }
}

