/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Parcel;
import android.os.Parcelable;
import android.view.InputEvent;

public class MotionEvent
extends InputEvent
implements Parcelable {
    public static final long MS_PER_NS = 1000000L;
    public static final boolean TRACK_RECYCLED_LOCATION = false;
    public static final int ACTION_MASK = 255;
    public static final int ACTION_DOWN = 0;
    public static final int ACTION_UP = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_CANCEL = 3;
    public static final int ACTION_OUTSIDE = 4;
    public static final int ACTION_POINTER_DOWN = 5;
    public static final int ACTION_POINTER_UP = 6;
    public static final int ACTION_POINTER_INDEX_MASK = 65280;
    public static final int ACTION_POINTER_INDEX_SHIFT = 8;
    @Deprecated
    public static final int ACTION_POINTER_1_DOWN = 5;
    @Deprecated
    public static final int ACTION_POINTER_2_DOWN = 261;
    @Deprecated
    public static final int ACTION_POINTER_3_DOWN = 517;
    @Deprecated
    public static final int ACTION_POINTER_1_UP = 6;
    @Deprecated
    public static final int ACTION_POINTER_2_UP = 262;
    @Deprecated
    public static final int ACTION_POINTER_3_UP = 518;
    @Deprecated
    public static final int ACTION_POINTER_ID_MASK = 65280;
    @Deprecated
    public static final int ACTION_POINTER_ID_SHIFT = 8;
    public static final int FLAG_WINDOW_IS_OBSCURED = 1;
    public static final int EDGE_TOP = 1;
    public static final int EDGE_BOTTOM = 2;
    public static final int EDGE_LEFT = 4;
    public static final int EDGE_RIGHT = 8;
    public static final int SAMPLE_X = 0;
    public static final int SAMPLE_Y = 1;
    public static final int SAMPLE_PRESSURE = 2;
    public static final int SAMPLE_SIZE = 3;
    public static final int SAMPLE_TOUCH_MAJOR = 4;
    public static final int SAMPLE_TOUCH_MINOR = 5;
    public static final int SAMPLE_TOOL_MAJOR = 6;
    public static final int SAMPLE_TOOL_MINOR = 7;
    public static final int SAMPLE_ORIENTATION = 8;
    public static final int NUM_SAMPLE_DATA = 9;
    public static final int BASE_AVAIL_POINTERS = 5;
    public static final int BASE_AVAIL_SAMPLES = 8;
    public static final int MAX_RECYCLED = 10;
    public static Object gRecyclerLock = new Object();
    public static int gRecyclerUsed = 0;
    public static MotionEvent gRecyclerTop = null;
    public long mDownTimeNano;
    public int mAction;
    public float mXOffset;
    public float mYOffset;
    public float mXPrecision;
    public float mYPrecision;
    public int mEdgeFlags;
    public int mMetaState;
    public int mFlags;
    public int mNumPointers;
    public int mNumSamples;
    public int mLastDataSampleIndex;
    public int mLastEventTimeNanoSampleIndex;
    public int[] mPointerIdentifiers;
    public float[] mDataSamples;
    public long[] mEventTimeNanoSamples;
    public MotionEvent mNext;
    public RuntimeException mRecycledLocation;
    public boolean mRecycled;
    public static final Parcelable.Creator<MotionEvent> CREATOR = new Parcelable.Creator<MotionEvent>(){

        @Override
        public MotionEvent createFromParcel(Parcel in) {
            in.readInt();
            return MotionEvent.createFromParcelBody(in);
        }

        public MotionEvent[] newArray(int size) {
            return new MotionEvent[size];
        }
    };

    public MotionEvent(int pointerCount, int sampleCount) {
        this.mPointerIdentifiers = new int[pointerCount];
        this.mDataSamples = new float[pointerCount * sampleCount * 9];
        this.mEventTimeNanoSamples = new long[sampleCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MotionEvent obtain(int pointerCount, int sampleCount) {
        int neededDataSamplesLength;
        MotionEvent ev;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerTop == null) {
                if (pointerCount < 5) {
                    pointerCount = 5;
                }
                if (sampleCount < 8) {
                    sampleCount = 8;
                }
                return new MotionEvent(pointerCount, sampleCount);
            }
            ev = gRecyclerTop;
            gRecyclerTop = ev.mNext;
            --gRecyclerUsed;
        }
        ev.mRecycledLocation = null;
        ev.mRecycled = false;
        ev.mNext = null;
        if (ev.mPointerIdentifiers.length < pointerCount) {
            ev.mPointerIdentifiers = new int[pointerCount];
        }
        if (ev.mEventTimeNanoSamples.length < sampleCount) {
            ev.mEventTimeNanoSamples = new long[sampleCount];
        }
        if (ev.mDataSamples.length < (neededDataSamplesLength = pointerCount * sampleCount * 9)) {
            ev.mDataSamples = new float[neededDataSamplesLength];
        }
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointers, int[] pointerIds, PointerCoords[] pointerCoords, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags, int source, int flags) {
        MotionEvent ev = MotionEvent.obtain(pointers, 1);
        ev.mDeviceId = deviceId;
        ev.mSource = source;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTimeNano = downTime * 1000000L;
        ev.mAction = action;
        ev.mFlags = flags;
        ev.mMetaState = metaState;
        ev.mXOffset = 0.0f;
        ev.mYOffset = 0.0f;
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        ev.mNumPointers = pointers;
        ev.mNumSamples = 1;
        ev.mLastDataSampleIndex = 0;
        ev.mLastEventTimeNanoSampleIndex = 0;
        System.arraycopy(pointerIds, 0, ev.mPointerIdentifiers, 0, pointers);
        ev.mEventTimeNanoSamples[0] = eventTime * 1000000L;
        ev.setPointerCoordsAtSampleIndex(0, pointerCoords);
        return ev;
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        MotionEvent ev = MotionEvent.obtain(1, 1);
        ev.mDeviceId = deviceId;
        ev.mSource = 0;
        ev.mEdgeFlags = edgeFlags;
        ev.mDownTimeNano = downTime * 1000000L;
        ev.mAction = action;
        ev.mFlags = 0;
        ev.mMetaState = metaState;
        ev.mXOffset = 0.0f;
        ev.mYOffset = 0.0f;
        ev.mXPrecision = xPrecision;
        ev.mYPrecision = yPrecision;
        ev.mNumPointers = 1;
        ev.mNumSamples = 1;
        ev.mLastDataSampleIndex = 0;
        ev.mLastEventTimeNanoSampleIndex = 0;
        ev.mPointerIdentifiers[0] = 0;
        ev.mEventTimeNanoSamples[0] = eventTime * 1000000L;
        ev.setPointerCoordsAtSampleIndex(0, x, y, pressure, size);
        return ev;
    }

    @Deprecated
    public static MotionEvent obtain(long downTime, long eventTime, int action, int pointers, float x, float y, float pressure, float size, int metaState, float xPrecision, float yPrecision, int deviceId, int edgeFlags) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, pressure, size, metaState, xPrecision, yPrecision, deviceId, edgeFlags);
    }

    public static MotionEvent obtain(long downTime, long eventTime, int action, float x, float y, int metaState) {
        return MotionEvent.obtain(downTime, eventTime, action, x, y, 1.0f, 1.0f, metaState, 1.0f, 1.0f, 0, 0);
    }

    public static MotionEvent obtain(MotionEvent o) {
        MotionEvent ev = MotionEvent.obtain(o.mNumPointers, o.mNumSamples);
        ev.mDeviceId = o.mDeviceId;
        ev.mSource = o.mSource;
        ev.mEdgeFlags = o.mEdgeFlags;
        ev.mDownTimeNano = o.mDownTimeNano;
        ev.mAction = o.mAction;
        ev.mFlags = o.mFlags;
        ev.mMetaState = o.mMetaState;
        ev.mXOffset = o.mXOffset;
        ev.mYOffset = o.mYOffset;
        ev.mXPrecision = o.mXPrecision;
        ev.mYPrecision = o.mYPrecision;
        int numPointers = ev.mNumPointers = o.mNumPointers;
        int numSamples = ev.mNumSamples = o.mNumSamples;
        ev.mLastDataSampleIndex = o.mLastDataSampleIndex;
        ev.mLastEventTimeNanoSampleIndex = o.mLastEventTimeNanoSampleIndex;
        System.arraycopy(o.mPointerIdentifiers, 0, ev.mPointerIdentifiers, 0, numPointers);
        System.arraycopy(o.mEventTimeNanoSamples, 0, ev.mEventTimeNanoSamples, 0, numSamples);
        System.arraycopy(o.mDataSamples, 0, ev.mDataSamples, 0, numPointers * numSamples * 9);
        return ev;
    }

    public static MotionEvent obtainNoHistory(MotionEvent o) {
        MotionEvent ev = MotionEvent.obtain(o.mNumPointers, 1);
        ev.mDeviceId = o.mDeviceId;
        ev.mSource = o.mSource;
        ev.mEdgeFlags = o.mEdgeFlags;
        ev.mDownTimeNano = o.mDownTimeNano;
        ev.mAction = o.mAction;
        o.mFlags = o.mFlags;
        ev.mMetaState = o.mMetaState;
        ev.mXOffset = o.mXOffset;
        ev.mYOffset = o.mYOffset;
        ev.mXPrecision = o.mXPrecision;
        ev.mYPrecision = o.mYPrecision;
        int numPointers = ev.mNumPointers = o.mNumPointers;
        ev.mNumSamples = 1;
        ev.mLastDataSampleIndex = 0;
        ev.mLastEventTimeNanoSampleIndex = 0;
        System.arraycopy(o.mPointerIdentifiers, 0, ev.mPointerIdentifiers, 0, numPointers);
        ev.mEventTimeNanoSamples[0] = o.mEventTimeNanoSamples[o.mLastEventTimeNanoSampleIndex];
        System.arraycopy(o.mDataSamples, o.mLastDataSampleIndex, ev.mDataSamples, 0, numPointers * 9);
        return ev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        if (this.mRecycled) {
            throw new RuntimeException(this.toString() + " recycled twice!");
        }
        this.mRecycled = true;
        Object object = gRecyclerLock;
        synchronized (object) {
            if (gRecyclerUsed < 10) {
                ++gRecyclerUsed;
                this.mNumSamples = 0;
                this.mNext = gRecyclerTop;
                gRecyclerTop = this;
            }
        }
    }

    public void scale(float scale) {
        this.mXOffset *= scale;
        this.mYOffset *= scale;
        this.mXPrecision *= scale;
        this.mYPrecision *= scale;
        float[] history = this.mDataSamples;
        int length = this.mNumPointers * this.mNumSamples * 9;
        for (int i = 0; i < length; i += 9) {
            int n = i + 0;
            history[n] = history[n] * scale;
            int n2 = i + 1;
            history[n2] = history[n2] * scale;
            int n3 = i + 3;
            history[n3] = history[n3] * scale;
            int n4 = i + 4;
            history[n4] = history[n4] * scale;
            int n5 = i + 5;
            history[n5] = history[n5] * scale;
            int n6 = i + 6;
            history[n6] = history[n6] * scale;
            int n7 = i + 7;
            history[n7] = history[n7] * scale;
        }
    }

    public int getAction() {
        return this.mAction;
    }

    public int getActionMasked() {
        return this.mAction & 0xFF;
    }

    public int getActionIndex() {
        return (this.mAction & 0xFF00) >> 8;
    }

    public int getFlags() {
        return this.mFlags;
    }

    public long getDownTime() {
        return this.mDownTimeNano / 1000000L;
    }

    public long getEventTime() {
        return this.mEventTimeNanoSamples[this.mLastEventTimeNanoSampleIndex] / 1000000L;
    }

    public long getEventTimeNano() {
        return this.mEventTimeNanoSamples[this.mLastEventTimeNanoSampleIndex];
    }

    public float getX() {
        return this.mDataSamples[this.mLastDataSampleIndex + 0] + this.mXOffset;
    }

    public float getY() {
        return this.mDataSamples[this.mLastDataSampleIndex + 1] + this.mYOffset;
    }

    public float getPressure() {
        return this.mDataSamples[this.mLastDataSampleIndex + 2];
    }

    public float getSize() {
        return this.mDataSamples[this.mLastDataSampleIndex + 3];
    }

    public float getTouchMajor() {
        return this.mDataSamples[this.mLastDataSampleIndex + 4];
    }

    public float getTouchMinor() {
        return this.mDataSamples[this.mLastDataSampleIndex + 5];
    }

    public float getToolMajor() {
        return this.mDataSamples[this.mLastDataSampleIndex + 6];
    }

    public float getToolMinor() {
        return this.mDataSamples[this.mLastDataSampleIndex + 7];
    }

    public float getOrientation() {
        return this.mDataSamples[this.mLastDataSampleIndex + 8];
    }

    public int getPointerCount() {
        return this.mNumPointers;
    }

    public int getPointerId(int pointerIndex) {
        return this.mPointerIdentifiers[pointerIndex];
    }

    public int findPointerIndex(int pointerId) {
        int i = this.mNumPointers;
        while (i > 0) {
            if (this.mPointerIdentifiers[--i] != pointerId) continue;
            return i;
        }
        return -1;
    }

    public float getX(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 0] + this.mXOffset;
    }

    public float getY(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 1] + this.mYOffset;
    }

    public float getPressure(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 2];
    }

    public float getSize(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 3];
    }

    public float getTouchMajor(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 4];
    }

    public float getTouchMinor(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 5];
    }

    public float getToolMajor(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 6];
    }

    public float getToolMinor(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 7];
    }

    public float getOrientation(int pointerIndex) {
        return this.mDataSamples[this.mLastDataSampleIndex + pointerIndex * 9 + 8];
    }

    public void getPointerCoords(int pointerIndex, PointerCoords outPointerCoords) {
        int sampleIndex = this.mLastDataSampleIndex + pointerIndex * 9;
        this.getPointerCoordsAtSampleIndex(sampleIndex, outPointerCoords);
    }

    public int getMetaState() {
        return this.mMetaState;
    }

    public float getRawX() {
        return this.mDataSamples[this.mLastDataSampleIndex + 0];
    }

    public float getRawY() {
        return this.mDataSamples[this.mLastDataSampleIndex + 1];
    }

    public float getXPrecision() {
        return this.mXPrecision;
    }

    public float getYPrecision() {
        return this.mYPrecision;
    }

    public int getHistorySize() {
        return this.mLastEventTimeNanoSampleIndex;
    }

    public long getHistoricalEventTime(int pos) {
        return this.mEventTimeNanoSamples[pos] / 1000000L;
    }

    public float getHistoricalX(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 0] + this.mXOffset;
    }

    public float getHistoricalY(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 1] + this.mYOffset;
    }

    public float getHistoricalPressure(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 2];
    }

    public float getHistoricalSize(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 3];
    }

    public float getHistoricalTouchMajor(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 4];
    }

    public float getHistoricalTouchMinor(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 5];
    }

    public float getHistoricalToolMajor(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 6];
    }

    public float getHistoricalToolMinor(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 7];
    }

    public float getHistoricalOrientation(int pos) {
        return this.mDataSamples[pos * this.mNumPointers * 9 + 8];
    }

    public float getHistoricalX(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 0] + this.mXOffset;
    }

    public float getHistoricalY(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 1] + this.mYOffset;
    }

    public float getHistoricalPressure(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 2];
    }

    public float getHistoricalSize(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 3];
    }

    public float getHistoricalTouchMajor(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 4];
    }

    public float getHistoricalTouchMinor(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 5];
    }

    public float getHistoricalToolMajor(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 6];
    }

    public float getHistoricalToolMinor(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 7];
    }

    public float getHistoricalOrientation(int pointerIndex, int pos) {
        return this.mDataSamples[(pos * this.mNumPointers + pointerIndex) * 9 + 8];
    }

    public void getHistoricalPointerCoords(int pointerIndex, int pos, PointerCoords outPointerCoords) {
        int sampleIndex = (pos * this.mNumPointers + pointerIndex) * 9;
        this.getPointerCoordsAtSampleIndex(sampleIndex, outPointerCoords);
    }

    public int getEdgeFlags() {
        return this.mEdgeFlags;
    }

    public void setEdgeFlags(int flags) {
        this.mEdgeFlags = flags;
    }

    public void setAction(int action) {
        this.mAction = action;
    }

    public void offsetLocation(float deltaX, float deltaY) {
        this.mXOffset += deltaX;
        this.mYOffset += deltaY;
    }

    public void setLocation(float x, float y) {
        float[] dataSamples = this.mDataSamples;
        int lastDataSampleIndex = this.mLastDataSampleIndex;
        this.mXOffset = x - dataSamples[lastDataSampleIndex + 0];
        this.mYOffset = y - dataSamples[lastDataSampleIndex + 1];
    }

    public void getPointerCoordsAtSampleIndex(int sampleIndex, PointerCoords outPointerCoords) {
        float[] dataSamples = this.mDataSamples;
        outPointerCoords.x = dataSamples[sampleIndex + 0] + this.mXOffset;
        outPointerCoords.y = dataSamples[sampleIndex + 1] + this.mYOffset;
        outPointerCoords.pressure = dataSamples[sampleIndex + 2];
        outPointerCoords.size = dataSamples[sampleIndex + 3];
        outPointerCoords.touchMajor = dataSamples[sampleIndex + 4];
        outPointerCoords.touchMinor = dataSamples[sampleIndex + 5];
        outPointerCoords.toolMajor = dataSamples[sampleIndex + 6];
        outPointerCoords.toolMinor = dataSamples[sampleIndex + 7];
        outPointerCoords.orientation = dataSamples[sampleIndex + 8];
    }

    public void setPointerCoordsAtSampleIndex(int sampleIndex, PointerCoords[] pointerCoords) {
        int numPointers = this.mNumPointers;
        for (int i = 0; i < numPointers; ++i) {
            this.setPointerCoordsAtSampleIndex(sampleIndex, pointerCoords[i]);
            sampleIndex += 9;
        }
    }

    public void setPointerCoordsAtSampleIndex(int sampleIndex, PointerCoords pointerCoords) {
        float[] dataSamples = this.mDataSamples;
        dataSamples[sampleIndex + 0] = pointerCoords.x - this.mXOffset;
        dataSamples[sampleIndex + 1] = pointerCoords.y - this.mYOffset;
        dataSamples[sampleIndex + 2] = pointerCoords.pressure;
        dataSamples[sampleIndex + 3] = pointerCoords.size;
        dataSamples[sampleIndex + 4] = pointerCoords.touchMajor;
        dataSamples[sampleIndex + 5] = pointerCoords.touchMinor;
        dataSamples[sampleIndex + 6] = pointerCoords.toolMajor;
        dataSamples[sampleIndex + 7] = pointerCoords.toolMinor;
        dataSamples[sampleIndex + 8] = pointerCoords.orientation;
    }

    public void setPointerCoordsAtSampleIndex(int sampleIndex, float x, float y, float pressure, float size) {
        float[] dataSamples = this.mDataSamples;
        dataSamples[sampleIndex + 0] = x - this.mXOffset;
        dataSamples[sampleIndex + 1] = y - this.mYOffset;
        dataSamples[sampleIndex + 2] = pressure;
        dataSamples[sampleIndex + 3] = size;
        dataSamples[sampleIndex + 4] = pressure;
        dataSamples[sampleIndex + 5] = pressure;
        dataSamples[sampleIndex + 6] = size;
        dataSamples[sampleIndex + 7] = size;
        dataSamples[sampleIndex + 8] = 0.0f;
    }

    public void incrementNumSamplesAndReserveStorage(int dataSampleStride) {
        int nextDataSampleIndex;
        if (this.mNumSamples == this.mEventTimeNanoSamples.length) {
            long[] newEventTimeNanoSamples = new long[this.mNumSamples + 8];
            System.arraycopy(this.mEventTimeNanoSamples, 0, newEventTimeNanoSamples, 0, this.mNumSamples);
            this.mEventTimeNanoSamples = newEventTimeNanoSamples;
        }
        if ((nextDataSampleIndex = this.mLastDataSampleIndex + dataSampleStride) + dataSampleStride > this.mDataSamples.length) {
            float[] newDataSamples = new float[nextDataSampleIndex + 8 * dataSampleStride];
            System.arraycopy(this.mDataSamples, 0, newDataSamples, 0, nextDataSampleIndex);
            this.mDataSamples = newDataSamples;
        }
        this.mLastEventTimeNanoSampleIndex = this.mNumSamples++;
        this.mLastDataSampleIndex = nextDataSampleIndex;
    }

    public void addBatch(long eventTime, float x, float y, float pressure, float size, int metaState) {
        this.incrementNumSamplesAndReserveStorage(9);
        this.mEventTimeNanoSamples[this.mLastEventTimeNanoSampleIndex] = eventTime * 1000000L;
        this.setPointerCoordsAtSampleIndex(this.mLastDataSampleIndex, x, y, pressure, size);
        this.mMetaState |= metaState;
    }

    public void addBatch(long eventTime, PointerCoords[] pointerCoords, int metaState) {
        int dataSampleStride = this.mNumPointers * 9;
        this.incrementNumSamplesAndReserveStorage(dataSampleStride);
        this.mEventTimeNanoSamples[this.mLastEventTimeNanoSampleIndex] = eventTime * 1000000L;
        this.setPointerCoordsAtSampleIndex(this.mLastDataSampleIndex, pointerCoords);
        this.mMetaState |= metaState;
    }

    public String toString() {
        return "MotionEvent{" + Integer.toHexString(System.identityHashCode(this)) + " action=" + this.mAction + " x=" + this.getX() + " y=" + this.getY() + " pressure=" + this.getPressure() + " size=" + this.getSize() + "}";
    }

    public static MotionEvent createFromParcelBody(Parcel in) {
        int NP = in.readInt();
        int NS = in.readInt();
        int NI = NP * NS * 9;
        MotionEvent ev = MotionEvent.obtain(NP, NS);
        ev.mNumPointers = NP;
        ev.mNumSamples = NS;
        ev.readBaseFromParcel(in);
        ev.mDownTimeNano = in.readLong();
        ev.mAction = in.readInt();
        ev.mXOffset = in.readFloat();
        ev.mYOffset = in.readFloat();
        ev.mXPrecision = in.readFloat();
        ev.mYPrecision = in.readFloat();
        ev.mEdgeFlags = in.readInt();
        ev.mMetaState = in.readInt();
        ev.mFlags = in.readInt();
        int[] pointerIdentifiers = ev.mPointerIdentifiers;
        for (int i = 0; i < NP; ++i) {
            pointerIdentifiers[i] = in.readInt();
        }
        long[] eventTimeNanoSamples = ev.mEventTimeNanoSamples;
        for (int i = 0; i < NS; ++i) {
            eventTimeNanoSamples[i] = in.readLong();
        }
        float[] dataSamples = ev.mDataSamples;
        for (int i = 0; i < NI; ++i) {
            dataSamples[i] = in.readFloat();
        }
        ev.mLastEventTimeNanoSampleIndex = NS - 1;
        ev.mLastDataSampleIndex = (NS - 1) * NP * 9;
        return ev;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(1);
        int NP = this.mNumPointers;
        int NS = this.mNumSamples;
        int NI = NP * NS * 9;
        out.writeInt(NP);
        out.writeInt(NS);
        this.writeBaseToParcel(out);
        out.writeLong(this.mDownTimeNano);
        out.writeInt(this.mAction);
        out.writeFloat(this.mXOffset);
        out.writeFloat(this.mYOffset);
        out.writeFloat(this.mXPrecision);
        out.writeFloat(this.mYPrecision);
        out.writeInt(this.mEdgeFlags);
        out.writeInt(this.mMetaState);
        out.writeInt(this.mFlags);
        int[] pointerIdentifiers = this.mPointerIdentifiers;
        for (int i = 0; i < NP; ++i) {
            out.writeInt(pointerIdentifiers[i]);
        }
        long[] eventTimeNanoSamples = this.mEventTimeNanoSamples;
        for (int i = 0; i < NS; ++i) {
            out.writeLong(eventTimeNanoSamples[i]);
        }
        float[] dataSamples = this.mDataSamples;
        for (int i = 0; i < NI; ++i) {
            out.writeFloat(dataSamples[i]);
        }
    }

    public static class PointerCoords {
        public float x;
        public float y;
        public float pressure;
        public float size;
        public float touchMajor;
        public float touchMinor;
        public float toolMajor;
        public float toolMinor;
        public float orientation;
    }
}

