/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.IWindowManager;
import android.view.KeyEvent;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class KeyCharacterMap {
    public static final int BUILT_IN_KEYBOARD = 0;
    public static final int NUMERIC = 1;
    public static final int PREDICTIVE = 2;
    public static final int ALPHA = 3;
    public static final char HEX_INPUT = '\uef00';
    public static final char PICKER_DIALOG_INPUT = '\uef01';
    public static Object sLock = new Object();
    public static SparseArray<WeakReference<KeyCharacterMap>> sInstances = new SparseArray();
    public int mPointer;
    public int mKeyboardDevice;
    public static SparseIntArray COMBINING = new SparseIntArray();
    public static SparseIntArray DEAD = new SparseIntArray();
    public static final int ACUTE = 0xB40000;
    public static final int GRAVE = 0x600000;
    public static final int CIRCUMFLEX = 0x5E0000;
    public static final int TILDE = 0x7E0000;
    public static final int UMLAUT = 0xA80000;
    public static final int COMBINING_ACCENT = Integer.MIN_VALUE;
    public static final int COMBINING_ACCENT_MASK = Integer.MAX_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyCharacterMap load(int keyboard) {
        Object object = sLock;
        synchronized (object) {
            KeyCharacterMap result;
            WeakReference<KeyCharacterMap> ref = sInstances.get(keyboard);
            if (ref != null && (result = (KeyCharacterMap)ref.get()) != null) {
                return result;
            }
            result = new KeyCharacterMap(keyboard);
            sInstances.put(keyboard, new WeakReference<KeyCharacterMap>(result));
            return result;
        }
    }

    public KeyCharacterMap(int keyboardDevice) {
        this.mKeyboardDevice = keyboardDevice;
        this.mPointer = KeyCharacterMap.ctor_native(keyboardDevice);
    }

    public int get(int keyCode, int meta) {
        char ret;
        int map;
        if ((meta & 0x100) != 0) {
            meta |= 1;
        }
        if ((meta & 0x200) != 0) {
            meta |= 2;
        }
        if ((meta & 0x100) != 0 && KeyCharacterMap.get_native(this.mPointer, keyCode, 1) == KeyCharacterMap.get_native(this.mPointer, keyCode, 2)) {
            meta &= 0xFFFFFFFE;
        }
        if ((map = COMBINING.get(ret = KeyCharacterMap.get_native(this.mPointer, keyCode, meta))) != 0) {
            return map;
        }
        return ret;
    }

    public char getNumber(int keyCode) {
        return KeyCharacterMap.getNumber_native(this.mPointer, keyCode);
    }

    public char getMatch(int keyCode, char[] chars) {
        return this.getMatch(keyCode, chars, 0);
    }

    public char getMatch(int keyCode, char[] chars, int modifiers) {
        if (chars == null) {
            throw new NullPointerException();
        }
        return KeyCharacterMap.getMatch_native(this.mPointer, keyCode, chars, modifiers);
    }

    public char getDisplayLabel(int keyCode) {
        return KeyCharacterMap.getDisplayLabel_native(this.mPointer, keyCode);
    }

    public static int getDeadChar(int accent, int c) {
        return DEAD.get(accent << 16 | c);
    }

    public boolean getKeyData(int keyCode, KeyData results) {
        if (results.meta.length >= 4) {
            return KeyCharacterMap.getKeyData_native(this.mPointer, keyCode, results);
        }
        throw new IndexOutOfBoundsException("results.meta.length must be >= 4");
    }

    public KeyEvent[] getEvents(char[] chars) {
        if (chars == null) {
            throw new NullPointerException();
        }
        long[] keys = KeyCharacterMap.getEvents_native(this.mPointer, chars);
        if (keys == null) {
            return null;
        }
        int len = keys.length * 2;
        int N = keys.length;
        for (int i = 0; i < N; ++i) {
            int mods = (int)(keys[i] >> 32);
            if ((mods & 2) != 0) {
                len += 2;
            }
            if ((mods & 1) != 0) {
                len += 2;
            }
            if ((mods & 4) == 0) continue;
            len += 2;
        }
        KeyEvent[] rv = new KeyEvent[len];
        int index = 0;
        long now = SystemClock.uptimeMillis();
        int device = this.mKeyboardDevice;
        for (int i = 0; i < N; ++i) {
            int mods = (int)(keys[i] >> 32);
            int meta = 0;
            if ((mods & 2) != 0) {
                rv[index] = new KeyEvent(now, now, 0, 57, 0, meta |= 2, device, 0);
                ++index;
            }
            if ((mods & 1) != 0) {
                rv[index] = new KeyEvent(now, now, 0, 59, 0, meta |= 1, device, 0);
                ++index;
            }
            if ((mods & 4) != 0) {
                rv[index] = new KeyEvent(now, now, 0, 63, 0, meta |= 4, device, 0);
                ++index;
            }
            int key = (int)keys[i];
            rv[index] = new KeyEvent(now, now, 0, key, 0, meta, device, 0);
            rv[++index] = new KeyEvent(now, now, 1, key, 0, meta, device, 0);
            ++index;
            if ((mods & 2) != 0) {
                rv[index] = new KeyEvent(now, now, 1, 57, 0, meta &= 0xFFFFFFFD, device, 0);
                ++index;
            }
            if ((mods & 1) != 0) {
                rv[index] = new KeyEvent(now, now, 1, 59, 0, meta &= 0xFFFFFFFE, device, 0);
                ++index;
            }
            if ((mods & 4) == 0) continue;
            rv[index] = new KeyEvent(now, now, 1, 63, 0, meta &= 0xFFFFFFFB, device, 0);
            ++index;
        }
        return rv;
    }

    public boolean isPrintingKey(int keyCode) {
        int type = Character.getType(this.get(keyCode, 0));
        switch (type) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    public void finalize() throws Throwable {
        KeyCharacterMap.dtor_native(this.mPointer);
    }

    public int getKeyboardType() {
        return KeyCharacterMap.getKeyboardType_native(this.mPointer);
    }

    public static boolean deviceHasKey(int keyCode) {
        int[] codeArray = new int[]{keyCode};
        boolean[] ret = KeyCharacterMap.deviceHasKeys(codeArray);
        return ret[0];
    }

    public static boolean[] deviceHasKeys(int[] keyCodes) {
        boolean[] ret = new boolean[keyCodes.length];
        IWindowManager wm = IWindowManager.Stub.asInterface(ServiceManager.getService((String)"window"));
        try {
            wm.hasKeys(keyCodes, ret);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return ret;
    }

    public static int ctor_native(int n) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#ctor_native(I)I", true, null);
    }

    public static void dtor_native(int n) {
        OverrideMethod.invokeV("android.view.KeyCharacterMap#dtor_native(I)V", true, null);
    }

    public static char get_native(int n, int n2, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#get_native(III)C", true, null);
    }

    public static char getNumber_native(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#getNumber_native(II)C", true, null);
    }

    public static char getMatch_native(int n, int n2, char[] cArray, int n3) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#getMatch_native(II[CI)C", true, null);
    }

    public static char getDisplayLabel_native(int n, int n2) {
        return (char)OverrideMethod.invokeI("android.view.KeyCharacterMap#getDisplayLabel_native(II)C", true, null);
    }

    public static boolean getKeyData_native(int n, int n2, KeyData keyData) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#getKeyData_native(IILandroid/view/KeyCharacterMap$KeyData;)Z", true, null) != 0;
    }

    public static int getKeyboardType_native(int n) {
        return OverrideMethod.invokeI("android.view.KeyCharacterMap#getKeyboardType_native(I)I", true, null);
    }

    public static long[] getEvents_native(int n, char[] cArray) {
        return (long[])OverrideMethod.invokeA("android.view.KeyCharacterMap#getEvents_native(I[C)[J", true, null);
    }

    static {
        COMBINING.put(768, -2147483552);
        COMBINING.put(769, -2147483468);
        COMBINING.put(770, -2147483554);
        COMBINING.put(771, -2147483522);
        COMBINING.put(776, -2147483480);
        DEAD.put(11796545, 193);
        DEAD.put(11796547, 262);
        DEAD.put(11796549, 201);
        DEAD.put(11796551, 500);
        DEAD.put(11796553, 205);
        DEAD.put(0xB4004B, 7728);
        DEAD.put(11796556, 313);
        DEAD.put(11796557, 7742);
        DEAD.put(11796558, 323);
        DEAD.put(11796559, 211);
        DEAD.put(11796560, 7764);
        DEAD.put(11796562, 340);
        DEAD.put(11796563, 346);
        DEAD.put(11796565, 218);
        DEAD.put(11796567, 7810);
        DEAD.put(11796569, 221);
        DEAD.put(11796570, 377);
        DEAD.put(11796577, 225);
        DEAD.put(11796579, 263);
        DEAD.put(11796581, 233);
        DEAD.put(11796583, 501);
        DEAD.put(11796585, 237);
        DEAD.put(11796587, 7729);
        DEAD.put(11796588, 314);
        DEAD.put(11796589, 7743);
        DEAD.put(11796590, 324);
        DEAD.put(11796591, 243);
        DEAD.put(11796592, 7765);
        DEAD.put(11796594, 341);
        DEAD.put(11796595, 347);
        DEAD.put(11796597, 250);
        DEAD.put(11796599, 7811);
        DEAD.put(11796601, 253);
        DEAD.put(11796602, 378);
        DEAD.put(6160449, 194);
        DEAD.put(6160451, 264);
        DEAD.put(6160453, 202);
        DEAD.put(6160455, 284);
        DEAD.put(6160456, 292);
        DEAD.put(6160457, 206);
        DEAD.put(6160458, 308);
        DEAD.put(6160463, 212);
        DEAD.put(6160467, 348);
        DEAD.put(0x5E0055, 219);
        DEAD.put(6160471, 372);
        DEAD.put(6160473, 374);
        DEAD.put(6160474, 7824);
        DEAD.put(6160481, 226);
        DEAD.put(6160483, 265);
        DEAD.put(6160485, 234);
        DEAD.put(6160487, 285);
        DEAD.put(6160488, 293);
        DEAD.put(6160489, 238);
        DEAD.put(6160490, 309);
        DEAD.put(6160495, 244);
        DEAD.put(6160499, 349);
        DEAD.put(6160501, 251);
        DEAD.put(6160503, 373);
        DEAD.put(6160505, 375);
        DEAD.put(6160506, 7825);
        DEAD.put(6291521, 192);
        DEAD.put(6291525, 200);
        DEAD.put(6291529, 204);
        DEAD.put(6291534, 504);
        DEAD.put(6291535, 210);
        DEAD.put(0x600055, 217);
        DEAD.put(6291543, 7808);
        DEAD.put(6291545, 7922);
        DEAD.put(0x600061, 224);
        DEAD.put(0x600065, 232);
        DEAD.put(0x600069, 236);
        DEAD.put(0x60006E, 505);
        DEAD.put(0x60006F, 242);
        DEAD.put(6291573, 249);
        DEAD.put(0x600077, 7809);
        DEAD.put(6291577, 7923);
        DEAD.put(8257601, 195);
        DEAD.put(8257605, 7868);
        DEAD.put(8257609, 296);
        DEAD.put(8257614, 209);
        DEAD.put(8257615, 213);
        DEAD.put(8257621, 360);
        DEAD.put(8257622, 7804);
        DEAD.put(8257625, 7928);
        DEAD.put(8257633, 227);
        DEAD.put(8257637, 7869);
        DEAD.put(8257641, 297);
        DEAD.put(8257646, 241);
        DEAD.put(8257647, 245);
        DEAD.put(8257653, 361);
        DEAD.put(8257654, 7805);
        DEAD.put(8257657, 7929);
        DEAD.put(11010113, 196);
        DEAD.put(11010117, 203);
        DEAD.put(11010120, 7718);
        DEAD.put(11010121, 207);
        DEAD.put(11010127, 214);
        DEAD.put(11010133, 220);
        DEAD.put(11010135, 7812);
        DEAD.put(11010136, 7820);
        DEAD.put(11010137, 376);
        DEAD.put(11010145, 228);
        DEAD.put(11010149, 235);
        DEAD.put(11010152, 7719);
        DEAD.put(11010153, 239);
        DEAD.put(11010159, 246);
        DEAD.put(11010164, 7831);
        DEAD.put(11010165, 252);
        DEAD.put(11010167, 7813);
        DEAD.put(11010168, 7821);
        DEAD.put(11010169, 255);
    }

    public static class KeyData {
        public static final int META_LENGTH = 4;
        public char displayLabel;
        public char number;
        public char[] meta = new char[4];
    }
}

