/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.text.style.DynamicDrawableSpan;
import android.util.Log;
import java.io.InputStream;

public class ImageSpan
extends DynamicDrawableSpan {
    public Drawable mDrawable;
    public Uri mContentUri;
    public int mResourceId;
    public Context mContext;
    public String mSource;

    @Deprecated
    public ImageSpan(Bitmap b) {
        this(null, b, 0);
    }

    @Deprecated
    public ImageSpan(Bitmap b, int verticalAlignment) {
        this(null, b, verticalAlignment);
    }

    public ImageSpan(Context context, Bitmap b) {
        this(context, b, 0);
    }

    public ImageSpan(Context context, Bitmap b, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mDrawable = context != null ? new BitmapDrawable(context.getResources(), b) : new BitmapDrawable(b);
        int width = this.mDrawable.getIntrinsicWidth();
        int height = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(0, 0, width > 0 ? width : 0, height > 0 ? height : 0);
    }

    public ImageSpan(Drawable d) {
        this(d, 0);
    }

    public ImageSpan(Drawable d, int verticalAlignment) {
        super(verticalAlignment);
        this.mDrawable = d;
    }

    public ImageSpan(Drawable d, String source) {
        this(d, source, 0);
    }

    public ImageSpan(Drawable d, String source, int verticalAlignment) {
        super(verticalAlignment);
        this.mDrawable = d;
        this.mSource = source;
    }

    public ImageSpan(Context context, Uri uri) {
        this(context, uri, 0);
    }

    public ImageSpan(Context context, Uri uri, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mContentUri = uri;
        this.mSource = uri.toString();
    }

    public ImageSpan(Context context, int resourceId) {
        this(context, resourceId, 0);
    }

    public ImageSpan(Context context, int resourceId, int verticalAlignment) {
        super(verticalAlignment);
        this.mContext = context;
        this.mResourceId = resourceId;
    }

    public Drawable getDrawable() {
        Drawable drawable2 = null;
        if (this.mDrawable != null) {
            drawable2 = this.mDrawable;
        } else if (this.mContentUri != null) {
            Bitmap bitmap = null;
            try {
                InputStream is = this.mContext.getContentResolver().openInputStream(this.mContentUri);
                bitmap = BitmapFactory.decodeStream(is);
                drawable2 = new BitmapDrawable(this.mContext.getResources(), bitmap);
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                is.close();
            }
            catch (Exception e) {
                Log.e("sms", "Failed to loaded content " + this.mContentUri, e);
            }
        } else {
            try {
                drawable2 = this.mContext.getResources().getDrawable(this.mResourceId);
                drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
            }
            catch (Exception e) {
                Log.e("sms", "Unable to find resource: " + this.mResourceId);
            }
        }
        return drawable2;
    }

    public String getSource() {
        return this.mSource;
    }
}

