/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Rect;
import android.os.Handler;
import android.os.SystemClock;
import android.text.Editable;
import android.text.GetChars;
import android.text.NoCopySpan;
import android.text.Spannable;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.TextKeyListener;
import android.text.method.TransformationMethod;
import android.text.style.UpdateLayout;
import android.view.View;
import java.lang.ref.WeakReference;

public class PasswordTransformationMethod
implements TransformationMethod,
TextWatcher {
    public static PasswordTransformationMethod sInstance;
    public static char DOT;

    public CharSequence getTransformation(CharSequence source, View view) {
        if (source instanceof Spannable) {
            Spannable sp = (Spannable)source;
            ViewReference[] vr = sp.getSpans(0, sp.length(), ViewReference.class);
            for (int i = 0; i < vr.length; ++i) {
                sp.removeSpan(vr[i]);
            }
            PasswordTransformationMethod.removeVisibleSpans(sp);
            sp.setSpan(new ViewReference(view), 0, 0, 34);
        }
        return new PasswordCharSequence(source);
    }

    public static PasswordTransformationMethod getInstance() {
        if (sInstance != null) {
            return sInstance;
        }
        sInstance = new PasswordTransformationMethod();
        return sInstance;
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        if (s instanceof Spannable) {
            Spannable sp = (Spannable)s;
            ViewReference[] vr = sp.getSpans(0, s.length(), ViewReference.class);
            if (vr.length == 0) {
                return;
            }
            View v = null;
            for (int i = 0; v == null && i < vr.length; ++i) {
                v = (View)vr[i].get();
            }
            if (v == null) {
                return;
            }
            int pref = TextKeyListener.getInstance().getPrefs(v.getContext());
            if ((pref & 8) != 0 && count > 0) {
                PasswordTransformationMethod.removeVisibleSpans(sp);
                if (count == 1) {
                    sp.setSpan(new Visible(sp, this), start, start + count, 33);
                }
            }
        }
    }

    public void afterTextChanged(Editable s) {
    }

    public void onFocusChanged(View view, CharSequence sourceText, boolean focused, int direction, Rect previouslyFocusedRect) {
        if (!focused && sourceText instanceof Spannable) {
            Spannable sp = (Spannable)sourceText;
            PasswordTransformationMethod.removeVisibleSpans(sp);
        }
    }

    public static void removeVisibleSpans(Spannable sp) {
        Visible[] old = sp.getSpans(0, sp.length(), Visible.class);
        for (int i = 0; i < old.length; ++i) {
            sp.removeSpan(old[i]);
        }
    }

    static {
        DOT = (char)8226;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewReference
    extends WeakReference<View>
    implements NoCopySpan {
        public ViewReference(View v) {
            super(v);
        }
    }

    public static class Visible
    extends Handler
    implements UpdateLayout,
    Runnable {
        public Spannable mText;
        public PasswordTransformationMethod mTransformer;

        public Visible(Spannable sp, PasswordTransformationMethod ptm) {
            this.mText = sp;
            this.mTransformer = ptm;
            this.postAtTime(this, SystemClock.uptimeMillis() + 1500L);
        }

        public void run() {
            this.mText.removeSpan(this);
        }
    }

    public static class PasswordCharSequence
    implements CharSequence,
    GetChars {
        public CharSequence mSource;

        public PasswordCharSequence(CharSequence source) {
            this.mSource = source;
        }

        public int length() {
            return this.mSource.length();
        }

        public char charAt(int i) {
            if (this.mSource instanceof Spanned) {
                Spanned sp = (Spanned)this.mSource;
                int st = sp.getSpanStart(TextKeyListener.ACTIVE);
                int en2 = sp.getSpanEnd(TextKeyListener.ACTIVE);
                if (i >= st && i < en2) {
                    return this.mSource.charAt(i);
                }
                Visible[] visible = sp.getSpans(0, sp.length(), Visible.class);
                for (int a = 0; a < visible.length; ++a) {
                    if (sp.getSpanStart(visible[a].mTransformer) < 0) continue;
                    st = sp.getSpanStart(visible[a]);
                    en2 = sp.getSpanEnd(visible[a]);
                    if (i < st || i >= en2) continue;
                    return this.mSource.charAt(i);
                }
            }
            return DOT;
        }

        public CharSequence subSequence(int start, int end) {
            char[] buf = new char[end - start];
            this.getChars(start, end, buf, 0);
            return new String(buf);
        }

        public String toString() {
            return ((Object)this.subSequence(0, this.length())).toString();
        }

        public void getChars(int start, int end, char[] dest, int off) {
            TextUtils.getChars(this.mSource, start, end, dest, off);
            int st = -1;
            int en2 = -1;
            int nvisible = 0;
            int[] starts = null;
            int[] ends = null;
            if (this.mSource instanceof Spanned) {
                Spanned sp = (Spanned)this.mSource;
                st = sp.getSpanStart(TextKeyListener.ACTIVE);
                en2 = sp.getSpanEnd(TextKeyListener.ACTIVE);
                Visible[] visible = sp.getSpans(0, sp.length(), Visible.class);
                nvisible = visible.length;
                starts = new int[nvisible];
                ends = new int[nvisible];
                for (int i = 0; i < nvisible; ++i) {
                    if (sp.getSpanStart(visible[i].mTransformer) < 0) continue;
                    starts[i] = sp.getSpanStart(visible[i]);
                    ends[i] = sp.getSpanEnd(visible[i]);
                }
            }
            for (int i = start; i < end; ++i) {
                if (i >= st && i < en2) continue;
                boolean visible = false;
                for (int a = 0; a < nvisible; ++a) {
                    if (i < starts[a] || i >= ends[a]) continue;
                    visible = true;
                    break;
                }
                if (visible) continue;
                dest[i - start + off] = DOT;
            }
        }
    }
}

