/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.text.SpannableString;
import android.text.Spanned;
import android.text.TextUtils;

public interface InputFilter {
    public CharSequence filter(CharSequence var1, int var2, int var3, Spanned var4, int var5, int var6);

    public static class LengthFilter
    implements InputFilter {
        public int mMax;

        public LengthFilter(int max) {
            this.mMax = max;
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            int keep = this.mMax - (dest.length() - (dend - dstart));
            if (keep <= 0) {
                return "";
            }
            if (keep >= end - start) {
                return null;
            }
            return source.subSequence(start, start + keep);
        }
    }

    public static class AllCaps
    implements InputFilter {
        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            for (int i = start; i < end; ++i) {
                if (!Character.isLowerCase(source.charAt(i))) continue;
                char[] v = new char[end - start];
                TextUtils.getChars(source, start, end, v, 0);
                String s = new String(v).toUpperCase();
                if (source instanceof Spanned) {
                    SpannableString sp = new SpannableString(s);
                    TextUtils.copySpansFrom((Spanned)source, start, end, null, sp, 0);
                    return sp;
                }
                return s;
            }
            return null;
        }
    }
}

