/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import java.io.UnsupportedEncodingException;

public class Script
extends BaseObj {
    public static final int MAX_SLOT = 16;
    public boolean mIsRoot;
    public Type[] mTypes;
    public boolean[] mWritable;
    public Invokable[] mInvokables;

    public Script(int id2, RenderScript rs) {
        super(rs);
        this.mID = id2;
    }

    public void bindAllocation(Allocation va, int slot) {
        this.mRS.validate();
        this.mRS.nScriptBindAllocation(this.mID, va.mID, slot);
    }

    public void setClearColor(float r, float g, float b, float a) {
        this.mRS.validate();
        this.mRS.nScriptSetClearColor(this.mID, r, g, b, a);
    }

    public void setClearDepth(float d) {
        this.mRS.validate();
        this.mRS.nScriptSetClearDepth(this.mID, d);
    }

    public void setClearStencil(int stencil) {
        this.mRS.validate();
        this.mRS.nScriptSetClearStencil(this.mID, stencil);
    }

    public void setTimeZone(String timeZone) {
        this.mRS.validate();
        try {
            this.mRS.nScriptSetTimeZone(this.mID, timeZone.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        public RenderScript mRS;
        public boolean mIsRoot = false;
        public Type[] mTypes;
        public String[] mNames;
        public boolean[] mWritable;
        public int mInvokableCount = 0;
        public Invokable[] mInvokables;

        public Builder(RenderScript rs) {
            this.mRS = rs;
            this.mTypes = new Type[16];
            this.mNames = new String[16];
            this.mWritable = new boolean[16];
            this.mInvokables = new Invokable[16];
        }

        public void setType(Type t, int slot) {
            this.mTypes[slot] = t;
            this.mNames[slot] = null;
        }

        public void setType(Type t, String name, int slot) {
            this.mTypes[slot] = t;
            this.mNames[slot] = name;
        }

        public Invokable addInvokable(String func) {
            Invokable i = new Invokable();
            i.mName = func;
            i.mRS = this.mRS;
            i.mSlot = this.mInvokableCount;
            this.mInvokables[this.mInvokableCount++] = i;
            return i;
        }

        public void setType(boolean writable, int slot) {
            this.mWritable[slot] = writable;
        }

        public void transferCreate() {
            int ct;
            this.mRS.nScriptSetRoot(this.mIsRoot);
            for (ct = 0; ct < this.mTypes.length; ++ct) {
                if (this.mTypes[ct] == null) continue;
                this.mRS.nScriptSetType(this.mTypes[ct].mID, this.mWritable[ct], this.mNames[ct], ct);
            }
            for (ct = 0; ct < this.mInvokableCount; ++ct) {
                this.mRS.nScriptSetInvokable(this.mInvokables[ct].mName, ct);
            }
        }

        public void transferObject(Script s) {
            s.mIsRoot = this.mIsRoot;
            s.mTypes = this.mTypes;
            s.mInvokables = new Invokable[this.mInvokableCount];
            for (int ct = 0; ct < this.mInvokableCount; ++ct) {
                s.mInvokables[ct] = this.mInvokables[ct];
                s.mInvokables[ct].mScript = s;
            }
            s.mInvokables = null;
        }

        public void setRoot(boolean r) {
            this.mIsRoot = r;
        }
    }

    public static class Invokable {
        public RenderScript mRS;
        public Script mScript;
        public int mSlot = -1;
        public String mName;

        public void execute() {
            this.mRS.nScriptInvoke(this.mScript.mID, this.mSlot);
        }
    }
}

