/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.Intent;
import android.preference.GenericInflater;
import android.preference.Preference;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.util.Log;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceInflater
extends GenericInflater<Preference, PreferenceGroup> {
    public static final String TAG = "PreferenceInflater";
    public static final String INTENT_TAG_NAME = "intent";
    public PreferenceManager mPreferenceManager;

    public PreferenceInflater(Context context, PreferenceManager preferenceManager) {
        super(context);
        this.init(preferenceManager);
    }

    public PreferenceInflater(GenericInflater<Preference, PreferenceGroup> original, PreferenceManager preferenceManager, Context newContext) {
        super(original, newContext);
        this.init(preferenceManager);
    }

    @Override
    public GenericInflater<Preference, PreferenceGroup> cloneInContext(Context newContext) {
        return new PreferenceInflater(this, this.mPreferenceManager, newContext);
    }

    public void init(PreferenceManager preferenceManager) {
        this.mPreferenceManager = preferenceManager;
        this.setDefaultPackage("android.preference.");
    }

    @Override
    public boolean onCreateCustomFromTag(XmlPullParser parser, Preference parentPreference, AttributeSet attrs) throws XmlPullParserException {
        String tag = parser.getName();
        if (tag.equals(INTENT_TAG_NAME)) {
            Intent intent = null;
            try {
                intent = Intent.parseIntent(this.getContext().getResources(), parser, attrs);
            }
            catch (IOException e) {
                Log.w(TAG, "Could not parse Intent.");
                Log.w(TAG, e);
            }
            if (intent != null) {
                parentPreference.setIntent(intent);
            }
            return true;
        }
        return false;
    }

    @Override
    public PreferenceGroup onMergeRoots(PreferenceGroup givenRoot, boolean attachToGivenRoot, PreferenceGroup xmlRoot) {
        if (givenRoot == null) {
            xmlRoot.onAttachedToHierarchy(this.mPreferenceManager);
            return xmlRoot;
        }
        return givenRoot;
    }
}

