/*
 * Decompiled with CFR 0.152.
 */
package android.os;

public class ConditionVariable {
    public volatile boolean mCondition;

    public ConditionVariable() {
        this.mCondition = false;
    }

    public ConditionVariable(boolean state) {
        this.mCondition = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        ConditionVariable conditionVariable = this;
        synchronized (conditionVariable) {
            boolean old = this.mCondition;
            this.mCondition = true;
            if (!old) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConditionVariable conditionVariable = this;
        synchronized (conditionVariable) {
            this.mCondition = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void block() {
        ConditionVariable conditionVariable = this;
        synchronized (conditionVariable) {
            while (!this.mCondition) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean block(long timeout) {
        if (timeout != 0L) {
            ConditionVariable conditionVariable = this;
            synchronized (conditionVariable) {
                long now = System.currentTimeMillis();
                long end = now + timeout;
                while (!this.mCondition && now < end) {
                    try {
                        this.wait(end - now);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                }
                return this.mCondition;
            }
        }
        this.block();
        return true;
    }
}

