/*
 * Decompiled with CFR 0.152.
 */
package android.opengl;

import com.android.tools.layoutlib.create.OverrideMethod;

public class Matrix {
    public static void multiplyMM(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        OverrideMethod.invokeV("android.opengl.Matrix#multiplyMM([FI[FI[FI)V", true, null);
    }

    public static void multiplyMV(float[] fArray, int n, float[] fArray2, int n2, float[] fArray3, int n3) {
        OverrideMethod.invokeV("android.opengl.Matrix#multiplyMV([FI[FI[FI)V", true, null);
    }

    public static void transposeM(float[] mTrans, int mTransOffset, float[] m, int mOffset) {
        for (int i = 0; i < 4; ++i) {
            int mBase = i * 4 + mOffset;
            mTrans[i + mTransOffset] = m[mBase];
            mTrans[i + 4 + mTransOffset] = m[mBase + 1];
            mTrans[i + 8 + mTransOffset] = m[mBase + 2];
            mTrans[i + 12 + mTransOffset] = m[mBase + 3];
        }
    }

    public static boolean invertM(float[] mInv, int mInvOffset, float[] m, int mOffset) {
        float[] src = new float[16];
        Matrix.transposeM(src, 0, m, mOffset);
        float[] tmp = new float[]{src[10] * src[15], src[11] * src[14], src[9] * src[15], src[11] * src[13], src[9] * src[14], src[10] * src[13], src[8] * src[15], src[11] * src[12], src[8] * src[14], src[10] * src[12], src[8] * src[13], src[9] * src[12]};
        float[] dst = new float[16];
        dst[0] = tmp[0] * src[5] + tmp[3] * src[6] + tmp[4] * src[7];
        dst[0] = dst[0] - (tmp[1] * src[5] + tmp[2] * src[6] + tmp[5] * src[7]);
        dst[1] = tmp[1] * src[4] + tmp[6] * src[6] + tmp[9] * src[7];
        dst[1] = dst[1] - (tmp[0] * src[4] + tmp[7] * src[6] + tmp[8] * src[7]);
        dst[2] = tmp[2] * src[4] + tmp[7] * src[5] + tmp[10] * src[7];
        dst[2] = dst[2] - (tmp[3] * src[4] + tmp[6] * src[5] + tmp[11] * src[7]);
        dst[3] = tmp[5] * src[4] + tmp[8] * src[5] + tmp[11] * src[6];
        dst[3] = dst[3] - (tmp[4] * src[4] + tmp[9] * src[5] + tmp[10] * src[6]);
        dst[4] = tmp[1] * src[1] + tmp[2] * src[2] + tmp[5] * src[3];
        dst[4] = dst[4] - (tmp[0] * src[1] + tmp[3] * src[2] + tmp[4] * src[3]);
        dst[5] = tmp[0] * src[0] + tmp[7] * src[2] + tmp[8] * src[3];
        dst[5] = dst[5] - (tmp[1] * src[0] + tmp[6] * src[2] + tmp[9] * src[3]);
        dst[6] = tmp[3] * src[0] + tmp[6] * src[1] + tmp[11] * src[3];
        dst[6] = dst[6] - (tmp[2] * src[0] + tmp[7] * src[1] + tmp[10] * src[3]);
        dst[7] = tmp[4] * src[0] + tmp[9] * src[1] + tmp[10] * src[2];
        dst[7] = dst[7] - (tmp[5] * src[0] + tmp[8] * src[1] + tmp[11] * src[2]);
        tmp[0] = src[2] * src[7];
        tmp[1] = src[3] * src[6];
        tmp[2] = src[1] * src[7];
        tmp[3] = src[3] * src[5];
        tmp[4] = src[1] * src[6];
        tmp[5] = src[2] * src[5];
        tmp[6] = src[0] * src[7];
        tmp[7] = src[3] * src[4];
        tmp[8] = src[0] * src[6];
        tmp[9] = src[2] * src[4];
        tmp[10] = src[0] * src[5];
        tmp[11] = src[1] * src[4];
        dst[8] = tmp[0] * src[13] + tmp[3] * src[14] + tmp[4] * src[15];
        dst[8] = dst[8] - (tmp[1] * src[13] + tmp[2] * src[14] + tmp[5] * src[15]);
        dst[9] = tmp[1] * src[12] + tmp[6] * src[14] + tmp[9] * src[15];
        dst[9] = dst[9] - (tmp[0] * src[12] + tmp[7] * src[14] + tmp[8] * src[15]);
        dst[10] = tmp[2] * src[12] + tmp[7] * src[13] + tmp[10] * src[15];
        dst[10] = dst[10] - (tmp[3] * src[12] + tmp[6] * src[13] + tmp[11] * src[15]);
        dst[11] = tmp[5] * src[12] + tmp[8] * src[13] + tmp[11] * src[14];
        dst[11] = dst[11] - (tmp[4] * src[12] + tmp[9] * src[13] + tmp[10] * src[14]);
        dst[12] = tmp[2] * src[10] + tmp[5] * src[11] + tmp[1] * src[9];
        dst[12] = dst[12] - (tmp[4] * src[11] + tmp[0] * src[9] + tmp[3] * src[10]);
        dst[13] = tmp[8] * src[11] + tmp[0] * src[8] + tmp[7] * src[10];
        dst[13] = dst[13] - (tmp[6] * src[10] + tmp[9] * src[11] + tmp[1] * src[8]);
        dst[14] = tmp[6] * src[9] + tmp[11] * src[11] + tmp[3] * src[8];
        dst[14] = dst[14] - (tmp[10] * src[11] + tmp[2] * src[8] + tmp[7] * src[9]);
        dst[15] = tmp[10] * src[10] + tmp[4] * src[8] + tmp[9] * src[9];
        dst[15] = dst[15] - (tmp[8] * src[9] + tmp[11] * src[10] + tmp[5] * src[8]);
        float det = src[0] * dst[0] + src[1] * dst[1] + src[2] * dst[2] + src[3] * dst[3];
        if (det == 0.0f) {
            // empty if block
        }
        det = 1.0f / det;
        for (int j = 0; j < 16; ++j) {
            mInv[j + mInvOffset] = dst[j] * det;
        }
        return true;
    }

    public static void orthoM(float[] m, int mOffset, float left, float right, float bottom, float top, float near, float far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (bottom == top) {
            throw new IllegalArgumentException("bottom == top");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        float r_width = 1.0f / (right - left);
        float r_height = 1.0f / (top - bottom);
        float r_depth = 1.0f / (far - near);
        float x = 2.0f * r_width;
        float y = 2.0f * r_height;
        float z = -2.0f * r_depth;
        float tx = -(right + left) * r_width;
        float ty = -(top + bottom) * r_height;
        float tz = -(far + near) * r_depth;
        m[mOffset + 0] = x;
        m[mOffset + 5] = y;
        m[mOffset + 10] = z;
        m[mOffset + 12] = tx;
        m[mOffset + 13] = ty;
        m[mOffset + 14] = tz;
        m[mOffset + 15] = 1.0f;
        m[mOffset + 1] = 0.0f;
        m[mOffset + 2] = 0.0f;
        m[mOffset + 3] = 0.0f;
        m[mOffset + 4] = 0.0f;
        m[mOffset + 6] = 0.0f;
        m[mOffset + 7] = 0.0f;
        m[mOffset + 8] = 0.0f;
        m[mOffset + 9] = 0.0f;
        m[mOffset + 11] = 0.0f;
    }

    public static void frustumM(float[] m, int offset, float left, float right, float bottom, float top, float near, float far) {
        if (left == right) {
            throw new IllegalArgumentException("left == right");
        }
        if (top == bottom) {
            throw new IllegalArgumentException("top == bottom");
        }
        if (near == far) {
            throw new IllegalArgumentException("near == far");
        }
        if (near <= 0.0f) {
            throw new IllegalArgumentException("near <= 0.0f");
        }
        if (far <= 0.0f) {
            throw new IllegalArgumentException("far <= 0.0f");
        }
        float r_width = 1.0f / (right - left);
        float r_height = 1.0f / (top - bottom);
        float r_depth = 1.0f / (near - far);
        float x = 2.0f * (near * r_width);
        float y = 2.0f * (near * r_height);
        float A = 2.0f * ((right + left) * r_width);
        float B = (top + bottom) * r_height;
        float C = (far + near) * r_depth;
        float D = 2.0f * (far * near * r_depth);
        m[offset + 0] = x;
        m[offset + 5] = y;
        m[offset + 8] = A;
        m[offset + 9] = B;
        m[offset + 10] = C;
        m[offset + 14] = D;
        m[offset + 11] = -1.0f;
        m[offset + 1] = 0.0f;
        m[offset + 2] = 0.0f;
        m[offset + 3] = 0.0f;
        m[offset + 4] = 0.0f;
        m[offset + 6] = 0.0f;
        m[offset + 7] = 0.0f;
        m[offset + 12] = 0.0f;
        m[offset + 13] = 0.0f;
        m[offset + 15] = 0.0f;
    }

    public static float length(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public static void setIdentityM(float[] sm, int smOffset) {
        int i;
        for (i = 0; i < 16; ++i) {
            sm[smOffset + i] = 0.0f;
        }
        for (i = 0; i < 16; i += 5) {
            sm[smOffset + i] = 1.0f;
        }
    }

    public static void scaleM(float[] sm, int smOffset, float[] m, int mOffset, float x, float y, float z) {
        for (int i = 0; i < 4; ++i) {
            int smi = smOffset + i;
            int mi = mOffset + i;
            sm[smi] = m[mi] * x;
            sm[4 + smi] = m[4 + mi] * y;
            sm[8 + smi] = m[8 + mi] * z;
            sm[12 + smi] = m[12 + mi];
        }
    }

    public static void scaleM(float[] m, int mOffset, float x, float y, float z) {
        for (int i = 0; i < 4; ++i) {
            int mi;
            int n = mi = mOffset + i;
            m[n] = m[n] * x;
            int n2 = 4 + mi;
            m[n2] = m[n2] * y;
            int n3 = 8 + mi;
            m[n3] = m[n3] * z;
        }
    }

    public static void translateM(float[] tm, int tmOffset, float[] m, int mOffset, float x, float y, float z) {
        int i;
        for (i = 0; i < 12; ++i) {
            tm[tmOffset + i] = m[mOffset + i];
        }
        for (i = 0; i < 4; ++i) {
            int tmi = tmOffset + i;
            int mi = mOffset + i;
            tm[12 + tmi] = m[mi] * x + m[4 + mi] * y + m[8 + mi] * z + m[12 + mi];
        }
    }

    public static void translateM(float[] m, int mOffset, float x, float y, float z) {
        for (int i = 0; i < 4; ++i) {
            int mi = mOffset + i;
            int n = 12 + mi;
            m[n] = m[n] + (m[mi] * x + m[4 + mi] * y + m[8 + mi] * z);
        }
    }

    public static void rotateM(float[] rm, int rmOffset, float[] m, int mOffset, float a, float x, float y, float z) {
        float[] r = new float[16];
        Matrix.setRotateM(r, 0, a, x, y, z);
        Matrix.multiplyMM(rm, rmOffset, m, mOffset, r, 0);
    }

    public static void rotateM(float[] m, int mOffset, float a, float x, float y, float z) {
        float[] temp = new float[32];
        Matrix.setRotateM(temp, 0, a, x, y, z);
        Matrix.multiplyMM(temp, 16, m, mOffset, temp, 0);
        System.arraycopy(temp, 16, m, mOffset, 16);
    }

    public static void setRotateM(float[] rm, int rmOffset, float a, float x, float y, float z) {
        rm[rmOffset + 3] = 0.0f;
        rm[rmOffset + 7] = 0.0f;
        rm[rmOffset + 11] = 0.0f;
        rm[rmOffset + 12] = 0.0f;
        rm[rmOffset + 13] = 0.0f;
        rm[rmOffset + 14] = 0.0f;
        rm[rmOffset + 15] = 1.0f;
        float s = (float)Math.sin(a *= (float)Math.PI / 180);
        float c = (float)Math.cos(a);
        if (1.0f == x && 0.0f == y && 0.0f == z) {
            rm[rmOffset + 5] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 6] = s;
            rm[rmOffset + 9] = -s;
            rm[rmOffset + 1] = 0.0f;
            rm[rmOffset + 2] = 0.0f;
            rm[rmOffset + 4] = 0.0f;
            rm[rmOffset + 8] = 0.0f;
            rm[rmOffset + 0] = 1.0f;
        } else if (0.0f == x && 1.0f == y && 0.0f == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 10] = c;
            rm[rmOffset + 8] = s;
            rm[rmOffset + 2] = -s;
            rm[rmOffset + 1] = 0.0f;
            rm[rmOffset + 4] = 0.0f;
            rm[rmOffset + 6] = 0.0f;
            rm[rmOffset + 9] = 0.0f;
            rm[rmOffset + 5] = 1.0f;
        } else if (0.0f == x && 0.0f == y && 1.0f == z) {
            rm[rmOffset + 0] = c;
            rm[rmOffset + 5] = c;
            rm[rmOffset + 1] = s;
            rm[rmOffset + 4] = -s;
            rm[rmOffset + 2] = 0.0f;
            rm[rmOffset + 6] = 0.0f;
            rm[rmOffset + 8] = 0.0f;
            rm[rmOffset + 9] = 0.0f;
            rm[rmOffset + 10] = 1.0f;
        } else {
            float len = Matrix.length(x, y, z);
            if (1.0f != len) {
                float recipLen = 1.0f / len;
                x *= recipLen;
                y *= recipLen;
                z *= recipLen;
            }
            float nc = 1.0f - c;
            float xy = x * y;
            float yz = y * z;
            float zx = z * x;
            float xs = x * s;
            float ys = y * s;
            float zs = z * s;
            rm[rmOffset + 0] = x * x * nc + c;
            rm[rmOffset + 4] = xy * nc - zs;
            rm[rmOffset + 8] = zx * nc + ys;
            rm[rmOffset + 1] = xy * nc + zs;
            rm[rmOffset + 5] = y * y * nc + c;
            rm[rmOffset + 9] = yz * nc - xs;
            rm[rmOffset + 2] = zx * nc - ys;
            rm[rmOffset + 6] = yz * nc + xs;
            rm[rmOffset + 10] = z * z * nc + c;
        }
    }

    public static void setRotateEulerM(float[] rm, int rmOffset, float x, float y, float z) {
        float cx = (float)Math.cos(x *= (float)Math.PI / 180);
        float sx = (float)Math.sin(x);
        float cy = (float)Math.cos(y *= (float)Math.PI / 180);
        float sy = (float)Math.sin(y);
        float cz = (float)Math.cos(z *= (float)Math.PI / 180);
        float sz = (float)Math.sin(z);
        float cxsy = cx * sy;
        float sxsy = sx * sy;
        rm[rmOffset + 0] = cy * cz;
        rm[rmOffset + 1] = -cy * sz;
        rm[rmOffset + 2] = sy;
        rm[rmOffset + 3] = 0.0f;
        rm[rmOffset + 4] = cxsy * cz + cx * sz;
        rm[rmOffset + 5] = -cxsy * sz + cx * cz;
        rm[rmOffset + 6] = -sx * cy;
        rm[rmOffset + 7] = 0.0f;
        rm[rmOffset + 8] = -sxsy * cz + sx * sz;
        rm[rmOffset + 9] = sxsy * sz + sx * cz;
        rm[rmOffset + 10] = cx * cy;
        rm[rmOffset + 11] = 0.0f;
        rm[rmOffset + 12] = 0.0f;
        rm[rmOffset + 13] = 0.0f;
        rm[rmOffset + 14] = 0.0f;
        rm[rmOffset + 15] = 1.0f;
    }

    public static void setLookAtM(float[] rm, int rmOffset, float eyeX, float eyeY, float eyeZ, float centerX, float centerY, float centerZ, float upX, float upY, float upZ) {
        float fx = centerX - eyeX;
        float fy = centerY - eyeY;
        float fz = centerZ - eyeZ;
        float rlf = 1.0f / Matrix.length(fx, fy, fz);
        float sx = (fy *= rlf) * upZ - (fz *= rlf) * upY;
        float sy = fz * upX - (fx *= rlf) * upZ;
        float sz = fx * upY - fy * upX;
        float rls = 1.0f / Matrix.length(sx, sy, sz);
        float ux = (sy *= rls) * fz - (sz *= rls) * fy;
        float uy = sz * fx - (sx *= rls) * fz;
        float uz = sx * fy - sy * fx;
        rm[rmOffset + 0] = sx;
        rm[rmOffset + 1] = ux;
        rm[rmOffset + 2] = -fx;
        rm[rmOffset + 3] = 0.0f;
        rm[rmOffset + 4] = sy;
        rm[rmOffset + 5] = uy;
        rm[rmOffset + 6] = -fy;
        rm[rmOffset + 7] = 0.0f;
        rm[rmOffset + 8] = sz;
        rm[rmOffset + 9] = uz;
        rm[rmOffset + 10] = -fz;
        rm[rmOffset + 11] = 0.0f;
        rm[rmOffset + 12] = 0.0f;
        rm[rmOffset + 13] = 0.0f;
        rm[rmOffset + 14] = 0.0f;
        rm[rmOffset + 15] = 1.0f;
        Matrix.translateM(rm, rmOffset, -eyeX, -eyeY, -eyeZ);
    }
}

