/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Canvas;
import android.graphics.Paint;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class Movie {
    public final int mNativeMovie;

    public Movie(int nativeMovie) {
        if (nativeMovie == 0) {
            throw new RuntimeException("native movie creation failed");
        }
        this.mNativeMovie = nativeMovie;
    }

    public int width() {
        return OverrideMethod.invokeI("android.graphics.Movie#width()I", true, this);
    }

    public int height() {
        return OverrideMethod.invokeI("android.graphics.Movie#height()I", true, this);
    }

    public boolean isOpaque() {
        return OverrideMethod.invokeI("android.graphics.Movie#isOpaque()Z", true, this) != 0;
    }

    public int duration() {
        return OverrideMethod.invokeI("android.graphics.Movie#duration()I", true, this);
    }

    public boolean setTime(int n) {
        return OverrideMethod.invokeI("android.graphics.Movie#setTime(I)Z", true, this) != 0;
    }

    public void draw(Canvas canvas, float f, float f2, Paint paint) {
        OverrideMethod.invokeV("android.graphics.Movie#draw(Landroid/graphics/Canvas;FFLandroid/graphics/Paint;)V", true, this);
    }

    public void draw(Canvas canvas, float x, float y) {
        this.draw(canvas, x, y, null);
    }

    public static Movie decodeStream(InputStream inputStream) {
        return (Movie)OverrideMethod.invokeA("android.graphics.Movie#decodeStream(Ljava/io/InputStream;)Landroid/graphics/Movie;", true, null);
    }

    public static Movie decodeByteArray(byte[] byArray, int n, int n2) {
        return (Movie)OverrideMethod.invokeA("android.graphics.Movie#decodeByteArray([BII)Landroid/graphics/Movie;", true, null);
    }

    public static Movie decodeFile(String pathName) {
        FileInputStream is;
        try {
            is = new FileInputStream(pathName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        return Movie.decodeTempStream(is);
    }

    public static Movie decodeTempStream(InputStream is) {
        Movie moov = null;
        try {
            moov = Movie.decodeStream(is);
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return moov;
    }
}

