/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Matrix_Delegate;
import android.graphics.RectF;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import java.io.PrintWriter;

public class Matrix {
    public static final int MSCALE_X = 0;
    public static final int MSKEW_X = 1;
    public static final int MTRANS_X = 2;
    public static final int MSKEW_Y = 3;
    public static final int MSCALE_Y = 4;
    public static final int MTRANS_Y = 5;
    public static final int MPERSP_0 = 6;
    public static final int MPERSP_1 = 7;
    public static final int MPERSP_2 = 8;
    public int native_instance;

    public Matrix() {
        this.native_instance = Matrix.native_create(0);
    }

    public Matrix(Matrix src) {
        this.native_instance = Matrix.native_create(src != null ? src.native_instance : 0);
    }

    public boolean isIdentity() {
        return Matrix.native_isIdentity(this.native_instance);
    }

    public boolean rectStaysRect() {
        return Matrix.native_rectStaysRect(this.native_instance);
    }

    public void set(Matrix src) {
        if (src == null) {
            this.reset();
        } else {
            Matrix.native_set(this.native_instance, src.native_instance);
        }
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof Matrix && Matrix.native_equals(this.native_instance, ((Matrix)obj).native_instance);
    }

    public void reset() {
        Matrix.native_reset(this.native_instance);
    }

    public void setTranslate(float dx, float dy) {
        Matrix.native_setTranslate(this.native_instance, dx, dy);
    }

    public void setScale(float sx, float sy, float px, float py) {
        Matrix.native_setScale(this.native_instance, sx, sy, px, py);
    }

    public void setScale(float sx, float sy) {
        Matrix.native_setScale(this.native_instance, sx, sy);
    }

    public void setRotate(float degrees, float px, float py) {
        Matrix.native_setRotate(this.native_instance, degrees, px, py);
    }

    public void setRotate(float degrees) {
        Matrix.native_setRotate(this.native_instance, degrees);
    }

    public void setSinCos(float sinValue, float cosValue, float px, float py) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue, px, py);
    }

    public void setSinCos(float sinValue, float cosValue) {
        Matrix.native_setSinCos(this.native_instance, sinValue, cosValue);
    }

    public void setSkew(float kx, float ky, float px, float py) {
        Matrix.native_setSkew(this.native_instance, kx, ky, px, py);
    }

    public void setSkew(float kx, float ky) {
        Matrix.native_setSkew(this.native_instance, kx, ky);
    }

    public boolean setConcat(Matrix a, Matrix b) {
        return Matrix.native_setConcat(this.native_instance, a.native_instance, b.native_instance);
    }

    public boolean preTranslate(float dx, float dy) {
        return Matrix.native_preTranslate(this.native_instance, dx, dy);
    }

    public boolean preScale(float sx, float sy, float px, float py) {
        return Matrix.native_preScale(this.native_instance, sx, sy, px, py);
    }

    public boolean preScale(float sx, float sy) {
        return Matrix.native_preScale(this.native_instance, sx, sy);
    }

    public boolean preRotate(float degrees, float px, float py) {
        return Matrix.native_preRotate(this.native_instance, degrees, px, py);
    }

    public boolean preRotate(float degrees) {
        return Matrix.native_preRotate(this.native_instance, degrees);
    }

    public boolean preSkew(float kx, float ky, float px, float py) {
        return Matrix.native_preSkew(this.native_instance, kx, ky, px, py);
    }

    public boolean preSkew(float kx, float ky) {
        return Matrix.native_preSkew(this.native_instance, kx, ky);
    }

    public boolean preConcat(Matrix other) {
        return Matrix.native_preConcat(this.native_instance, other.native_instance);
    }

    public boolean postTranslate(float dx, float dy) {
        return Matrix.native_postTranslate(this.native_instance, dx, dy);
    }

    public boolean postScale(float sx, float sy, float px, float py) {
        return Matrix.native_postScale(this.native_instance, sx, sy, px, py);
    }

    public boolean postScale(float sx, float sy) {
        return Matrix.native_postScale(this.native_instance, sx, sy);
    }

    public boolean postRotate(float degrees, float px, float py) {
        return Matrix.native_postRotate(this.native_instance, degrees, px, py);
    }

    public boolean postRotate(float degrees) {
        return Matrix.native_postRotate(this.native_instance, degrees);
    }

    public boolean postSkew(float kx, float ky, float px, float py) {
        return Matrix.native_postSkew(this.native_instance, kx, ky, px, py);
    }

    public boolean postSkew(float kx, float ky) {
        return Matrix.native_postSkew(this.native_instance, kx, ky);
    }

    public boolean postConcat(Matrix other) {
        return Matrix.native_postConcat(this.native_instance, other.native_instance);
    }

    public boolean setRectToRect(RectF src, RectF dst, ScaleToFit stf) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_setRectToRect(this.native_instance, src, dst, stf.nativeInt);
    }

    public static void checkPointArrays(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        int srcStop = srcIndex + (pointCount << 1);
        int dstStop = dstIndex + (pointCount << 1);
        if ((pointCount | srcIndex | dstIndex | srcStop | dstStop) < 0 || srcStop > src.length || dstStop > dst.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public boolean setPolyToPoly(float[] src, int srcIndex, float[] dst, int dstIndex, int pointCount) {
        if (pointCount > 4) {
            throw new IllegalArgumentException();
        }
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        return Matrix.native_setPolyToPoly(this.native_instance, src, srcIndex, dst, dstIndex, pointCount);
    }

    public boolean invert(Matrix inverse) {
        return Matrix.native_invert(this.native_instance, inverse.native_instance);
    }

    public void mapPoints(float[] dst, int dstIndex, float[] src, int srcIndex, int pointCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, pointCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, pointCount, true);
    }

    public void mapVectors(float[] dst, int dstIndex, float[] src, int srcIndex, int vectorCount) {
        Matrix.checkPointArrays(src, srcIndex, dst, dstIndex, vectorCount);
        Matrix.native_mapPoints(this.native_instance, dst, dstIndex, src, srcIndex, vectorCount, false);
    }

    public void mapPoints(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapPoints(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapVectors(float[] dst, float[] src) {
        if (dst.length != src.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mapVectors(dst, 0, src, 0, dst.length >> 1);
    }

    public void mapPoints(float[] pts) {
        this.mapPoints(pts, 0, pts, 0, pts.length >> 1);
    }

    public void mapVectors(float[] vecs) {
        this.mapVectors(vecs, 0, vecs, 0, vecs.length >> 1);
    }

    public boolean mapRect(RectF dst, RectF src) {
        if (dst == null || src == null) {
            throw new NullPointerException();
        }
        return Matrix.native_mapRect(this.native_instance, dst, src);
    }

    public boolean mapRect(RectF rect) {
        return this.mapRect(rect, rect);
    }

    public float mapRadius(float radius) {
        return Matrix.native_mapRadius(this.native_instance, radius);
    }

    public void getValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_getValues(this.native_instance, values);
    }

    public void setValues(float[] values) {
        if (values.length < 9) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Matrix.native_setValues(this.native_instance, values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Matrix{");
        this.toShortString(sb);
        sb.append('}');
        return sb.toString();
    }

    public String toShortString() {
        StringBuilder sb = new StringBuilder(64);
        this.toShortString(sb);
        return sb.toString();
    }

    public void toShortString(StringBuilder sb) {
        float[] values = new float[9];
        this.getValues(values);
        sb.append('[');
        sb.append(values[0]);
        sb.append(", ");
        sb.append(values[1]);
        sb.append(", ");
        sb.append(values[2]);
        sb.append("][");
        sb.append(values[3]);
        sb.append(", ");
        sb.append(values[4]);
        sb.append(", ");
        sb.append(values[5]);
        sb.append("][");
        sb.append(values[6]);
        sb.append(", ");
        sb.append(values[7]);
        sb.append(", ");
        sb.append(values[8]);
        sb.append(']');
    }

    public void printShortString(PrintWriter pw) {
        float[] values = new float[9];
        this.getValues(values);
        pw.print('[');
        pw.print(values[0]);
        pw.print(", ");
        pw.print(values[1]);
        pw.print(", ");
        pw.print(values[2]);
        pw.print("][");
        pw.print(values[3]);
        pw.print(", ");
        pw.print(values[4]);
        pw.print(", ");
        pw.print(values[5]);
        pw.print("][");
        pw.print(values[6]);
        pw.print(", ");
        pw.print(values[7]);
        pw.print(", ");
        pw.print(values[8]);
        pw.print(']');
    }

    public void finalize() throws Throwable {
        Matrix.finalizer(this.native_instance);
    }

    public int ni() {
        return this.native_instance;
    }

    @LayoutlibDelegate
    public static int native_create(int n) {
        return Matrix_Delegate.native_create((int)n);
    }

    @LayoutlibDelegate
    public static boolean native_isIdentity(int n) {
        return Matrix_Delegate.native_isIdentity((int)n);
    }

    @LayoutlibDelegate
    public static boolean native_rectStaysRect(int n) {
        return Matrix_Delegate.native_rectStaysRect((int)n);
    }

    @LayoutlibDelegate
    public static void native_reset(int n) {
        Matrix_Delegate.native_reset((int)n);
    }

    @LayoutlibDelegate
    public static void native_set(int n, int n2) {
        Matrix_Delegate.native_set((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_setTranslate(int n, float f, float f2) {
        Matrix_Delegate.native_setTranslate((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static void native_setScale(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setScale((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static void native_setScale(int n, float f, float f2) {
        Matrix_Delegate.native_setScale((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static void native_setRotate(int n, float f, float f2, float f3) {
        Matrix_Delegate.native_setRotate((int)n, (float)f, (float)f2, (float)f3);
    }

    @LayoutlibDelegate
    public static void native_setRotate(int n, float f) {
        Matrix_Delegate.native_setRotate((int)n, (float)f);
    }

    @LayoutlibDelegate
    public static void native_setSinCos(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setSinCos((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static void native_setSinCos(int n, float f, float f2) {
        Matrix_Delegate.native_setSinCos((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static void native_setSkew(int n, float f, float f2, float f3, float f4) {
        Matrix_Delegate.native_setSkew((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static void native_setSkew(int n, float f, float f2) {
        Matrix_Delegate.native_setSkew((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_setConcat(int n, int n2, int n3) {
        return Matrix_Delegate.native_setConcat((int)n, (int)n2, (int)n3);
    }

    @LayoutlibDelegate
    public static boolean native_preTranslate(int n, float f, float f2) {
        return Matrix_Delegate.native_preTranslate((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_preScale(int n, float f, float f2, float f3, float f4) {
        return Matrix_Delegate.native_preScale((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static boolean native_preScale(int n, float f, float f2) {
        return Matrix_Delegate.native_preScale((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_preRotate(int n, float f, float f2, float f3) {
        return Matrix_Delegate.native_preRotate((int)n, (float)f, (float)f2, (float)f3);
    }

    @LayoutlibDelegate
    public static boolean native_preRotate(int n, float f) {
        return Matrix_Delegate.native_preRotate((int)n, (float)f);
    }

    @LayoutlibDelegate
    public static boolean native_preSkew(int n, float f, float f2, float f3, float f4) {
        return Matrix_Delegate.native_preSkew((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static boolean native_preSkew(int n, float f, float f2) {
        return Matrix_Delegate.native_preSkew((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_preConcat(int n, int n2) {
        return Matrix_Delegate.native_preConcat((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_postTranslate(int n, float f, float f2) {
        return Matrix_Delegate.native_postTranslate((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_postScale(int n, float f, float f2, float f3, float f4) {
        return Matrix_Delegate.native_postScale((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static boolean native_postScale(int n, float f, float f2) {
        return Matrix_Delegate.native_postScale((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_postRotate(int n, float f, float f2, float f3) {
        return Matrix_Delegate.native_postRotate((int)n, (float)f, (float)f2, (float)f3);
    }

    @LayoutlibDelegate
    public static boolean native_postRotate(int n, float f) {
        return Matrix_Delegate.native_postRotate((int)n, (float)f);
    }

    @LayoutlibDelegate
    public static boolean native_postSkew(int n, float f, float f2, float f3, float f4) {
        return Matrix_Delegate.native_postSkew((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    @LayoutlibDelegate
    public static boolean native_postSkew(int n, float f, float f2) {
        return Matrix_Delegate.native_postSkew((int)n, (float)f, (float)f2);
    }

    @LayoutlibDelegate
    public static boolean native_postConcat(int n, int n2) {
        return Matrix_Delegate.native_postConcat((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_setRectToRect(int n, RectF rectF, RectF rectF2, int n2) {
        return Matrix_Delegate.native_setRectToRect((int)n, (RectF)rectF, (RectF)rectF2, (int)n2);
    }

    @LayoutlibDelegate
    public static boolean native_setPolyToPoly(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4) {
        return Matrix_Delegate.native_setPolyToPoly((int)n, (float[])fArray, (int)n2, (float[])fArray2, (int)n3, (int)n4);
    }

    @LayoutlibDelegate
    public static boolean native_invert(int n, int n2) {
        return Matrix_Delegate.native_invert((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void native_mapPoints(int n, float[] fArray, int n2, float[] fArray2, int n3, int n4, boolean bl) {
        Matrix_Delegate.native_mapPoints((int)n, (float[])fArray, (int)n2, (float[])fArray2, (int)n3, (int)n4, (boolean)bl);
    }

    @LayoutlibDelegate
    public static boolean native_mapRect(int n, RectF rectF, RectF rectF2) {
        return Matrix_Delegate.native_mapRect((int)n, (RectF)rectF, (RectF)rectF2);
    }

    @LayoutlibDelegate
    public static float native_mapRadius(int n, float f) {
        return Matrix_Delegate.native_mapRadius((int)n, (float)f);
    }

    @LayoutlibDelegate
    public static void native_getValues(int n, float[] fArray) {
        Matrix_Delegate.native_getValues((int)n, (float[])fArray);
    }

    @LayoutlibDelegate
    public static void native_setValues(int n, float[] fArray) {
        Matrix_Delegate.native_setValues((int)n, (float[])fArray);
    }

    @LayoutlibDelegate
    public static boolean native_equals(int n, int n2) {
        return Matrix_Delegate.native_equals((int)n, (int)n2);
    }

    @LayoutlibDelegate
    public static void finalizer(int n) {
        Matrix_Delegate.finalizer((int)n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScaleToFit {
        FILL(0),
        START(1),
        CENTER(2),
        END(3);

        public final int nativeInt;

        public ScaleToFit(int nativeInt) {
            this.nativeInt = nativeInt;
        }
    }
}

