/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory_Delegate;
import android.graphics.Rect;
import android.os.MemoryFile;
import android.util.TypedValue;
import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.BufferedInputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BitmapFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeFile(String pathName, Options opts) {
        Bitmap bm = null;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(pathName);
            bm = BitmapFactory.decodeStream(stream, null, opts);
        }
        catch (Exception e) {
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException e) {}
            }
        }
        return bm;
    }

    public static Bitmap decodeFile(String pathName) {
        return BitmapFactory.decodeFile(pathName, null);
    }

    public static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, Options opts) {
        if (opts == null) {
            opts = new Options();
        }
        if (opts.inDensity == 0 && value != null) {
            int density = value.density;
            if (density == 0) {
                opts.inDensity = 160;
            } else if (density != 65535) {
                opts.inDensity = density;
            }
        }
        if (opts.inTargetDensity == 0 && res != null) {
            opts.inTargetDensity = res.getDisplayMetrics().densityDpi;
        }
        return BitmapFactory.decodeStream(is, pad, opts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap decodeResource(Resources res, int id2, Options opts) {
        Bitmap bm = null;
        InputStream is = null;
        try {
            TypedValue value = new TypedValue();
            is = res.openRawResource(id2, value);
            bm = BitmapFactory.decodeResourceStream(res, value, is, null, opts);
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
        return bm;
    }

    public static Bitmap decodeResource(Resources res, int id2) {
        return BitmapFactory.decodeResource(res, id2, null);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length, Options opts) {
        if ((offset | length) < 0 || data.length < offset + length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return BitmapFactory.nativeDecodeByteArray(data, offset, length, opts);
    }

    public static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        return BitmapFactory.decodeByteArray(data, offset, length, null);
    }

    public static Bitmap decodeStream(InputStream is, Rect outPadding, Options opts) {
        Bitmap bm;
        if (is == null) {
            return null;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is, 16384);
        }
        is.mark(1024);
        if (is instanceof AssetManager.AssetInputStream) {
            bm = BitmapFactory.nativeDecodeAsset(((AssetManager.AssetInputStream)is).getAssetInt(), outPadding, opts);
        } else {
            byte[] tempStorage = null;
            if (opts != null) {
                tempStorage = opts.inTempStorage;
            }
            if (tempStorage == null) {
                tempStorage = new byte[16384];
            }
            bm = BitmapFactory.nativeDecodeStream(is, tempStorage, outPadding, opts);
        }
        return BitmapFactory.finishDecode(bm, outPadding, opts);
    }

    @LayoutlibDelegate
    public static Bitmap finishDecode(Bitmap bitmap, Rect rect, Options options) {
        return BitmapFactory_Delegate.finishDecode((Bitmap)bitmap, (Rect)rect, (Options)options);
    }

    public static Bitmap decodeStream(InputStream is) {
        return BitmapFactory.decodeStream(is, null, null);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, Options opts) {
        try {
            if (MemoryFile.isMemoryFile(fd)) {
                int mappedlength = MemoryFile.getSize(fd);
                MemoryFile file = new MemoryFile(fd, mappedlength, "r");
                InputStream is = file.getInputStream();
                Bitmap bm = BitmapFactory.decodeStream(is, outPadding, opts);
                return BitmapFactory.finishDecode(bm, outPadding, opts);
            }
        }
        catch (IOException ex) {
            return null;
        }
        Bitmap bm = BitmapFactory.nativeDecodeFileDescriptor(fd, outPadding, opts);
        return BitmapFactory.finishDecode(bm, outPadding, opts);
    }

    public static Bitmap decodeFileDescriptor(FileDescriptor fd) {
        return BitmapFactory.decodeFileDescriptor(fd, null, null);
    }

    public static void setDefaultConfig(Bitmap.Config config) {
        if (config == null) {
            config = Bitmap.Config.RGB_565;
        }
        BitmapFactory.nativeSetDefaultConfig(config.nativeInt);
    }

    @LayoutlibDelegate
    public static void nativeSetDefaultConfig(int n) {
        BitmapFactory_Delegate.nativeSetDefaultConfig((int)n);
    }

    @LayoutlibDelegate
    public static Bitmap nativeDecodeStream(InputStream inputStream, byte[] byArray, Rect rect, Options options) {
        return BitmapFactory_Delegate.nativeDecodeStream((InputStream)inputStream, (byte[])byArray, (Rect)rect, (Options)options);
    }

    @LayoutlibDelegate
    public static Bitmap nativeDecodeFileDescriptor(FileDescriptor fileDescriptor, Rect rect, Options options) {
        return BitmapFactory_Delegate.nativeDecodeFileDescriptor((FileDescriptor)fileDescriptor, (Rect)rect, (Options)options);
    }

    @LayoutlibDelegate
    public static Bitmap nativeDecodeAsset(int n, Rect rect, Options options) {
        return BitmapFactory_Delegate.nativeDecodeAsset((int)n, (Rect)rect, (Options)options);
    }

    @LayoutlibDelegate
    public static Bitmap nativeDecodeByteArray(byte[] byArray, int n, int n2, Options options) {
        return BitmapFactory_Delegate.nativeDecodeByteArray((byte[])byArray, (int)n, (int)n2, (Options)options);
    }

    @LayoutlibDelegate
    public static byte[] nativeScaleNinePatch(byte[] byArray, float f, Rect rect) {
        return BitmapFactory_Delegate.nativeScaleNinePatch((byte[])byArray, (float)f, (Rect)rect);
    }

    public static class Options {
        public boolean inJustDecodeBounds;
        public int inSampleSize;
        public Bitmap.Config inPreferredConfig = Bitmap.Config.ARGB_8888;
        public boolean inDither = false;
        public int inDensity;
        public int inTargetDensity;
        public int inScreenDensity;
        public boolean inScaled = true;
        public boolean inPurgeable;
        public boolean inInputShareable;
        public boolean inNativeAlloc;
        public boolean inPreferQualityOverSpeed;
        public int outWidth;
        public int outHeight;
        public String outMimeType;
        public byte[] inTempStorage;
        public boolean mCancel;

        public void requestCancel() {
            OverrideMethod.invokeV("android.graphics.BitmapFactory$Options#requestCancel()V", true, this);
        }

        public void requestCancelDecode() {
            this.mCancel = true;
            this.requestCancel();
        }
    }
}

