/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import java.util.Locale;

public abstract class PluralRules {
    public static final int QUANTITY_OTHER = 0;
    public static final int QUANTITY_ZERO = 1;
    public static final int QUANTITY_ONE = 2;
    public static final int QUANTITY_TWO = 4;
    public static final int QUANTITY_FEW = 8;
    public static final int QUANTITY_MANY = 16;
    public static final int ID_OTHER = 0x1000004;
    public static PluralRules cs;
    public static PluralRules en;

    public abstract int quantityForNumber(int var1);

    public int attrForNumber(int n) {
        return PluralRules.attrForQuantity(this.quantityForNumber(n));
    }

    public static int attrForQuantity(int quantity) {
        switch (quantity) {
            case 1: {
                return 0x1000005;
            }
            case 2: {
                return 0x1000006;
            }
            case 4: {
                return 0x1000007;
            }
            case 8: {
                return 0x1000008;
            }
            case 16: {
                return 0x1000009;
            }
        }
        return 0x1000004;
    }

    public static String stringForQuantity(int quantity) {
        switch (quantity) {
            case 1: {
                return "zero";
            }
            case 2: {
                return "one";
            }
            case 4: {
                return "two";
            }
            case 8: {
                return "few";
            }
            case 16: {
                return "many";
            }
        }
        return "other";
    }

    public static PluralRules ruleForLocale(Locale locale) {
        String lang = locale.getLanguage();
        if ("cs".equals(lang)) {
            if (cs == null) {
                cs = new cs(null);
            }
            return cs;
        }
        if (en == null) {
            en = new en(null);
        }
        return en;
    }

    public static class 1 {
    }

    public static class en
    extends PluralRules {
        public en() {
        }

        public int quantityForNumber(int n) {
            if (n == 1) {
                return 2;
            }
            return 0;
        }

        public /* synthetic */ en(1 x0) {
            this();
        }
    }

    public static class cs
    extends PluralRules {
        public cs() {
        }

        public int quantityForNumber(int n) {
            if (n == 1) {
                return 2;
            }
            if (n >= 2 && n <= 4) {
                return 8;
            }
            return 0;
        }

        public /* synthetic */ cs(1 x0) {
            this();
        }
    }
}

