/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentInsertHandler;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.util.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultDataHandler
implements ContentInsertHandler {
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String URI_STR = "uri";
    public static final String POSTFIX = "postfix";
    public static final String DEL = "del";
    public static final String SELECT = "select";
    public static final String ARG = "arg";
    public Stack<Uri> mUris = new Stack();
    public ContentValues mValues;
    public ContentResolver mContentResolver;

    public void insert(ContentResolver contentResolver, InputStream in) throws IOException, SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(in, Xml.Encoding.UTF_8, this);
    }

    public void insert(ContentResolver contentResolver, String in) throws SAXException {
        this.mContentResolver = contentResolver;
        Xml.parse(in, (ContentHandler)this);
    }

    public void parseRow(Attributes atts) throws SAXException {
        Uri uri;
        String uriStr = atts.getValue(URI_STR);
        if (uriStr != null) {
            uri = Uri.parse(uriStr);
            if (uri == null) {
                throw new SAXException("attribute " + atts.getValue(URI_STR) + " parsing failure");
            }
        } else if (this.mUris.size() > 0) {
            String postfix = atts.getValue(POSTFIX);
            uri = postfix != null ? Uri.withAppendedPath((Uri)this.mUris.lastElement(), postfix) : (Uri)this.mUris.lastElement();
        } else {
            throw new SAXException("attribute parsing failure");
        }
        this.mUris.push(uri);
    }

    public Uri insertRow() {
        Uri u = this.mContentResolver.insert((Uri)this.mUris.lastElement(), this.mValues);
        this.mValues = null;
        return u;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (ROW.equals(localName)) {
            if (this.mValues != null) {
                if (this.mUris.empty()) {
                    throw new SAXException("uri is empty");
                }
                Uri nextUri = this.insertRow();
                if (nextUri == null) {
                    throw new SAXException("insert to uri " + ((Uri)this.mUris.lastElement()).toString() + " failure");
                }
                this.mUris.pop();
                this.mUris.push(nextUri);
                this.parseRow(atts);
                return;
            } else {
                int attrLen = atts.getLength();
                if (attrLen == 0) {
                    this.mUris.push((Uri)this.mUris.lastElement());
                    return;
                } else {
                    this.parseRow(atts);
                }
            }
            return;
        } else if (COL.equals(localName)) {
            int attrLen = atts.getLength();
            if (attrLen != 2) {
                throw new SAXException("illegal attributes number " + attrLen);
            }
            String key = atts.getValue(0);
            String value = atts.getValue(1);
            if (key == null || key.length() <= 0 || value == null || value.length() <= 0) throw new SAXException("illegal attributes value");
            if (this.mValues == null) {
                this.mValues = new ContentValues();
            }
            this.mValues.put(key, value);
            return;
        } else {
            if (!DEL.equals(localName)) throw new SAXException("unknown element: " + localName);
            Uri u = Uri.parse(atts.getValue(URI_STR));
            if (u == null) {
                throw new SAXException("attribute " + atts.getValue(URI_STR) + " parsing failure");
            }
            int attrLen = atts.getLength() - 2;
            if (attrLen > 0) {
                String[] selectionArgs = new String[attrLen];
                for (int i = 0; i < attrLen; ++i) {
                    selectionArgs[i] = atts.getValue(i + 2);
                }
                this.mContentResolver.delete(u, atts.getValue(1), selectionArgs);
                return;
            } else if (attrLen == 0) {
                this.mContentResolver.delete(u, atts.getValue(1), null);
                return;
            } else {
                this.mContentResolver.delete(u, null, null);
            }
        }
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        if (ROW.equals(localName)) {
            if (this.mUris.empty()) {
                throw new SAXException("uri mismatch");
            }
            if (this.mValues != null) {
                this.insertRow();
            }
            this.mUris.pop();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

