/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentValues;
import android.database.ContentObserver;
import android.database.Cursor;
import android.os.Handler;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentQueryMap
extends Observable {
    public Cursor mCursor;
    public String[] mColumnNames;
    public int mKeyColumn;
    public Handler mHandlerForUpdateNotifications = null;
    public boolean mKeepUpdated = false;
    public Map<String, ContentValues> mValues = null;
    public ContentObserver mContentObserver;
    public boolean mDirty = false;

    public ContentQueryMap(Cursor cursor, String columnNameOfKey, boolean keepUpdated, Handler handlerForUpdateNotifications) {
        this.mCursor = cursor;
        this.mColumnNames = this.mCursor.getColumnNames();
        this.mKeyColumn = this.mCursor.getColumnIndexOrThrow(columnNameOfKey);
        this.mHandlerForUpdateNotifications = handlerForUpdateNotifications;
        this.setKeepUpdated(keepUpdated);
        if (!keepUpdated) {
            this.readCursorIntoCache();
        }
    }

    public void setKeepUpdated(boolean keepUpdated) {
        if (keepUpdated == this.mKeepUpdated) {
            return;
        }
        this.mKeepUpdated = keepUpdated;
        if (!this.mKeepUpdated) {
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mContentObserver = null;
        } else {
            if (this.mHandlerForUpdateNotifications == null) {
                this.mHandlerForUpdateNotifications = new Handler();
            }
            if (this.mContentObserver == null) {
                this.mContentObserver = new ContentObserver(this.mHandlerForUpdateNotifications){

                    public void onChange(boolean selfChange) {
                        if (ContentQueryMap.this.countObservers() != 0) {
                            ContentQueryMap.this.requery();
                        } else {
                            ContentQueryMap.this.mDirty = true;
                        }
                    }
                };
            }
            this.mCursor.registerContentObserver(this.mContentObserver);
            this.mDirty = true;
        }
    }

    public synchronized ContentValues getValues(String rowName) {
        if (this.mDirty) {
            this.requery();
        }
        return this.mValues.get(rowName);
    }

    public void requery() {
        this.mDirty = false;
        this.mCursor.requery();
        this.readCursorIntoCache();
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void readCursorIntoCache() {
        int capacity = this.mValues != null ? this.mValues.size() : 0;
        this.mValues = new HashMap<String, ContentValues>(capacity);
        while (this.mCursor.moveToNext()) {
            ContentValues values = new ContentValues();
            for (int i = 0; i < this.mColumnNames.length; ++i) {
                if (i == this.mKeyColumn) continue;
                values.put(this.mColumnNames[i], this.mCursor.getString(i));
            }
            this.mValues.put(this.mCursor.getString(this.mKeyColumn), values);
        }
    }

    public synchronized Map<String, ContentValues> getRows() {
        if (this.mDirty) {
            this.requery();
        }
        return this.mValues;
    }

    public synchronized void close() {
        if (this.mContentObserver != null) {
            this.mCursor.unregisterContentObserver(this.mContentObserver);
            this.mContentObserver = null;
        }
        this.mCursor.close();
        this.mCursor = null;
    }

    public void finalize() throws Throwable {
        if (this.mCursor != null) {
            this.close();
        }
        super.finalize();
    }
}

