/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.app.ActivityManagerProxy;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IActivityWatcher;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.IServiceConnection;
import android.app.IThumbnailReceiver;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class ActivityManagerNative
extends Binder
implements IActivityManager {
    public static boolean sSystemReady = false;
    public static IActivityManager gDefault;

    public static IActivityManager asInterface(IBinder obj) {
        if (obj == null) {
            return null;
        }
        IActivityManager in = (IActivityManager)obj.queryLocalInterface("android.app.IActivityManager");
        if (in != null) {
            return in;
        }
        return new ActivityManagerProxy(obj);
    }

    public static IActivityManager getDefault() {
        if (gDefault != null) {
            return gDefault;
        }
        IBinder b = ServiceManager.getService((String)"activity");
        gDefault = ActivityManagerNative.asInterface(b);
        return gDefault;
    }

    public static boolean isSystemReady() {
        if (!sSystemReady) {
            sSystemReady = ActivityManagerNative.getDefault().testIsSystemReady();
        }
        return sSystemReady;
    }

    public static void broadcastStickyIntent(Intent intent, String permission2) {
        try {
            ActivityManagerNative.getDefault().broadcastIntent(null, intent, null, null, -1, null, null, null, false, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static void noteWakeupAlarm(PendingIntent ps) {
        try {
            ActivityManagerNative.getDefault().noteWakeupAlarm(ps.getTarget());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public ActivityManagerNative() {
        this.attachInterface(this, "android.app.IActivityManager");
    }

    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        switch (code) {
            case 3: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                Uri[] grantedUriPermissions = data.createTypedArray(Uri.CREATOR);
                int grantedMode = data.readInt();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                boolean onlyIfNeeded = data.readInt() != 0;
                boolean debug = data.readInt() != 0;
                int result = this.startActivity(app, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 105: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                Uri[] grantedUriPermissions = data.createTypedArray(Uri.CREATOR);
                int grantedMode = data.readInt();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                boolean onlyIfNeeded = data.readInt() != 0;
                boolean debug = data.readInt() != 0;
                IActivityManager.WaitResult result = this.startActivityAndWait(app, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug);
                reply.writeNoException();
                result.writeToParcel(reply, 0);
                return true;
            }
            case 107: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                Uri[] grantedUriPermissions = data.createTypedArray(Uri.CREATOR);
                int grantedMode = data.readInt();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                boolean onlyIfNeeded = data.readInt() != 0;
                boolean debug = data.readInt() != 0;
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                int result = this.startActivityWithConfig(app, intent, resolvedType, grantedUriPermissions, grantedMode, resultTo, resultWho, requestCode, onlyIfNeeded, debug, config);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 100: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                IntentSender intent = IntentSender.CREATOR.createFromParcel(data);
                Intent fillInIntent = null;
                if (data.readInt() != 0) {
                    fillInIntent = Intent.CREATOR.createFromParcel(data);
                }
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                int flagsMask = data.readInt();
                int flagsValues = data.readInt();
                int result = this.startActivityIntentSender(app, intent, fillInIntent, resolvedType, resultTo, resultWho, requestCode, flagsMask, flagsValues);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 67: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder callingActivity = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                boolean result = this.startNextMatchingActivity(callingActivity, intent);
                reply.writeNoException();
                reply.writeInt(result ? 1 : 0);
                return true;
            }
            case 11: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent resultData = null;
                int resultCode = data.readInt();
                if (data.readInt() != 0) {
                    resultData = Intent.CREATOR.createFromParcel(data);
                }
                boolean res = this.finishActivity(token, resultCode, resultData);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 32: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                this.finishSubActivity(token, resultWho, requestCode);
                reply.writeNoException();
                return true;
            }
            case 106: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean res = this.willActivityBeVisible(token);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 12: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                b = data.readStrongBinder();
                IIntentReceiver rec = b != null ? IIntentReceiver.Stub.asInterface(b) : null;
                IntentFilter filter = IntentFilter.CREATOR.createFromParcel(data);
                String perm = data.readString();
                Intent intent = this.registerReceiver(app, rec, filter, perm);
                reply.writeNoException();
                if (intent != null) {
                    reply.writeInt(1);
                    intent.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 13: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                if (b == null) {
                    return true;
                }
                IIntentReceiver rec = IIntentReceiver.Stub.asInterface(b);
                this.unregisterReceiver(rec);
                reply.writeNoException();
                return true;
            }
            case 14: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                b = data.readStrongBinder();
                IIntentReceiver resultTo = b != null ? IIntentReceiver.Stub.asInterface(b) : null;
                int resultCode = data.readInt();
                String resultData = data.readString();
                Bundle resultExtras = data.readBundle();
                String perm = data.readString();
                boolean serialized = data.readInt() != 0;
                boolean sticky = data.readInt() != 0;
                int res = this.broadcastIntent(app, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, perm, serialized, sticky);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 15: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = b != null ? ApplicationThreadNative.asInterface(b) : null;
                Intent intent = Intent.CREATOR.createFromParcel(data);
                this.unbroadcastIntent(app, intent);
                reply.writeNoException();
                return true;
            }
            case 16: {
                boolean resultAbort;
                data.enforceInterface("android.app.IActivityManager");
                IBinder who = data.readStrongBinder();
                int resultCode = data.readInt();
                String resultData = data.readString();
                Bundle resultExtras = data.readBundle();
                boolean bl = resultAbort = data.readInt() != 0;
                if (who != null) {
                    this.finishReceiver(who, resultCode, resultData, resultExtras, resultAbort);
                }
                reply.writeNoException();
                return true;
            }
            case 17: {
                data.enforceInterface("android.app.IActivityManager");
                IApplicationThread app = ApplicationThreadNative.asInterface(data.readStrongBinder());
                if (app != null) {
                    this.attachApplication(app);
                }
                reply.writeNoException();
                return true;
            }
            case 18: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Configuration config = null;
                if (data.readInt() != 0) {
                    config = Configuration.CREATOR.createFromParcel(data);
                }
                if (token != null) {
                    this.activityIdle(token, config);
                }
                reply.writeNoException();
                return true;
            }
            case 19: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bundle map = data.readBundle();
                this.activityPaused(token, map);
                reply.writeNoException();
                return true;
            }
            case 20: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bitmap thumbnail = data.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(data) : null;
                CharSequence description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data);
                this.activityStopped(token, thumbnail, description);
                reply.writeNoException();
                return true;
            }
            case 62: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                this.activityDestroyed(token);
                reply.writeNoException();
                return true;
            }
            case 21: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String res = token != null ? this.getCallingPackage(token) : null;
                reply.writeNoException();
                reply.writeString(res);
                return true;
            }
            case 22: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ComponentName cn = this.getCallingActivity(token);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 23: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                IBinder receiverBinder = data.readStrongBinder();
                IThumbnailReceiver receiver = receiverBinder != null ? IThumbnailReceiver.Stub.asInterface(receiverBinder) : null;
                List list = this.getTasks(maxNum, fl, receiver);
                reply.writeNoException();
                int N = list != null ? list.size() : -1;
                reply.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    ActivityManager.RunningTaskInfo info = (ActivityManager.RunningTaskInfo)list.get(i);
                    info.writeToParcel(reply, 0);
                }
                return true;
            }
            case 60: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                List<ActivityManager.RecentTaskInfo> list = this.getRecentTasks(maxNum, fl);
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 81: {
                data.enforceInterface("android.app.IActivityManager");
                int maxNum = data.readInt();
                int fl = data.readInt();
                List list = this.getServices(maxNum, fl);
                reply.writeNoException();
                int N = list != null ? list.size() : -1;
                reply.writeInt(N);
                for (int i = 0; i < N; ++i) {
                    ActivityManager.RunningServiceInfo info = (ActivityManager.RunningServiceInfo)list.get(i);
                    info.writeToParcel(reply, 0);
                }
                return true;
            }
            case 77: {
                data.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.ProcessErrorStateInfo> list = this.getProcessesInErrorState();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 83: {
                data.enforceInterface("android.app.IActivityManager");
                List<ActivityManager.RunningAppProcessInfo> list = this.getRunningAppProcesses();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 108: {
                data.enforceInterface("android.app.IActivityManager");
                List<ApplicationInfo> list = this.getRunningExternalApplications();
                reply.writeNoException();
                reply.writeTypedList(list);
                return true;
            }
            case 24: {
                data.enforceInterface("android.app.IActivityManager");
                int task = data.readInt();
                this.moveTaskToFront(task);
                reply.writeNoException();
                return true;
            }
            case 25: {
                data.enforceInterface("android.app.IActivityManager");
                int task = data.readInt();
                this.moveTaskToBack(task);
                reply.writeNoException();
                return true;
            }
            case 75: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean nonRoot = data.readInt() != 0;
                boolean res = this.moveActivityTaskToBack(token, nonRoot);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 26: {
                data.enforceInterface("android.app.IActivityManager");
                int task = data.readInt();
                this.moveTaskBackwards(task);
                reply.writeNoException();
                return true;
            }
            case 27: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                boolean onlyRoot = data.readInt() != 0;
                int res = token != null ? this.getTaskForActivity(token, onlyRoot) : -1;
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 39: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ComponentName className = ComponentName.readFromParcel(data);
                this.finishOtherInstances(token, className);
                reply.writeNoException();
                return true;
            }
            case 28: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Bitmap thumbnail = data.readInt() != 0 ? Bitmap.CREATOR.createFromParcel(data) : null;
                CharSequence description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(data);
                this.reportThumbnail(token, thumbnail, description);
                reply.writeNoException();
                return true;
            }
            case 29: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String name = data.readString();
                IActivityManager.ContentProviderHolder cph = this.getContentProvider(app, name);
                reply.writeNoException();
                if (cph != null) {
                    reply.writeInt(1);
                    cph.writeToParcel(reply, 0);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 30: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                ArrayList<IActivityManager.ContentProviderHolder> providers = data.createTypedArrayList(IActivityManager.ContentProviderHolder.CREATOR);
                this.publishContentProviders(app, providers);
                reply.writeNoException();
                return true;
            }
            case 69: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String name = data.readString();
                this.removeContentProvider(app, name);
                reply.writeNoException();
                return true;
            }
            case 33: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName comp = ComponentName.CREATOR.createFromParcel(data);
                PendingIntent pi = this.getRunningServiceControlPanel(comp);
                reply.writeNoException();
                PendingIntent.writePendingIntentOrNullToParcel(pi, reply);
                return true;
            }
            case 34: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                ComponentName cn = this.startService(app, service, resolvedType);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 35: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                int res = this.stopService(app, service, resolvedType);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 48: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                IBinder token = data.readStrongBinder();
                int startId = data.readInt();
                boolean res = this.stopServiceToken(className, token, startId);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 74: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                IBinder token = data.readStrongBinder();
                int id2 = data.readInt();
                Notification notification = null;
                if (data.readInt() != 0) {
                    notification = Notification.CREATOR.createFromParcel(data);
                }
                boolean removeNotification = data.readInt() != 0;
                this.setServiceForeground(className, token, id2, notification, removeNotification);
                reply.writeNoException();
                return true;
            }
            case 36: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                IBinder token = data.readStrongBinder();
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                b = data.readStrongBinder();
                int fl = data.readInt();
                IServiceConnection conn = IServiceConnection.Stub.asInterface(b);
                int res = this.bindService(app, token, service, resolvedType, conn, fl);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 37: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IServiceConnection conn = IServiceConnection.Stub.asInterface(b);
                boolean res = this.unbindService(conn);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 38: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                IBinder service = data.readStrongBinder();
                this.publishService(token, intent, service);
                reply.writeNoException();
                return true;
            }
            case 72: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                boolean doRebind = data.readInt() != 0;
                this.unbindFinished(token, intent, doRebind);
                reply.writeNoException();
                return true;
            }
            case 61: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int type = data.readInt();
                int startId = data.readInt();
                int res = data.readInt();
                this.serviceDoneExecuting(token, type, startId, res);
                reply.writeNoException();
                return true;
            }
            case 44: {
                data.enforceInterface("android.app.IActivityManager");
                ComponentName className = ComponentName.readFromParcel(data);
                String profileFile = data.readString();
                int fl = data.readInt();
                Bundle arguments = data.readBundle();
                IBinder b = data.readStrongBinder();
                IInstrumentationWatcher w = IInstrumentationWatcher.Stub.asInterface(b);
                boolean res = this.startInstrumentation(className, profileFile, fl, arguments, w);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 45: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                int resultCode = data.readInt();
                Bundle results = data.readBundle();
                this.finishInstrumentation(app, resultCode, results);
                reply.writeNoException();
                return true;
            }
            case 46: {
                data.enforceInterface("android.app.IActivityManager");
                Configuration config = this.getConfiguration();
                reply.writeNoException();
                config.writeToParcel(reply, 0);
                return true;
            }
            case 47: {
                data.enforceInterface("android.app.IActivityManager");
                Configuration config = Configuration.CREATOR.createFromParcel(data);
                this.updateConfiguration(config);
                reply.writeNoException();
                return true;
            }
            case 70: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int requestedOrientation = data.readInt();
                this.setRequestedOrientation(token, requestedOrientation);
                reply.writeNoException();
                return true;
            }
            case 71: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int req = this.getRequestedOrientation(token);
                reply.writeNoException();
                reply.writeInt(req);
                return true;
            }
            case 49: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                ComponentName cn = this.getActivityClassForToken(token);
                reply.writeNoException();
                ComponentName.writeToParcel(cn, reply);
                return true;
            }
            case 50: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                reply.writeNoException();
                reply.writeString(this.getPackageForToken(token));
                return true;
            }
            case 63: {
                data.enforceInterface("android.app.IActivityManager");
                int type = data.readInt();
                String packageName = data.readString();
                IBinder token = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                Intent requestIntent = data.readInt() != 0 ? Intent.CREATOR.createFromParcel(data) : null;
                String requestResolvedType = data.readString();
                int fl = data.readInt();
                IIntentSender res = this.getIntentSender(type, packageName, token, resultWho, requestCode, requestIntent, requestResolvedType, fl);
                reply.writeNoException();
                reply.writeStrongBinder(res != null ? res.asBinder() : null);
                return true;
            }
            case 64: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                this.cancelIntentSender(r);
                reply.writeNoException();
                return true;
            }
            case 65: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender r = IIntentSender.Stub.asInterface(data.readStrongBinder());
                String res = this.getPackageForIntentSender(r);
                reply.writeNoException();
                reply.writeString(res);
                return true;
            }
            case 51: {
                data.enforceInterface("android.app.IActivityManager");
                int max = data.readInt();
                this.setProcessLimit(max);
                reply.writeNoException();
                return true;
            }
            case 52: {
                data.enforceInterface("android.app.IActivityManager");
                int limit = this.getProcessLimit();
                reply.writeNoException();
                reply.writeInt(limit);
                return true;
            }
            case 73: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                int pid = data.readInt();
                boolean isForeground = data.readInt() != 0;
                this.setProcessForeground(token, pid, isForeground);
                reply.writeNoException();
                return true;
            }
            case 53: {
                data.enforceInterface("android.app.IActivityManager");
                String perm = data.readString();
                int pid = data.readInt();
                int uid = data.readInt();
                int res = this.checkPermission(perm, pid, uid);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 54: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int pid = data.readInt();
                int uid = data.readInt();
                int mode = data.readInt();
                int res = this.checkUriPermission(uri, pid, uid, mode);
                reply.writeNoException();
                reply.writeInt(res);
                return true;
            }
            case 78: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                IPackageDataObserver observer = IPackageDataObserver.Stub.asInterface(data.readStrongBinder());
                boolean res = this.clearApplicationUserData(packageName, observer);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 55: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                String targetPkg = data.readString();
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                this.grantUriPermission(app, targetPkg, uri, mode);
                reply.writeNoException();
                return true;
            }
            case 56: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                this.revokeUriPermission(app, uri, mode);
                reply.writeNoException();
                return true;
            }
            case 58: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder b = data.readStrongBinder();
                IApplicationThread app = ApplicationThreadNative.asInterface(b);
                boolean waiting = data.readInt() != 0;
                this.showWaitingForDebugger(app, waiting);
                reply.writeNoException();
                return true;
            }
            case 76: {
                data.enforceInterface("android.app.IActivityManager");
                ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
                this.getMemoryInfo(mi);
                reply.writeNoException();
                mi.writeToParcel(reply, 0);
                return true;
            }
            case 4: {
                data.enforceInterface("android.app.IActivityManager");
                this.unhandledBack();
                reply.writeNoException();
                return true;
            }
            case 5: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.parse(data.readString());
                ParcelFileDescriptor pfd = this.openContentUri(uri);
                reply.writeNoException();
                if (pfd != null) {
                    reply.writeInt(1);
                    pfd.writeToParcel(reply, 1);
                } else {
                    reply.writeInt(0);
                }
                return true;
            }
            case 40: {
                data.enforceInterface("android.app.IActivityManager");
                this.goingToSleep();
                reply.writeNoException();
                return true;
            }
            case 41: {
                data.enforceInterface("android.app.IActivityManager");
                this.wakingUp();
                reply.writeNoException();
                return true;
            }
            case 42: {
                data.enforceInterface("android.app.IActivityManager");
                String pn = data.readString();
                boolean wfd = data.readInt() != 0;
                boolean per = data.readInt() != 0;
                this.setDebugApp(pn, wfd, per);
                reply.writeNoException();
                return true;
            }
            case 43: {
                data.enforceInterface("android.app.IActivityManager");
                boolean enabled = data.readInt() != 0;
                this.setAlwaysFinish(enabled);
                reply.writeNoException();
                return true;
            }
            case 57: {
                data.enforceInterface("android.app.IActivityManager");
                IActivityController watcher = IActivityController.Stub.asInterface(data.readStrongBinder());
                this.setActivityController(watcher);
                return true;
            }
            case 66: {
                data.enforceInterface("android.app.IActivityManager");
                this.enterSafeMode();
                reply.writeNoException();
                return true;
            }
            case 68: {
                data.enforceInterface("android.app.IActivityManager");
                IIntentSender is = IIntentSender.Stub.asInterface(data.readStrongBinder());
                this.noteWakeupAlarm(is);
                reply.writeNoException();
                return true;
            }
            case 80: {
                data.enforceInterface("android.app.IActivityManager");
                int[] pids = data.createIntArray();
                String reason = data.readString();
                boolean res = this.killPids(pids, reason);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 1: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                String cls = data.readString();
                String action = data.readString();
                String indata = data.readString();
                this.startRunning(pkg, cls, action, indata);
                reply.writeNoException();
                return true;
            }
            case 2: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo(data);
                this.handleApplicationCrash(app, ci);
                reply.writeNoException();
                return true;
            }
            case 102: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                String tag = data.readString();
                ApplicationErrorReport.CrashInfo ci = new ApplicationErrorReport.CrashInfo(data);
                boolean res = this.handleApplicationWtf(app, tag, ci);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 110: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder app = data.readStrongBinder();
                int violationMask = data.readInt();
                StrictMode.ViolationInfo info = new StrictMode.ViolationInfo(data);
                this.handleApplicationStrictModeViolation(app, violationMask, info);
                reply.writeNoException();
                return true;
            }
            case 59: {
                data.enforceInterface("android.app.IActivityManager");
                int sig = data.readInt();
                this.signalPersistentProcesses(sig);
                reply.writeNoException();
                return true;
            }
            case 103: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                this.killBackgroundProcesses(packageName);
                reply.writeNoException();
                return true;
            }
            case 79: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                this.forceStopPackage(packageName);
                reply.writeNoException();
                return true;
            }
            case 84: {
                data.enforceInterface("android.app.IActivityManager");
                ConfigurationInfo config = this.getDeviceConfigurationInfo();
                reply.writeNoException();
                config.writeToParcel(reply, 0);
                return true;
            }
            case 86: {
                data.enforceInterface("android.app.IActivityManager");
                String process = data.readString();
                boolean start = data.readInt() != 0;
                String path = data.readString();
                ParcelFileDescriptor fd = data.readInt() != 0 ? data.readFileDescriptor() : null;
                boolean res = this.profileControl(process, start, path, fd);
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 87: {
                data.enforceInterface("android.app.IActivityManager");
                boolean res = this.shutdown(data.readInt());
                reply.writeNoException();
                reply.writeInt(res ? 1 : 0);
                return true;
            }
            case 88: {
                data.enforceInterface("android.app.IActivityManager");
                this.stopAppSwitches();
                reply.writeNoException();
                return true;
            }
            case 89: {
                data.enforceInterface("android.app.IActivityManager");
                this.resumeAppSwitches();
                reply.writeNoException();
                return true;
            }
            case 85: {
                data.enforceInterface("android.app.IActivityManager");
                Intent service = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder binder = this.peekService(service, resolvedType);
                reply.writeNoException();
                reply.writeStrongBinder(binder);
                return true;
            }
            case 90: {
                data.enforceInterface("android.app.IActivityManager");
                ApplicationInfo info = ApplicationInfo.CREATOR.createFromParcel(data);
                int backupRestoreMode = data.readInt();
                boolean success = this.bindBackupAgent(info, backupRestoreMode);
                reply.writeNoException();
                reply.writeInt(success ? 1 : 0);
                return true;
            }
            case 91: {
                data.enforceInterface("android.app.IActivityManager");
                String packageName = data.readString();
                IBinder agent = data.readStrongBinder();
                this.backupAgentCreated(packageName, agent);
                reply.writeNoException();
                return true;
            }
            case 92: {
                data.enforceInterface("android.app.IActivityManager");
                ApplicationInfo info = ApplicationInfo.CREATOR.createFromParcel(data);
                this.unbindBackupAgent(info);
                reply.writeNoException();
                return true;
            }
            case 93: {
                data.enforceInterface("android.app.IActivityManager");
                IActivityWatcher watcher = IActivityWatcher.Stub.asInterface(data.readStrongBinder());
                this.registerActivityWatcher(watcher);
                return true;
            }
            case 94: {
                data.enforceInterface("android.app.IActivityManager");
                IActivityWatcher watcher = IActivityWatcher.Stub.asInterface(data.readStrongBinder());
                this.unregisterActivityWatcher(watcher);
                return true;
            }
            case 95: {
                data.enforceInterface("android.app.IActivityManager");
                int uid = data.readInt();
                Intent intent = Intent.CREATOR.createFromParcel(data);
                String resolvedType = data.readString();
                IBinder resultTo = data.readStrongBinder();
                String resultWho = data.readString();
                int requestCode = data.readInt();
                boolean onlyIfNeeded = data.readInt() != 0;
                int result = this.startActivityInPackage(uid, intent, resolvedType, resultTo, resultWho, requestCode, onlyIfNeeded);
                reply.writeNoException();
                reply.writeInt(result);
                return true;
            }
            case 96: {
                data.enforceInterface("android.app.IActivityManager");
                String pkg = data.readString();
                int uid = data.readInt();
                this.killApplicationWithUid(pkg, uid);
                reply.writeNoException();
                return true;
            }
            case 97: {
                data.enforceInterface("android.app.IActivityManager");
                String reason = data.readString();
                this.closeSystemDialogs(reason);
                reply.writeNoException();
                return true;
            }
            case 98: {
                data.enforceInterface("android.app.IActivityManager");
                int[] pids = data.createIntArray();
                Parcelable[] res = this.getProcessMemoryInfo(pids);
                reply.writeNoException();
                reply.writeTypedArray(res, 1);
                return true;
            }
            case 99: {
                data.enforceInterface("android.app.IActivityManager");
                String processName = data.readString();
                int uid = data.readInt();
                this.killApplicationProcess(processName, uid);
                reply.writeNoException();
                return true;
            }
            case 101: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder token = data.readStrongBinder();
                String packageName = data.readString();
                int enterAnim = data.readInt();
                int exitAnim = data.readInt();
                this.overridePendingTransition(token, packageName, enterAnim, exitAnim);
                reply.writeNoException();
                return true;
            }
            case 104: {
                data.enforceInterface("android.app.IActivityManager");
                boolean areThey = this.isUserAMonkey();
                reply.writeNoException();
                reply.writeInt(areThey ? 1 : 0);
                return true;
            }
            case 109: {
                data.enforceInterface("android.app.IActivityManager");
                this.finishHeavyWeightApp();
                reply.writeNoException();
                return true;
            }
            case 114: {
                data.enforceInterface("android.app.IActivityManager");
                int uid = data.readInt();
                int initialPid = data.readInt();
                String packageName = data.readString();
                String message = data.readString();
                this.crashApplication(uid, initialPid, packageName, message);
                reply.writeNoException();
                return true;
            }
            case 115: {
                data.enforceInterface("android.app.IActivityManager");
                Uri uri = Uri.CREATOR.createFromParcel(data);
                String type = this.getProviderMimeType(uri);
                reply.writeNoException();
                reply.writeString(type);
                return true;
            }
            case 116: {
                data.enforceInterface("android.app.IActivityManager");
                String name = data.readString();
                IBinder perm = this.newUriPermissionOwner(name);
                reply.writeNoException();
                reply.writeStrongBinder(perm);
                return true;
            }
            case 117: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder owner = data.readStrongBinder();
                int fromUid = data.readInt();
                String targetPkg = data.readString();
                Uri uri = Uri.CREATOR.createFromParcel(data);
                int mode = data.readInt();
                this.grantUriPermissionFromOwner(owner, fromUid, targetPkg, uri, mode);
                reply.writeNoException();
                return true;
            }
            case 118: {
                data.enforceInterface("android.app.IActivityManager");
                IBinder owner = data.readStrongBinder();
                Uri uri = null;
                if (data.readInt() != 0) {
                    Uri.CREATOR.createFromParcel(data);
                }
                int mode = data.readInt();
                this.revokeUriPermissionFromOwner(owner, uri, mode);
                reply.writeNoException();
                return true;
            }
        }
        return super.onTransact(code, data, reply, flags);
    }

    public IBinder asBinder() {
        return this;
    }
}

