/*
 * Decompiled with CFR 0.152.
 */
package signature.model.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import signature.model.IClassReference;
import signature.model.IGenericDeclaration;
import signature.model.ITypeReference;
import signature.model.ITypeVariableReference;
import signature.model.impl.SigArrayType;
import signature.model.impl.SigClassDefinition;
import signature.model.impl.SigClassReference;
import signature.model.impl.SigParameterizedType;
import signature.model.impl.SigTypeVariableDefinition;
import signature.model.impl.SigTypeVariableReference;
import signature.model.impl.SigWildcardType;
import signature.model.impl.Uninitialized;
import signature.model.util.ITypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypePool
implements ITypeFactory {
    private Map<String, SigClassDefinition> classPool = new HashMap<String, SigClassDefinition>();
    private Map<TypeVariableKey, SigTypeVariableDefinition> typeVariablePool = new HashMap<TypeVariableKey, SigTypeVariableDefinition>();

    @Override
    public SigClassDefinition getClass(String packageName, String className) {
        String key = packageName + "<>" + className;
        SigClassDefinition clazz = this.classPool.get(key);
        if (clazz == null) {
            clazz = new SigClassDefinition(packageName, className);
            this.classPool.put(key, clazz);
        }
        return clazz;
    }

    @Override
    public IClassReference getClassReference(String packageName, String className) {
        return new SigClassReference(this.getClass(packageName, className));
    }

    @Override
    public SigArrayType getArrayType(ITypeReference componentType) {
        assert (componentType != null);
        return new SigArrayType(componentType);
    }

    @Override
    public SigParameterizedType getParameterizedType(ITypeReference ownerType, IClassReference rawType, List<ITypeReference> typeArguments) {
        assert (rawType != null);
        assert (typeArguments != null);
        return new SigParameterizedType(ownerType, rawType, typeArguments);
    }

    @Override
    public boolean containsTypeVariableDefinition(String name, IGenericDeclaration genericDeclaration) {
        TypeVariableKey key = new TypeVariableKey(name, genericDeclaration);
        return this.typeVariablePool.get(key) != null;
    }

    @Override
    public SigTypeVariableDefinition getTypeVariable(String name, IGenericDeclaration genericDeclaration) {
        assert (name != null);
        assert (genericDeclaration != null);
        TypeVariableKey key = new TypeVariableKey(name, genericDeclaration);
        SigTypeVariableDefinition sigTypeVariable = this.typeVariablePool.get(key);
        if (sigTypeVariable == null) {
            sigTypeVariable = new SigTypeVariableDefinition(name, genericDeclaration);
            this.typeVariablePool.put(key, sigTypeVariable);
        }
        return sigTypeVariable;
    }

    @Override
    public ITypeVariableReference getTypeVariableReference(String name, IGenericDeclaration genericDeclaration) {
        return new SigTypeVariableReference(this.getTypeVariable(name, genericDeclaration));
    }

    @Override
    public SigWildcardType getWildcardType(ITypeReference lowerBound, List<ITypeReference> upperBounds) {
        assert (upperBounds != null);
        SigWildcardType sigWildcardType = new SigWildcardType(lowerBound, upperBounds);
        return sigWildcardType;
    }

    public void replaceAllUninitialiezWithNull() {
        for (SigClassDefinition clazz : this.classPool.values()) {
            TypePool.replaceUninitializedWithNull(clazz);
        }
    }

    private static void replaceUninitializedWithNull(SigClassDefinition clazz) {
        if (clazz == null) {
            return;
        }
        if (!Uninitialized.isInitialized(clazz.getAnnotationFields())) {
            clazz.setAnnotationFields(null);
        }
        if (!Uninitialized.isInitialized(clazz.getAnnotations())) {
            clazz.setAnnotations(null);
        }
        if (!Uninitialized.isInitialized(clazz.getAnnotations())) {
            clazz.setAnnotations(null);
        }
        if (!Uninitialized.isInitialized(clazz.getConstructors())) {
            clazz.setConstructors(null);
        }
        if (!Uninitialized.isInitialized(clazz.getDeclaringClass())) {
            clazz.setDeclaringClass(null);
        }
        if (!Uninitialized.isInitialized(clazz.getEnumConstants())) {
            clazz.setEnumConstants(null);
        }
        if (!Uninitialized.isInitialized(clazz.getFields())) {
            clazz.setFields(null);
        }
        if (!Uninitialized.isInitialized(clazz.getInnerClasses())) {
            clazz.setInnerClasses(null);
        }
        if (!Uninitialized.isInitialized(clazz.getInterfaces())) {
            clazz.setInterfaces(null);
        }
        if (!Uninitialized.isInitialized((Object)clazz.getKind())) {
            clazz.setKind(null);
        }
        if (!Uninitialized.isInitialized(clazz.getMethods())) {
            clazz.setMethods(null);
        }
        if (!Uninitialized.isInitialized(clazz.getModifiers())) {
            clazz.setModifiers(null);
        }
        if (!Uninitialized.isInitialized(clazz.getSuperClass())) {
            clazz.setSuperClass(null);
        }
        if (!Uninitialized.isInitialized(clazz.getTypeParameters())) {
            clazz.setTypeParameters(null);
        }
    }

    private static class TypeVariableKey {
        private String name;
        private IGenericDeclaration genericDeclaration;

        public TypeVariableKey(String name, IGenericDeclaration genericDeclaration) {
            this.genericDeclaration = genericDeclaration;
            this.name = name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.genericDeclaration.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            TypeVariableKey other = (TypeVariableKey)obj;
            if (this.genericDeclaration != other.genericDeclaration) {
                return false;
            }
            return this.name.equals(other.name);
        }
    }
}

