/*
 * Decompiled with CFR 0.152.
 */
package signature.model.util;

import java.util.Collection;
import signature.model.IAnnotatableElement;
import signature.model.IAnnotation;
import signature.model.IAnnotationElement;
import signature.model.IAnnotationField;
import signature.model.IApi;
import signature.model.IClassDefinition;
import signature.model.IField;
import signature.model.IPackage;
import signature.model.ITypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    private ModelUtil() {
    }

    public static IClassDefinition getClass(IPackage aPackage, String qualifiedClassName) {
        for (IClassDefinition clazz : aPackage.getClasses()) {
            if (!qualifiedClassName.equals(clazz.getName())) continue;
            return clazz;
        }
        return null;
    }

    public static IAnnotation getAnnotation(IAnnotatableElement element, String qualifiedTypeName) {
        for (IAnnotation annotation : element.getAnnotations()) {
            if (!qualifiedTypeName.equals(annotation.getType().getClassDefinition().getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    public static IAnnotationElement getAnnotationElement(IAnnotation annotation, String elementName) {
        for (IAnnotationElement element : annotation.getElements()) {
            if (!elementName.equals(element.getDeclaringField().getName())) continue;
            return element;
        }
        return null;
    }

    public static IField getField(IClassDefinition clazz, String fieldName) {
        for (IField field : clazz.getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static IAnnotationField getAnnotationField(IClassDefinition annotation, String fieldName) {
        for (IAnnotationField field : annotation.getAnnotationFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static IPackage getPackage(IApi api, String packageName) {
        for (IPackage aPackage : api.getPackages()) {
            if (!packageName.equals(aPackage.getName())) continue;
            return aPackage;
        }
        return null;
    }

    public static String getPackageName(String classIdentifier) {
        int lastIndexOfSlash = classIdentifier.lastIndexOf(46);
        String packageName = null;
        packageName = lastIndexOfSlash == -1 ? "" : classIdentifier.substring(0, lastIndexOfSlash);
        return packageName;
    }

    public static String getClassName(String classIdentifier) {
        int lastIndexOfDot = classIdentifier.lastIndexOf(46);
        String className = null;
        className = lastIndexOfDot == -1 ? classIdentifier : classIdentifier.substring(lastIndexOfDot + 1);
        return className;
    }

    public static String separate(Collection<? extends Object> elements, String separator) {
        StringBuilder s = new StringBuilder();
        boolean first = true;
        for (Object object : elements) {
            if (!first) {
                s.append(separator);
            }
            s.append(object.toString());
            first = false;
        }
        return s.toString();
    }

    public static boolean isJavaLangObject(ITypeReference type) {
        IClassDefinition clazz;
        if (type instanceof IClassDefinition && "java.lang".equals((clazz = (IClassDefinition)((Object)type)).getPackageName())) {
            return "Object".equals(clazz.getName());
        }
        return false;
    }
}

