/*
 * Decompiled with CFR 0.152.
 */
package signature.model.impl;

import signature.model.IPrimitiveType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SigPrimitiveType implements IPrimitiveType
{
    VOID_TYPE("void"),
    BOOLEAN_TYPE("boolean"),
    BYTE_TYPE("byte"),
    CHAR_TYPE("char"),
    SHORT_TYPE("short"),
    INT_TYPE("int"),
    LONG_TYPE("long"),
    FLOAT_TYPE("float"),
    DOUBLE_TYPE("double");

    private String name;

    private SigPrimitiveType(String name) {
        this.name = name;
    }

    public static SigPrimitiveType valueOfTypeName(String name) {
        for (SigPrimitiveType primitive : SigPrimitiveType.values()) {
            if (!primitive.name.equals(name)) continue;
            return primitive;
        }
        throw new IllegalArgumentException(name + " is not a primitive type");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

