/*
 * Decompiled with CFR 0.152.
 */
package signature.model.impl;

import java.io.Serializable;
import java.util.List;
import signature.model.IClassReference;
import signature.model.IParameterizedType;
import signature.model.ITypeReference;
import signature.model.impl.SigClassReference;
import signature.model.impl.Uninitialized;
import signature.model.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SigParameterizedType
implements IParameterizedType,
Serializable {
    private ITypeReference ownerType;
    private IClassReference rawType;
    private List<ITypeReference> typeArguments;

    public SigParameterizedType(ITypeReference ownerType, IClassReference rawType, List<ITypeReference> typeArguments) {
        this.ownerType = ownerType;
        this.rawType = rawType;
        this.typeArguments = typeArguments;
    }

    @Override
    public ITypeReference getOwnerType() {
        ITypeReference returnValue = this.ownerType;
        if (returnValue == null && this.rawType.getClassDefinition().getDeclaringClass() != null) {
            returnValue = new SigClassReference(this.rawType.getClassDefinition().getDeclaringClass());
        }
        return returnValue;
    }

    @Override
    public IClassReference getRawType() {
        return this.rawType;
    }

    @Override
    public List<ITypeReference> getTypeArguments() {
        return this.typeArguments;
    }

    public int hashCode() {
        return SigParameterizedType.hashCode(this);
    }

    public static int hashCode(IParameterizedType type) {
        int prime = 31;
        int result = 1;
        result = 31 * type.getRawType().hashCode();
        result = 31 * result + ((Object)type.getTypeArguments()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        return SigParameterizedType.equals(this, obj);
    }

    public static boolean equals(IParameterizedType thiz, Object that) {
        if (!(that instanceof IParameterizedType)) {
            return false;
        }
        IParameterizedType other = (IParameterizedType)that;
        if (thiz.getOwnerType() == null ? other.getOwnerType() != null : (Uninitialized.isInitialized(thiz.getOwnerType()) ? !Uninitialized.isInitialized(other.getOwnerType()) : !thiz.getOwnerType().equals(other.getOwnerType()))) {
            return false;
        }
        if (!thiz.getRawType().equals(other.getRawType())) {
            return false;
        }
        return ((Object)thiz.getTypeArguments()).equals(other.getTypeArguments());
    }

    public String toString() {
        return SigParameterizedType.toString(this);
    }

    public static String toString(IParameterizedType type) {
        StringBuilder builder = new StringBuilder();
        if (type.getOwnerType() != null) {
            builder.append(type.getOwnerType().toString());
            builder.append("::");
        }
        builder.append(type.getRawType());
        builder.append("<");
        builder.append(ModelUtil.separate(type.getTypeArguments(), ", "));
        builder.append(">");
        return builder.toString();
    }
}

