/*
 * Decompiled with CFR 0.152.
 */
package signature.io.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import signature.compare.model.IClassDefinitionDelta;
import signature.compare.model.IPackageDelta;
import signature.compare.model.impl.SigDelta;
import signature.io.html.ClassByNameComparator;
import signature.io.html.IEmitter;
import signature.io.html.TemplateStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageOverviewPage
implements IEmitter {
    private static final String PACGE = "PackageOverviewPage";
    private final IPackageDelta delta;
    private List<IClassDefinitionDelta> removedClasses;
    private List<IClassDefinitionDelta> addedClasses;
    private List<IClassDefinitionDelta> changedClasses;
    private final Map<String, String> commonInfos;

    public PackageOverviewPage(IPackageDelta delta, Map<String, String> commonInfos) {
        this.delta = delta;
        this.commonInfos = commonInfos;
        this.prepareData();
    }

    private void prepareData() {
        this.removedClasses = new ArrayList<IClassDefinitionDelta>(SigDelta.getRemoved(this.delta.getClassDeltas()));
        Collections.sort(this.removedClasses, new ClassByNameComparator());
        this.addedClasses = new ArrayList<IClassDefinitionDelta>(SigDelta.getAdded(this.delta.getClassDeltas()));
        Collections.sort(this.addedClasses, new ClassByNameComparator());
        this.changedClasses = new ArrayList<IClassDefinitionDelta>(SigDelta.getChanged(this.delta.getClassDeltas()));
        Collections.sort(this.changedClasses, new ClassByNameComparator());
    }

    @Override
    public void writeTo(StringBuilder b) {
        StringTemplate template = TemplateStore.getStringTemplate(PACGE);
        template.setArgumentContext(this.commonInfos);
        template.setAttribute("package_delta", this.delta);
        template.setAttribute("removed_classes", this.removedClasses);
        template.setAttribute("added_classes", this.addedClasses);
        template.setAttribute("changed_classes", this.changedClasses);
        b.append(template.toString());
    }
}

