/*
 * Decompiled with CFR 0.152.
 */
package signature.io.html;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.antlr.stringtemplate.StringTemplate;
import signature.compare.model.IApiDelta;
import signature.compare.model.IClassDefinitionDelta;
import signature.compare.model.IDelta;
import signature.compare.model.IPackageDelta;
import signature.compare.model.impl.SigDelta;
import signature.io.IApiDeltaExternalizer;
import signature.io.html.ApiOverviewPage;
import signature.io.html.ClassOverviewPage;
import signature.io.html.PackageOverviewPage;
import signature.io.html.TemplateStore;
import signature.model.IApi;
import signature.model.IClassDefinition;
import signature.model.IPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlDeltaExternalizer
implements IApiDeltaExternalizer {
    private static final String OVERVIEW_PAGE_NAME = "changes.html";
    private static final String STYLE_SHEET_NAME = "styles.css";
    private static final String DELTA_FOLDER = "changes" + File.separator;

    @Override
    public void externalize(String location, IApiDelta apiDelta) throws IOException {
        File directory;
        if (!location.endsWith(File.separator)) {
            location = location + File.separator;
        }
        if (!(directory = new File(location)).exists()) {
            directory.mkdirs();
        }
        this.copyStyleSheet(location);
        HashMap<String, String> commonInfos = new HashMap<String, String>();
        commonInfos.put("creation_time", DateFormat.getDateTimeInstance().format(new Date()));
        commonInfos.put("from_desc", ((IApi)apiDelta.getFrom()).getName());
        commonInfos.put("to_desc", ((IApi)apiDelta.getTo()).getName());
        StringBuilder content = new StringBuilder();
        ApiOverviewPage apiOverviewPage = new ApiOverviewPage(apiDelta, commonInfos);
        apiOverviewPage.writeTo(content);
        this.writeToFile(location + OVERVIEW_PAGE_NAME, content.toString());
        Set<IPackageDelta> changedPackages = SigDelta.getChanged(apiDelta.getPackageDeltas());
        if (!changedPackages.isEmpty()) {
            File file = new File(location + DELTA_FOLDER);
            if (!file.exists()) {
                file.mkdir();
            }
            for (IPackageDelta packageDelta : changedPackages) {
                content = new StringBuilder();
                PackageOverviewPage packagePage = new PackageOverviewPage(packageDelta, commonInfos);
                packagePage.writeTo(content);
                IPackage aPackage = HtmlDeltaExternalizer.getAnElement(packageDelta);
                String packageOverviewFileName = location + DELTA_FOLDER + "pkg_" + aPackage.getName() + ".html";
                this.writeToFile(packageOverviewFileName, content.toString());
                for (IClassDefinitionDelta classDelta : packageDelta.getClassDeltas()) {
                    content = new StringBuilder();
                    ClassOverviewPage classPage = new ClassOverviewPage(classDelta, commonInfos);
                    classPage.writeTo(content);
                    IClassDefinition aClass = HtmlDeltaExternalizer.getAnElement(classDelta);
                    String classOverviewFileName = location + DELTA_FOLDER + aPackage.getName() + "." + aClass.getName() + ".html";
                    this.writeToFile(classOverviewFileName, content.toString());
                }
            }
        }
    }

    private static <T> T getAnElement(IDelta<T> delta) {
        if (delta.getFrom() != null) {
            return delta.getFrom();
        }
        return delta.getTo();
    }

    private void copyStyleSheet(String directory) throws IOException {
        StringTemplate template = TemplateStore.getStringTemplate("Styles");
        template.setAttribute("version", "0.1");
        this.writeToFile(directory + STYLE_SHEET_NAME, template.toString());
    }

    private void writeToFile(String fileName, String content) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(fileName);
        fileOutputStream.write(content.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
    }
}

