/*
 * Decompiled with CFR 0.152.
 */
package signature.io.html;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import signature.compare.model.IExecutableMemberDelta;
import signature.model.IArrayType;
import signature.model.IClassDefinition;
import signature.model.IClassReference;
import signature.model.IExecutableMember;
import signature.model.IParameter;
import signature.model.IParameterizedType;
import signature.model.IPrimitiveType;
import signature.model.ITypeDefinition;
import signature.model.ITypeReference;
import signature.model.ITypeVariableDefinition;
import signature.model.ITypeVariableReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutableMemberComparator
implements Comparator<IExecutableMemberDelta<? extends IExecutableMember>> {
    @Override
    public int compare(IExecutableMemberDelta<? extends IExecutableMember> a, IExecutableMemberDelta<? extends IExecutableMember> b) {
        assert (a.getType() == b.getType());
        IExecutableMember aMember = null;
        IExecutableMember bMember = null;
        if (a.getFrom() != null) {
            aMember = (IExecutableMember)a.getFrom();
            bMember = (IExecutableMember)b.getFrom();
        } else {
            aMember = (IExecutableMember)a.getTo();
            bMember = (IExecutableMember)b.getTo();
        }
        int returnValue = aMember.getName().compareTo(bMember.getName());
        return returnValue != 0 ? returnValue : this.compareParameterLists(aMember.getParameters(), bMember.getParameters());
    }

    private int compareParameterLists(List<IParameter> a, List<IParameter> b) {
        if (a.size() != b.size()) {
            return a.size() - b.size();
        }
        Iterator<IParameter> aIt = a.iterator();
        Iterator<IParameter> bIt = b.iterator();
        int returnValue = 0;
        while (aIt.hasNext() && bIt.hasNext()) {
            returnValue += this.getTypeName(aIt.next().getType()).compareTo(this.getTypeName(bIt.next().getType()));
        }
        return returnValue;
    }

    private String getTypeName(ITypeReference type) {
        if (type instanceof IClassReference) {
            return this.getTypeName(((IClassReference)type).getClassDefinition());
        }
        if (type instanceof ITypeVariableReference) {
            return this.getTypeName(((ITypeVariableReference)type).getTypeVariableDefinition());
        }
        if (type instanceof IParameterizedType) {
            return this.getTypeName(((IParameterizedType)type).getRawType());
        }
        if (type instanceof IArrayType) {
            return this.getTypeName(((IArrayType)type).getComponentType());
        }
        if (type instanceof IPrimitiveType) {
            return ((IPrimitiveType)type).getName();
        }
        return type.toString();
    }

    private String getTypeName(ITypeDefinition type) {
        if (type instanceof IClassDefinition) {
            return ((IClassDefinition)type).getName();
        }
        if (type instanceof ITypeVariableDefinition) {
            return ((ITypeVariableDefinition)type).getName();
        }
        return type.toString();
    }
}

