/*
 * Decompiled with CFR 0.152.
 */
package signature.io.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import signature.compare.model.IApiDelta;
import signature.compare.model.IPackageDelta;
import signature.compare.model.impl.SigDelta;
import signature.io.html.IEmitter;
import signature.io.html.PackageByNameComparator;
import signature.io.html.TemplateStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApiOverviewPage
implements IEmitter {
    private final IApiDelta apiDelta;
    private List<IPackageDelta> removedPackages;
    private List<IPackageDelta> addedPackages;
    private List<IPackageDelta> changedPackages;
    private Map<String, String> commonInfos;

    public ApiOverviewPage(IApiDelta apiDelta, Map<String, String> commonInfos) {
        this.apiDelta = apiDelta;
        this.commonInfos = commonInfos;
        this.prepareData();
    }

    private void prepareData() {
        if (this.apiDelta.getPackageDeltas().isEmpty()) {
            this.commonInfos.put("no_delta", "no_delta");
        }
        this.removedPackages = new ArrayList<IPackageDelta>(SigDelta.getRemoved(this.apiDelta.getPackageDeltas()));
        Collections.sort(this.removedPackages, new PackageByNameComparator());
        this.addedPackages = new ArrayList<IPackageDelta>(SigDelta.getAdded(this.apiDelta.getPackageDeltas()));
        Collections.sort(this.addedPackages, new PackageByNameComparator());
        this.changedPackages = new ArrayList<IPackageDelta>(SigDelta.getChanged(this.apiDelta.getPackageDeltas()));
        Collections.sort(this.changedPackages, new PackageByNameComparator());
    }

    @Override
    public void writeTo(StringBuilder b) {
        StringTemplate template = TemplateStore.getStringTemplate("ApiOverviewPage");
        template.setArgumentContext(this.commonInfos);
        template.setAttribute("removed_packages", this.removedPackages);
        template.setAttribute("added_packages", this.addedPackages);
        template.setAttribute("changed_packages", this.changedPackages);
        b.append(template.toString());
    }
}

